/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task.processassistant;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.identity.UserInfo;

public class ProcessAssistantUtil {
    public static final String TIMETODAY = "timeto";
    public static final String TIMEYESTODAY = "timeyesto";
    public static final String TIMEWEEK = "timewe";
    public static final String TIMEMONTH = "timemo";
    public static final String TIMEQUARTER = "timet";
    public static final String BOS_USER = "bos_user";

    public static Map<String, Object> queryUserInfo(Long userId, String userName) {
        if (WfUtils.isEmpty(userId)) {
            return Collections.emptyMap();
        }
        String fields = "picturefield,useropenid";
        QFilter filter = new QFilter("id", "=", (Object)userId);
        QFilter[] qFilters = new QFilter[]{filter};
        DynamicObject[] dynObjs = BusinessDataServiceHelper.load((String)BOS_USER, (String)fields, (QFilter[])qFilters);
        if (dynObjs.length > 0) {
            HashMap<String, Object> userInfo = new HashMap<String, Object>();
            String userNameForFinal = null;
            userNameForFinal = WfUtils.isEmpty(userName) ? dynObjs[0].getString("name") : userName;
            userInfo.put("name", userNameForFinal);
            userInfo.put("imgUrl", WfUtils.getAbsAvatarPath(dynObjs[0].get("picturefield")));
            userInfo.put("openId", dynObjs[0].get("useropenid"));
            return userInfo;
        }
        return Collections.emptyMap();
    }

    public static Map<String, UserInfo> queryUserInfos(Set<Long> userIds, Map<Long, String> userInfoMap) {
        HashMap<String, UserInfo> userInfo = new HashMap<String, UserInfo>();
        QFilter filter = new QFilter("id", "in", userIds);
        QFilter enable = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        QFilter[] qFilters = new QFilter[]{filter, enable};
        String fields = "name,id,picturefield,useropenid,number";
        DynamicObject[] dynObjs = BusinessDataServiceHelper.load((String)BOS_USER, (String)fields, (QFilter[])qFilters);
        Long userId = null;
        String userName = null;
        String userNameForFinal = null;
        for (int i = 0; i < dynObjs.length; ++i) {
            userId = dynObjs[i].getLong("id");
            userName = dynObjs[i].getString("name");
            if (WfUtils.isEmptyString(userName) || userId == null) continue;
            userNameForFinal = userInfoMap.get(userId);
            if (WfUtils.isEmpty(userNameForFinal)) {
                userNameForFinal = userName;
            }
            dynObjs[i].set("name", (Object)userNameForFinal);
            userInfo.put(dynObjs[i].get("id").toString(), new UserInfo(dynObjs[i]));
        }
        return userInfo;
    }

    public static String sqlAddFilter(String sql, String timeFilter) {
        if (TIMETODAY.equalsIgnoreCase(timeFilter)) {
            sql = sql + " and DAYOFYEAR(a.FCREATEDATE)=DAYOFYEAR(now()) and YEAR(a.FCREATEDATE)=YEAR(now()) ";
        } else if (TIMEYESTODAY.equals(timeFilter)) {
            sql = sql + " and DAYOFYEAR(a.FCREATEDATE)=DAYOFYEAR(now())-1 and YEAR(a.FCREATEDATE)=YEAR(now()) ";
        } else if (TIMEWEEK.equals(timeFilter)) {
            sql = sql + " and WEEK(a.FCREATEDATE)=WEEK(now()) and YEAR(a.FCREATEDATE)=YEAR(now()) ";
        } else if (TIMEMONTH.equals(timeFilter)) {
            sql = sql + " and MONTH(a.FCREATEDATE)=MONTH(now()) and YEAR(a.FCREATEDATE)=YEAR(now()) ";
        } else if (TIMEQUARTER.equals(timeFilter)) {
            sql = sql + " and QUARTER(a.FCREATEDATE)=QUARTER(now()) and YEAR(a.FCREATEDATE)=YEAR(now()) ";
        }
        return sql;
    }

    public static String sqlAddEntityNumberFilter(String sql, String entityFilter) {
        if (WfUtils.isNotEmpty(entityFilter)) {
            String[] entityNumbers = entityFilter.split(",");
            StringBuilder sb = new StringBuilder();
            sb.append('(');
            for (String s : entityNumbers) {
                if (!WfUtils.isNotEmpty(s)) continue;
                sb.append("'").append(s).append("'").append(",");
            }
            if (sb.length() > 1) {
                sql = sql + " and a.fbilltype in " + sb.substring(0, sb.length() - 1) + ") ";
            }
        }
        return sql;
    }

    public static Map<String, Object> queryUserInfo(Long initiator) {
        if (WfUtils.isEmpty(initiator)) {
            return Collections.emptyMap();
        }
        QFilter filter = new QFilter("id", "=", (Object)initiator);
        String fields = "picturefield,useropenid";
        QFilter[] qFilters = new QFilter[]{filter};
        DynamicObject[] dynObjs = BusinessDataServiceHelper.load((String)BOS_USER, (String)fields, (QFilter[])qFilters);
        if (dynObjs.length > 0) {
            HashMap<String, Object> userInfo = new HashMap<String, Object>();
            userInfo.put("name", dynObjs[0].get("name"));
            userInfo.put("imgUrl", WfUtils.getAbsAvatarPath(dynObjs[0].get("picturefield")));
            userInfo.put("openId", dynObjs[0].get("useropenid"));
            return userInfo;
        }
        return Collections.emptyMap();
    }

    public static Map<String, Map<String, Object>> queryUserInfo(Set<Long> userIds, Map<Long, String> userInfoMap) {
        if (userIds == null || userIds.size() < 1) {
            return Collections.emptyMap();
        }
        String fields = "picturefield,useropenid,id,name";
        QFilter filter = new QFilter("id", "in", userIds);
        QFilter[] qFilters = new QFilter[]{filter};
        DynamicObject[] dynObjs = BusinessDataServiceHelper.load((String)BOS_USER, (String)fields, (QFilter[])qFilters);
        if (dynObjs.length > 0) {
            HashMap<String, Map<String, Object>> re = new HashMap<String, Map<String, Object>>(dynObjs.length);
            for (int i = 0; i < dynObjs.length; ++i) {
                HashMap<String, Object> userInfo = new HashMap<String, Object>();
                String userNameForFinal = dynObjs[0].getString("name");
                if (userInfoMap != null && userInfoMap.size() > 0 && WfUtils.isNotEmpty(userInfoMap.get(dynObjs[i].get("id")))) {
                    userNameForFinal = userInfoMap.get(dynObjs[i].get("id"));
                }
                userInfo.put("name", userNameForFinal);
                userInfo.put("imgUrl", WfUtils.getAbsAvatarPath(dynObjs[i].get("picturefield")));
                userInfo.put("openId", dynObjs[i].get("useropenid"));
                re.put(dynObjs[i].get("id").toString(), userInfo);
            }
            return re;
        }
        return Collections.emptyMap();
    }

    public static Map<String, UserInfo> queryUserInfos(Set<Long> userIds) {
        HashMap<String, UserInfo> userInfo = new HashMap<String, UserInfo>();
        QFilter filter = new QFilter("id", "in", userIds);
        QFilter enable = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        QFilter[] qFilters = new QFilter[]{filter, enable};
        String fields = "name,id,picturefield,useropenid,number";
        DynamicObject[] dynObjs = BusinessDataServiceHelper.load((String)BOS_USER, (String)fields, (QFilter[])qFilters);
        Long userId = null;
        String userName = null;
        String userNumber = null;
        String userNameForFinal = null;
        for (int i = 0; i < dynObjs.length; ++i) {
            userId = dynObjs[i].getLong("id");
            userName = dynObjs[i].getString("name");
            userNumber = dynObjs[i].getString("number");
            if (WfUtils.isEmptyString(userName) || userId == null) continue;
            userNameForFinal = WfUtils.getUserNameForFinal(userId, userName, userNumber);
            dynObjs[i].set("name", (Object)userNameForFinal);
            userInfo.put(dynObjs[i].get("id").toString(), new UserInfo(dynObjs[i]));
        }
        return userInfo;
    }

    public static String sqlAddfilterCustome(String sql, String timeFilter, String beginDate, String endDate) {
        if ("timecustom".equalsIgnoreCase(timeFilter)) {
            StringBuilder sb = new StringBuilder(sql);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                if (beginDate != null) {
                    sdf.parseObject(beginDate);
                    sb.append(" and a.FCREATEDATE >= {ts '").append(beginDate).append(" 00:00:00'} ");
                }
                if (endDate != null) {
                    sdf.parseObject(endDate);
                    sb.append(" and a.FCREATEDATE <= {ts '").append(endDate).append(" 23:59:59'}");
                }
                return sb.toString();
            }
            catch (Exception e) {
                if (beginDate != null) {
                    sb.append(" and a.FCREATEDATE >= {ts '").append(beginDate).append("'} ");
                }
                if (endDate != null) {
                    sb.append(" and a.FCREATEDATE <= {ts '").append(endDate).append("'}");
                }
                return sb.toString();
            }
        }
        return ProcessAssistantUtil.sqlAddFilter(sql, timeFilter);
    }

    public static String sqlAddPriorityFilter(String sql, String priorityFilter) {
        if (WfUtils.isNotEmpty(priorityFilter)) {
            String[] prioritys = priorityFilter.split(",");
            StringBuilder sb = new StringBuilder();
            sb.append('(');
            for (String s : prioritys) {
                if (!WfUtils.isNotEmpty(s)) continue;
                sb.append(s).append(",");
            }
            if (sb.length() > 1) {
                sql = sql + " and c.fpriority in " + sb.substring(0, sb.length() - 1) + ") ";
            }
        }
        return sql;
    }

    public static Map<Object, DynamicObject> getMarkValueMap() {
        QFilter[] filters = new QFilter[]{new QFilter("categorynumber", "=", (Object)"priority")};
        Map taskMarkMap = BusinessDataServiceHelper.loadFromCache((String)"wf_taskmark", (String)"number,value,name", (QFilter[])filters);
        return taskMarkMap;
    }

    public static Map<Long, String> getProcdefNameByProcdefId(Set<Long> procdefIds) {
        HashMap<Long, String> procdefMap = new HashMap<Long, String>(procdefIds.size());
        if (procdefIds.isEmpty() || procdefIds.size() == 0) {
            return procdefMap;
        }
        QFilter qFilter = new QFilter("id", "in", procdefIds);
        DynamicObjectCollection cl = QueryServiceHelper.query((String)"wf_processdefinition", (String)"id,name", (QFilter[])new QFilter[]{qFilter}, (String)"createdate asc");
        if (WfUtils.isNotEmptyForCollection((Collection)cl)) {
            for (DynamicObject obj : cl) {
                procdefMap.put(obj.getLong("id"), obj.getString("name"));
            }
        }
        return procdefMap;
    }

    public static Map<Long, String> getPresentAssignee(Set<Long> procInstIds) {
        HashMap<Long, String> result = new HashMap<Long, String>(procInstIds.size());
        if (WfUtils.isEmptyForCollection(procInstIds)) {
            return result;
        }
        String sql = "select t.fprocinstid,p.fusername from t_wf_task t left join t_wf_participant p on t.fid = p.ftaskid where t.fisdisplay = '1' and p.fcompositetaskid =0 and t.fprocinstid in (?) ;";
        sql = sql.replaceAll("\\?", WfUtils.getQuestionMarkList(procInstIds.size()));
        ArrayList<Long> params = new ArrayList<Long>();
        params.addAll(procInstIds);
        try (DataSet ds = DB.queryDataSet((String)WfUtils.createAlgoKey("HistoricTaskInstanceEntityManagerImpl"), (DBRoute)DBRoute.workflow, (String)sql, (Object[])params.toArray());){
            for (Row r : ds) {
                Long procInstId = r.getLong("fprocinstid");
                String userName = r.getString("fusername");
                if (WfUtils.isEmpty((String)result.get(procInstId))) {
                    result.put(procInstId, userName);
                    continue;
                }
                result.put(procInstId, (String)result.get(procInstId) + StandardTips.getComma() + userName);
            }
        }
        return result;
    }
}

