/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task.processassistant;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.ORM;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.identity.UserInfo;
import kd.bos.workflow.engine.impl.cmd.task.processassistant.ProcessAssistantUtil;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.service.impl.ThreadLocalVariables;

public class ProcessGetAssistantApplyedTasksCmd
implements Command<DynamicObjectCollection>,
Serializable {
    private static final long serialVersionUID = -6763502634294991131L;
    private Long userId;
    private Integer start;
    private Integer limit;
    private String timeFilter;
    private String starterOrSubjectFilter;
    private String entityFilter;
    private String beginDate;
    private String endDate;
    private String entityName;
    private static final String BILLNAME = "billName";
    private static final String SUBJECT = "subject";
    private static final String STARTNAME = "startname";
    private static final String INITIATORID = "initiatorId";
    private static final String PROCINSTID = "procinstid";

    public ProcessGetAssistantApplyedTasksCmd(Long userId, Integer start, Integer limit, String starterOrSubjectFilter, String timeFilter, String entityFilter, String beginDate, String endDate, String entityName) {
        this.userId = userId;
        this.start = start;
        this.limit = limit;
        this.starterOrSubjectFilter = starterOrSubjectFilter;
        this.timeFilter = timeFilter;
        this.entityFilter = entityFilter;
        this.beginDate = beginDate;
        this.endDate = endDate;
        this.entityName = entityName;
    }

    @Override
    public DynamicObjectCollection execute(CommandContext commandContext) {
        HashMap<Long, String> userInfoMap = new HashMap<Long, String>();
        String lang = RequestContext.get().getLang().toString();
        String masterTableAlias = "a";
        String multiLangTableAlias = "b";
        String entityNumber = "wf_hiprocinst";
        String billNameSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, "FENTRABILLNAME", BILLNAME, "entrabillname");
        String subjectSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, "FSUBJECT", SUBJECT, SUBJECT);
        String startnameSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, "fstartname", STARTNAME, STARTNAME);
        String activitynameSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, "factivityname", "activityname", "activityname");
        String noCodeFlow = ThreadLocalVariables.get();
        String sql = "SELECT top " + (this.start + this.limit) + " a.FID procinstid, a.FENDTIME endTime," + billNameSQL + "," + subjectSQL + ", a.FBUSINESSKEY businesskey,\ta.FSTARTUSERID startUserId, a.FENTITYNUMBER formId, a.FBILLNO billNo," + activitynameSQL + ", a.fcreatedate createdate, a.fentitynumber entityNumber, '' initiatorId, '' initiator, '' userImgUrl, '' openId, '' text, '' url," + startnameSQL + " from t_wf_hiprocinst a LEFT JOIN t_wf_hiprocinst_l b ON a.FID = b.FID AND b.FLOCALEID = ? WHERE a.fcreatorid =? AND a.FENDTIME is not NULL AND a.FENDTYPE <> ? " + (WfUtils.isEmpty(noCodeFlow) ? "" : " and a.fprocesstype = ? ");
        sql = ProcessAssistantUtil.sqlAddEntityNumberFilter(sql, this.entityFilter);
        sql = ProcessAssistantUtil.sqlAddfilterCustome(sql, this.timeFilter, this.beginDate, this.endDate);
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(lang);
        paramList.add(this.userId);
        paramList.add("20");
        if (WfUtils.isNotEmpty(noCodeFlow)) {
            paramList.add(noCodeFlow);
        }
        if (WfUtils.isNotEmpty(this.starterOrSubjectFilter)) {
            sql = sql + " and ( b.fsubject like ? )";
            paramList.add("%" + this.starterOrSubjectFilter + "%");
        }
        if (WfUtils.isNotEmpty(this.entityName)) {
            sql = sql + " and ( b.fentrabillname like ? )";
            paramList.add(this.entityName + "%");
        }
        sql = sql + " order by a.FcreateDate desc ";
        HashSet<Long> userIds = new HashSet<Long>();
        userIds.add(this.userId);
        try (DataSet ds = DB.queryDataSet((String)"WfTaskCenter.t_wf_hiprocinst.queryGridData", (DBRoute)WfUtils.WFS, (String)sql, (Object[])paramList.toArray());){
            String startName = null;
            DynamicObjectCollection ret = ORM.create().toPlainDynamicObjectCollection(ds, this.start.intValue(), this.limit.intValue());
            for (DynamicObject row : ret) {
                Long startUserId = row.getLong("startUserId");
                startName = row.getString(STARTNAME);
                if (WfUtils.isNotEmpty(startUserId)) {
                    userInfoMap.put(startUserId, startName);
                    userIds.add(startUserId);
                    row.set(INITIATORID, (Object)startUserId);
                } else {
                    row.set(INITIATORID, (Object)this.userId);
                }
                row.set("text", (Object)ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"ProcessAssistantApplyedTasksCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]));
                row.set("url", (Object)MessageServiceUtil.buildWebPageUrlForMyApplyed((Long)row.get(PROCINSTID)));
            }
            Map<String, UserInfo> userInfos = ProcessAssistantUtil.queryUserInfos(userIds, userInfoMap);
            for (DynamicObject row : ret) {
                String initiatorId = String.valueOf(row.get(INITIATORID));
                UserInfo userInfo = userInfos.get(initiatorId);
                if (userInfo == null) continue;
                row.set("initiator", (Object)userInfo.getName());
                row.set("userImgUrl", (Object)userInfo.getImgUrl());
                row.set("openId", (Object)userInfo.getOpenId());
            }
            DynamicObjectCollection dynamicObjectCollection = ret;
            return dynamicObjectCollection;
        }
    }
}

