/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task.taskmodel;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.job.EventTriggerCmd;
import kd.bos.workflow.engine.impl.cmd.task.taskmodel.HandleTask;
import kd.bos.workflow.engine.impl.cmd.task.taskmodel.ResultInfo;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntityManager;
import kd.bos.workflow.engine.impl.util.WfOperationLogUtil;
import kd.bos.workflow.engine.msg.WFMessageServiceHelper;
import kd.bos.workflow.engine.task.BatchOperateResult;
import kd.bos.workflow.engine.task.OperateResult;
import kd.bos.workflow.engine.task.TaskCirculateEventParams;
import kd.bos.workflow.engine.task.TaskEventTypeEnum;
import kd.bos.workflow.engine.task.operation.CirculateOperationParam;
import kd.bos.workflow.exception.WFErrorCode;

public class CirculateTaskCmd
extends HandleTask
implements Command<BatchOperateResult> {
    private static Log logger = LogFactory.getLog(CirculateTaskCmd.class);
    protected CirculateOperationParam circulateOperationParam;
    protected List<Long> circulateUserIds;
    protected ILocaleString circulateMsg;
    protected List<Long> taskIds;
    protected Long operaterId;
    private boolean isAutoCirculate = false;
    protected List<HistoricTaskInstanceEntity> historicTaskEntities;
    protected List<TaskCirculateEventParams> taskCirculateEventParams = new ArrayList<TaskCirculateEventParams>();
    protected BatchOperateResult batchOperateResult = new BatchOperateResult();

    public CirculateTaskCmd() {
    }

    public CirculateTaskCmd(CirculateOperationParam circulateOperationParam, boolean isAutoCirculate) {
        this.circulateOperationParam = circulateOperationParam;
        this.circulateUserIds = circulateOperationParam.getCirculateUserIds();
        this.circulateMsg = circulateOperationParam.getCirculateMsg();
        this.taskIds = circulateOperationParam.getTaskIds();
        this.operaterId = circulateOperationParam.getOperaterId();
        this.isAutoCirculate = isAutoCirculate;
    }

    @Override
    protected void executeBeforeHandleTaskListeners(TaskEntity taskEntity, Map<String, Object> variables) {
    }

    @Override
    protected void executeHandleTaskListeners(TaskEntity taskEntity, Map<String, Object> variables) {
    }

    @Override
    protected void executeAfterHandleTaskListeners(TaskEntity taskEntity, Map<String, Object> variables) {
    }

    protected ResultInfo verifyTaskEntity(CommandContext commandContext) {
        ResultInfo resultInfo = this.verifyCirculateTasksParams();
        if (!resultInfo.isSuccess()) {
            return resultInfo;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", this.taskIds)};
        this.historicTaskEntities = commandContext.getHistoricTaskInstanceEntityManager().findByQueryFilters(qFilters);
        if (WfUtils.isEmptyForCollection(this.historicTaskEntities)) {
            return new ResultInfo(false, String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u76f8\u5173\u4efb\u52a1\uff0c\u6570\u636e\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u4e0d\u53ef%s\u3002", (String)"CirculateTaskCmd_0", (String)"bos-wf-engine", (Object[])new Object[0]), WfConfigurationUtil.getCirculationName()));
        }
        this.verifyTaskAllowCirculate();
        if (WfUtils.isEmptyForCollection(this.historicTaskEntities)) {
            return new ResultInfo(false, String.format(ResManager.loadKDString((String)"\u6240\u6709\u4efb\u52a1\u5747\u4e0d\u652f\u6301\u8be5\u64cd\u4f5c\uff0c\u4e0d\u53ef%s\u3002", (String)"CirculateTaskCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]), WfConfigurationUtil.getCirculationName()));
        }
        return new ResultInfo(true);
    }

    private ResultInfo verifyCirculateTasksParams() {
        if (WfUtils.isEmptyForCollection(this.taskIds)) {
            return new ResultInfo(false, ResManager.loadKDString((String)"\u5165\u53c2\u4efb\u52a1ID\u96c6\u5408\uff08taskIds\uff09\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CirculateTaskCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        if (!this.isAutoCirculate) {
            if (WfUtils.isEmpty(this.operaterId)) {
                return new ResultInfo(false, ResManager.loadKDString((String)"\u5165\u53c2\u4f20\u9605\u64cd\u4f5c\u4eba\uff08operaterId\uff09\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CirculateTaskCmd_3", (String)"bos-wf-engine", (Object[])new Object[0]));
            }
            boolean senderUserIdEnable = UserServiceHelper.isUserEnable((long)this.operaterId);
            if (!senderUserIdEnable) {
                return new ResultInfo(false, String.format(ResManager.loadKDString((String)"%1$s\u4eba\u4e0d\u53ef\u7528(\u4e0d\u5b58\u5728\u6216\u7981\u7528\u72b6\u6001)\uff0c\u4e0d\u80fd\u591f%2$s\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"CirculateTaskCmd_4", (String)"bos-wf-engine", (Object[])new Object[0]), WfConfigurationUtil.getCirculationName(), WfConfigurationUtil.getCirculationName()));
            }
        }
        if (WfUtils.isEmpty(this.circulateMsg)) {
            this.circulateMsg = ResManager.getLocaleString((String)"\u8bf7\u53c2\u9605\u3002", (String)"CirculateTaskCmd_11", (String)"bos-wf-engine");
        }
        if (WfUtils.isEmptyForCollection(this.circulateUserIds)) {
            return new ResultInfo(false, ResManager.loadKDString((String)"\u5165\u53c2\u88ab\u4f20\u9605\u4eba\uff08circulationUserIds\uff09\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CirculateTaskCmd_6", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        ArrayList<Long> userIdsCopy = new ArrayList<Long>(this.circulateUserIds);
        WfUtils.filterEnableUsers(this.circulateUserIds);
        if (WfUtils.isEmptyForCollection(this.circulateUserIds)) {
            List userInfoByID = UserServiceHelper.getUserInfoByID(userIdsCopy);
            List collect = userInfoByID.stream().map(item -> item.get("name") + "(" + item.get("number") + ")").collect(Collectors.toList());
            String msg = ResManager.loadKDString((String)"\u53c2\u4e0e\u4eba[%1$s]\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u7ecf\u88ab\u7981\u7528\uff0c\u4e0d\u80fd\u591f%2$s\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"CirculateTaskCmd_7", (String)"bos-wf-engine", (Object[])new Object[0]);
            return new ResultInfo(false, String.format(msg, Joiner.on((String)",").join(collect), WfConfigurationUtil.getCirculationName(), WfConfigurationUtil.getCirculationName()));
        }
        return new ResultInfo(true);
    }

    @Override
    public BatchOperateResult execute(CommandContext commandContext) {
        ResultInfo resultInfo = this.verifyTaskEntity(commandContext);
        if (!resultInfo.isSuccess()) {
            throw new KDException(WFErrorCode.verifyNotPassError(), new Object[]{"circulate", WfUtils.listToString(this.taskIds, ","), resultInfo.getDescription()});
        }
        this.circulateTasks(commandContext);
        this.triggerCirculateEvent(commandContext);
        return this.batchOperateResult;
    }

    protected void verifyTaskAllowCirculate() {
        Iterator<HistoricTaskInstanceEntity> iterator = this.historicTaskEntities.iterator();
        while (iterator.hasNext()) {
            HistoricTaskInstanceEntity historicTaskInstance = iterator.next();
            String control = historicTaskInstance.getControl();
            if (!WfUtils.isEmpty(control) && control.contains("\"circulate\":\"true\"")) continue;
            iterator.remove();
            this.batchOperateResult.setFailedCount(this.batchOperateResult.getFailedCount() + 1);
            String msg = String.format(ResManager.loadKDString((String)"\u4efb\u52a1\uff1a%1$s\u6240\u5c5e\u6d41\u7a0b\u8282\u70b9\u4e2d\u7684\u8282\u70b9\u63a7\u5236\uff0c\u6ca1\u6709\u5f00\u542f\u3010\u5141\u8bb8\u4f20\u9605\u3011\uff0c\u4efb\u52a1\u4e0d\u53ef%2$s\u3002", (String)"CirculateTaskCmd_8", (String)"bos-wf-engine", (Object[])new Object[0]), historicTaskInstance.getId(), WfConfigurationUtil.getCirculationName());
            this.batchOperateResult.getOperateResults().add(new OperateResult("circulate", "failed", msg, historicTaskInstance.getId(), historicTaskInstance.getBillNo()));
        }
    }

    protected void circulateTasks(CommandContext commandContext) {
        for (HistoricTaskInstanceEntity historicTaskEntity : this.historicTaskEntities) {
            if (historicTaskEntity == null) continue;
            ResultInfo resultInfo = this.circulateTask(commandContext, historicTaskEntity);
            if (resultInfo.isSuccess()) {
                Map<String, Object> data = resultInfo.getData();
                Long circulateMsgId = (Long)data.get("circulateMsgId");
                this.batchOperateResult.setSucessCount(this.batchOperateResult.getSucessCount() + 1);
                this.batchOperateResult.getOperateResults().add(new OperateResult("circulate", "success", circulateMsgId + "", historicTaskEntity.getId(), historicTaskEntity.getBillNo()));
                continue;
            }
            this.batchOperateResult.setFailedCount(this.batchOperateResult.getFailedCount() + 1);
            this.batchOperateResult.getOperateResults().add(new OperateResult("circulate", "failed", resultInfo.getDescription(), historicTaskEntity.getId(), historicTaskEntity.getBillNo()));
        }
        this.batchOperateResult.setValidateMsg(String.format(ResManager.loadKDString((String)"%1$s%2$s\u6761\u4efb\u52a1\uff0c\u6210\u529f%3$s\u6761\uff0c\u5931\u8d25%4$s\u6761\u3002", (String)"CirculateTaskCmd_9", (String)"bos-wf-engine", (Object[])new Object[0]), WfConfigurationUtil.getCirculationName(), null == this.taskIds ? 0 : this.taskIds.size(), this.batchOperateResult.getSucessCount(), this.batchOperateResult.getFailedCount()));
    }

    private ResultInfo circulateTask(CommandContext commandContext, HistoricTaskInstanceEntity historicTaskEntity) {
        if (historicTaskEntity == null) {
            return new ResultInfo(true);
        }
        Long circulateMsgId = 0L;
        try {
            this.handleCirculateLogs(commandContext, historicTaskEntity);
            circulateMsgId = this.handleCirculateMessage(historicTaskEntity);
            this.wrapCirculateEventData(historicTaskEntity);
        }
        catch (Exception e) {
            String description = String.format("task[%s-%s] circulate fail, reason[%s]", historicTaskEntity.getId(), historicTaskEntity.getBillNo(), WfUtils.getExceptionStacktrace(e));
            return new ResultInfo(false, description);
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("circulateMsgId", circulateMsgId);
        return new ResultInfo(true, "success", data);
    }

    private Long handleCirculateMessage(HistoricTaskInstanceEntity historicTaskEntity) {
        Long msgId = ID.genLongId();
        WFMessageServiceHelper.sendLinkMessageForCirculation(historicTaskEntity.getId(), this.circulateMsg, this.circulateUserIds, this.operaterId, msgId);
        return msgId;
    }

    private void handleCirculateLogs(CommandContext commandContext, HistoricTaskInstanceEntity historicTaskEntity) {
        TaskHandleLogEntityManager taskHandleLogEntityManager = commandContext.getTaskHandleLogEntityManager();
        Date date = commandContext.getProcessEngineConfiguration().getClock().getCurrentTime();
        TaskHandleLogEntity taskHandleLogEntity = null;
        for (Long userId : this.circulateUserIds) {
            taskHandleLogEntity = this.getTaskHandleLogEntity(historicTaskEntity, userId, date);
            taskHandleLogEntityManager.insert(taskHandleLogEntity);
            WfOperationLogUtil.recordOperationLogFromTaskHandle(commandContext, taskHandleLogEntity, null, null);
        }
    }

    private TaskHandleLogEntity getTaskHandleLogEntity(HistoricTaskInstanceEntity historicTaskEntity, Long assigneeId, Date date) {
        TaskHandleLogEntityImpl taskHandleLogEntity = new TaskHandleLogEntityImpl();
        taskHandleLogEntity.setAssigneeid(assigneeId);
        taskHandleLogEntity.setAssignee(WfUtils.findUserName(assigneeId));
        taskHandleLogEntity.setOwnerId(this.operaterId);
        taskHandleLogEntity.setCreateDate(date);
        taskHandleLogEntity.setModifyDate(date);
        taskHandleLogEntity.setType("circulation");
        if (WfUtils.isNotEmpty(this.circulateMsg)) {
            taskHandleLogEntity.setOpinion(this.circulateMsg);
        }
        if (historicTaskEntity != null) {
            taskHandleLogEntity.setTaskId(historicTaskEntity.getId());
            taskHandleLogEntity.setProcessDefinitionId(historicTaskEntity.getProcessDefinitionId());
            taskHandleLogEntity.setProcessInstanceId(historicTaskEntity.getProcessInstanceId());
            taskHandleLogEntity.setBusinessKey(historicTaskEntity.getBusinessKey());
            taskHandleLogEntity.setBillNo(historicTaskEntity.getBillNo());
            taskHandleLogEntity.setActivityId(historicTaskEntity.getTaskDefinitionKey());
            taskHandleLogEntity.setActivityName(historicTaskEntity.getName());
        }
        if (this.isAutoCirculate) {
            try {
                taskHandleLogEntity.setNote(WfUtils.getPromptWordLocaleString("\u7cfb\u7edf\u81ea\u52a8\u4f20\u9605", "CirculateTaskCmd_10", "bos-wf-engine"));
            }
            catch (Exception e) {
                logger.info(String.format("setNote is error %s", WfUtils.getExceptionStacktrace(e)));
            }
        }
        return taskHandleLogEntity;
    }

    private void wrapCirculateEventData(HistoricTaskInstanceEntity historicTaskEntity) {
        TaskCirculateEventParams taskCirculateEventParam = new TaskCirculateEventParams();
        taskCirculateEventParam.setTaskId(historicTaskEntity.getId());
        taskCirculateEventParam.setBillNo(historicTaskEntity.getBillNo());
        taskCirculateEventParam.setBusinessKey(historicTaskEntity.getBusinessKey());
        taskCirculateEventParam.setEntityNumber(historicTaskEntity.getEntityNumber());
        this.taskCirculateEventParams.add(taskCirculateEventParam);
    }

    protected void triggerCirculateEvent(CommandContext commandContext) {
        if (!commandContext.getProcessEngineConfiguration().isEnableBecEventDispatcher()) {
            logger.info("not use event power!");
            return;
        }
        HashMap<String, Object> eventMap = new HashMap<String, Object>();
        eventMap.put("taskCirculateEventParams", this.taskCirculateEventParams);
        eventMap.put("circulationMsg", this.circulateMsg);
        eventMap.put("senderUserId", this.operaterId);
        eventMap.put("circulationUserIds", this.circulateUserIds);
        new EventTriggerCmd(TaskEventTypeEnum.TASk_CIRCULATE_EVENT.getCode(), SerializationUtils.toJsonString(eventMap)).execute(commandContext);
    }
}

