/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task.taskmodel;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.job.EventTriggerCmd;
import kd.bos.workflow.engine.impl.cmd.task.RevoteCompositeTaskIdCmd;
import kd.bos.workflow.engine.impl.cmd.task.taskmodel.HandleTask;
import kd.bos.workflow.engine.impl.cmd.task.taskmodel.ResultInfo;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.ManagementConstants;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityManager;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.TaskHelper;
import kd.bos.workflow.engine.task.BatchOperateResult;
import kd.bos.workflow.engine.task.Comment;
import kd.bos.workflow.engine.task.OperateResult;
import kd.bos.workflow.engine.task.TaskCompleteEventParams;
import kd.bos.workflow.engine.task.TaskEventTypeEnum;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.bos.workflow.engine.task.operation.CompleteOperationParam;

public class CompleteTaskCmd
extends HandleTask
implements Command<BatchOperateResult> {
    protected static Log logger = LogFactory.getLog(CompleteTaskCmd.class);
    protected CompleteOperationParam completeOperationParam;
    protected Map<String, Object> variables;
    protected String decOptionNumber;
    protected String auditMessage;
    protected List<Long> taskIds;
    protected Long userId;
    protected Boolean asyncTodo = null;
    protected Boolean verifyValidate = false;
    protected boolean compensation = false;
    protected BatchOperateResult batchOperateResult = new BatchOperateResult();
    protected List<TaskEntity> taskEntitys;
    private List<TaskCompleteEventParams> taskCompleteEventParams = new ArrayList<TaskCompleteEventParams>();
    protected Map<String, Object> compensationVariables = null;
    private boolean dealWithCompositeTask = false;
    private List<Long> compositeTaskIds = null;
    private List<TaskEntity> compositeTaskEntities = null;

    @Override
    public BatchOperateResult execute(CommandContext commandContext) {
        return null;
    }

    protected ResultInfo verifyTask() {
        if (this.taskIds == null || this.taskIds.isEmpty()) {
            return new ResultInfo(false, ResManager.loadKDString((String)"\u4f20\u5165\u7684\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CompleteTaskCmd_0", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        if (WfUtils.isEmpty(this.completeOperationParam.getAuditMessage())) {
            return new ResultInfo(false, ResManager.loadKDString((String)"\u4f20\u5165\u7684\u5ba1\u6279\u610f\u89c1\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CompleteTaskCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        if (WfUtils.isEmpty(this.completeOperationParam.getDecOptionNumber())) {
            return new ResultInfo(false, ResManager.loadKDString((String)"\u4f20\u5165\u7684\u51b3\u7b56\u9879\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CompleteTaskCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        CommandContext commandContext = Context.getCommandContext();
        this.taskEntitys = commandContext.getTaskEntityManager().findByTaskIds(this.taskIds);
        if (this.taskEntitys == null || this.taskEntitys.isEmpty()) {
            return new ResultInfo(false, ResManager.loadKDString((String)"\u4efb\u52a1\u4e0d\u5b58\u5728\u3002", (String)"CompleteTaskCmd_3", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        return new ResultInfo(true);
    }

    protected ResultInfo verifyTaskDecision() {
        return new ResultInfo(true);
    }

    protected void setVariables() {
        if (!this.variables.containsKey("auditMessage")) {
            this.variables.put("auditMessage", this.completeOperationParam.getAuditMessage());
        }
        if (!this.variables.containsKey("auditNumber")) {
            this.variables.put("auditNumber", this.completeOperationParam.getDecOptionNumber());
        }
        if (!this.variables.containsKey("auditUserId")) {
            Long auditUserId = RequestContext.get().getCurrUserId();
            if (WfUtils.isNotEmpty(this.completeOperationParam.getOperaterId())) {
                auditUserId = this.completeOperationParam.getOperaterId();
            }
            this.variables.put("auditUserId", auditUserId);
        }
        if (this.variables != null && this.variables.get("terminal") == null) {
            this.variables.put("terminal", RequestContext.get().getClient());
        }
        this.variables.put("auditTime", new Date().getTime());
    }

    private ResultInfo validateTaskEntity(TaskEntity taskEntity) {
        String suspensionState = taskEntity.getSuspensionState();
        if (WfUtils.isNotEmpty(suspensionState) && !ManagementConstants.ACTIVE.getStateCode().equals(suspensionState)) {
            this.batchOperateResult.setFailedCount(this.batchOperateResult.getFailedCount() + 1);
            String msg = String.format("[%s-%s]%s", taskEntity.getId(), taskEntity.getBillNo(), ResManager.loadKDString((String)"\u4efb\u52a1\u88ab\u6302\u8d77\uff0c\u4e0d\u80fd\u5904\u7406\u3002", (String)"CompleteTaskCmd_14", (String)"bos-wf-engine", (Object[])new Object[0]));
            this.batchOperateResult.getOperateResults().add(new OperateResult("complete", "failed", msg, taskEntity.getId(), taskEntity.getBillNo()));
            return new ResultInfo(false);
        }
        List<IdentityLinkEntity> identityLinks = taskEntity.getIdentityLinks();
        IdentityLinkEntity identityLink = identityLinks.stream().filter(item -> item.getUserId().equals(this.userId)).findFirst().orElse(null);
        if (identityLink == null) {
            this.batchOperateResult.setFailedCount(this.batchOperateResult.getFailedCount() + 1);
            String msg = String.format("[%s]%s", this.userId, ResManager.loadKDString((String)"\u4e0d\u662f\u4efb\u52a1\u53c2\u4e0e\u4eba\u3002", (String)"CompleteTaskCmd_15", (String)"bos-wf-engine", (Object[])new Object[0]));
            this.batchOperateResult.getOperateResults().add(new OperateResult("complete", "failed", msg, taskEntity.getId(), taskEntity.getBillNo()));
            return new ResultInfo(false);
        }
        return new ResultInfo(true);
    }

    protected void handleTask(CommandContext commandContext) {
        try {
            ArrayList<TaskEntity> ts = new ArrayList<TaskEntity>();
            StringBuilder logInfoBuilder = new StringBuilder();
            TaskHelper taskHelper = commandContext.getProcessEngineConfiguration().getTaskHelper();
            for (TaskEntity taskEntity : this.taskEntitys) {
                try {
                    ResultInfo resultInfo = this.validateTaskEntity(taskEntity);
                    if (!resultInfo.isSuccess()) continue;
                    this.executeBeforeHandleTaskListeners(taskEntity, this.variables);
                    boolean verifySuccess = true;
                    if (this.verifyValidate.booleanValue()) {
                        verifySuccess = taskHelper.isValidate(taskEntity, this.variables);
                    }
                    if (verifySuccess) {
                        if (taskEntity.isDisplay()) {
                            taskEntity.setDisplay(false);
                            commandContext.getTaskEntityManager().update(taskEntity);
                        }
                        this.batchOperateResult.setSucessCount(this.batchOperateResult.getSucessCount() + 1);
                        this.batchOperateResult.getOperateResults().add(new OperateResult("complete", "success", "", taskEntity.getId(), taskEntity.getBillNo()));
                        ts.add(taskEntity);
                        logInfoBuilder.append(taskEntity.getId()).append(",");
                    } else {
                        this.batchOperateResult.setFailedCount(this.batchOperateResult.getFailedCount() + 1);
                        String msg = String.format("%s[%s]%s", taskEntity.getEntityName().getLocaleValue(), taskEntity.getBillNo(), ResManager.loadKDString((String)"\u4efb\u52a1\u5904\u7406\u8fc7\u7a0b\u4e2d\u6821\u9a8c\u64cd\u4f5c\u63d2\u4ef6\u5931\u8d25\u3002", (String)"CompleteTaskCmd_4", (String)"bos-wf-engine", (Object[])new Object[0]));
                        this.batchOperateResult.getOperateResults().add(new OperateResult("complete", "failed", msg, taskEntity.getId(), taskEntity.getBillNo()));
                    }
                    taskEntity.setTransientVariable("updateQuantitySummaryDone", Boolean.TRUE);
                }
                catch (Exception e) {
                    logger.error(WfUtils.getExceptionStacktrace(e));
                    this.batchOperateResult.setFailedCount(this.batchOperateResult.getFailedCount() + 1);
                    String msg = String.format(ResManager.loadKDString((String)"\u4efb\u52a1[%1$s-%2$s]\u5904\u7406\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38[%3$s]\u3002", (String)"CompleteTaskCmd_5", (String)"bos-wf-engine", (Object[])new Object[0]), taskEntity.getId(), taskEntity.getBillNo(), e.getMessage());
                    this.batchOperateResult.getOperateResults().add(new OperateResult("complete", "failed", msg, taskEntity.getId(), taskEntity.getBillNo()));
                }
            }
            this.batchOperateResult.setValidateMsg(String.format(ResManager.loadKDString((String)"[%1$s][%2$s]\u6761\u4efb\u52a1\uff0c\u6210\u529f[%3$s]\u6761\uff0c\u5931\u8d25[%4$s]\u6761\u3002", (String)"CompleteTaskCmd_6", (String)"bos-wf-engine", (Object[])new Object[0]), "executeComplete", null == this.taskIds ? 0 : this.taskIds.size(), this.batchOperateResult.getSucessCount(), this.batchOperateResult.getFailedCount()));
            if (ts.isEmpty()) {
                return;
            }
            try {
                this.handleTodoTask(taskHelper, ts);
                this.dealUndealCoordindateTask(commandContext, taskHelper, ts);
                this.variables.put("updateQuantitySummaryDone", Boolean.TRUE);
                this.variables.put("savedLogMark", "true");
                this.planBatchCompensationTaskJob(ts);
                taskHelper.addOperationLogForTasks(commandContext, ts, this.variables, this.userId);
                taskHelper.gatherAsyncCompensationData(ts);
            }
            catch (Exception e) {
                logInfoBuilder.append(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff1a%s", (String)"CompleteTaskCmd_7", (String)"bos-wf-engine", (Object[])new Object[0]), e.getMessage()));
                logger.error(String.format("\u6279\u91cf\u5904\u7406\u4efb\u52a1\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", WfUtils.getExceptionStacktrace(e)));
            }
            if (logInfoBuilder.length() > 0) {
                WfUtils.addOpLog("wf_task", "submit", new MultiLangEnumBridge("\u63d0\u4ea4\u5ba1\u6279\u4efb\u52a1", "CompleteTaskCmd_8", "bos-wf-engine"), null, logInfoBuilder.toString());
            }
        }
        catch (Exception e) {
            logger.error(WfUtils.getExceptionStacktrace(e));
        }
    }

    protected void planBatchCompensationTaskJob(List<TaskEntity> taskEntities) {
    }

    protected void planCompensationTaskJob(TaskHelper taskHelper, TaskEntity taskEntity) {
        taskHelper.planCompensationTaskJob(taskEntity, this.variables);
    }

    protected void dealUndealCoordindateTask(CommandContext commandContext, TaskHelper taskHelper, List<TaskEntity> ts) {
        taskHelper.deleteUndealCoordinateTask(commandContext, ts);
    }

    protected void handleTodoTask(TaskHelper taskHelper, List<TaskEntity> tasks) {
        boolean async = this.asyncTodo != null ? this.asyncTodo : tasks.size() > 1;
        taskHelper.quickBatchCompleteTask(tasks, this.userId, async);
    }

    protected ResultInfo handleCompensationTasks(CommandContext commandContext) {
        TaskHelper taskHelper = commandContext.getProcessEngineConfiguration().getTaskHelper();
        this.taskEntitys = commandContext.getTaskEntityManager().findByTaskIds(this.taskIds.toArray(new Long[0]), false);
        if (this.taskEntitys == null || this.taskEntitys.isEmpty()) {
            return new ResultInfo(false, String.format(ResManager.loadKDString((String)"\u4efb\u52a1[%s]\u5df2\u7ecf\u88ab\u5904\u7406", (String)"CompleteTaskCmd_9", (String)"bos-wf-engine", (Object[])new Object[0]), this.taskIds.get(0)));
        }
        this.dealWithCompositeTask = this.isNeedDealWithCompositeTask();
        for (TaskEntity taskEntity : this.taskEntitys) {
            Object terminal;
            this.dealCompositeTask(commandContext, taskHelper, taskEntity);
            this.compensationVariables = this.getHandleTaskParameters(taskEntity);
            if (this.variables.isEmpty() || this.variables.get("nocomment") == null) {
                Comment comment = taskHelper.addComment(taskEntity.getId(), null, this.userId, null, this.compensationVariables);
                taskHelper.addHiAttachment(comment, this.compensationVariables);
            }
            if ((terminal = this.variables.get("terminal")) != null) {
                taskHelper.updateTaskHandleLogForTasks(commandContext, taskEntity.getId(), terminal, this.getUserId());
            }
            this.variables.put("auditUserId", this.userId);
            this.executeHandleTaskListeners(taskEntity, this.variables);
            this.parseEventParams(taskEntity, this.variables);
            taskEntity.setTransientVariable("syncTaskComplete", true);
            taskHelper.completeTaskWithOutContinue(taskEntity, this.getUserId(), this.compensationVariables, true);
            taskEntity.removeTransientVariable("syncTaskComplete");
            this.executeAfterHandleTaskListeners(taskEntity, this.variables);
        }
        return new ResultInfo(true);
    }

    @Override
    protected void executeBeforeHandleTaskListeners(TaskEntity taskEntity, Map<String, Object> variables) {
    }

    @Override
    protected void executeHandleTaskListeners(TaskEntity taskEntity, Map<String, Object> variables) {
    }

    @Override
    protected void executeAfterHandleTaskListeners(TaskEntity taskEntity, Map<String, Object> variables) {
    }

    protected Map<String, Object> getHandleTaskParameters(TaskInfo info) {
        Long processDefinitionId = info.getProcessDefinitionId();
        Long processInstanceId = info.getProcessInstanceId();
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(processDefinitionId, processInstanceId);
        AuditTask element = (AuditTask)bpmnModel.getFlowElement(info.getTaskDefinitionKey());
        if (this.variables != null && this.variables.get("batchOpType") != null) {
            String batchOpType = (String)this.variables.get("batchOpType");
            if ("approve".equals(batchOpType) && null != element.getBatchApprove() && element.getBatchApprove().isBatchApprove()) {
                this.variables.put("auditNumber", element.getBatchApprove().getBatchApproveDec());
            }
            if ("reject".equals(batchOpType) && null != element.getBatchReject() && element.getBatchReject().isBatchReject()) {
                this.variables.put("auditNumber", element.getBatchReject().getBatchRejectDec());
                this.variables.put("dynType", "dynReject");
                this.variables.put("nextNodeId", element.getBatchReject().getBatchRejectNode());
            }
            this.variables.put("auditType", batchOpType);
        }
        String activityId = element.getId();
        List<DecisionOption> decisionOptions = element.getDecisionOptions();
        if (this.variables != null && this.variables.get("auditNumber") != null) {
            Object decisionNumber = this.variables.get("auditNumber");
            BaseElement decision = null;
            for (DecisionOption decisionOption : decisionOptions) {
                if (decisionNumber == null || !decisionOption.getNumber().equalsIgnoreCase(decisionNumber.toString())) continue;
                decision = decisionOption;
                break;
            }
            if (decision != null) {
                Object decisionName = this.variables.get("auditName");
                String decisionNameMultiKey = BpmnModelUtil.getDecisionNameMultiKey(activityId, decision.getId());
                ILocaleString decisionNameMulti = BpmnModelUtil.getMultiLangFieldValue(processInstanceId, decisionNameMultiKey, ((DecisionOption)decision).getName());
                LocaleString decisionNameLocale = null;
                if (decisionName instanceof Map) {
                    decisionNameLocale = LocaleString.fromMap((Map)((Map)decisionName));
                    if (decisionNameLocale != null && decisionNameLocale.size() <= 1) {
                        for (Lang lang : WfUtils.getSupportLangs()) {
                            String lan = lang.toString();
                            if (!WfUtils.isEmpty((String)decisionNameLocale.get((Object)lan))) continue;
                            decisionNameLocale.setItem(lan, decisionNameMulti.get((Object)lan));
                        }
                    }
                } else if (decisionName instanceof String) {
                    String multiKey = BpmnModelUtil.getDecisionNameMultiKey(activityId, (String)this.variables.get("auditNumber"));
                    decisionNameLocale = BpmnModelUtil.getMultiLangFieldValue(processInstanceId, multiKey, decisionName.toString());
                } else {
                    decisionNameLocale = decisionNameMulti;
                }
                this.variables.put("auditName", decisionNameLocale);
                if (((DecisionOption)decision).isRejectToParentProcessScene()) {
                    this.variables.put("dynType", "abortByRejectToParentProcess");
                }
            }
            this.variables.put("taskCompensation", true);
            this.variables.put("terminal", this.variables.get("terminal"));
            return this.variables;
        }
        BaseElement ret = null;
        for (DecisionOption d : decisionOptions) {
            if (!"approve".equals(d.getAuditType())) continue;
            if (ret == null) {
                ret = d;
            }
            if (!d.isDefaultDecision()) continue;
            ret = d;
            break;
        }
        HashMap<String, Object> mapParams = new HashMap<String, Object>();
        if (ret != null) {
            mapParams.put("auditNumber", ret.getNumber());
            String multiKey = BpmnModelUtil.getDecisionNameMultiKey(activityId, ret.getId());
            ILocaleString decisionName = BpmnModelUtil.getMultiLangFieldValue(processInstanceId, multiKey, ((DecisionOption)ret).getName());
            mapParams.put("auditName", decisionName);
            mapParams.put("auditType", ((DecisionOption)ret).getAuditType());
            if (null != this.variables) {
                Object message = this.variables.get("auditMessage");
                Object value = null;
                value = message instanceof Map ? LocaleString.fromMap((Map)((Map)message)) : WfUtils.getMultiLangValue(message != null ? message.toString() : "");
                if (WfUtils.isEmpty((ILocaleString)value)) {
                    ILocaleString auditMessage = WfUtils.getPromptWordLocaleString("\u540c\u610f", "CompleteTaskCmd_10", "bos-wf-engine");
                    mapParams.put("auditMessage", auditMessage);
                } else {
                    mapParams.put("auditMessage", value);
                }
                mapParams.put("terminal", this.variables.get("terminal"));
                if (this.variables.get("savedLogMark") != null) {
                    mapParams.put("savedLogMark", this.variables.get("savedLogMark"));
                }
            }
        }
        mapParams.put("taskCompensation", true);
        return mapParams;
    }

    private Long getUserId() {
        return WfUtils.isEmpty(this.userId) ? Long.valueOf(RequestContext.get().getUserId()) : this.userId;
    }

    protected void triggerTaskComplateEvent(CommandContext commandContext) {
        if (!commandContext.getProcessEngineConfiguration().isEnableBecEventDispatcher()) {
            return;
        }
        HashMap<String, Object> eventMap = new HashMap<String, Object>();
        Object auditMsg = null;
        if (this.compensationVariables != null) {
            auditMsg = this.compensationVariables.get("auditMessage");
        }
        eventMap.put("auditMessage", auditMsg);
        eventMap.put("taskCompleteEventParams", this.taskCompleteEventParams);
        new EventTriggerCmd(TaskEventTypeEnum.COMPLATE_TASK_EVENT.getCode(), SerializationUtils.toJsonString(eventMap)).execute(commandContext);
    }

    protected void revoteCompositeTask(CommandContext commandContext) {
        if (!this.dealWithCompositeTask || WfUtils.isEmptyForCollection(this.compositeTaskIds)) {
            return;
        }
        new RevoteCompositeTaskIdCmd(this.compositeTaskIds, this.compositeTaskEntities).execute(commandContext);
    }

    private void parseEventParams(TaskEntity task, Map<String, Object> variables) {
        TaskCompleteEventParams taskCompleteEventParam = new TaskCompleteEventParams();
        taskCompleteEventParam.setTaskId(task.getId());
        taskCompleteEventParam.setBusinessKey(task.getBusinessKey());
        taskCompleteEventParam.setEntityNumber(task.getEntityNumber());
        taskCompleteEventParam.setAuditNumber((String)variables.get("auditNumber"));
        taskCompleteEventParam.setBillNum(task.getBillNo());
        this.taskCompleteEventParams.add(taskCompleteEventParam);
    }

    protected boolean isNeedDealWithCompositeTask() {
        Object dealWithCompositeTaskObj;
        boolean dealWithCompositeTask = true;
        if (WfUtils.isNotEmptyForMap(this.variables) && WfUtils.isNotEmptyString(dealWithCompositeTaskObj = this.variables.get("dealWithCompositeTask"))) {
            dealWithCompositeTask = Boolean.parseBoolean(dealWithCompositeTaskObj.toString());
        }
        if (dealWithCompositeTask) {
            this.variables.put("dealWithCompositeTask", false);
        }
        return dealWithCompositeTask;
    }

    protected void dealCompositeTask(CommandContext commandContext, TaskHelper taskHelper, TaskEntity taskEntity) {
        IdentityLinkEntityManager identityLinkEntityManager;
        if (!this.dealWithCompositeTask) {
            return;
        }
        Long procinstanceId = taskEntity.getProcessInstanceId();
        String auditType = (String)this.variables.get("auditType");
        if (!"reject".equalsIgnoreCase(auditType) && !"forceReject".equalsIgnoreCase(auditType)) {
            this.compositeTaskEntities = this.planBatchCompensationForCompositeTask(commandContext, taskEntity.getId(), procinstanceId, taskHelper);
        }
        if (this.isRevoteCompositeTask(taskEntity, auditType, identityLinkEntityManager = commandContext.getIdentityLinkEntityManager())) {
            this.compositeTaskIds.add(taskEntity.getId());
        }
    }

    private List<TaskEntity> planBatchCompensationForCompositeTask(CommandContext commandContext, Long taskId, Long procinstanceId, TaskHelper taskHelper) {
        TaskEntityManager taskEntityManager;
        List<TaskEntity> compositeTaskEntities;
        Long tmpUser = this.userId;
        if (this.userId == null || this.userId == 0L) {
            String currentUserId = RequestContext.get().getUserId();
            tmpUser = currentUserId == null ? 0L : Long.parseLong(currentUserId);
        }
        if (WfUtils.isNotEmptyForCollection(compositeTaskEntities = (taskEntityManager = commandContext.getTaskEntityManager()).findCompositeTasksByTaskId(taskId, procinstanceId, tmpUser))) {
            for (TaskEntity task : compositeTaskEntities) {
                if (task.isDisplay()) {
                    task.setDisplay(false);
                    commandContext.getTaskEntityManager().update(task);
                }
                this.planCompensationTaskJob(taskHelper, task);
            }
        }
        return compositeTaskEntities;
    }

    private boolean isRevoteCompositeTask(TaskEntity task, String auditType, IdentityLinkEntityManager identityLinkEntityManager) {
        boolean dealWithCompositeTask = false;
        if ("reject".equalsIgnoreCase(auditType) || "forceReject".equalsIgnoreCase(auditType)) {
            return !dealWithCompositeTask;
        }
        QFilter filter0 = new QFilter("processInstanceId", "=", (Object)task.getProcessInstanceId());
        QFilter filter1 = new QFilter("userId", "!=", (Object)RequestContext.get().getCurrUserId());
        QFilter filter2 = new QFilter("compositetaskid", "is not null", null);
        QFilter filter3 = new QFilter("compositetaskid", "=", (Object)task.getId());
        QFilter[] filters = new QFilter[]{filter0, filter1, filter2, filter3};
        return identityLinkEntityManager.exist(filters);
    }
}

