/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task.taskmodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.event.ActivitiEventDispatcher;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.impl.cmd.job.EventTriggerCmd;
import kd.bos.workflow.engine.impl.cmd.task.taskmodel.HandleTask;
import kd.bos.workflow.engine.impl.cmd.task.taskmodel.ResultInfo;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityManager;
import kd.bos.workflow.engine.msg.info.TaskEntityInfo;
import kd.bos.workflow.engine.task.TaskEventTypeEnum;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.bos.workflow.engine.task.TaskUtils;
import kd.bos.workflow.exception.WFErrorCode;

public class CreateTaskCmd
extends HandleTask
implements Command<TaskInfo> {
    protected static Log logger = LogFactory.getLog(CreateTaskCmd.class);
    public static final String WF_TASKTHIRDSOURCE = "wf_taskthirdsource";
    protected TaskEntityInfo taskEntityInfo;

    @Override
    public TaskInfo execute(CommandContext commandContext) {
        ResultInfo resultInfo = this.checkValidity();
        if (!resultInfo.isSuccess()) {
            throw new KDException(WFErrorCode.verifyNotPassError(), new Object[]{"create", "", resultInfo.getDescription()});
        }
        return this.createTask(commandContext);
    }

    protected ResultInfo checkValidity() {
        ResultInfo resultInfo = new ResultInfo(true, "create task successfully");
        String taskModelNumber = this.taskEntityInfo.getNumber();
        String entityNumber = this.taskEntityInfo.getEntityNumber();
        String businessKey = this.taskEntityInfo.getBusinessKey();
        if (this.taskEntityInfo == null || WfUtils.isEmpty(taskModelNumber) || WfUtils.isEmpty(entityNumber) || WfUtils.isEmpty(businessKey)) {
            logger.info(String.format("create task is fail and taskEntityInfo: %s", this.taskEntityInfo));
            HashMap<String, Object> data = new HashMap<String, Object>();
            resultInfo = new ResultInfo(false, "create task is fail and taskEntityInfo", data);
        }
        return resultInfo;
    }

    protected TaskEntity createTask(CommandContext commandContext) {
        TaskEntity taskEntity = this.buildTaskEntity(commandContext);
        this.afterBuildTaskEntity(taskEntity);
        commandContext.getTaskEntityManager().insert(taskEntity, null);
        this.executeBeforeHandleTaskListeners(taskEntity, null);
        this.assignTaskParticipants(taskEntity);
        this.dispatchTaskListeners(taskEntity);
        this.executeHandleTaskListeners(taskEntity, null);
        this.planToDoJob(commandContext, taskEntity.getId());
        this.triggerCreateTaskEvent(taskEntity, new ArrayList<Long>(taskEntity.getParticipants()), commandContext);
        this.executeAfterHandleTaskListeners(taskEntity, null);
        return taskEntity;
    }

    protected void afterBuildTaskEntity(TaskEntity taskEntity) {
    }

    protected void assignTaskParticipants(TaskEntity taskEntity) {
    }

    private void dispatchTaskListeners(TaskEntity taskEntity) {
        ActivitiEventDispatcher eventDispatcher = Context.getProcessEngineConfiguration().getEventDispatcher();
        if (eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.TASK_CREATED, taskEntity));
        }
    }

    @Override
    protected void executeBeforeHandleTaskListeners(TaskEntity taskEntity, Map<String, Object> variables) {
    }

    @Override
    protected void executeHandleTaskListeners(TaskEntity taskEntity, Map<String, Object> params) {
    }

    @Override
    protected void executeAfterHandleTaskListeners(TaskEntity taskEntity, Map<String, Object> params) {
    }

    protected void planToDoJob(CommandContext commandContext, Long taskId) {
        if (this.taskEntityInfo.isAllowSendTodo()) {
            commandContext.getMessageService().createToDo(taskId);
        }
    }

    private void triggerCreateTaskEvent(TaskEntity task, List<Long> userIds, CommandContext commandContext) {
        if (!commandContext.getProcessEngineConfiguration().isEnableBecEventDispatcher()) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("taskId", task.getId());
        map.put("userIds", userIds);
        map.put("busKey", task.getBusinessKey());
        map.put("billNo", task.getBillNo());
        map.put("entityNum", task.getEntityNumber());
        map.put("taskTitle", task.getSubject());
        map.put("activityId", task.getTaskDefinitionKey());
        map.put("activityName", task.getName());
        map.put("createTime", task.getCreateDate());
        new EventTriggerCmd(TaskEventTypeEnum.TASK_CREATE_EVENT.getCode(), SerializationUtils.toJsonString(map)).execute(commandContext);
    }

    private TaskEntity buildTaskEntity(CommandContext commandContext) {
        TaskEntityManager taskEntityManager = commandContext.getTaskEntityManager();
        TaskEntity taskEntity = (TaskEntity)taskEntityManager.create();
        if (WfUtils.isNotEmpty(this.taskEntityInfo.getId())) {
            taskEntity.setId(this.taskEntityInfo.getId());
        }
        taskEntity.setName(this.taskEntityInfo.getName());
        ILocaleString description = this.taskEntityInfo.getDescription();
        if (WfUtils.isNotEmpty(description)) {
            taskEntity.setDescription(description.getLocaleValue());
        }
        taskEntity.setEndType(this.taskEntityInfo.getEndType());
        taskEntity.setDisplay(this.taskEntityInfo.isDisplay());
        if (WfUtils.isNotEmpty(this.taskEntityInfo.getProcessingPage())) {
            taskEntity.setProcessingPage(this.taskEntityInfo.getProcessingPage());
        } else {
            taskEntity.setProcessingMobilePage("wf_task_blankhandlepage");
        }
        if (WfUtils.isNotEmpty(this.taskEntityInfo.getProcessingMobilePage())) {
            taskEntity.setProcessingMobilePage(this.taskEntityInfo.getProcessingMobilePage());
        } else {
            taskEntity.setProcessingMobilePage("wf_task_blankhandlepage_mob");
        }
        taskEntity.setFormKey(this.taskEntityInfo.getFormKey());
        taskEntity.setMobileFormKey(this.taskEntityInfo.getMobileFormKey());
        taskEntity.setEntityNumber(this.taskEntityInfo.getEntityNumber());
        taskEntity.setBillNo(this.taskEntityInfo.getBillNo());
        taskEntity.setBusinessKey(this.taskEntityInfo.getBusinessKey());
        this.setEntityProperties(taskEntity);
        taskEntity.setStarterId(this.taskEntityInfo.getStarterId());
        taskEntity.setStartName(WfUtils.findUserName(this.taskEntityInfo.getStarterId()));
        taskEntity.setStartNameFormat(taskEntity.getStartName());
        taskEntity.setDueDate(this.taskEntityInfo.getDueDate());
        taskEntity.setSubject(this.taskEntityInfo.getSubject());
        taskEntity.setHandleState(this.taskEntityInfo.getHandleState());
        taskEntity.setCategory(this.taskEntityInfo.getCategory());
        taskEntity.setValidateOperation(this.taskEntityInfo.getValidateOperation());
        Map params = this.taskEntityInfo.getParams();
        if (params.containsKey("control")) {
            taskEntity.setControl((String)params.get("control"));
        }
        String source = this.taskEntityInfo.getSource();
        taskEntity.setSource(source);
        this.wrapBizTaskSource(taskEntity);
        if (WfUtils.isNotEmpty(this.taskEntityInfo.getResourceId())) {
            taskEntity.setResourceId(this.taskEntityInfo.getResourceId());
        }
        if (WfUtils.isNotEmpty(this.taskEntityInfo.getUrl())) {
            taskEntity.setUrl(this.taskEntityInfo.getUrl());
        }
        if (WfUtils.isNotEmpty(this.taskEntityInfo.getMobileUrl())) {
            taskEntity.setMobileUrl(this.taskEntityInfo.getMobileUrl());
        }
        return taskEntity;
    }

    private void wrapBizTaskSource(TaskEntity taskEntity) {
        String source = this.taskEntityInfo.getSource();
        if (!TaskUtils.isBizTask(source)) {
            return;
        }
        String sysNumber = "";
        String bizNumber = "";
        LocaleString sysName = null;
        LocaleString bizName = null;
        if (WfUtils.isNotEmpty(source) && !"cosmic".equalsIgnoreCase(source)) {
            sysNumber = this.taskEntityInfo.getSource();
            sysName = this.taskEntityInfo.getSourceName();
            bizNumber = this.taskEntityInfo.getBizType().getNumber();
            bizName = this.taskEntityInfo.getBizType().getName();
            taskEntity.setSourceName((ILocaleString)sysName);
            taskEntity.setYzjGroupId(bizNumber);
        } else {
            sysNumber = this.taskEntityInfo.getSource();
            bizNumber = this.taskEntityInfo.getBizType().getNumber();
            bizName = this.taskEntityInfo.getBizType().getName();
            taskEntity.setYzjGroupId(bizNumber);
        }
        try {
            QFilter f1 = new QFilter("sysnumber", "=", (Object)sysNumber);
            QFilter f2 = new QFilter("biznumber", "=", (Object)bizNumber);
            boolean exists = QueryServiceHelper.exists((String)WF_TASKTHIRDSOURCE, (QFilter[])new QFilter[]{f1, f2});
            if (!exists) {
                DynamicObject taskThridSource = BusinessDataServiceHelper.newDynamicObject((String)WF_TASKTHIRDSOURCE);
                taskThridSource.set("sysnumber", (Object)sysNumber);
                taskThridSource.set("sysname", (Object)sysName);
                taskThridSource.set("biznumber", (Object)bizNumber);
                taskThridSource.set("bizname", (Object)bizName);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskThridSource});
            }
        }
        catch (Exception e) {
            logger.error(String.format("query&insert %s occur error, errorInfo[%s]", WF_TASKTHIRDSOURCE, WfUtils.getExceptionStacktrace(e)));
        }
    }

    private void setEntityProperties(TaskEntity taskEntity) {
        LocaleString entityName;
        String entityNumber = this.taskEntityInfo.getEntityNumber();
        String businessKey = this.taskEntityInfo.getBusinessKey();
        if (WfUtils.isEmpty(entityNumber) || WfUtils.isEmpty(businessKey)) {
            return;
        }
        Map<String, Object> entityProperties = WfUtils.getEntityProperties(entityNumber, businessKey);
        if (entityProperties.isEmpty()) {
            return;
        }
        String billType = (String)entityProperties.get("billType");
        if (WfUtils.isNotEmpty(billType)) {
            taskEntity.setBillType(billType);
        }
        if (WfUtils.isNotEmpty((ILocaleString)(entityName = (LocaleString)entityProperties.get("entityName")))) {
            taskEntity.setEntityName((ILocaleString)entityName);
        }
    }
}

