/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task.taskmodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.delegatesetting.DelegateSettingEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.task.BatchOperateResult;
import kd.bos.workflow.engine.task.TaskDelegateCalculateUtil;
import kd.bos.workflow.engine.task.delegatesetting.TaskDelegateCalculateResult;

public class DelegateTaskCmd
implements Command<BatchOperateResult> {
    private static Log logger = LogFactory.getLog(DelegateTaskCmd.class);
    protected TaskEntity taskEntity;
    protected List<Long> userIds;

    @Override
    public BatchOperateResult execute(CommandContext commandContext) {
        return this.delegateBizTask(commandContext);
    }

    private BatchOperateResult delegateBizTask(CommandContext commandContext) {
        try {
            TaskDelegateCalculateResult taskDelegateResult = TaskDelegateCalculateUtil.getTrusteeIds(this.taskEntity, this.userIds, new ArrayList<Long>());
            Map<Long, List<DelegateSettingEntity>> delegateSettingEntityMapping = taskDelegateResult.getAssignorIdAndDelegateSettingEntitys();
            Collection<List<DelegateSettingEntity>> delegateSettingEntities = delegateSettingEntityMapping.values();
            List delegate = delegateSettingEntities.stream().filter(item -> item != null).findAny().orElse(null);
            if (delegate.isEmpty()) {
                return null;
            }
            TaskDelegateCalculateUtil.taskDelegate(this.taskEntity, this.userIds, delegateSettingEntityMapping);
        }
        catch (Exception e) {
            logger.warn(String.format("delegateTask error:[%s]", WfUtils.getExceptionStacktrace(e)));
        }
        return null;
    }
}

