/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task.taskmodel;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.event.ActivitiEventDispatcher;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.impl.cmd.task.taskmodel.HandleTask;
import kd.bos.workflow.engine.impl.cmd.task.taskmodel.ResultInfo;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityManager;
import kd.bos.workflow.engine.impl.util.TaskHelper;
import kd.bos.workflow.engine.impl.util.WfOperationLogUtil;
import kd.bos.workflow.engine.task.BatchOperateResult;
import kd.bos.workflow.engine.task.OperateResult;
import kd.bos.workflow.engine.task.operation.DeleteOperationParam;
import kd.bos.workflow.exception.WFErrorCode;

public class DeleteTaskCmd
extends HandleTask
implements Command<BatchOperateResult> {
    protected static Log logger = LogFactory.getLog(DeleteTaskCmd.class);
    private static final String DELETE = "delete";
    protected DeleteOperationParam deleteOperationParam;
    protected List<Long> taskIds;
    protected Long userId;
    protected String taskOperation;
    protected List<TaskEntity> taskEntities;
    protected BatchOperateResult batchOperateResult = new BatchOperateResult();

    @Override
    public BatchOperateResult execute(CommandContext commandContext) {
        ResultInfo resultInfo = this.verifyTaskEntity(commandContext);
        if (!resultInfo.isSuccess()) {
            throw new KDException(WFErrorCode.verifyNotPassError(), new Object[]{DELETE, WfUtils.listToString(this.taskIds, ","), this.batchOperateResult.toString()});
        }
        this.handleTaskEntities(commandContext);
        this.triggerEvent(commandContext);
        return this.batchOperateResult;
    }

    protected void triggerEvent(CommandContext commandContext) {
    }

    protected void handleTaskEntities(CommandContext commandContext) {
        for (TaskEntity taskEntity : this.taskEntities) {
            ResultInfo resultInfo = this.handleTasks(commandContext, taskEntity);
            if (resultInfo.isSuccess()) {
                this.batchOperateResult.setSucessCount(this.batchOperateResult.getSucessCount() + 1);
                this.batchOperateResult.getOperateResults().add(new OperateResult(this.taskOperation, "success", "", taskEntity.getId(), taskEntity.getBillNo()));
                continue;
            }
            this.batchOperateResult.setFailedCount(this.batchOperateResult.getFailedCount() + 1);
            this.batchOperateResult.getOperateResults().add(new OperateResult(this.taskOperation, "failed", resultInfo.getDescription(), taskEntity.getId(), taskEntity.getBillNo()));
        }
        this.batchOperateResult.setValidateMsg(String.format(ResManager.loadKDString((String)"%1$s%2$s\u6761\u4efb\u52a1\uff0c\u6210\u529f%3$s\u6761\uff0c\u5931\u8d25%4$s\u6761\u3002", (String)"DeleteTaskCmd_0", (String)"bos-wf-engine", (Object[])new Object[0]), this.taskOperation, null == this.taskIds ? 0 : this.taskIds.size(), this.batchOperateResult.getSucessCount(), this.batchOperateResult.getFailedCount()));
    }

    private ResultInfo handleTasks(CommandContext commandContext, TaskEntity taskEntity) {
        try {
            this.executeBeforeHandleTaskListeners(taskEntity, null);
            List<Long> deleteUserIds = this.getTaskUserIds(taskEntity);
            this.executeHandleTaskListeners(taskEntity, null);
            this.handleTaskInfo(commandContext, taskEntity);
            this.dispatchTaskListener(taskEntity);
            this.deleteTodo(commandContext, taskEntity, deleteUserIds);
            this.addOperationLog(commandContext, taskEntity);
            this.executeAfterHandleTaskListeners(taskEntity, null);
        }
        catch (Exception e) {
            String description = String.format("task[%s-%s] %s fail, reason[%s]", taskEntity.getId(), taskEntity.getBillNo(), this.taskOperation, WfUtils.getExceptionStacktrace(e));
            return new ResultInfo(false, description);
        }
        return new ResultInfo(true);
    }

    private List<Long> getTaskUserIds(TaskEntity taskEntity) {
        List<IdentityLinkEntity> identityLinks = taskEntity.getIdentityLinks();
        ArrayList<Long> userIds = new ArrayList<Long>(identityLinks.size());
        for (IdentityLinkEntity identityLink : identityLinks) {
            userIds.add(identityLink.getUserId());
        }
        return userIds;
    }

    private void addOperationLog(CommandContext commandContext, TaskEntity taskEntity) {
        boolean isDelte = DELETE.equalsIgnoreCase(this.taskOperation);
        ILocaleString note = isDelte ? WfUtils.getPromptWordLocaleString("\u5220\u9664\u4efb\u52a1", "DeleteTaskCmd_1", "bos-wf-engine") : WfUtils.getPromptWordLocaleString("\u5173\u95ed\u4efb\u52a1", "DeleteTaskCmd_2", "bos-wf-engine");
        MultiLangEnumBridge opNameBridge = isDelte ? new MultiLangEnumBridge("\u5220\u9664\u4efb\u52a1", "DeleteTaskCmd_1", "bos-wf-engine") : new MultiLangEnumBridge("\u5173\u95ed\u4efb\u52a1", "DeleteTaskCmd_2", "bos-wf-engine");
        String opKey = isDelte ? DELETE : "close";
        OperationLogEntityImpl operationLog = new OperationLogEntityImpl();
        operationLog.setTaskId(taskEntity.getId());
        operationLog.setCreateDate(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
        operationLog.setType(isDelte ? "deleteTask" : "closeTask");
        operationLog.setOwnerId(this.userId);
        operationLog.setOwner(WfUtils.findUserName(this.userId));
        operationLog.setNote(note);
        operationLog.setTerminalWay("background");
        WfOperationLogUtil.recordOperationLog(commandContext, operationLog);
        commandContext.getOperationLogEntityManager().insert(operationLog);
        WfUtils.addOpLog("wf_task", opKey, opNameBridge, null, String.format("operte[delete or close] task[%s] success", taskEntity.getId()));
    }

    protected void handleTaskInfo(CommandContext commandContext, TaskEntity taskEntity) {
        TaskHelper taskHelper = commandContext.getProcessEngineConfiguration().getTaskHelper();
        taskHelper.deleteTaskEntity(taskEntity, "deleteTaskApi[taskmodel]", true, false);
        Long taskId = taskEntity.getId();
        commandContext.getTrdCommentEntityManager().delete(taskId);
        commandContext.getCommentEntityManager().deleteCommentsByTaskId(taskId);
        QFilter[] filters = new QFilter[]{new QFilter("taskid", "=", (Object)taskId)};
        commandContext.getRuleTaskRelationEntityManager().deleteByFilters(filters);
        commandContext.getTaskHandleLogEntityManager().deleteByFilters(filters);
    }

    private void dispatchTaskListener(TaskEntity taskEntity) {
        ActivitiEventType activitiEventType = null;
        activitiEventType = DELETE.equalsIgnoreCase(this.taskOperation) ? ActivitiEventType.TASK_DELETED : ActivitiEventType.TASK_SKIP;
        ActivitiEventDispatcher eventDispatcher = Context.getProcessEngineConfiguration().getEventDispatcher();
        eventDispatcher.dispatchEvent(ActivitiEventBuilder.createEntityEvent(activitiEventType, taskEntity));
    }

    @Override
    protected void executeBeforeHandleTaskListeners(TaskEntity taskEntity, Map<String, Object> variables) {
    }

    @Override
    protected void executeHandleTaskListeners(TaskEntity taskEntity, Map<String, Object> variables) {
    }

    @Override
    protected void executeAfterHandleTaskListeners(TaskEntity taskEntity, Map<String, Object> variables) {
    }

    private void deleteTodo(CommandContext commandContext, TaskEntity taskEntity, List<Long> userIds) {
        commandContext.getMessageService().deleteToDo(taskEntity.getId(), userIds);
    }

    protected ResultInfo verifyTaskEntity(CommandContext commandContext) {
        if (this.taskIds == null || this.taskIds.isEmpty()) {
            return new ResultInfo(false, ResManager.loadKDString((String)"\u4f20\u5165\u7684\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DeleteTaskCmd_3", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        if (WfUtils.isEmpty(this.userId)) {
            return new ResultInfo(false, ResManager.loadKDString((String)"\u4f20\u5165\u7684\u64cd\u4f5c\u4eba\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DeleteTaskCmd_4", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        this.verifyTaskEntityExist(commandContext);
        if (this.batchOperateResult.getOperateResults().size() < this.taskIds.size()) {
            return new ResultInfo(true);
        }
        return new ResultInfo(false, String.format("%s task failed", this.taskOperation));
    }

    private void verifyTaskEntityExist(CommandContext commandContext) {
        TaskEntityManager taskEntityManager = commandContext.getTaskEntityManager();
        this.taskEntities = taskEntityManager.findByTaskIds(this.taskIds.toArray(new Long[0]), true);
        if (this.taskEntities.size() != this.taskIds.size()) {
            ArrayList<Long> tIds = new ArrayList<Long>(this.taskIds);
            for (TaskEntity taskEntity : this.taskEntities) {
                tIds.remove(taskEntity.getId());
            }
            for (Long tId : tIds) {
                this.batchOperateResult.setFailedCount(this.batchOperateResult.getFailedCount() + 1);
                String msg = String.format(ResManager.loadKDString((String)"\u4efb\u52a1[%s]\u53ef\u80fd\u5df2\u7ecf\u88ab\u5904\u7406\u5b8c\u6210\u3002", (String)"DeleteTaskCmd_5", (String)"bos-wf-engine", (Object[])new Object[0]), tId);
                this.batchOperateResult.getOperateResults().add(new OperateResult(this.taskOperation, "failed", msg, tId, ""));
            }
        }
    }
}

