/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task.taskmodel;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.taskmodel.HandleTask;
import kd.bos.workflow.engine.impl.cmd.task.taskmodel.ResultInfo;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.ManagementConstants;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.DurationDetailEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.DurationDetailEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.SuspendType;
import kd.bos.workflow.engine.impl.persistence.entity.task.RuleTaskRelationEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.RuleTaskRelationEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.RuleTaskRelationEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskMarkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskMarkEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskMarkEntityManager;
import kd.bos.workflow.engine.impl.util.WfOperationLogUtil;
import kd.bos.workflow.engine.task.BatchOperateResult;
import kd.bos.workflow.engine.task.OperateResult;
import kd.bos.workflow.engine.task.operation.SuspendOperationParam;

public class SuspendActiveTaskCmd
extends HandleTask
implements Command<BatchOperateResult> {
    private static Log logger = LogFactory.getLog(SuspendActiveTaskCmd.class);
    protected SuspendOperationParam suspendOperationParam;
    protected ILocaleString suspendReason;
    protected boolean isSuspendTask;
    protected List<Long> taskIds;
    protected Long operaterId;
    protected List<TaskEntity> taskEntities;
    protected BatchOperateResult batchOperateResult = new BatchOperateResult();

    public SuspendActiveTaskCmd() {
    }

    public SuspendActiveTaskCmd(SuspendOperationParam suspendOperationParam) {
        this.suspendOperationParam = suspendOperationParam;
        this.suspendReason = suspendOperationParam.getSuspendReason();
        this.isSuspendTask = suspendOperationParam.isSuspendTask();
        this.operaterId = suspendOperationParam.getOperaterId();
        this.taskIds = suspendOperationParam.getTaskIds();
    }

    @Override
    protected void executeBeforeHandleTaskListeners(TaskEntity taskEntity, Map<String, Object> variables) {
    }

    @Override
    protected void executeHandleTaskListeners(TaskEntity taskEntity, Map<String, Object> variables) {
    }

    @Override
    protected void executeAfterHandleTaskListeners(TaskEntity taskEntity, Map<String, Object> variables) {
    }

    @Override
    public BatchOperateResult execute(CommandContext commandContext) {
        ResultInfo resultInfo = this.verifyTaskEntity(commandContext);
        if (resultInfo.isSuccess()) {
            this.suspendTasks(commandContext);
        } else {
            this.batchOperateResult.setFailedCount(this.taskIds.size());
            this.batchOperateResult.setValidateMsg(resultInfo.getDescription());
        }
        return this.batchOperateResult;
    }

    protected ResultInfo verifyTaskEntity(CommandContext commandContext) {
        if (WfUtils.isEmptyForCollection(this.taskIds)) {
            return new ResultInfo(false, ResManager.loadKDString((String)"\u4efb\u52a1ID\u96c6\u5408\uff08taskIds\uff09\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SuspendActiveTaskCmd_0", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        if (WfUtils.isEmpty(this.operaterId)) {
            return new ResultInfo(false, ResManager.loadKDString((String)"\u64cd\u4f5c\u4eba\uff08operaterId\uff09\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SuspendActiveTaskCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        boolean senderUserIdEnable = UserServiceHelper.isUserEnable((long)this.operaterId);
        if (!senderUserIdEnable) {
            return new ResultInfo(false, String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u4eba[%s]\u4e0d\u53ef\u7528(\u4e0d\u5b58\u5728\u6216\u7981\u7528\u72b6\u6001)\uff0c\u4e0d\u80fd\u591f\u6267\u884c\u8be5\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"SuspendActiveTaskCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]), this.operaterId));
        }
        if (this.isSuspendTask && WfUtils.isEmpty(this.suspendReason)) {
            return new ResultInfo(false, ResManager.loadKDString((String)"\u6302\u8d77\u539f\u56e0\uff08suspendReason\uff09\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SuspendActiveTaskCmd_3", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        this.taskIds = this.taskIds.stream().filter(taskId -> WfUtils.isNotEmpty(taskId)).collect(Collectors.toList());
        this.taskEntities = commandContext.getTaskEntityManager().findByQueryFilters(new QFilter[]{new QFilter("id", "in", this.taskIds)});
        if (WfUtils.isEmptyForCollection(this.taskEntities)) {
            return new ResultInfo(false, String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u76f8\u5173\u4efb\u52a1\uff0c\u6570\u636e\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u4e0d\u53ef%s\u3002", (String)"SuspendActiveTaskCmd_4", (String)"bos-wf-engine", (Object[])new Object[0]), this.getOperationName()));
        }
        this.verifyTaskEntityOneByOne();
        if (WfUtils.isEmptyForCollection(this.taskEntities)) {
            return new ResultInfo(false, String.format(ResManager.loadKDString((String)"\u6240\u6709\u4efb\u52a1\u5747\u4e0d\u652f\u6301\u8be5\u64cd\u4f5c\uff0c\u4e0d\u53ef%s\u3002", (String)"SuspendActiveTaskCmd_5", (String)"bos-wf-engine", (Object[])new Object[0]), this.getOperationName()));
        }
        return new ResultInfo(true);
    }

    private void verifyTaskEntityOneByOne() {
        Iterator<TaskEntity> iterator = this.taskEntities.iterator();
        while (iterator.hasNext()) {
            TaskEntity taskEntity = iterator.next();
            ResultInfo resultInfo = this.verifyTaskStatus(taskEntity);
            if (!resultInfo.isSuccess()) {
                iterator.remove();
                this.batchOperateResult.setSucessCount(this.batchOperateResult.getSucessCount() + 1);
                this.batchOperateResult.getOperateResults().add(new OperateResult(this.getOperationName(), "failed", resultInfo.getDescription(), taskEntity.getId(), taskEntity.getBillNo()));
                continue;
            }
            resultInfo = this.verifyTaskParticpant(taskEntity);
            if (resultInfo.isSuccess()) continue;
            iterator.remove();
            this.batchOperateResult.setFailedCount(this.batchOperateResult.getFailedCount() + 1);
            this.batchOperateResult.getOperateResults().add(new OperateResult(this.getOperationName(), "failed", resultInfo.getDescription(), taskEntity.getId(), taskEntity.getBillNo()));
        }
    }

    private ResultInfo verifyTaskStatus(TaskEntity taskEntity) {
        boolean isTaskStatusRight = false;
        String suspensionState = taskEntity.getSuspensionState();
        if (this.isSuspendTask && ManagementConstants.ACTIVE.getStateCode().equals(suspensionState) || !this.isSuspendTask && !ManagementConstants.ACTIVE.getStateCode().equals(suspensionState)) {
            isTaskStatusRight = true;
        }
        if (!isTaskStatusRight) {
            String msg = String.format(ResManager.loadKDString((String)"\u4efb\u52a1[%1$s]\u76ee\u524d\u72b6\u6001\u4e0d\u652f\u6301%2$s\u3002", (String)"SuspendActiveTaskCmd_6", (String)"bos-wf-engine", (Object[])new Object[0]), taskEntity.getBillNo(), this.getOperationName());
            return new ResultInfo(false, msg);
        }
        return new ResultInfo(true);
    }

    private ResultInfo verifyTaskParticpant(TaskEntity taskEntity) {
        boolean isTaskParticpant = false;
        List<IdentityLinkEntity> identityLinks = taskEntity.getIdentityLinks();
        for (IdentityLinkEntity identityLink : identityLinks) {
            if ("coordinate".equals(identityLink.getType()) || !identityLink.getUserId().equals(this.operaterId)) continue;
            isTaskParticpant = true;
            break;
        }
        if (!isTaskParticpant) {
            String msg = String.format(ResManager.loadKDString((String)"\u8be5\u4eba\u5458[%1$s]\u975e\u4efb\u52a1[%2$s]\u5904\u7406\u4eba\uff0c\u4e0d\u80fd\u6267\u884c[%2$s]\u64cd\u4f5c\u3002", (String)"SuspendActiveTaskCmd_7", (String)"bos-wf-engine", (Object[])new Object[0]), this.operaterId, taskEntity.getBillNo(), this.getOperationName());
            return new ResultInfo(false, msg);
        }
        return new ResultInfo(true);
    }

    protected void suspendTasks(CommandContext commandContext) {
        for (TaskEntity taskEntity : this.taskEntities) {
            ResultInfo resultInfo = this.suspendTask(commandContext, taskEntity);
            if (resultInfo.isSuccess()) {
                this.batchOperateResult.setSucessCount(this.batchOperateResult.getSucessCount() + 1);
                this.batchOperateResult.getOperateResults().add(new OperateResult(this.getOperation(), "success", "", taskEntity.getId(), taskEntity.getBillNo()));
                continue;
            }
            this.batchOperateResult.setFailedCount(this.batchOperateResult.getFailedCount() + 1);
            this.batchOperateResult.getOperateResults().add(new OperateResult(this.getOperation(), "failed", resultInfo.getDescription(), taskEntity.getId(), taskEntity.getBillNo()));
        }
        this.batchOperateResult.setValidateMsg(String.format(ResManager.loadKDString((String)"\u5171\u5904\u7406%1$s\u6761\u4efb\u52a1\uff0c\u5176\u4e2d%2$s\u6761\u6210\u529f\uff0c%3$s\u6761\u5931\u8d25\u3002", (String)"SuspendActiveTaskCmd_8", (String)"bos-wf-engine", (Object[])new Object[0]), null == this.taskIds ? 0 : this.taskIds.size(), this.batchOperateResult.getSucessCount(), this.batchOperateResult.getFailedCount()));
    }

    private ResultInfo suspendTask(CommandContext commandContext, TaskEntity taskEntity) {
        try {
            this.executeBeforeHandleTaskListeners(taskEntity, new HashMap<String, Object>());
            this.handleSuspendTask(commandContext, taskEntity);
            this.executeHandleTaskListeners(taskEntity, new HashMap<String, Object>());
            this.handleSuspendLogs(commandContext);
            this.executeAfterHandleTaskListeners(taskEntity, new HashMap<String, Object>());
        }
        catch (Exception e) {
            String description = String.format(ResManager.loadKDString((String)"\u4efb\u52a1[%1$s]%2$s\u5931\u8d25, \u539f\u56e0\u5982\u4e0b\uff1a[%3$s]", (String)"SuspendActiveTaskCmd_9", (String)"bos-wf-engine", (Object[])new Object[0]), taskEntity.getBillNo(), this.getOperationName(), WfUtils.getExceptionStacktrace(e));
            return new ResultInfo(false, description);
        }
        return new ResultInfo(true);
    }

    private void handleSuspendTask(CommandContext commandContext, TaskEntity taskEntity) {
        if (this.isSuspendTask) {
            taskEntity.setSuspensionState(ManagementConstants.CUSTOMSUSPEND.getStateCode());
        } else {
            taskEntity.setSuspensionState(ManagementConstants.ACTIVE.getStateCode());
        }
        commandContext.getTaskEntityManager().update(taskEntity);
        if (this.isSuspendTask) {
            this.insertTaskRelation(commandContext, taskEntity);
            DurationDetailEntityManager durationDetailEntityManager = commandContext.getDurationDetailEntityManager();
            durationDetailEntityManager.insertDurationDetailByTaskId(taskEntity.getId(), taskEntity.getProcessInstanceId(), this.suspendReason, SuspendType.MANUALSUSPEND.getCode());
        } else {
            RuleTaskRelationEntityManager ruleTaskRelationEntityManager = commandContext.getRuleTaskRelationEntityManager();
            QFilter f1 = new QFilter("taskid", "=", (Object)taskEntity.getId());
            QFilter f2 = new QFilter("ruletype", "=", (Object)ManagementConstants.CUSTOMSUSPEND.getName());
            ruleTaskRelationEntityManager.deleteByFilters(new QFilter[]{f1, f2});
            this.updateDurationDetail(commandContext, taskEntity);
        }
    }

    private void handleSuspendLogs(CommandContext commandContext) {
        MultiLangEnumBridge opNameBridge;
        String operatorType = this.isSuspendTask ? "suspend" : "suspendCancel";
        OperationLogEntityImpl operationLog = new OperationLogEntityImpl();
        Date date = commandContext.getProcessEngineConfiguration().getClock().getCurrentTime();
        operationLog.setTaskId(this.taskIds.get(0));
        operationLog.setCreateDate(date);
        operationLog.setType(operatorType);
        operationLog.setOwnerId(this.operaterId);
        operationLog.setOwner(WfUtils.findUserName(this.operaterId));
        operationLog.setNOpinion(this.suspendReason);
        ILocaleString note = WfUtils.getPromptWordLocaleString("\u4e1a\u52a1\u624b\u52a8\u6302\u8d77\u4efb\u52a1", "SuspendActiveTaskCmd_10", "bos-wf-engine");
        operationLog.setNote(note);
        WfOperationLogUtil.recordOperationLog(commandContext, operationLog);
        String operationName = this.getOperationName();
        String opKey = this.isSuspendTask ? "suspend" : "activate";
        MultiLangEnumBridge multiLangEnumBridge = opNameBridge = this.isSuspendTask ? new MultiLangEnumBridge("\u6302\u8d77", "SuspendActiveTaskCmd_15", "bos-wf-engine") : new MultiLangEnumBridge("\u6fc0\u6d3b", "SuspendActiveTaskCmd_16", "bos-wf-engine");
        if (this.isSuspendTask && WfUtils.isNotEmpty(this.suspendReason)) {
            WfUtils.addOpLog("wf_task", opKey, opNameBridge, new MultiLangEnumBridge("\u4efb\u52a1%1$s\u6210\u529f\uff0c\u6302\u8d77\u539f\u56e0\uff1a%2$s", "SuspendActiveTaskCmd_17", "bos-wf-engine"), operationName, this.suspendReason);
        } else {
            WfUtils.addOpLog("wf_task", opKey, opNameBridge, new MultiLangEnumBridge("\u4efb\u52a1%s\u6210\u529f", "SuspendActiveTaskCmd_11", "bos-wf-engine"), operationName);
        }
    }

    private void insertTaskRelation(CommandContext commandContext, TaskEntity taskEntity) {
        TaskMarkEntityManager taskMarkEntityManager = commandContext.getTaskMarkEntityManager();
        TaskMarkEntity taskMarkEntity = taskMarkEntityManager.getTaskMarkEntityByNumber(ManagementConstants.CUSTOMSUSPEND.getName());
        Long taskMarkId = 1573895671679822848L;
        if (taskMarkEntity == null) {
            taskMarkEntity = new TaskMarkEntityImpl();
            taskMarkEntity.setId(taskMarkId);
            taskMarkEntity.setNumber(ManagementConstants.CUSTOMSUSPEND.getName());
            taskMarkEntity.setCategorynumber("task");
            ILocaleString taskName = WfUtils.getPromptWordLocaleString("\u4efb\u52a1", "SuspendActiveTaskCmd_13", "bos-wf-engine");
            taskMarkEntity.setCategoryname(taskName);
            ILocaleString markName = WfUtils.getPromptWordLocaleString("\u624b\u5de5\u6302\u8d77", "SuspendActiveTaskCmd_14", "bos-wf-engine");
            taskMarkEntity.setName(markName);
            taskMarkEntityManager.insert(taskMarkEntity);
        }
        RuleTaskRelationEntityManager ruleTaskRelationEntityManager = commandContext.getRuleTaskRelationEntityManager();
        QFilter f1 = new QFilter("taskid", "=", (Object)taskEntity.getId());
        QFilter f2 = new QFilter("ruletype", "=", (Object)ManagementConstants.CUSTOMSUSPEND.getName());
        List rtRelationEntities = ruleTaskRelationEntityManager.findByQueryFilters(new QFilter[]{f1, f2});
        HashSet<Long> tIds = new HashSet<Long>();
        if (rtRelationEntities != null) {
            for (RuleTaskRelationEntity ruleTaskRelationEntity : rtRelationEntities) {
                tIds.add(ruleTaskRelationEntity.getTaskid());
            }
        }
        if (!tIds.contains(taskEntity.getId())) {
            List<IdentityLinkEntity> identityLinks = taskEntity.getIdentityLinks();
            for (IdentityLinkEntity identityLinkEntity : identityLinks) {
                RuleTaskRelationEntityImpl relationEntity = new RuleTaskRelationEntityImpl();
                relationEntity.setTaskid(taskEntity.getId());
                relationEntity.setRuletype(ManagementConstants.CUSTOMSUSPEND.getName());
                relationEntity.setMarkid(taskMarkId);
                relationEntity.setUserid(identityLinkEntity.getUserId());
                relationEntity.setCurrentSubject(taskEntity.getSubject());
                relationEntity.setProcinstId(taskEntity.getProcessInstanceId());
                ruleTaskRelationEntityManager.insert(relationEntity);
            }
        }
    }

    private void updateDurationDetail(CommandContext commandContext, TaskEntity taskEntity) {
        DurationDetailEntityManager durationDetailEntityManager = commandContext.getDurationDetailEntityManager();
        List<DurationDetailEntity> durationDetails = durationDetailEntityManager.getDurationDetailsByTaskId(taskEntity.getId());
        if (durationDetails != null && !durationDetails.isEmpty()) {
            for (DurationDetailEntity durationDetail : durationDetails) {
                if (durationDetail.getUndoSuspendTime() != null) continue;
                Date currentDate = WfUtils.now();
                durationDetail.setUndoSuspendTime(currentDate);
                Date suspendTime = durationDetail.getSuspendTime();
                if (suspendTime != null) {
                    Long newSuspendDuration = currentDate.getTime() - suspendTime.getTime();
                    durationDetail.setSuspendDuration(newSuspendDuration);
                    Long realDuration = newSuspendDuration - durationDetail.getCalendarDuration();
                    durationDetail.setRealDuration(realDuration);
                }
                durationDetailEntityManager.update(durationDetail);
            }
        }
    }

    protected String getOperationName() {
        return this.isSuspendTask ? ResManager.loadKDString((String)"\u6302\u8d77", (String)"SuspendActiveTaskCmd_15", (String)"bos-wf-engine", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6fc0\u6d3b", (String)"SuspendActiveTaskCmd_16", (String)"bos-wf-engine", (Object[])new Object[0]);
    }

    protected String getOperation() {
        return this.isSuspendTask ? "suspend" : "activate";
    }

    protected Map<String, Object> buildListenerParams(Map<String, Object> variables) {
        if (variables == null) {
            variables = new HashMap<String, Object>();
        }
        variables.put("operaterId", this.operaterId);
        variables.put("taskIds", this.taskIds);
        variables.put("suspendReason", this.suspendReason);
        variables.put("isSuspendTask", this.isSuspendTask);
        return variables;
    }
}

