/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task.taskmodel;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.event.ActivitiEventDispatcher;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.impl.bpmn.helper.BPMNUtil;
import kd.bos.workflow.engine.impl.cmd.job.EventTriggerCmd;
import kd.bos.workflow.engine.impl.cmd.management.delegatesetting.ResumeDelegateTasksCmd;
import kd.bos.workflow.engine.impl.cmd.task.TaskTransferDealWithCoordinateCmd;
import kd.bos.workflow.engine.impl.cmd.task.TaskTransferDealWithSameUserCmd;
import kd.bos.workflow.engine.impl.cmd.task.taskmodel.HandleTask;
import kd.bos.workflow.engine.impl.cmd.task.taskmodel.ResultInfo;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.DefaultCommandContextCloseListener;
import kd.bos.workflow.engine.impl.jobexecutor.JobUtil;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.ManagementConstants;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.RuleTaskRelationEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntityManager;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.ParticipantHelper;
import kd.bos.workflow.engine.impl.util.TaskHelper;
import kd.bos.workflow.engine.impl.util.WfOperationLogUtil;
import kd.bos.workflow.engine.task.BatchOperateResult;
import kd.bos.workflow.engine.task.OperateResult;
import kd.bos.workflow.engine.task.TaskEventTypeEnum;
import kd.bos.workflow.engine.task.TaskUtils;
import kd.bos.workflow.engine.task.TasksTransferEventParams;
import kd.bos.workflow.engine.task.operation.TransferOperationParam;
import kd.bos.workflow.engine.task.operation.UpdateParticipantParam;
import kd.bos.workflow.exception.WFErrorCode;

public class TransferTaskCmd
extends HandleTask
implements Command<BatchOperateResult> {
    protected static Log logger = LogFactory.getLog(TransferTaskCmd.class);
    private static final String PASS = "pass";
    protected TransferOperationParam transferOperationParam;
    protected List<Long> taskIds;
    protected Long transfererId;
    protected ILocaleString transferOpinion;
    protected Boolean transferSubscribe = false;
    protected Long ownerId;
    protected UpdateParticipantParam updateParticipantParam;
    protected List<Long> particpationIds;
    protected boolean isAdminTransfer = false;
    protected boolean isAutoTransfer = false;
    protected boolean isNeedDealCompositeTask = false;
    protected Map<String, Object> dynInfo;
    private Boolean worksBatchTransfer = Boolean.FALSE;
    protected List<TaskEntity> taskEntities;
    private List<TasksTransferEventParams> tasksTransferEventParams = new ArrayList<TasksTransferEventParams>();
    protected BatchOperateResult batchOperateResult = new BatchOperateResult();

    @Override
    public BatchOperateResult execute(CommandContext commandContext) {
        ResultInfo resultInfo = this.verifyTaskEntity(commandContext);
        if (!resultInfo.isSuccess()) {
            throw new KDException(WFErrorCode.verifyNotPassError(), new Object[]{"transfer", WfUtils.listToString(this.taskIds, ","), this.batchOperateResult.toString()});
        }
        this.transferTaskEntities(commandContext);
        this.triggerTransferEvent(commandContext);
        return this.batchOperateResult;
    }

    protected void triggerTransferEvent(CommandContext commandContext) {
        if (!commandContext.getProcessEngineConfiguration().isEnableBecEventDispatcher()) {
            return;
        }
        if (this.tasksTransferEventParams.isEmpty()) {
            return;
        }
        HashMap<String, Object> eventMap = new HashMap<String, Object>();
        eventMap.put("tasksTransferEventParams", this.tasksTransferEventParams);
        eventMap.put("transferOpinion", this.transferOpinion);
        eventMap.put("transferId", this.transfererId);
        eventMap.put("transferType", this.isAdminTransfer ? "AdminTransfer" : "OrdinaryTransfer");
        new EventTriggerCmd(TaskEventTypeEnum.TASK_TRANSFER_EVENT.getCode(), SerializationUtils.toJsonString(eventMap)).execute(commandContext);
    }

    private ResultInfo validateTaskEntity(TaskEntity taskEntity) {
        List<IdentityLinkEntity> identityLinks;
        IdentityLinkEntity identityLink;
        String suspensionState = taskEntity.getSuspensionState();
        if (WfUtils.isNotEmpty(suspensionState) && !ManagementConstants.ACTIVE.getStateCode().equals(suspensionState)) {
            this.batchOperateResult.setFailedCount(this.batchOperateResult.getFailedCount() + 1);
            String msg = String.format("[%s-%s]%s", taskEntity.getId(), taskEntity.getBillNo(), ResManager.loadKDString((String)"\u4efb\u52a1\u88ab\u6302\u8d77\uff0c\u4e0d\u80fd\u8f6c\u4ea4\u3002", (String)"TransferTaskCmd_12", (String)"bos-wf-engine", (Object[])new Object[0]));
            this.batchOperateResult.getOperateResults().add(new OperateResult("transfer", "failed", msg, taskEntity.getId(), taskEntity.getBillNo()));
            return new ResultInfo(false);
        }
        if (!this.isAdminTransfer && (identityLink = (IdentityLinkEntity)(identityLinks = taskEntity.getIdentityLinks()).stream().filter(item -> item.getUserId().equals(this.ownerId)).findFirst().orElse(null)) == null) {
            this.batchOperateResult.setFailedCount(this.batchOperateResult.getFailedCount() + 1);
            String msg = String.format("[%s-%s][%s]%s", taskEntity.getId(), taskEntity.getBillNo(), this.ownerId, ResManager.loadKDString((String)"\u4e0d\u662f\u4efb\u52a1\u53c2\u4e0e\u4eba\u3002", (String)"TransferTaskCmd_13", (String)"bos-wf-engine", (Object[])new Object[0]));
            this.batchOperateResult.getOperateResults().add(new OperateResult("transfer", "failed", msg, taskEntity.getId(), taskEntity.getBillNo()));
            return new ResultInfo(false);
        }
        return new ResultInfo(true);
    }

    protected void transferTaskEntities(CommandContext commandContext) {
        for (TaskEntity taskEntity : this.taskEntities) {
            ResultInfo resultInfo = this.validateTaskEntity(taskEntity);
            if (!resultInfo.isSuccess()) continue;
            resultInfo = this.transferTasks(commandContext, taskEntity);
            if (resultInfo.isSuccess()) {
                this.batchOperateResult.setSucessCount(this.batchOperateResult.getSucessCount() + 1);
                this.batchOperateResult.getOperateResults().add(new OperateResult("transfer", "success", "", taskEntity.getId(), taskEntity.getBillNo()));
                continue;
            }
            this.batchOperateResult.setFailedCount(this.batchOperateResult.getFailedCount() + 1);
            this.batchOperateResult.getOperateResults().add(new OperateResult("transfer", "failed", resultInfo.getDescription(), taskEntity.getId(), taskEntity.getBillNo()));
        }
        this.batchOperateResult.setValidateMsg(String.format(ResManager.loadKDString((String)"%1$s%2$s\u6761\u4efb\u52a1\uff0c\u6210\u529f%3$s\u6761\uff0c\u5931\u8d25%4$s\u6761\u3002", (String)"TransferTaskCmd_0", (String)"bos-wf-engine", (Object[])new Object[0]), WfConfigurationUtil.getTransferName(), null == this.taskIds ? 0 : this.taskIds.size(), this.batchOperateResult.getSucessCount(), this.batchOperateResult.getFailedCount()));
    }

    private ResultInfo transferTasks(CommandContext commandContext, TaskEntity taskEntity) {
        try {
            List<Long> originalParticipantIds = this.getTaskOriginalUserIds(taskEntity);
            this.executeBeforeHandleTaskListeners(taskEntity, new HashMap<String, Object>());
            List<TaskHandleLogEntity> taskHandleLogEntities = this.getTaskHandleLogEntities(commandContext, taskEntity);
            this.handleTaskQuantitySummary(commandContext, taskEntity);
            this.dispatchTransferEvent(taskHandleLogEntities);
            new ResumeDelegateTasksCmd(taskEntity.getId()).execute(commandContext);
            this.handleTaskData(commandContext, taskEntity);
            this.handleTransferLogs(commandContext, taskEntity, taskHandleLogEntities);
            this.handleRtrelationData(commandContext, taskEntity, originalParticipantIds);
            this.executeHandleTaskListeners(taskEntity, new HashMap<String, Object>());
            this.dealWithToDoInfo(commandContext, taskEntity, originalParticipantIds);
            this.transferCompositeTask(commandContext, taskEntity);
            this.executeAfterHandleTaskListeners(taskEntity, new HashMap<String, Object>());
            this.wrapTransferEventData(taskEntity);
        }
        catch (Exception ex) {
            String description = String.format("task[%s-%s] transfer fail, reason[%s]", taskEntity.getId(), taskEntity.getBillNo(), WfUtils.getExceptionStacktrace(ex));
            return new ResultInfo(false, description);
        }
        return new ResultInfo(true);
    }

    private List<Long> getTaskOriginalUserIds(TaskEntity taskEntity) {
        List<IdentityLinkEntity> identityLinks = taskEntity.getIdentityLinks();
        ArrayList<Long> userIds = new ArrayList<Long>(identityLinks.size());
        for (IdentityLinkEntity identityLink : identityLinks) {
            userIds.add(identityLink.getUserId());
        }
        return userIds;
    }

    @Override
    protected void executeBeforeHandleTaskListeners(TaskEntity taskEntity, Map<String, Object> variables) {
    }

    @Override
    protected void executeHandleTaskListeners(TaskEntity taskEntity, Map<String, Object> variables) {
    }

    @Override
    protected void executeAfterHandleTaskListeners(TaskEntity taskEntity, Map<String, Object> variables) {
    }

    protected void buildListenerParams(Map<String, Object> variables) {
        variables.put("ownerId", this.ownerId);
        variables.put("opinion", this.transferOpinion);
        variables.put("taskIds", this.taskIds);
        if (this.isAdminTransfer) {
            variables.put("partitionIds", this.particpationIds);
            variables.put("isAdminTransfer", true);
        } else {
            variables.put("transferUserId", this.transfererId);
        }
    }

    protected void transferCompositeTask(CommandContext commandContext, TaskEntity taskEntity) {
        Long taskId = taskEntity.getId();
        try {
            if (this.isNeedDealCompositeTask) {
                TaskHelper.dealWithCompositeTask(taskId);
            } else if (TaskHelper.isComposeTask(taskId)) {
                TaskEntityManager taskEntityManager = commandContext.getTaskEntityManager();
                List<Long> composedTaskIds = taskEntityManager.findComposedTaskIdsByCompositeTaskIdAndUserId(taskId, this.ownerId);
                for (Long composedTaskId : composedTaskIds) {
                    TaskEntity composedTaskEntity = (TaskEntity)taskEntityManager.findById(composedTaskId);
                    this.transferTasks(commandContext, composedTaskEntity);
                }
            } else if (TaskHelper.isComposedTask(taskId)) {
                TaskHelper.clearIdentityCompositeTaskId(taskId);
            }
        }
        catch (Exception e) {
            String description = String.format("task[%s-%s] transfer fail, reason[%s]", taskEntity.getId(), taskEntity.getBillNo(), WfUtils.getExceptionStacktrace(e));
            logger.error(description);
        }
    }

    private void triggerApproverModifyListener(CommandContext commandContext, TaskEntity taskEntity) {
        if (!JobUtil.isInJobThread()) {
            commandContext.addCloseListener(new DefaultCommandContextCloseListener("withdraw-transfer"){

                @Override
                public void closed(CommandContext commandContext) {
                }
            });
        }
    }

    private void handleRtrelationData(CommandContext commandContext, TaskEntity taskEntity, List<Long> originalParticipantIds) {
        if (this.isAdminTransfer) {
            RuleTaskRelationEntityManager ruleMgr = commandContext.getRuleTaskRelationEntityManager();
            for (Long originalParticipantId : originalParticipantIds) {
                ruleMgr.deleteEntitiesByTaskIdAndTypeAndUserId(taskEntity.getId(), "coordinate", String.valueOf(originalParticipantId));
            }
            return;
        }
        Long taskId = taskEntity.getId();
        TaskUtils.insertRuleTaskRelationByTaskIdAndType(commandContext, taskId, this.transfererId, PASS);
        TaskUtils.deleteRuleTaskRelationByTaskIdAndType(commandContext, taskId, this.ownerId, "folder");
        TaskUtils.deleteRuleTaskRelationByTaskIdAndType(commandContext, taskId, this.ownerId, "priority");
        TaskUtils.deleteRuleTaskRelationByTaskIdAndType(commandContext, taskId, this.transfererId, "coordinate");
        Integer priority = 0;
        Object level = null;
        if (WfUtils.isNotEmptyForMap(this.dynInfo)) {
            level = this.dynInfo.get("priority");
            priority = TaskHelper.getPriorityValueByTaskLevel(level, taskId);
        }
        if (WfUtils.isNotEmptyString(priority) && 0 != priority && WfUtils.isNotEmptyString(level)) {
            TaskUtils.insertRuleTaskRelationByTaskIdAndType(commandContext, taskId, this.transfererId, level.toString());
        }
    }

    private void dealWithToDoInfo(CommandContext commandContext, TaskEntity taskEntity, List<Long> originalParticipantIds) {
        Long taskId = taskEntity.getId();
        if (this.isAdminTransfer) {
            ArrayList<Long> needCreateUserIds = new ArrayList<Long>(this.particpationIds);
            ArrayList<Long> needDeleteUserIds = new ArrayList<Long>();
            if (WfUtils.isNotEmptyForCollection(originalParticipantIds)) {
                for (Long originalParticipantId : originalParticipantIds) {
                    if (this.particpationIds.contains(originalParticipantId)) {
                        needCreateUserIds.remove(originalParticipantId);
                        continue;
                    }
                    needDeleteUserIds.add(originalParticipantId);
                }
            }
            if (!needDeleteUserIds.isEmpty()) {
                commandContext.getMessageService().deleteToDo(taskId, needDeleteUserIds);
            }
            if (!needCreateUserIds.isEmpty()) {
                commandContext.getMessageService().createTransferToDo(taskId, needCreateUserIds);
            }
        } else {
            if (!this.isAutoTransfer) {
                ArrayList<Long> userIds = new ArrayList<Long>();
                userIds.add(this.ownerId);
                commandContext.getMessageService().deleteToDo(taskId, userIds);
            }
            ArrayList<Long> transfererIds = new ArrayList<Long>();
            transfererIds.add(this.transfererId);
            commandContext.getMessageService().createTransferToDo(taskId, transfererIds);
        }
    }

    private void handleTransferLogs(CommandContext commandContext, TaskEntity taskEntity, List<TaskHandleLogEntity> taskHandleLogEntities) {
        TaskHandleLogEntityManager taskHandleLogEntityManager = commandContext.getTaskHandleLogEntityManager();
        if (this.isAdminTransfer) {
            QFilter taskFilter = new QFilter("taskId", "=", (Object)taskEntity.getId());
            QFilter userFilter = new QFilter("ownerId", "=", (Object)this.ownerId);
            QFilter typeFilter = new QFilter("type", "=", (Object)"transfer");
            taskHandleLogEntityManager.deleteByFilters(new QFilter[]{taskFilter, userFilter, typeFilter});
        }
        for (TaskHandleLogEntity taskHandleLogEntity : taskHandleLogEntities) {
            taskHandleLogEntityManager.insert(taskHandleLogEntity);
            WfOperationLogUtil.recordOperationLogFromTaskHandle(commandContext, taskHandleLogEntity, null, null);
        }
        Long taskId = taskHandleLogEntities.get(0).getTaskId();
        String transferName = WfConfigurationUtil.getTransferName();
        Long ownerId = taskHandleLogEntities.get(0).getOwnerId();
        WfUtils.addOpLog("wf_task", "taskTransfer", new MultiLangEnumBridge("\u5f85\u529e\u4efb\u52a1\u8f6c\u4ea4", "TaskTransferCmd_19", "bos-wf-engine"), new MultiLangEnumBridge("\u5c06\u5f85\u529e\u4efb\u52a1[%1$s]\u4ece%2$s%3$s\u7ed9[%4$s]", "TransferTaskCmd_2", "bos-wf-engine"), taskId, ownerId, transferName, this.isAdminTransfer ? WfUtils.listToString(this.particpationIds, ",") : this.transfererId);
    }

    private void handleTaskData(CommandContext commandContext, TaskEntity taskEntity) {
        String type = "participant";
        Long taskId = taskEntity.getId();
        ArrayList<Long> transferIds = new ArrayList<Long>();
        Long srcUserId = this.ownerId;
        if (this.isAdminTransfer) {
            transferIds.addAll(this.particpationIds);
            srcUserId = 0L;
            this.deleteOriginalIdentityLink(commandContext, taskEntity);
            this.insertNewIdentityLink(commandContext, taskEntity);
        } else {
            transferIds.add(this.transfererId);
            this.saveTransfererInfoForUpdateHiIdentity(commandContext, type, taskId);
            this.saveTransfererInfoForUpdateIdentity(commandContext, type, taskId);
        }
        commandContext.getHistoryManager().recordTaskParticipant(taskId, srcUserId, transferIds);
        this.updateHitaskInstPresentAssignee(commandContext, taskEntity);
        new TaskTransferDealWithCoordinateCmd(taskEntity.getId(), ((Object)transferIds).toString()).execute(commandContext);
        new TaskTransferDealWithSameUserCmd(taskId, transferIds).execute(commandContext);
    }

    protected void updateHitaskInstPresentAssignee(CommandContext commandContext, TaskEntity taskEntity) {
        BPMNUtil.updateHitaskInstPresentAssignee(taskEntity.getExecution(), null);
        commandContext.getTaskEntityManager().updateYzjTaskMemberInfoVariables(commandContext, taskEntity, this.ownerId, this.transfererId);
    }

    private void saveTransfererInfoForUpdateHiIdentity(CommandContext commandContext, String type, Long taskId) {
        HistoricIdentityLinkEntityManager historicIdentityLinkEntityManager = commandContext.getHistoricIdentityLinkEntityManager();
        List<HistoricIdentityLinkEntity> entity = historicIdentityLinkEntityManager.findHistoricIdentityLinksByTaskUserGroupAndType(taskId, this.ownerId, type);
        HistoricIdentityLinkEntity historicIdentityLinkEntity = (HistoricIdentityLinkEntity)commandContext.getHistoricIdentityLinkEntityManager().create();
        if (entity != null && !entity.isEmpty()) {
            historicIdentityLinkEntity = entity.get(0);
            if (null == historicIdentityLinkEntity.getOwnerId() || 0L == historicIdentityLinkEntity.getOwnerId()) {
                historicIdentityLinkEntity.setOwnerId(this.ownerId);
            }
            if (this.transferOpinion != null && this.transferOpinion.toString() != null) {
                historicIdentityLinkEntity.setTransferOpinion(this.transferOpinion);
            }
            historicIdentityLinkEntity.setUserId(this.transfererId);
            TaskEntity taskEntity = (TaskEntity)commandContext.getTaskEntityManager().findById(taskId);
            ILocaleString participantDisplayInfo = ParticipantHelper.getParticipantDisplayInfo(taskEntity, Collections.singletonList(this.transfererId)).get(this.transfererId);
            historicIdentityLinkEntity.setUserNameFormatter(participantDisplayInfo);
            historicIdentityLinkEntity.setUserName(WfUtils.findUserName(this.transfererId));
            historicIdentityLinkEntity.setReadTime(null);
            historicIdentityLinkEntity.setPriority(0);
            historicIdentityLinkEntityManager.update(historicIdentityLinkEntity);
        }
    }

    private void saveTransfererInfoForUpdateIdentity(CommandContext commandContext, String type, Long taskId) {
        IdentityLinkEntityManager identityLinkEntityManager = commandContext.getIdentityLinkEntityManager();
        List<IdentityLinkEntity> identityLinkEntitys = identityLinkEntityManager.findIdentityLinkByTaskUserAndType(taskId, this.ownerId, type);
        IdentityLinkEntity identityLinkEntity = new IdentityLinkEntityImpl();
        if (identityLinkEntitys != null && !identityLinkEntitys.isEmpty()) {
            identityLinkEntity = identityLinkEntitys.get(0);
            if (null == identityLinkEntity.getOwnerId() || 0L == identityLinkEntity.getOwnerId()) {
                identityLinkEntity.setOwnerId(this.ownerId);
            }
            if (this.transferOpinion != null && this.transferOpinion.toString() != null) {
                identityLinkEntity.setTransferOpinion(this.transferOpinion);
            }
            identityLinkEntity.setUserId(this.transfererId);
            identityLinkEntity.setCreateDate(WfUtils.now());
            identityLinkEntity.setUserName(WfUtils.findUserName(this.transfererId));
            TaskEntity taskEntity = (TaskEntity)commandContext.getTaskEntityManager().findById(taskId);
            ILocaleString participantDisplayInfo = ParticipantHelper.getParticipantDisplayInfo(taskEntity, Collections.singletonList(this.transfererId)).get(this.transfererId);
            identityLinkEntity.setUserNameFormatter(participantDisplayInfo);
            identityLinkEntity.setReadTime(null);
            identityLinkEntity.setPriority(0);
            identityLinkEntity.setCreateDate(WfUtils.now());
            identityLinkEntityManager.update(identityLinkEntity);
            List<IdentityLinkEntity> coIdentityLinkEntities = identityLinkEntityManager.findIdentityLinkByTaskUserAndType(taskId, this.transfererId, "coordinate");
            if (coIdentityLinkEntities != null && !coIdentityLinkEntities.isEmpty()) {
                RuleTaskRelationEntityManager ruleMgr = commandContext.getRuleTaskRelationEntityManager();
                for (IdentityLinkEntity coIdentityLinkEntity : coIdentityLinkEntities) {
                    identityLinkEntityManager.delete(coIdentityLinkEntity);
                    ruleMgr.deleteEntitiesByTaskIdAndTypeAndUserId(taskId, "coordinate", this.transfererId.toString());
                }
            }
        }
    }

    private void dispatchTransferEvent(List<TaskHandleLogEntity> entities) {
        ActivitiEventDispatcher eventDispatcher = Context.getProcessEngineConfiguration().getEventDispatcher();
        if (eventDispatcher.isEnabled() && entities != null) {
            if (this.isAdminTransfer) {
                eventDispatcher.dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.TASK_TRANSFER, entities));
            } else {
                eventDispatcher.dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.TASK_TRANSFER, entities.get(0)));
            }
        }
    }

    private void handleTaskQuantitySummary(CommandContext commandContext, TaskEntity taskEntity) {
        if (this.isAdminTransfer) {
            return;
        }
        TaskHelper taskHelper = commandContext.getProcessEngineConfiguration().getTaskHelper();
        taskHelper.gatherAsyncCompensationData(taskEntity);
    }

    private List<TaskHandleLogEntity> getTaskHandleLogEntities(CommandContext commandContext, TaskEntity taskEntity) {
        ArrayList<TaskHandleLogEntity> taskHandleLogEntities = new ArrayList<TaskHandleLogEntity>();
        if (this.isAdminTransfer) {
            String orinignalParticipantStr = this.collectorOrinignalParticipant(commandContext, taskEntity.getId());
            for (Long transfererId : this.particpationIds) {
                taskHandleLogEntities.add(this.getTaskHandleLogEntity(commandContext, taskEntity, transfererId, orinignalParticipantStr));
            }
        } else {
            taskHandleLogEntities.add(this.getTaskHandleLogEntity(commandContext, taskEntity, this.transfererId, null));
        }
        return taskHandleLogEntities;
    }

    private TaskHandleLogEntity getTaskHandleLogEntity(CommandContext commandContext, TaskEntity taskEntity, Long transferUserId, String orinignalParticipantStr) {
        TaskHandleLogEntityImpl taskHandleLogEntity = new TaskHandleLogEntityImpl();
        Date date = commandContext.getProcessEngineConfiguration().getClock().getCurrentTime();
        taskHandleLogEntity.setAssigneeid(transferUserId);
        taskHandleLogEntity.setAssignee(WfUtils.findUserName(transferUserId));
        taskHandleLogEntity.setAssigneeFormat(ParticipantHelper.getParticipantDisplayInfo(taskEntity, Collections.singletonList(transferUserId)).get(transferUserId));
        taskHandleLogEntity.setOwnerId(this.ownerId);
        taskHandleLogEntity.setOwner(WfUtils.findUserName(this.ownerId));
        taskHandleLogEntity.setOwnerFormat(ParticipantHelper.getParticipantDisplayInfo(taskEntity, Collections.singletonList(this.ownerId)).get(this.ownerId));
        taskHandleLogEntity.setCreateDate(date);
        taskHandleLogEntity.setModifyDate(date);
        taskHandleLogEntity.setType("transfer");
        taskHandleLogEntity.setTaskId(taskEntity.getId());
        if (this.transferOpinion != null && this.transferOpinion.toString() != null) {
            taskHandleLogEntity.setOpinion(this.transferOpinion);
        }
        taskHandleLogEntity.setSubscribe(this.transferSubscribe);
        taskHandleLogEntity.setProcessDefinitionId(taskEntity.getProcessDefinitionId());
        taskHandleLogEntity.setProcessInstanceId(taskEntity.getProcessInstanceId());
        taskHandleLogEntity.setBusinessKey(taskEntity.getBusinessKey());
        taskHandleLogEntity.setBillNo(taskEntity.getBillNo());
        taskHandleLogEntity.setIsadminforward(this.isAdminTransfer);
        taskHandleLogEntity.setActivityId(taskEntity.getTaskDefinitionKey());
        taskHandleLogEntity.setActivityName(taskEntity.getName());
        taskHandleLogEntity.setOriginalParticipant(orinignalParticipantStr == null ? "" : orinignalParticipantStr);
        if (this.isAutoTransfer) {
            taskHandleLogEntity.setNote(WfUtils.getPromptWordLocaleString("\u7cfb\u7edf\u81ea\u52a8\u8f6c\u4ea4", "AdminTransferTaskCmd_22", "bos-wf-engine"));
        } else if (this.worksBatchTransfer != null && this.worksBatchTransfer.booleanValue()) {
            taskHandleLogEntity.setNote(WfUtils.getPromptWordLocaleString("\u79fb\u4ea4\u5ba1\u6279\u4efb\u52a1", "AdminTransferTaskCmd_25", "bos-wf-engine"));
            taskHandleLogEntity.setOpinion(null);
        } else {
            taskHandleLogEntity.setNote(WfUtils.getPromptWordLocaleString("\u91cd\u65b0\u8bbe\u7f6e\u53c2\u4e0e\u4eba", "AdminTransferTaskCmd_21", "bos-wf-engine"));
        }
        return taskHandleLogEntity;
    }

    private void wrapTransferEventData(TaskEntity taskEntity) {
        List<IdentityLinkEntity> identityLinks = taskEntity.getIdentityLinks();
        ArrayList<Long> ownerIds = new ArrayList<Long>(identityLinks.size());
        for (IdentityLinkEntity identityLink : identityLinks) {
            ownerIds.add(identityLink.getUserId());
        }
        TasksTransferEventParams tasksTransferEventParam = new TasksTransferEventParams();
        tasksTransferEventParam.setTaskId(taskEntity.getId());
        tasksTransferEventParam.setOwnerId(ownerIds);
        tasksTransferEventParam.setBusinessKey(taskEntity.getBusinessKey());
        tasksTransferEventParam.setBillNo(taskEntity.getBillNo());
        tasksTransferEventParam.setEntityNumber(taskEntity.getEntityNumber());
        this.tasksTransferEventParams.add(tasksTransferEventParam);
    }

    protected ResultInfo verifyTaskEntity(CommandContext commandContext) {
        ResultInfo resultInfo = this.verifyOperationParams();
        if (!resultInfo.isSuccess()) {
            this.batchOperateResult.setValidateMsg(resultInfo.getDescription());
            return resultInfo;
        }
        TaskEntityManager taskEntityManager = commandContext.getTaskEntityManager();
        this.taskEntities = taskEntityManager.findByTaskIds(this.taskIds.toArray(new Long[0]), true);
        if (this.taskEntities == null || this.taskEntities.isEmpty()) {
            this.batchOperateResult.setFailedCount(this.taskIds.size());
        }
        ArrayList<Long> tIds = new ArrayList<Long>(this.taskIds);
        for (TaskEntity taskEntity : this.taskEntities) {
            tIds.remove(taskEntity.getId());
            this.verifyTransferInfo(taskEntity);
        }
        for (Long tId : tIds) {
            this.batchOperateResult.setFailedCount(this.batchOperateResult.getFailedCount() + 1);
            String msg = String.format(ResManager.loadKDString((String)"\u4efb\u52a1[%s]\u53ef\u80fd\u5df2\u7ecf\u88ab\u5904\u7406\u5b8c\u6210\u3002", (String)"TransferTaskCmd_3", (String)"bos-wf-engine", (Object[])new Object[0]), tId);
            this.batchOperateResult.getOperateResults().add(new OperateResult("transfer", "failed", msg, tId, ""));
        }
        if (this.batchOperateResult.getOperateResults().size() < this.taskIds.size()) {
            return new ResultInfo(true);
        }
        return new ResultInfo(false, "transfer is not success");
    }

    private ResultInfo verifyOperationParams() {
        if (WfUtils.isEmptyForCollection(this.taskIds)) {
            return new ResultInfo(false, ResManager.loadKDString((String)"\u4f20\u5165\u7684\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TransferTaskCmd_4", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        if (WfUtils.isEmpty(this.ownerId)) {
            return new ResultInfo(false, ResManager.loadKDString((String)"\u4f20\u5165\u7684\u64cd\u4f5c\u4eba\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TransferTaskCmd_5", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        if (this.isAdminTransfer) {
            if (WfUtils.isEmptyForCollection(this.particpationIds)) {
                return new ResultInfo(false, ResManager.loadKDString((String)"\u4f20\u5165\u7684\u53c2\u4e0e\u4eba\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TransferTaskCmd_6", (String)"bos-wf-engine", (Object[])new Object[0]));
            }
        } else if (WfUtils.isEmpty(this.transfererId)) {
            return new ResultInfo(false, ResManager.loadKDString((String)"\u4f20\u5165\u7684\u88ab\u8f6c\u4ea4\u4eba\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TransferTaskCmd_7", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        return new ResultInfo(true);
    }

    private void verifyTransferInfo(TaskEntity taskEntity) {
        ResultInfo resultInfo = this.verifyAllowTransferTask(taskEntity);
        if (!resultInfo.isSuccess()) {
            this.batchOperateResult.setFailedCount(this.batchOperateResult.getFailedCount() + 1);
            String msg = String.format(ResManager.loadKDString((String)"\u4efb\u52a1[%s]\u5728\u6a21\u578b\u4e2d\u4e0d\u652f\u6301\u8f6c\u4ea4\u3002", (String)"TransferTaskCmd_8", (String)"bos-wf-engine", (Object[])new Object[0]), taskEntity.getBillNo());
            this.batchOperateResult.getOperateResults().add(new OperateResult("transfer", "failed", msg, taskEntity.getId(), taskEntity.getBillNo()));
            return;
        }
        resultInfo = this.verifyTransferUsers(taskEntity);
        if (!resultInfo.isSuccess()) {
            this.batchOperateResult.setFailedCount(this.batchOperateResult.getFailedCount() + 1);
            this.batchOperateResult.getOperateResults().add(new OperateResult("transfer", "failed", resultInfo.getDescription(), taskEntity.getId(), taskEntity.getBillNo()));
            return;
        }
        resultInfo = this.verifyLoopTransfer(taskEntity);
        if (!resultInfo.isSuccess()) {
            this.batchOperateResult.setFailedCount(this.batchOperateResult.getFailedCount() + 1);
            String msg = String.format(ResManager.loadKDString((String)"\u4efb\u52a1[%1$s]\u5df2\u7ecf\u5b58\u5728[%2$s]\u8f6c\u4ea4\u7ed9[%3$s]\u7684\u8bb0\u5f55\uff0c\u81ea\u52a8\u8f6c\u4ea4\u4e0b\u4e0d\u80fd\u518d\u8f6c\u4ea4\u3002", (String)"TransferTaskCmd_9", (String)"bos-wf-engine", (Object[])new Object[0]), taskEntity.getId(), this.ownerId, this.transfererId);
            this.batchOperateResult.getOperateResults().add(new OperateResult("transfer", "failed", msg, taskEntity.getId(), taskEntity.getBillNo()));
        }
    }

    private ResultInfo verifyTransferUsers(TaskEntity taskEntity) {
        String billno = taskEntity.getBillNo();
        List<IdentityLinkEntity> identityLinks = taskEntity.getIdentityLinks();
        if (identityLinks.isEmpty()) {
            if (!this.isAdminTransfer) {
                return new ResultInfo(false, String.format(ResManager.loadKDString((String)"\u4efb\u52a1[%s]\u5f53\u524d\u8282\u70b9\u53c2\u4e0e\u4eba\u4e3a\u7a7a\u3002", (String)"TransferTaskCmd_10", (String)"bos-wf-engine", (Object[])new Object[0]), billno));
            }
        } else {
            boolean isSameParticipantion;
            ArrayList<Long> currentParticpationIds = new ArrayList<Long>(identityLinks.size());
            for (IdentityLinkEntity identityLink : identityLinks) {
                currentParticpationIds.add(identityLink.getUserId());
            }
            boolean bl = isSameParticipantion = this.isAdminTransfer ? this.compare(currentParticpationIds, this.particpationIds) : currentParticpationIds.contains(this.transfererId);
            if (isSameParticipantion) {
                return new ResultInfo(false, String.format(ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u5df2\u7ecf\u4e3a\u4efb\u52a1[%1$s]\u7684\u53c2\u4e0e\u4eba\uff0c\u4e0d\u53ef\u4ee5%2$s\u7ed9\u6b64\u4eba\u3002", (String)"TransferTaskCmd_11", (String)"bos-wf-engine", (Object[])new Object[0]), billno, WfConfigurationUtil.getTransferName()));
            }
        }
        return new ResultInfo(true);
    }

    protected ResultInfo verifyAllowTransferTask(TaskEntity taskEntity) {
        if (this.isAdminTransfer) {
            return new ResultInfo(true);
        }
        boolean canTransfer = true;
        String control = taskEntity.getControl();
        JSONObject controlJson = null;
        if (WfUtils.isNotEmpty(control)) {
            controlJson = JSONObject.parseObject((String)control);
            canTransfer = controlJson.getBoolean("transfer");
        }
        if (!canTransfer) {
            return new ResultInfo(false);
        }
        return new ResultInfo(true);
    }

    protected ResultInfo verifyLoopTransfer(TaskEntity taskEntity) {
        return new ResultInfo(true);
    }

    private boolean compare(List<Long> list1, List<Long> list2) {
        if (list1 == null || list2 == null) {
            return false;
        }
        if (list1.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list1.size(); ++i) {
            Long element2;
            Long element1 = list1.get(i);
            if (element1.equals(element2 = list2.get(i))) continue;
            return false;
        }
        return true;
    }

    private String collectorOrinignalParticipant(CommandContext commandContext, Long taskId) {
        TaskHandleLogEntityManager taskHandleLogEntityManager = commandContext.getTaskHandleLogEntityManager();
        List<TaskHandleLogEntity> taskHandleLogEntities = taskHandleLogEntityManager.findEntitiesByTaskIdAndType(taskId, "transfer");
        if (CollectionUtil.isNotEmpty(taskHandleLogEntities) && taskHandleLogEntities.get(0).getOriginalParticipant() != null) {
            return taskHandleLogEntities.get(0).getOriginalParticipant();
        }
        IdentityLinkEntityManager identityLinkEntityManager = commandContext.getIdentityLinkEntityManager();
        List<IdentityLinkEntity> identityLinkEntitys = identityLinkEntityManager.findIdentityLinksByTaskId(taskId);
        String orinignalParticipant = null;
        if (CollectionUtil.isNotEmpty(identityLinkEntitys)) {
            List userId = identityLinkEntitys.stream().map(identityLinkEntity -> String.valueOf(identityLinkEntity.getUserId())).collect(Collectors.toList());
            orinignalParticipant = userId.stream().collect(Collectors.joining(","));
        }
        return orinignalParticipant;
    }

    private void deleteOriginalIdentityLink(CommandContext commandContext, TaskEntity taskEntity) {
        IdentityLinkEntityManager identityLinkEntityManager = commandContext.getIdentityLinkEntityManager();
        HistoricIdentityLinkEntityManager historicIdentityLinkEntityManager = commandContext.getHistoricIdentityLinkEntityManager();
        List<IdentityLinkEntity> originalIdentityLinkEntities = identityLinkEntityManager.findIdentityLinksByTaskId(taskEntity.getId(), identityLinkEntityManager.getSelectFields());
        if (originalIdentityLinkEntities == null || originalIdentityLinkEntities.isEmpty()) {
            return;
        }
        ArrayList<IdentityLinkEntity> needDeleteIdentityLinkEntities = new ArrayList<IdentityLinkEntity>();
        for (IdentityLinkEntity orginalIdentityLinkEntity : originalIdentityLinkEntities) {
            if ("coordinate".equals(orginalIdentityLinkEntity.getType()) && orginalIdentityLinkEntity.getOwnerId() != 1L) continue;
            needDeleteIdentityLinkEntities.add(orginalIdentityLinkEntity);
        }
        taskEntity.getIdentityLinks().removeAll(needDeleteIdentityLinkEntities);
        IdentityLinkEntity identityLinkEntity = null;
        for (IdentityLinkEntity identity : needDeleteIdentityLinkEntities) {
            if (identityLinkEntity == null) {
                identityLinkEntity = identity;
            }
            identityLinkEntityManager.delete(identity);
            historicIdentityLinkEntityManager.delete(identity.getId());
        }
    }

    private void insertNewIdentityLink(CommandContext commandContext, TaskEntity taskEntity) {
        IdentityLinkEntityManager identityLinkEntityManager = commandContext.getIdentityLinkEntityManager();
        for (Long particpationId : this.particpationIds) {
            IdentityLinkEntityImpl newIdentityLinkEntity = new IdentityLinkEntityImpl();
            newIdentityLinkEntity.setUserId(particpationId);
            newIdentityLinkEntity.setUserName(WfUtils.findUserName(particpationId));
            ILocaleString participantDisplayInfo = ParticipantHelper.getParticipantDisplayInfo(taskEntity, Collections.singletonList(particpationId)).get(particpationId);
            newIdentityLinkEntity.setUserNameFormatter(participantDisplayInfo);
            if (WfUtils.isNotEmpty(this.transferOpinion)) {
                newIdentityLinkEntity.setTransferOpinion(this.transferOpinion);
            }
            newIdentityLinkEntity.setType("participant");
            newIdentityLinkEntity.setProcessInstanceId(taskEntity.getProcessInstanceId());
            newIdentityLinkEntity.setProcessDefId(taskEntity.getProcessDefinitionId());
            newIdentityLinkEntity.setParenttaskid(taskEntity.getParentTaskId());
            newIdentityLinkEntity.setTaskId(taskEntity.getId());
            identityLinkEntityManager.insert(newIdentityLinkEntity);
            taskEntity.getIdentityLinks().add(newIdentityLinkEntity);
        }
    }
}

