/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.enumeration.TaskListenerInvocationType;
import kd.bos.workflow.engine.impl.cmd.job.EventTriggerCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.DefaultCommandContextCloseListener;
import kd.bos.workflow.engine.impl.jobexecutor.JobUtil;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.ParticipantHelper;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.task.TaskEventTypeEnum;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.bos.workflow.exception.WFErrorCode;

public class updateTaskInfoAndParticipantCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = -7483627450637339858L;
    private TaskInfo taskinfo;
    private List<Long> userIds;

    public updateTaskInfoAndParticipantCmd(TaskInfo taskinfo, List<Long> userIds) {
        this.taskinfo = taskinfo;
        this.userIds = userIds;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        if (WfUtils.isNullObject(this.taskinfo) || WfUtils.isEmpty(this.taskinfo.getId())) {
            throw new KDException(WFErrorCode.illegAlargumentException(), new Object[]{ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u9519\u8bef\uff0cTaskInfo\u4e3a\u7a7a\u6216\u6ca1\u6709ID\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u3002", (String)"updateTaskInfoAndParticipantCmd_1", (String)"bos-wf-engine", (Object[])new Object[0])});
        }
        if (CollectionUtil.isEmpty(this.userIds)) {
            throw new KDException(WFErrorCode.illegAlargumentException(), new Object[]{ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u9519\u8bef\uff0cuserIDs\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u3002", (String)"updateTaskInfoAndParticipantCmd_2", (String)"bos-wf-engine", (Object[])new Object[0])});
        }
        final TaskEntity task = (TaskEntity)this.taskinfo;
        Long taskId = task.getId();
        Set participants = task.getParticipants();
        commandContext.getTaskEntityManager().update(task);
        IdentityLinkEntityManager imgr = commandContext.getIdentityLinkEntityManager();
        imgr.deleteIdentityLinksByTask(task);
        commandContext.getHistoricIdentityLinkEntityManager().deleteHistoricIdentityLinksByTaskId(taskId);
        if (participants != null && participants.size() > 0) {
            commandContext.getMessageService().deleteToDo(taskId, new ArrayList<Long>(participants));
        }
        task.addUserIdentityLinks(this.userIds, "participant");
        final FlowElement elem = ProcessDefinitionUtil.getFlowElement(task.getProcessDefinitionId(), task.getProcessInstanceId(), task.getTaskDefinitionKey());
        String elementType = elem.getType();
        if ("YunzhijiaTask".equals(elementType)) {
            this.updateYZJVariableInstance(commandContext, participants);
        }
        if (elem != null && this.userIds != null && elem instanceof UserTask && ((UserTask)elem).isAllowSendTodo() && !((UserTask)elem).isHideTaskInCenter()) {
            commandContext.getMessageService().createTransferToDo(taskId, this.userIds);
        }
        if (JobUtil.isInJobThread()) {
            commandContext.getProcessEngineConfiguration().getListenerNotificationHelper().executeTaskListeners((UserTask)elem, task, "approverModify", TaskListenerInvocationType.NOTWITHDRAW);
        } else {
            commandContext.addCloseListener(new DefaultCommandContextCloseListener("updateTaskInfoAndParticipant"){

                @Override
                public void closed(CommandContext commandContext) {
                    commandContext.getProcessEngineConfiguration().getListenerNotificationHelper().executeTaskListeners((UserTask)elem, task, "approverModify", TaskListenerInvocationType.NOTWITHDRAW);
                }
            });
        }
        if (commandContext.getProcessEngineConfiguration().isEnableBecEventDispatcher()) {
            HashMap<String, Object> eventMap = new HashMap<String, Object>();
            eventMap.put("taskId", task.getId());
            eventMap.put("busKey", task.getBusinessKey());
            eventMap.put("entityNum", task.getEntityNumber());
            eventMap.put("billNo", task.getEntityNumber());
            eventMap.put("oldParticipants", participants);
            eventMap.put("userIds", this.userIds);
            new EventTriggerCmd(TaskEventTypeEnum.UPDATE_TASK_PARTICIPANT_EVENT.getCode(), SerializationUtils.toJsonString(eventMap)).execute(commandContext);
        }
        return null;
    }

    private void updateYZJVariableInstance(CommandContext commandContext, Set<Long> participants) {
        Long parentTaskId = this.taskinfo.getParentTaskId();
        TaskEntity parentTask = (TaskEntity)commandContext.getTaskEntityManager().findById(parentTaskId);
        Set updateParticipantIds = parentTask.getParticipants();
        if (!(updateParticipantIds == null || updateParticipantIds.size() <= 0 || participants == null || participants.size() == this.userIds.size() && participants.containsAll(this.userIds) && this.userIds.containsAll(participants))) {
            for (Long userId : participants) {
                updateParticipantIds.remove(userId);
            }
            for (Long userId : this.userIds) {
                updateParticipantIds.add(userId);
            }
            parentTask.setVariableLocal("teamMembers", WfUtils.listToString(updateParticipantIds, ","));
            ILocaleString participantNameFormater = ParticipantHelper.getUserNameFormatValue(parentTask, updateParticipantIds);
            parentTask.setVariableLocal("teamMemberNamesFormat", SerializationUtils.toJsonString((Object)participantNameFormater));
            ArrayList<Long> updateParticipantNameList = new ArrayList<Long>(updateParticipantIds);
            ILocaleString updateParticipantName = commandContext.getProcessEngineConfiguration().getTaskHelper().getParticipantName(updateParticipantNameList);
            parentTask.setVariableLocal("teamMemberNames", SerializationUtils.toJsonString((Object)updateParticipantName));
        }
    }
}

