/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task.upgrade;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.bpmn.model.Activity;
import kd.bos.workflow.bpmn.model.AutoTask;
import kd.bos.workflow.bpmn.model.BoundaryEvent;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.CancelEventDefinition;
import kd.bos.workflow.bpmn.model.CompensateEventDefinition;
import kd.bos.workflow.bpmn.model.EndEvent;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.StartEvent;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.domain.model.NodeForkJoinModel;
import kd.bos.workflow.engine.TableNameConstant;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.delegate.event.ActivitiEventDispatcher;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.history.HistoricProcessInstance;
import kd.bos.workflow.engine.impl.agenda.ForkJoinUtils;
import kd.bos.workflow.engine.impl.bpmn.listener.MessageChannelProcessListener;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.cmd.GetNotWithdrawProcInstIdByBusKeyCmd;
import kd.bos.workflow.engine.impl.cmd.job.EventTriggerCmd;
import kd.bos.workflow.engine.impl.cmd.management.AbandonProcessCmd;
import kd.bos.workflow.engine.impl.cmd.management.BillWithdrawJumpToUserNodeCmd;
import kd.bos.workflow.engine.impl.cmd.management.delegatesetting.ResumeDelegateTasksCmd;
import kd.bos.workflow.engine.impl.cmd.task.WithdrawTaskCmd;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.delegate.ActivityBehavior;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.DefaultCommandContextCloseListener;
import kd.bos.workflow.engine.impl.persistence.entity.design.AuditPointInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.AuditPointInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.detaillog.DetailLogEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricVariableInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricVariableInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.job.DeadLetterJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.TimerJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ManagementConstants;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.DynamicResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.DynamicResourceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.HiUserActInstEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.HiUserActInstEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.PathJson;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.VariableInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityManager;
import kd.bos.workflow.engine.impl.util.AutoTaskUtil;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.DynamicObjectJsonSerializer;
import kd.bos.workflow.engine.impl.util.DynamicProcessDefinitionHelper;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.RuntimeUtil;
import kd.bos.workflow.engine.impl.util.TaskHelper;
import kd.bos.workflow.engine.impl.util.ViewFlowchartUtil;
import kd.bos.workflow.engine.impl.util.WfOperationLogUtil;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.msg.MessageTypeEnum;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.engine.task.TaskDelegateUtil;
import kd.bos.workflow.engine.task.TaskEventTypeEnum;
import kd.bos.workflow.engine.task.auditpoint.AuditPointCheckResult;
import kd.bos.workflow.exception.WFErrorCode;

public class UpgradeWithdrawTaskCmd
implements Command<Void> {
    protected static Log logger = LogFactory.getLog(UpgradeWithdrawTaskCmd.class);
    private Long executionId;
    private Long hitaskId;
    private String businesskey;
    protected String operationName;
    private Long userId;
    private List<Map<String, Object>> restoredMapList = new ArrayList<Map<String, Object>>();
    private List<HiUserActInstEntity> strongControlHiUserActInstEntityList = new ArrayList<HiUserActInstEntity>();
    private HistoricActivityInstanceEntityManager hisActivityManager;
    private HiUserActInstEntityManager hiUserMgr;
    private ExecutionEntityManager executionMgr;
    private ExecutionEntity proInst;
    private Long proInstId;
    private Process process;
    private StringBuilder operationLog = new StringBuilder();
    private boolean calledByParentProcess;
    private static final String UPGRADEWITHDRAWTASKCMD_7 = "UpgradeWithdrawTaskCmd_7";
    private static final String STARTSIGNAL = "StartSignal";
    private Map<String, Object> eventMap = new HashMap<String, Object>();

    public UpgradeWithdrawTaskCmd(Long executionId, Long hitaskId) {
        this.executionId = executionId;
        this.hitaskId = hitaskId;
    }

    public UpgradeWithdrawTaskCmd(Long executionId, Long hitaskId, Long userId) {
        this.userId = userId;
        this.executionId = executionId;
        this.hitaskId = hitaskId;
    }

    public UpgradeWithdrawTaskCmd(String businessKey, String operationName) {
        this.businesskey = businessKey;
        this.operationName = operationName;
    }

    private UpgradeWithdrawTaskCmd(Long executionId, Long hitaskId, boolean calledByParent) {
        this.executionId = executionId;
        this.hitaskId = hitaskId;
        this.calledByParentProcess = calledByParent;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Void execute(CommandContext commandContext) {
        this.hisActivityManager = commandContext.getHistoricActivityInstanceEntityManager();
        this.hiUserMgr = commandContext.getHiUserActInstEntityManager();
        this.executionMgr = commandContext.getExecutionEntityManager();
        if (WfUtils.isEmpty(this.userId)) {
            this.userId = RequestContext.get().getCurrUserId();
        }
        if (WfUtils.isNotEmpty(this.businesskey)) {
            HistoricProcessInstanceEntity hpi;
            List<HistoricProcessInstanceEntity> hiProcisnts = commandContext.getHistoricProcessInstanceEntityManager().findNotEndProcessesByBusinesskey(this.businesskey);
            boolean isBizFlow = true;
            Iterator<HistoricProcessInstanceEntity> iterator = hiProcisnts.iterator();
            while (iterator.hasNext() && (isBizFlow = (hpi = iterator.next()).getProcessType().equals(ProcessType.BizFlow.name()))) {
            }
            if (isBizFlow) {
                logger.debug("all procinst is bizFlow, can withdraw.");
                return null;
            }
            QFilter jrF = new QFilter("businesskey", "=", (Object)this.businesskey);
            List allHiUsers = this.hiUserMgr.findByQueryFilters(new QFilter[]{jrF});
            if (allHiUsers == null || allHiUsers.isEmpty()) {
                if (this.widthdrawAddressProcess(commandContext)) {
                    return null;
                }
                Context.getProcessEngineConfiguration().getCommandExecutor().execute(new WithdrawTaskCmd(this.businesskey, this.operationName));
                return null;
            }
            HashMap evenParam = new HashMap();
            this.eventMap.put("billNo", hiProcisnts.get(0).getBillNo());
            this.eventMap.put("entityNum", hiProcisnts.get(0).getEntitynumber());
            this.eventMap.put("withdrawType", "withdrawByBusinessId");
            this.eventMap.put("busKey", this.businesskey);
            this.eventMap.put("userId", this.userId);
            if (this.validateTaskCanwithdraw(null, commandContext)) {
                if (!this.deleteProcess(commandContext, this.businesskey)) {
                    if (!WfUtils.isNotEmpty(this.hitaskId)) throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{ResManager.loadKDString((String)"\u540e\u7eed\u4efb\u52a1\u5df2\u5904\u7406\uff0c\u4e0d\u80fd\u64a4\u56de\u3002", (String)"UpgradeWithdrawTaskCmd_3", (String)"bos-wf-engine", (Object[])new Object[0])});
                    if (this.withdrawByHitaskId(commandContext)) {
                        return null;
                    }
                } else if (commandContext.getProcessEngineConfiguration().isEnableBecEventDispatcher()) {
                    new EventTriggerCmd(TaskEventTypeEnum.TASK_WITHDRAE_EVENT.getCode(), SerializationUtils.toJsonString(this.eventMap)).execute(commandContext);
                }
            }
        } else if (WfUtils.isNotEmpty(this.executionId)) {
            ExecutionEntity execution = (ExecutionEntity)this.executionMgr.findById(this.executionId);
            if (null == execution) {
                throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{ResManager.loadKDString((String)"\u672a\u627e\u5230\u76f8\u5e94\u6d41\u7a0b\u3002", (String)"UpgradeWithdrawTaskCmd_1", (String)"bos-wf-engine", (Object[])new Object[0])});
            }
            this.proInstId = execution.getProcessInstanceId();
            HistoricProcessInstance h = (HistoricProcessInstance)commandContext.getHistoricProcessInstanceEntityManager().findById(this.proInstId);
            HistoricProcessInstanceEntity entity = (HistoricProcessInstanceEntity)h;
            if (h == null) {
                throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{ResManager.loadKDString((String)"\u672a\u627e\u5230\u76f8\u5e94\u6d41\u7a0b\u3002", (String)"UpgradeWithdrawTaskCmd_1", (String)"bos-wf-engine", (Object[])new Object[0])});
            }
            String workFlowType = ViewFlowchartUtil.getWorkFlowType(this.proInstId);
            if (ProcessType.BizFlow.name().equals(workFlowType)) {
                throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{ResManager.loadKDString((String)"\u4e1a\u52a1\u6d41\u4e0d\u652f\u6301\u64a4\u56de\u3002", (String)"UpgradeWithdrawTaskCmd_128", (String)"bos-wf-engine", (Object[])new Object[0])});
            }
            if (h.getEndTime() != null) {
                throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{WFMultiLangConstants.flowOverText()});
            }
            QFilter jrF = new QFilter("proInstId", "=", (Object)this.proInstId);
            List allHiUsers = this.hiUserMgr.findByQueryFilters(new QFilter[]{jrF});
            if (allHiUsers == null || allHiUsers.isEmpty()) {
                Context.getProcessEngineConfiguration().getCommandExecutor().execute(new WithdrawTaskCmd(this.hitaskId, this.executionId));
                return null;
            }
            if (this.validateTaskCanwithdraw(null, commandContext)) {
                if (!this.deleteProcess(commandContext, this.businesskey)) {
                    if (!WfUtils.isNotEmpty(this.hitaskId)) throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{ResManager.loadKDString((String)"\u540e\u7eed\u4efb\u52a1\u5df2\u5904\u7406\uff0c\u4e0d\u80fd\u64a4\u56de\u3002", (String)"UpgradeWithdrawTaskCmd_3", (String)"bos-wf-engine", (Object[])new Object[0])});
                    if (this.withdrawByHitaskId(commandContext)) {
                        return null;
                    }
                } else {
                    if (commandContext.getProcessEngineConfiguration().isEnableBecEventDispatcher()) {
                        this.eventMap.put("billNo", entity.getBillNo());
                        this.eventMap.put("entityNum", entity.getEntitynumber());
                        this.eventMap.put("busKey", entity.getBusinessKey());
                        this.eventMap.put("withdrawType", "withdrawByProcessInstanceId");
                        this.eventMap.put("processInstanceId", this.proInstId);
                        this.eventMap.put("userId", this.userId);
                        new EventTriggerCmd(TaskEventTypeEnum.TASK_WITHDRAE_EVENT.getCode(), SerializationUtils.toJsonString(this.eventMap)).execute(commandContext);
                    }
                    this.recordNoCodeFlowEndEventLog(commandContext, execution);
                }
            }
        } else if (WfUtils.isNotEmpty(this.hitaskId)) {
            HistoricVariableInstanceEntity dynType;
            HistoricTaskInstanceEntity hitask = (HistoricTaskInstanceEntity)commandContext.getHistoricTaskInstanceEntityManager().findById(this.hitaskId);
            if (hitask != null) {
                String workFlowType = ViewFlowchartUtil.getWorkFlowType(hitask.getProcessInstanceId());
                if (ProcessType.BizFlow.name().equals(workFlowType)) {
                    throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{ResManager.loadKDString((String)"\u4e1a\u52a1\u6d41\u4e0d\u652f\u6301\u64a4\u56de\u3002", (String)"UpgradeWithdrawTaskCmd_128", (String)"bos-wf-engine", (Object[])new Object[0])});
                }
            }
            if ((dynType = commandContext.getHistoricVariableInstanceEntityManager().findHistoricVariableInstancesByTaskIdAndVarName(this.hitaskId, "dynType")) != null && "rejectToForkInner".equals(dynType.getValue())) {
                throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{ResManager.loadKDString((String)"\u9a73\u56de\u5230\u5206\u652f\u5185\u90e8\uff0c\u4e0d\u80fd\u64a4\u56de\u3002", (String)"UpgradeWithdrawTaskCmd_129", (String)"bos-wf-engine", (Object[])new Object[0])});
            }
            if (this.withdrawByHitaskId(commandContext)) {
                return null;
            }
        }
        if (TaskHelper.isComposedTask(this.hitaskId)) {
            TaskHelper.clearIdentityCompositeTaskId(this.hitaskId);
        }
        new ResumeDelegateTasksCmd(this.hitaskId).execute(commandContext);
        TaskDelegateUtil.recoverTaskDelegate(commandContext, this.hitaskId, Boolean.TRUE, "recoverTask");
        return null;
    }

    private boolean widthdrawAddressProcess(CommandContext commandContext) {
        List deadLetterJob = commandContext.getDeadLetterJobEntityManager().findByQueryFilters(new QFilter[]{new QFilter("businessKey", "=", (Object)this.businesskey), new QFilter("jobHandlerType", "=", (Object)"address-process-event")});
        if (deadLetterJob.isEmpty()) {
            List<TimerJobEntity> timerJob = commandContext.getTimerJobEntityManager().findJobsByBusinessKey(this.businesskey, "id,businesskey,entitynumber,jobhandlertype");
            for (TimerJobEntity tJob : timerJob) {
                String handlerType = tJob.getJobHandlerType();
                if (!"address-process-event".equals(handlerType)) continue;
                commandContext.getTimerJobEntityManager().delete(tJob.getId());
                String entityNumber = tJob.getEntityNumber();
                WfCacheHelper.removeExecutingJobGYEntityOfCurrentBusiness(this.businesskey, entityNumber);
                WfCacheHelper.removeWithdrawTimerOrDeadJobRootId(entityNumber, new String[]{String.valueOf(tJob.getId())});
                return true;
            }
        } else {
            Long jobId = ((DeadLetterJobEntity)deadLetterJob.get(0)).getId();
            String entityNumber = ((DeadLetterJobEntity)deadLetterJob.get(0)).getEntityNumber();
            commandContext.getDeadLetterJobEntityManager().delete(jobId);
            WfCacheHelper.removeExecutingJobGYEntityOfCurrentBusiness(this.businesskey, entityNumber);
            WfCacheHelper.removeWithdrawTimerOrDeadJobRootId(entityNumber, new String[]{String.valueOf(jobId)});
            return true;
        }
        return false;
    }

    private boolean withdrawByHitaskId(CommandContext commandContext) {
        HashSet<Long> deleteActInstIds = new HashSet<Long>();
        HashSet<Object> allTaskIds = new HashSet<Object>();
        HashSet<Long> allExecutionIds = new HashSet<Long>();
        List<Object> hiTaskInstEntitys = new ArrayList<HistoricActivityInstanceEntity>();
        HashMap<String, ExecutionEntity> idMapExecutions = new HashMap<String, ExecutionEntity>();
        HistoricActivityInstanceEntity hiTaskInst = this.hisActivityManager.findActivityByTaskId(this.hitaskId);
        if (hiTaskInst == null) {
            return false;
        }
        this.operationLog.append(String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u3010%s\u3011\u64a4\u56de\uff1b", (String)"UpgradeWithdrawTaskCmd_23", (String)"bos-wf-engine", (Object[])new Object[0]), hiTaskInst.getActivityName()));
        this.proInstId = hiTaskInst.getProcessInstanceId();
        this.validateTaskCanwithdraw(null, commandContext);
        if ("YunzhijiaTask".equals(hiTaskInst.getActivityType())) {
            throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{ResManager.loadKDString((String)"\u4f1a\u5ba1\u8282\u70b9\u4e0d\u80fd\u64a4\u56de\u3002", (String)"UpgradeWithdrawTaskCmd_4", (String)"bos-wf-engine", (Object[])new Object[0])});
        }
        TaskEntityManager taskEntityManager = commandContext.getTaskEntityManager();
        if (WfConfigurationUtil.isSupportStrongControl() && taskEntityManager != null && taskEntityManager.findById(this.hitaskId) != null) {
            TaskEntity taskEntity = (TaskEntity)taskEntityManager.findById(this.hitaskId);
            String taskDefinitionKey = taskEntity.getTaskDefinitionKey();
            BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(taskEntity.getProcessDefinitionId(), null, taskEntity.getProcessInstanceId());
            FlowElement curFlowElement = bpmnModel.getFlowElement(taskDefinitionKey);
            if (BpmnModelUtil.isFirstNodeByModel((FlowNode)curFlowElement)) {
                throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{ResManager.loadKDString((String)"\u4eba\u5de5\u8282\u70b9\u4e0d\u80fd\u64a4\u56de\u3002", (String)"UpgradeWithdrawTaskCmd_30", (String)"bos-wf-engine", (Object[])new Object[0])});
            }
        }
        if (WfUtils.isEmpty(hiTaskInst.getJoinFlag())) {
            hiTaskInstEntitys.add(hiTaskInst);
        } else {
            QFilter filter = new QFilter("joinFlag", "=", (Object)hiTaskInst.getJoinFlag());
            QFilter profilter = new QFilter("processInstanceId", "=", (Object)this.proInstId);
            hiTaskInstEntitys = this.hisActivityManager.findByQueryFilters(new QFilter[]{filter, profilter});
        }
        this.proInstId = ((HistoricActivityInstanceEntity)hiTaskInstEntitys.get(0)).getProcessInstanceId();
        QFilter jrF = new QFilter("proInstId", "=", (Object)this.proInstId);
        List allHiUsers = this.hiUserMgr.findByQueryFilters(new QFilter[]{jrF});
        if (allHiUsers == null || allHiUsers.isEmpty()) {
            Context.getProcessEngineConfiguration().getCommandExecutor().execute(new WithdrawTaskCmd(this.hitaskId, this.executionId));
            return true;
        }
        if (commandContext.getProcessEngineConfiguration().isEnableBecEventDispatcher()) {
            this.eventMap.put("withdrawType", "withdrawByTaskId");
            this.eventMap.put("hisTaskId", this.hitaskId);
            this.eventMap.put("busKey", hiTaskInst.getBusinessKey());
            this.eventMap.put("entityNum", hiTaskInst.getEntityNumber());
            this.eventMap.put("billNo", hiTaskInst.getBillNo());
            this.eventMap.put("userId", hiTaskInst.getAssignee());
            new EventTriggerCmd(TaskEventTypeEnum.TASK_WITHDRAE_EVENT.getCode(), SerializationUtils.toJsonString(this.eventMap)).execute(commandContext);
        }
        if (this.deleteProcess(commandContext, null)) {
            return true;
        }
        this.proInst = (ExecutionEntity)this.executionMgr.findById(this.proInstId);
        if (WfUtils.isNotEmptyString(this.proInst.getVariableLocal("canNotWithdrawTasks")) && ((String)this.proInst.getVariableLocal("canNotWithdrawTasks")).contains(String.valueOf(this.hitaskId))) {
            throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{ResManager.loadKDString((String)"\u62c6\u5206\u7b56\u7565\u4e3a\u9a73\u56de\u8d70\u5168\u90e8\u4e0e\u8df3\u8f6c\u4e0d\u652f\u6301\u64a4\u56de\u3002", (String)"UpgradeWithdrawTaskCmd2_8", (String)"bos-wf-engine", (Object[])new Object[0])});
        }
        this.process = ProcessDefinitionUtil.getProcess(((HistoricActivityInstanceEntity)hiTaskInstEntitys.get(0)).getProcessDefinitionId(), this.proInstId);
        if (this.validateTaskCanwithdraw(this.proInstId, commandContext)) {
            Map<String, List<FlowNode>> boundaryNodes;
            int n;
            ArrayList<Long> hiTaskActInstIds = new ArrayList<Long>(hiTaskInstEntitys.size() * 2);
            for (HistoricActivityInstanceEntity historicActivityInstanceEntity : hiTaskInstEntitys) {
                hiTaskActInstIds.add(historicActivityInstanceEntity.getId());
            }
            List<Object> hiUserInsts = new ArrayList<HiUserActInstEntity>();
            QFilter qFilter = new QFilter("proInstId", "=", (Object)this.proInstId);
            QFilter actInstId = new QFilter("lastNodeActInstId", "in", hiTaskActInstIds);
            if (this.strongControlHiUserActInstEntityList != null && !this.strongControlHiUserActInstEntityList.isEmpty()) {
                hiUserInsts.addAll(this.strongControlHiUserActInstEntityList);
            } else {
                hiUserInsts = this.hiUserMgr.findByQueryFilters(new QFilter[]{qFilter, actInstId});
            }
            if (hiUserInsts != null && hiUserInsts.size() > 0) {
                if ("forkJumpOrReject".equals(((HiUserActInstEntity)hiUserInsts.get(0)).getEndType())) {
                    throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{ResManager.loadKDString((String)"\u5176\u4ed6\u5206\u652f\u5df2\u7ecf\u8df3\u8f6c\u6216\u9a73\u56de\u5230\u62c6\u5206\u6216\u62c6\u5206\u4e4b\u524d\u8282\u70b9\uff0c\u5f53\u524d\u5206\u652f\u4e0d\u80fd\u64a4\u56de\u3002", (String)"UpgradeWithdrawTaskCmd_71", (String)"bos-wf-engine", (Object[])new Object[0])});
                }
                for (HiUserActInstEntity hiUserActInstEntity : hiUserInsts) {
                    if (!"jump".equals(hiUserActInstEntity.getEndType())) continue;
                    throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{String.format(ResManager.loadKDString((String)"%1$s\u7684\u540e\u7eed\u8282\u70b9\u5df2\u5904\u7406\u3002", (String)UPGRADEWITHDRAWTASKCMD_7, (String)"bos-wf-engine", (Object[])new Object[0]), WfMultiLangUtils.getValueFromLocalString(hiUserActInstEntity.getLastNodeName(), RequestContext.get().getLang().toString()))});
                }
            }
            List<HistoricActivityInstanceEntity> acts = this.hisActivityManager.findByActivityId(this.proInstId, hiTaskInst.getActivityId());
            boolean bl = false;
            for (HistoricActivityInstanceEntity hi : acts) {
                int tmp;
                if (hi.getId().equals(hiTaskInst.getId()) || n >= (tmp = hi.getCycle().split("\\_").length)) continue;
                n = tmp;
            }
            if (n > hiTaskInst.getCycle().split("\\_").length) {
                throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{ResManager.loadKDString((String)"\u540e\u7eed\u8282\u70b9\u5df2\u7ecf\u88ab\u5904\u7406\u3002", (String)"UpgradeWithdrawTaskCmd_72", (String)"bos-wf-engine", (Object[])new Object[0])});
            }
            if (hiUserInsts.isEmpty()) {
                throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{ResManager.loadKDString((String)"\u8be5\u8282\u70b9\u4e0d\u80fd\u64a4\u56de\uff08\u540e\u7eed\u5df2\u7ecf\u88ab\u5904\u7406\u6216\u6d41\u7a0b\u5df2\u7ecf\u8fdb\u5165\u8fb9\u754c\uff09\u3002", (String)"UpgradeWithdrawTaskCmd_6", (String)"bos-wf-engine", (Object[])new Object[0])});
            }
            ArrayList autoNodes = new ArrayList();
            HashMap<String, Integer> curNodesDeleteNoOfArrived = new HashMap<String, Integer>();
            HashMap<String, Long> curNodesJoinNodeExecutionIds = new HashMap<String, Long>();
            HashSet<Long> actInstIds = new HashSet<Long>();
            HashSet<Long> deleteHiUserActInstIds = new HashSet<Long>(hiUserInsts.size() * 5);
            HashSet<String> currentAutoAndHisActId = new HashSet<String>(hiUserInsts.size() * 5 + 50);
            boolean currentIsCallActivity = false;
            for (Object h : hiUserInsts) {
                String joinFlag;
                currentAutoAndHisActId.add(h.getCurrentActId());
                currentAutoAndHisActId.add(h.getLastUserNodeActId());
                if (h.getEndTime() != null) {
                    throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{String.format(ResManager.loadKDString((String)"%1$s\u7684\u540e\u7eed\u8282\u70b9\u5df2\u5904\u7406\u3002", (String)UPGRADEWITHDRAWTASKCMD_7, (String)"bos-wf-engine", (Object[])new Object[0]), WfMultiLangUtils.getValueFromLocalString(h.getLastNodeName(), RequestContext.get().getLang().toString()))});
                }
                if (h.getCurrentActId().contains("CallActivity")) {
                    currentIsCallActivity = true;
                }
                if (h.getCurrentActId().contains("SSCApprove")) {
                    this.judgeCanWithdraw((HiUserActInstEntity)h);
                }
                deleteHiUserActInstIds.add(h.getId());
                if (h.getCurrentActId().contains("YunzhijiaTask")) {
                    int approvaledCount = 0;
                    HistoricActivityInstanceEntity tactInst = (HistoricActivityInstanceEntity)this.hisActivityManager.findById(h.getCurrentActinstId());
                    String string = "select fid,ftaskid,fparentTaskid,fendtime from " + TableNameConstant.getHiActInstTableName() + " where FPROCINSTID = ? and factid = ? ";
                    Object[] params = new Object[]{h.getProinstId(), h.getCurrentActId()};
                    try (DataSet ds = DB.queryDataSet((String)"withdraw.yzjtasked", (DBRoute)DBRoute.workflow, (String)string, (Object[])params);){
                        for (Row r : ds) {
                            if (r == null || r.get("fparentTaskid") == null || tactInst == null || !r.get("fparentTaskid").equals(tactInst.getParentTaskId())) continue;
                            if (r.get("fendtime") != null) {
                                ++approvaledCount;
                                break;
                            }
                            actInstIds.add(r.getLong("fid"));
                        }
                    }
                    if (approvaledCount > 0) {
                        throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{ResManager.loadKDString((String)"\u4f1a\u5ba1\u8282\u70b9\u5df2\u5ba1\u6279\u3002", (String)"UpgradeWithdrawTaskCmd_8", (String)"bos-wf-engine", (Object[])new Object[0])});
                    }
                }
                if (WfUtils.isNotEmpty(joinFlag = h.getJoinFlag()) && ForkJoinUtils.getFirstEnterJoinExecution(joinFlag, this.proInst) != null && !actInstIds.contains(h.getCurrentActinstId())) {
                    int deleteNoOfArrivedCount = curNodesDeleteNoOfArrived.get(joinFlag) == null ? 1 : (Integer)curNodesDeleteNoOfArrived.get(joinFlag) + 1;
                    curNodesDeleteNoOfArrived.put(joinFlag, deleteNoOfArrivedCount);
                    curNodesJoinNodeExecutionIds.putIfAbsent(joinFlag, (Long)ForkJoinUtils.getFirstEnterJoinExecution(joinFlag, this.proInst));
                }
                actInstIds.add(h.getCurrentActinstId());
                String pathJson = h.getPathJson();
                if (!WfUtils.isNotEmpty(pathJson)) continue;
                List list = SerializationUtils.fromJsonStringToList((String)pathJson, PathJson.class);
                autoNodes.addAll(list);
                for (PathJson pj : list) {
                    currentAutoAndHisActId.add(pj.getNodeId());
                }
            }
            if (autoNodes != null && !autoNodes.isEmpty()) {
                HashSet<Long> callActivityActInstIdSet = new HashSet<Long>(autoNodes.size());
                for (PathJson autoNode : autoNodes) {
                    if (autoNode.getNodeId() == null || !autoNode.getNodeId().contains("CallActivity")) continue;
                    callActivityActInstIdSet.add(autoNode.getActInstId());
                }
                QFilter qFilter1 = new QFilter("id", "in", callActivityActInstIdSet);
                QFilter qFilter2 = new QFilter("endTime", "is not null", null);
                QFilter[] qFilters = new QFilter[]{qFilter1, qFilter2};
                if (this.hisActivityManager.exist(qFilters)) {
                    throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{ResManager.loadKDString((String)"\u540e\u7eed\u4efb\u52a1\u5df2\u5904\u7406\uff0c\u4e0d\u80fd\u64a4\u56de\u3002", (String)"UpgradeWithdrawTaskCmd_3", (String)"bos-wf-engine", (Object[])new Object[0])});
                }
            }
            if (currentIsCallActivity) {
                this.withdrawSubProcess(commandContext, this.proInstId);
            }
            if (!(boundaryNodes = this.process.getBoundaryNodes()).isEmpty()) {
                HashSet<String> boundaryKey = new HashSet<String>();
                for (String i : currentAutoAndHisActId) {
                    String string = this.process.getBoundaryEventId(i);
                    if (string != null) {
                        boundaryKey.add(string);
                    }
                    if (boundaryKey.size() <= 1) continue;
                    throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{ResManager.loadKDString((String)"\u65e0\u6cd5\u8de8\u8fb9\u754c\u64a4\u56de\u3002", (String)"UpgradeWithdrawTaskCmd_9", (String)"bos-wf-engine", (Object[])new Object[0])});
                }
                if (WfUtils.isNotEmptyString(this.proInst.getVariableLocal("enterBoundaryErrorNodeId"))) {
                    throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{ResManager.loadKDString((String)"\u6d41\u7a0b\u5df2\u8fdb\u5165\u5f02\u5e38\u5206\u652f\uff0c\u4e0d\u80fd\u64a4\u56de\u3002", (String)"UpgradeWithdrawTaskCmd_10", (String)"bos-wf-engine", (Object[])new Object[0])});
                }
            }
            HashSet<Long> flowActInstIds = new HashSet<Long>();
            List<Object> actInsts = new ArrayList();
            if (!actInstIds.isEmpty()) {
                HashMap<String, Long> needVoteFirstExecutionActInstIds = new HashMap<String, Long>();
                QFilter qFilter2 = new QFilter("processInstanceId", "=", (Object)this.proInstId);
                QFilter ff = new QFilter("id", "in", actInstIds);
                QFilter endf = new QFilter("endTime", "is null", null);
                actInsts = this.hisActivityManager.findByQueryFilters(new QFilter[]{qFilter2, ff, endf});
                List<ExecutionEntity> currentExecutions = this.executionMgr.findChildExecutionsByProcessInstanceId(this.proInstId);
                for (ExecutionEntity e : currentExecutions) {
                    idMapExecutions.put(String.valueOf(e.getId()), e);
                }
                if (currentExecutions != null && !currentExecutions.isEmpty()) {
                    this.operationLog.append(String.format(ResManager.loadKDString((String)"\u5355\u636e\u3010%s\u3011", (String)"UpgradeWithdrawTaskCmd_78", (String)"bos-wf-engine", (Object[])new Object[0]), currentExecutions.get(0).getBillNo()));
                }
                this.operationLog.append(ResManager.loadKDString((String)"\u5f53\u524d\u8282\u70b9\uff1a", (String)"UpgradeWithdrawTaskCmd_79", (String)"bos-wf-engine", (Object[])new Object[0]));
                NodeForkJoinModel hm = this.process.getForkJoinModels().get(hiTaskInst.getActivityId());
                Long joinExecution = null;
                if (hm != null && WfUtils.isNotEmpty(hm.getLatestForkNode())) {
                    int cycle = ForkJoinUtils.getEnterForkCycle(hm.getLatestForkNode(), this.proInst);
                    String joinFlag = hm.getLatestJoinNode() + "$" + cycle + "$" + hm.getLatestJoinNode();
                    joinExecution = (Long)ForkJoinUtils.getFirstEnterJoinExecution(joinFlag, this.proInst);
                }
                int size = actInsts.size();
                HistoricActivityInstanceEntity actInst = null;
                for (int i = 0; i < size; ++i) {
                    actInst = (HistoricActivityInstanceEntity)actInsts.get(i);
                    if (!this.operationLog.toString().contains(actInst.getActivityName() + "\uff0c")) {
                        this.operationLog.append(actInst.getActivityName()).append('\uff0c');
                    }
                    if (WfUtils.isNotEmpty(actInst.getJoinFlag()) && actInst.getExecutionId().equals(ForkJoinUtils.getFirstEnterJoinExecution(actInst.getJoinFlag(), this.proInst))) {
                        needVoteFirstExecutionActInstIds.put(actInst.getJoinFlag(), actInst.getId());
                    }
                    allExecutionIds.add(actInst.getExecutionId());
                    if (WfUtils.isNotEmpty(actInst.getTaskId())) {
                        allTaskIds.add(actInst.getTaskId());
                    }
                    deleteActInstIds.add(actInst.getId());
                    flowActInstIds.add(actInst.getSourceElementId());
                    if (WfUtils.isNotEmpty(actInst.getTaskId())) {
                        allTaskIds.add(actInst.getTaskId());
                        TaskEntity task = (TaskEntity)commandContext.getTaskEntityManager().findById(actInst.getTaskId());
                        if (task != null) {
                            task.getExecution().setCurrentTask(null);
                            this.executionMgr.update(task.getExecution());
                        }
                        if (task != null && "freeze".equals(task.getHandleState())) {
                            throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{ResManager.loadKDString((String)"\u51bb\u7ed3\u4efb\u52a1\u4e0d\u80fd\u64a4\u56de\u3002", (String)"UpgradeWithdrawTaskCmd_80", (String)"bos-wf-engine", (Object[])new Object[0])});
                        }
                        if (task != null && "UserTask".equals(task.getCategory()) && "dismissed".equals(task.getHandleState()) && !WfConfigurationUtil.canWithdrawWhenRejectToUserTask()) {
                            throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{ResManager.loadKDString((String)"\u9a73\u56de\u5230\u4eba\u5de5\u8282\u70b9\u540e\u4e0d\u80fd\u64a4\u56de\u3002", (String)"UpgradeWithdrawTaskCmd_113", (String)"bos-wf-engine", (Object[])new Object[0])});
                        }
                        if (task != null) {
                            this.cleanupExecutions(this.process.getFlowElement(actInst.getActivityId()), (ExecutionEntity)idMapExecutions.get(String.valueOf(task.getExecutionId())), commandContext);
                        }
                        this.deleteToDoMsg(commandContext, task);
                        if (task != null && actInst.getActivityType().equals("YunzhijiaTask")) {
                            commandContext.getTaskHelper().deleteTask(actInst.getParentTaskId(), "task withdraw", false);
                            ExecutionEntity childExecution = (ExecutionEntity)idMapExecutions.get(String.valueOf(actInst.getExecutionId()));
                            ExecutionEntity parentExecution = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(childExecution.getParentId());
                            QFilter parentf = new QFilter("parentTaskId", "=", (Object)task.getParentTaskId());
                            List yzjActInsts = this.hisActivityManager.findByQueryFilters(new QFilter[]{parentf});
                            for (HistoricActivityInstanceEntity yzjActInst : yzjActInsts) {
                                allTaskIds.add(yzjActInst.getTaskId());
                                this.hisActivityManager.delete(yzjActInst);
                                deleteActInstIds.add(yzjActInst.getId());
                                flowActInstIds.add(yzjActInst.getSourceElementId());
                                this.hisActivityManager.delete(yzjActInst.getSourceElementId());
                            }
                            if (!parentExecution.isActive()) {
                                this.executionMgr.deleteChildrenExecutions(parentExecution.getId());
                                parentExecution.removeVariable("loopCounter");
                                if (hiTaskInst.getExecutionId().longValue() == parentExecution.getId().longValue() || joinExecution != null && joinExecution.longValue() == parentExecution.getId().longValue()) {
                                    parentExecution.setMultiInstanceRoot(false);
                                    parentExecution.setActive(true);
                                } else {
                                    this.executionMgr.delete(parentExecution);
                                }
                            }
                        } else {
                            commandContext.getTaskHelper().deleteTask(actInst.getTaskId(), "task withdraw", false);
                        }
                        if (i >= size - 1 || !actInst.getActivityId().equals(((HistoricActivityInstanceEntity)actInsts.get(i + 1)).getActivityId())) {
                            this.executeWithdrawExecutionListeners(commandContext, (ExecutionEntity)idMapExecutions.get(String.valueOf(actInst.getExecutionId())), "start", "", actInst.getActivityId(), actInst.getId());
                        }
                    } else if ("CallActivity".equals(actInst.getActivityType())) {
                        ExecutionEntity childExecution = (ExecutionEntity)this.executionMgr.findById(actInst.getExecutionId());
                        DelegateExecution parentExecution = null;
                        if (childExecution != null && WfUtils.isNotEmpty(childExecution.getParentId())) {
                            parentExecution = (ExecutionEntity)this.executionMgr.findById(childExecution.getParentId());
                        }
                        if (parentExecution != null && !parentExecution.isActive()) {
                            parentExecution.setMultiInstanceRoot(false);
                        }
                        this.executeWithdrawExecutionListeners(commandContext, (ExecutionEntity)parentExecution, "start", "", actInst.getActivityId(), actInst.getId());
                    }
                    this.hisActivityManager.delete(actInst);
                    this.hisActivityManager.delete(actInst.getSourceElementId());
                }
                this.hiUserMgr.deleteByFilters(new QFilter[]{qFilter, actInstId});
                this.updateFlagAndFirstExecution(curNodesDeleteNoOfArrived, curNodesJoinNodeExecutionIds, needVoteFirstExecutionActInstIds, deleteActInstIds, deleteHiUserActInstIds);
            }
            if (!autoNodes.isEmpty()) {
                HashMap<String, Integer> autoNodesDeleteNoOfArrived = new HashMap<String, Integer>();
                HashMap<String, Long> hashMap = new HashMap<String, Long>();
                HashMap<String, Long> autoNeedVoteFirstExecutionActInstIds = new HashMap<String, Long>();
                HashSet autoNodeActInstIds = new HashSet(autoNodes.size() * 2);
                HashMap<String, Long> actInstIdExeIdMap = new HashMap<String, Long>(autoNodes.size() * 2);
                for (PathJson pj : autoNodes) {
                    String joinFlag = pj.getJoinFlag();
                    if (WfUtils.isNotEmpty(joinFlag) && ForkJoinUtils.getFirstEnterJoinExecution(joinFlag, this.proInst) != null && !autoNodeActInstIds.contains(pj.getActInstId())) {
                        int deleteNoOfArrivedCount = autoNodesDeleteNoOfArrived.get(joinFlag) == null ? 1 : (Integer)autoNodesDeleteNoOfArrived.get(joinFlag) + 1;
                        autoNodesDeleteNoOfArrived.put(joinFlag, deleteNoOfArrivedCount);
                        hashMap.putIfAbsent(joinFlag, (Long)ForkJoinUtils.getFirstEnterJoinExecution(joinFlag, this.proInst));
                    }
                    autoNodeActInstIds.add(pj.getActInstId());
                    actInstIdExeIdMap.put(String.valueOf(pj.getActInstId()), pj.getExecutionId());
                }
                QFilter idFilter = new QFilter("id", "in", (Object)autoNodeActInstIds);
                QFilter proFilter = new QFilter("processInstanceId", "=", (Object)this.proInstId);
                List autoActInsts = this.hisActivityManager.findByQueryFilters(new QFilter[]{proFilter, idFilter});
                this.operationLog.append(ResManager.loadKDString((String)"\u4e2d\u95f4\u8282\u70b9\uff1a", (String)"UpgradeWithdrawTaskCmd_45", (String)"bos-wf-engine", (Object[])new Object[0]));
                Object currentTaskId = null;
                HashSet<Long> historicActivityInstanceIds = new HashSet<Long>();
                for (HistoricActivityInstanceEntity i : autoActInsts) {
                    this.operationLog.append(i.getActivityName()).append('\uff0c');
                    this.recoveVariableCycleAndReject(i.getActivityId(), commandContext, actInsts, ((HistoricActivityInstanceEntity)hiTaskInstEntitys.get(0)).getActivityId());
                    FlowNode autoFNode = (FlowNode)this.process.getFlowElement(i.getActivityId());
                    if (autoFNode.getFork() != null && autoFNode.getFork().booleanValue() && "leavewhenallmeet".equals(autoFNode.getOutSet())) {
                        String forkId = autoFNode.getId();
                        int cycle = ForkJoinUtils.getEnterForkCycle(forkId, this.proInst);
                        String joinFlag = forkId + "$" + cycle + "$" + this.process.getForkJoinModels().get(forkId).getPairJoinNodeId();
                        ForkJoinUtils.removeNoOfShouldSurvive(joinFlag, this.proInst);
                    }
                    if (WfUtils.isNotEmpty(i.getJoinFlag()) && i.getExecutionId().equals(ForkJoinUtils.getFirstEnterJoinExecution(i.getJoinFlag(), this.proInst))) {
                        autoNeedVoteFirstExecutionActInstIds.put(i.getJoinFlag(), i.getId());
                    }
                    if (WfUtils.isNotEmpty((Long)(currentTaskId = i.getTaskId()))) {
                        allTaskIds.add(currentTaskId);
                    }
                    allExecutionIds.add(i.getExecutionId());
                    commandContext.getTaskHelper().deleteTask(i.getTaskId(), "task withdraw", false);
                    flowActInstIds.add(i.getSourceElementId());
                    String executionId = null;
                    if ("YunzhijiaTask".equals(i.getActivityType())) {
                        Long parentTaskId = i.getParentTaskId();
                        if (WfUtils.isNotEmpty(parentTaskId)) {
                            HistoricTaskInstanceEntity parentTaskEntity = (HistoricTaskInstanceEntity)commandContext.getHistoricTaskInstanceEntityManager().findById(parentTaskId);
                            if (null != parentTaskEntity) {
                                executionId = String.valueOf(parentTaskEntity.getExecutionId());
                                EntityQueryBuilder queryBuilder = commandContext.getHistoricTaskInstanceEntityManager().createQueryBuilder().addFilter("parentTaskId", parentTaskId);
                                List childrenTasks = commandContext.getHistoricTaskInstanceEntityManager().findByQueryBuilder(queryBuilder, true);
                                if (WfUtils.isNotEmptyForCollection(childrenTasks)) {
                                    Object childTaskId = null;
                                    for (HistoricTaskInstanceEntity childTask : childrenTasks) {
                                        childTaskId = childTask.getId();
                                        if (!WfUtils.isNotEmpty((Long)childTaskId) || !WfUtils.isEmpty((Long)currentTaskId) && (!WfUtils.isNotEmpty((Long)currentTaskId) || ((Long)currentTaskId).equals(childTaskId))) continue;
                                        allTaskIds.add(childTaskId);
                                    }
                                }
                            }
                            EntityQueryBuilder queryBuilderForActivity = commandContext.getHistoricActivityInstanceEntityManager().createQueryBuilder().addFilter("taskId", "in", allTaskIds);
                            List childrenHistoricActivityInstanceIds = commandContext.getHistoricActivityInstanceEntityManager().findByQueryBuilder(queryBuilderForActivity, true);
                            if (WfUtils.isNotEmptyForCollection(childrenHistoricActivityInstanceIds)) {
                                for (HistoricActivityInstanceEntity entity : childrenHistoricActivityInstanceIds) {
                                    historicActivityInstanceIds.add(entity.getId());
                                }
                            }
                            allTaskIds.add(parentTaskId);
                        }
                    } else {
                        executionId = String.valueOf(i.getExecutionId());
                    }
                    ExecutionEntity execution = (ExecutionEntity)idMapExecutions.get(executionId);
                    if (null != execution) {
                        this.executeWithdrawExecutionListeners(commandContext, execution, "end", this.operationName, i.getActivityId(), i.getId());
                        this.executeWithdrawExecutionListeners(commandContext, execution, "start", "", i.getActivityId(), i.getId());
                    }
                    this.withdrawAutoOperation(i);
                    historicActivityInstanceIds.add(i.getId());
                    if (WfUtils.isNotEmptyForCollection(historicActivityInstanceIds)) {
                        this.hisActivityManager.deleteByFilters(new QFilter[]{new QFilter("id", "in", historicActivityInstanceIds)});
                    }
                    deleteActInstIds.addAll(historicActivityInstanceIds);
                    this.hisActivityManager.delete(i.getSourceElementId());
                }
                QFilter f = new QFilter("taskId", "in", allTaskIds);
                QFilter cf = new QFilter("processInstanceId", "=", (Object)this.proInstId);
                commandContext.getCommentEntityManager().deleteByFilters(new QFilter[]{cf, f});
                this.updateFlagAndFirstExecution(autoNodesDeleteNoOfArrived, hashMap, autoNeedVoteFirstExecutionActInstIds, deleteActInstIds, deleteHiUserActInstIds);
            }
            if (!flowActInstIds.isEmpty()) {
                DynamicResourceEntityManager dynamicResourceEntityManager = commandContext.getDynamicResourceEntityManager();
                List<DynamicResourceEntity> list = dynamicResourceEntityManager.findByProcessInstanceId(this.proInstId);
                DynamicProcessDefinitionHelper dynProcessHelper = commandContext.getProcessEngineConfiguration().getDynamicProcessDefinitionHelper();
                if (list != null && !list.isEmpty()) {
                    for (DynamicResourceEntity d : list) {
                        if (!flowActInstIds.contains(d.getActivityInstanceId())) continue;
                        dynamicResourceEntityManager.delete(d);
                        dynProcessHelper.deleteSequenceFlow(d.getProcessDefineId(), d.getProcessInstanceId(), d, "task withdraw");
                    }
                }
            }
            for (Long l : allTaskIds) {
                commandContext.getHistoricTaskInstanceEntityManager().delete(l);
                commandContext.getHistoricVariableInstanceEntityManager().deleteHistoricVariableInstancesByTaskId(l);
            }
            HistoricTaskInstanceEntity historicTask = (HistoricTaskInstanceEntity)commandContext.getHistoricTaskInstanceEntityManager().findById(this.hitaskId);
            this.saveOperationLog(commandContext, this.hitaskId);
            QFilter qFilter3 = new QFilter("executionId", "in", allExecutionIds);
            QFilter idQfilter = new QFilter("id", "not in", deleteActInstIds);
            QFilter flowIdQfilter = new QFilter("id", "not in", flowActInstIds);
            QFilter hProQfilter = new QFilter("processInstanceId", "=", (Object)this.proInstId);
            List hasUsedExeIdActInsts = this.hisActivityManager.findByQueryFilters(new QFilter[]{hProQfilter, qFilter3, idQfilter, flowIdQfilter});
            int usiz = hasUsedExeIdActInsts == null ? 0 : hasUsedExeIdActInsts.size();
            HashSet<String> usedExecutionIds = new HashSet<String>(usiz);
            for (HistoricActivityInstanceEntity i : hasUsedExeIdActInsts) {
                usedExecutionIds.add(String.valueOf(i.getExecutionId()));
            }
            ArrayList<Long> deleteExecutionIds = new ArrayList<Long>();
            for (Long i : allExecutionIds) {
                if (usedExecutionIds.contains(String.valueOf(i))) continue;
                deleteExecutionIds.add(i);
                this.executionMgr.delete(i);
                this.executionMgr.findById(i);
            }
            if (historicTask != null) {
                Object boundaryEvents;
                this.recoveVariableCycleAndReject(historicTask.getTaskDefinitionKey(), commandContext, actInsts, historicTask.getTaskDefinitionKey());
                this.recoveParticipantVariable(historicTask, commandContext);
                this.removeRejectKeyVariable(actInsts, historicTask);
                FlowNode hisNode = (FlowNode)this.process.getFlowElement(historicTask.getTaskDefinitionKey());
                if (hisNode.getFork() != null && hisNode.getFork().booleanValue() && "leavewhenallmeet".equals(hisNode.getOutSet())) {
                    NodeForkJoinModel cmm = this.process.getForkJoinModels().get(((HistoricActivityInstanceEntity)actInsts.get(0)).getActivityId());
                    String forkId = hisNode.getId();
                    if (cmm != null && forkId.equals(cmm.getLatestForkNode())) {
                        int cycle = ForkJoinUtils.getEnterForkCycle(forkId, this.proInst);
                        String joinFlag = forkId + "$" + cycle + "$" + this.process.getForkJoinModels().get(forkId).getPairJoinNodeId();
                        ForkJoinUtils.removeNoOfShouldSurvive(joinFlag, this.proInst);
                    }
                }
                historicTask.setEndTime(null);
                historicTask.setDurationInMillis(0L);
                historicTask.setRealDurationInMillis(0L);
                historicTask.setHandleState("willApproval");
                historicTask.setExecutionType("byHand");
                ExecutionEntity executionEntity = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(historicTask.getExecutionId());
                executionEntity.setCurrentActInstId(hiTaskInst.getId());
                executionEntity.setCurrentTask(null);
                executionEntity.setCurrentTaskId(historicTask.getId());
                executionEntity.setActivityId(historicTask.getTaskDefinitionKey());
                executionEntity.setActive(true);
                FlowElement flowElement = this.process.getFlowElement(historicTask.getTaskDefinitionKey());
                executionEntity.setCurrentFlowElement(flowElement);
                if (executionEntity.hasVariable("priority")) {
                    executionEntity.removeVariable("priority");
                }
                if (CollectionUtil.isNotEmpty((Collection)(boundaryEvents = ((Activity)flowElement).getBoundaryEvents()))) {
                    this.executeBoundaryEvents((Collection<BoundaryEvent>)boundaryEvents, executionEntity, commandContext);
                }
                this.executeWithdrawExecutionListeners(commandContext, executionEntity, "end", this.operationName, historicTask.getTaskDefinitionKey(), hiTaskInst.getId());
                this.executeWithdrawTaskListeners(historicTask.getExecutionId());
                commandContext.getHistoricVariableInstanceEntityManager().deleteHistoricVariableInstancesByTaskId(historicTask.getId());
                ((HistoricTaskInstanceEntityImpl)historicTask).setCurrentActInst(((HiUserActInstEntity)hiUserInsts.get(0)).getLastNodeActinstId());
                TaskEntity task = commandContext.getTaskEntityManager().recoverTask(historicTask);
                this.dispatchTaskWithdrawRestoreListener(commandContext, task);
                commandContext.getTaskEntityManager().changeTaskAssignee(task, null, null);
                commandContext.getCommentEntityManager().deleteCommentsByTaskId(historicTask.getId());
                commandContext.getMessageService().deleteDealToDoAndCreateToDo(task.getId());
                commandContext.getHistoricTaskInstanceEntityManager().update(historicTask);
                AuditPointInstanceEntityManager auditPointInstanceEntityManager = commandContext.getAuditPointInstanceEntityManager();
                List<AuditPointInstanceEntity> auditPointInstances = auditPointInstanceEntityManager.findAuditPointInstancesByTaskId(historicTask.getId());
                if (CollectionUtil.isNotEmpty(auditPointInstances)) {
                    for (AuditPointInstanceEntity auditPointInstance : auditPointInstances) {
                        if ("automaticchecks".equals(auditPointInstance.getType())) continue;
                        auditPointInstance.setFailedReason((ILocaleString)new LocaleString());
                        auditPointInstance.setCheckResult(AuditPointCheckResult.UNCONFIRMED.getNumber());
                        auditPointInstanceEntityManager.update(auditPointInstance);
                    }
                }
                QFilter hiuFilter = WfUtils.isNotEmpty(hiTaskInst.getJoinFlag()) ? new QFilter("joinFlag", "=", (Object)hiTaskInst.getJoinFlag()) : new QFilter("currentActInstId", "=", (Object)hiTaskInst.getId());
                List needRecordHiuser = this.hiUserMgr.findByQueryFilters(new QFilter[]{hiuFilter});
                for (Object i : needRecordHiuser) {
                    if (deleteHiUserActInstIds.contains(i.getId())) continue;
                    i.setEndTime(null);
                    this.hiUserMgr.update(i);
                }
                for (Object i : hiTaskInstEntitys) {
                    i.setTargetElementId(null);
                    i.setEndTime(null);
                    i.setDurationInMillis(Long.valueOf(0L));
                    i.setRealDurationInMillis(Long.valueOf(0L));
                    this.hisActivityManager.update(i);
                }
                QFilter variExecutionFilter = new QFilter("executionId", "=", (Object)historicTask.getExecutionId());
                QFilter variNameFilter = new QFilter("name", "=", (Object)"lastUserDealNode");
                QFilter[] filters = new QFilter[]{variExecutionFilter, variNameFilter};
                List variEntitys = commandContext.getVariableInstanceEntityManager().findByQueryFilters(filters);
                for (Object v : variEntitys) {
                    if (needRecordHiuser != null && !needRecordHiuser.isEmpty() && ((HiUserActInstEntity)needRecordHiuser.get(0)).getLastUserNodeActId().contains(STARTSIGNAL)) {
                        v.setTextValue("start");
                    } else if (WfConfigurationUtil.isSupportStrongControl() && ("start".equals(v.getTextValue()) || "startProcessInstance".equals(v.getTextValue())) && BpmnModelUtil.instanceofUserTaskOnly(historicTask.getCategory())) {
                        v.setTextValue("startStrongControl");
                    } else {
                        v.setTextValue(historicTask.getTaskDefinitionKey());
                    }
                    commandContext.getVariableInstanceEntityManager().update(v);
                }
                List hiVariEntitys = commandContext.getHistoricVariableInstanceEntityManager().findByQueryFilters(filters);
                for (HistoricVariableInstanceEntity v : hiVariEntitys) {
                    if (needRecordHiuser != null && !needRecordHiuser.isEmpty() && ((HiUserActInstEntity)needRecordHiuser.get(0)).getLastUserNodeActId().contains(STARTSIGNAL)) {
                        v.setTextValue("start");
                    } else if (WfConfigurationUtil.isSupportStrongControl() && ("start".equals(v.getTextValue()) || "startProcessInstance".equals(v.getTextValue())) && BpmnModelUtil.instanceofUserTaskOnly(historicTask.getCategory())) {
                        v.setTextValue("startStrongControl");
                    } else {
                        v.setTextValue(historicTask.getTaskDefinitionKey());
                    }
                    commandContext.getHistoricVariableInstanceEntityManager().update(v);
                }
                List vars = commandContext.getHistoricVariableInstanceEntityManager().findByQueryFilters(new QFilter[]{new QFilter("processInstanceId", "=", (Object)this.proInstId), new QFilter("name", "=", (Object)String.format("%s_%s", hiTaskInst.getActivityId(), "rejectToForkInnerAndSkip"))});
                if (vars != null && !vars.isEmpty()) {
                    ((ExecutionEntity)this.executionMgr.findById(this.proInstId)).setVariable(String.format("%s_%s", hiTaskInst.getActivityId(), "rejectToForkInnerAndSkip"), ((HistoricVariableInstanceEntity)vars.get(0)).getValue());
                }
            }
            if (!deleteExecutionIds.isEmpty()) {
                QFilter eidf = new QFilter("executionId", "in", deleteExecutionIds);
                QFilter variNameFilter = new QFilter("name", "=", (Object)"lastUserDealNode");
                List vs = commandContext.getHistoricVariableInstanceEntityManager().findByQueryFilters(new QFilter[]{eidf, variNameFilter});
                for (HistoricVariableInstanceEntity v : vs) {
                    commandContext.getHistoricVariableInstanceEntityManager().delete(v);
                }
                List vsws = commandContext.getVariableInstanceEntityManager().findByQueryFilters(new QFilter[]{eidf, variNameFilter});
                for (VariableInstanceEntity v : vsws) {
                    commandContext.getVariableInstanceEntityManager().delete(v);
                }
            }
            WfUtils.addOpLog("wf_task", "withdraw", new MultiLangEnumBridge("\u64a4\u56de", "UpgradeWithdrawTaskCmd_88", "bos-wf-engine"), new MultiLangEnumBridge("\u201c%1$s\u201d\u64a4\u56de\u6210\u529f\u3002", "UpgradeWithdrawTaskCmd_68", "bos-wf-engine"), this.operationLog);
        }
        if (this.restoredMapList != null && !this.restoredMapList.isEmpty()) {
            for (Map<String, Object> restoredMap : this.restoredMapList) {
                HiUserActInstEntity hiUserActInstEntity = (HiUserActInstEntity)this.hiUserMgr.findById((Long)restoredMap.get("id"));
                hiUserActInstEntity.setLastNodeActinstId((Long)restoredMap.get("lastNodeActinstId"));
                hiUserActInstEntity.setLastUserNodeActId((String)restoredMap.get("lastUserNodeActId"));
                hiUserActInstEntity.setPathJson((String)restoredMap.get("pathjson"));
                this.hiUserMgr.update(hiUserActInstEntity);
            }
        }
        return false;
    }

    private void dispatchTaskWithdrawRestoreListener(CommandContext commandContext, TaskEntity task) {
        ActivitiEventDispatcher eventDispatcher = Context.getProcessEngineConfiguration().getEventDispatcher();
        if (eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.TASKWITHDRAW_RESTORE, task));
        }
    }

    private void recoveParticipantVariable(HistoricTaskInstanceEntity historicTask, CommandContext commandContext) {
        String taskDefinitionKey;
        ExecutionEntity executionEntity = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(historicTask.getExecutionId());
        String currentParticipant = (String)executionEntity.getVariable((taskDefinitionKey = historicTask.getTaskDefinitionKey()) + "currentParticipant");
        if (currentParticipant != null) {
            Map instanceParticipant = (Map)SerializationUtils.fromJsonString((String)currentParticipant, Map.class);
            String dynamicParticipant = (String)instanceParticipant.get(taskDefinitionKey);
            if (dynamicParticipant != null) {
                executionEntity.setVariable("dynParticipant", dynamicParticipant);
            } else {
                executionEntity.removeVariable("dynParticipant");
            }
        } else {
            executionEntity.removeVariable("dynParticipant");
        }
    }

    public void sendWithdrawMsg(CommandContext commandContext, Long taskId) {
        TaskEntity task = (TaskEntity)commandContext.getTaskEntityManager().findById(taskId);
        List<IdentityLinkEntity> identityLinks = commandContext.getIdentityLinkEntityManager().findIdentityLinksByTaskIds(new Long[]{taskId});
        ArrayList<Long> userIds = new ArrayList<Long>(identityLinks.size());
        for (IdentityLinkEntity iden : identityLinks) {
            userIds.add(iden.getUserId());
        }
        if (!userIds.isEmpty()) {
            this.sendWithdrawMsg(commandContext, task, userIds);
        }
    }

    public void sendWithdrawMsg(CommandContext commandContext, TaskEntity entity, List<Long> userIds) {
        if (entity == null) {
            return;
        }
        boolean sendable = WfConfigurationUtil.needWithdrawMsg();
        if (sendable) {
            ILocaleString billName = entity.getEntityName();
            ILocaleString nodeName = entity.getName();
            String billno = entity.getBillNo();
            ILocaleString titleValue = WfUtils.getPromptWordLocaleString("\u8282\u70b9%1$s\u7684\u5f85\u529e\u4efb\u52a1%2$s[%3$s]\u88ab\u64a4\u56de\u3002", "UpgradeWithdrawTaskCmd_120", "bos-wf-engine");
            ILocaleString title = WfMultiLangUtils.getMultiLangValue(new ILocaleString[]{titleValue, nodeName, billName, new LocaleString(billno)});
            MessageContext ctx = MessageServiceUtil.buildMessageContext(entity.getId());
            final MessageInfo info = new MessageInfo();
            info.setNotifyType(MessageServiceUtil.getNotifyTypeByNode("message"));
            info.setMessageTitle(title);
            info.setMessageContent(title);
            info.setUserIds(userIds);
            info.setBizDataId(entity.getId());
            info.setEntityNumber("wf_task");
            info.setPubaccNumber("flowassist");
            TaskEntity taskEntity = (TaskEntity)commandContext.getTaskEntityManager().findById(entity.getId());
            info.getParams().put("bizEntityObject", DynamicObjectJsonSerializer.convertDynamicObjectToJson(taskEntity.getDynamicObject()));
            info.setTplScene(MessageTypeEnum.WITHDRAW.getNumber());
            info.setMessageTag(WfUtils.getPromptWordLocaleString("\u5de5\u4f5c\u6d41", "MessageScheduleHelper_1", "bos-wf-engine"));
            boolean showUrlInWFSmsMessgae = WfConfigurationUtil.isShowUrlInWFSmsMessgae();
            info.getParams().put("showurlinwfsms", showUrlInWFSmsMessgae);
            commandContext.addCloseListener(new DefaultCommandContextCloseListener(""){

                @Override
                public void closed(CommandContext commandContext) {
                    MessageCenterServiceHelper.sendMessage((MessageInfo)info);
                }
            });
            logger.debug(String.format("sendWithdrawMessge task[%s],bk[%s]", ctx.getTaskId(), ctx.getBusinessKey()));
        }
    }

    private void judgeCanWithdraw(HiUserActInstEntity h) {
        try {
            boolean result = this.validateCanWithdraw(h.getExecutionId());
            if (!result) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u8282\u70b9\u4e0d\u80fd\u64a4\u56de", (String)"UpgradeWithdrawTaskCmd_108", (String)"bos-wf-engine", (Object[])new Object[0]), h.getCurrentNodeName()));
            }
        }
        catch (Exception e) {
            if (e instanceof KDException) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u64a4\u56de\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"UpgradeWithdrawTaskCmd_109", (String)"bos-wf-engine", (Object[])new Object[0]), e.getMessage()));
            }
            throw e;
        }
    }

    private void removeRejectKeyVariable(List<HistoricActivityInstanceEntity> actInsts, HistoricTaskInstanceEntity historicTask) {
        Map<String, NodeForkJoinModel> models = this.process.getForkJoinModels();
        NodeForkJoinModel model = models.get(historicTask.getTaskDefinitionKey());
        for (HistoricActivityInstanceEntity i : actInsts) {
            int sl;
            NodeForkJoinModel t = models.get(i.getActivityId());
            if (t == null || model == null || !model.getForkStructure().contains(t.getForkStructure()) || i.getActivityId().equals(model.getLatestJoinNode()) || (sl = model.getForkStructure().split("\\$").length - t.getForkStructure().split("\\$").length) != 1) continue;
            ForkJoinUtils.removeJoinNodeRejectKey(model.getLatestForkNode(), ForkJoinUtils.getEnterForkCycle(model.getLatestForkNode(), this.proInst), this.proInst);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteProcess(CommandContext commandContext, String businesskey) {
        ExecutionEntity billExec;
        ExecutionEntity parentExec;
        if (WfUtils.isNotEmpty(businesskey) && (this.proInstId = new GetNotWithdrawProcInstIdByBusKeyCmd(businesskey).execute(commandContext)) == null) {
            throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{WFMultiLangConstants.flowOverText()});
        }
        QFilter[] qFilter = null;
        QFilter bkFilter = new QFilter("proInstId", "=", (Object)this.proInstId);
        QFilter endFilter = new QFilter("endTime", "is null", null);
        if (WfUtils.isNotEmpty(this.hitaskId)) {
            QFilter[] qFilterArray;
            HistoricTaskInstanceEntity hitaskEntity = (HistoricTaskInstanceEntity)commandContext.getHistoricTaskInstanceEntityManager().findById(this.hitaskId);
            String taskDefinitionKey = hitaskEntity.getTaskDefinitionKey();
            BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(hitaskEntity.getProcessDefinitionId(), null, hitaskEntity.getProcessInstanceId());
            FlowElement flowElement = bpmnModel.getFlowElement(taskDefinitionKey);
            if (BpmnModelUtil.isFirstNodeByModel((FlowNode)flowElement)) {
                QFilter[] qFilterArray2 = new QFilter[2];
                qFilterArray2[0] = bkFilter;
                qFilterArray = qFilterArray2;
                qFilterArray2[1] = endFilter;
            } else {
                QFilter[] qFilterArray3 = new QFilter[3];
                qFilterArray3[0] = bkFilter;
                qFilterArray3[1] = endFilter;
                qFilterArray = qFilterArray3;
                qFilterArray3[2] = new QFilter("lastUserNodeActId", "=", (Object)taskDefinitionKey);
            }
            qFilter = qFilterArray;
        } else {
            qFilter = new QFilter[]{bkFilter, endFilter};
        }
        List userActInsts = this.hiUserMgr.findByQueryFilters(qFilter);
        if (userActInsts.isEmpty()) {
            return false;
        }
        HashSet<Long> actInstIds = new HashSet<Long>(userActInsts.size() * 2);
        HashSet<Long> autoActInstIds = new HashSet<Long>();
        HashSet<Long> callActivityInstIds = new HashSet<Long>();
        boolean withdrawProcInAuditing = false;
        boolean withdrawByAbandonProc = false;
        boolean currentActIsCallActivity = false;
        boolean pathContainsCallActivity = false;
        if (WfUtils.isEmpty(this.hitaskId)) {
            Process proc = null;
            if (this.calledByParentProcess) {
                Long parentProcInstId = ((HistoricProcessInstanceEntity)commandContext.getHistoricProcessInstanceEntityManager().findById(this.proInstId)).getSuperProcessInstanceId();
                proc = ProcessDefinitionUtil.getProcess(null, parentProcInstId);
            } else {
                proc = ProcessDefinitionUtil.getProcess(null, ((HiUserActInstEntity)userActInsts.get(0)).getProinstId());
            }
            withdrawProcInAuditing = proc.getWithdrawProcInAuditing();
        }
        boolean isUserTaskWithdraw = true;
        for (HiUserActInstEntity userActInst : userActInsts) {
            if (userActInst.getLastUserNodeActId().contains(STARTSIGNAL)) continue;
            isUserTaskWithdraw = false;
            break;
        }
        for (int j = 0; j < userActInsts.size(); ++j) {
            int approvaledCount;
            String pj;
            HiUserActInstEntity i = (HiUserActInstEntity)userActInsts.get(j);
            currentActIsCallActivity = i.getCurrentActId().contains("CallActivity");
            if (withdrawProcInAuditing && currentActIsCallActivity) {
                withdrawByAbandonProc = true;
            }
            if (WfUtils.isNotEmpty(pj = i.getPathJson())) {
                List pathjsons = SerializationUtils.fromJsonStringToList((String)pj, PathJson.class);
                Iterator itr = pathjsons.iterator();
                while (itr.hasNext()) {
                    PathJson p = (PathJson)itr.next();
                    if (p.getNodeId().contains("CallActivity")) {
                        pathContainsCallActivity = true;
                        callActivityInstIds.add(p.getActInstId());
                    } else {
                        autoActInstIds.add(p.getActInstId());
                    }
                    HistoricActivityInstanceEntity hiActInstanceEntity = (HistoricActivityInstanceEntity)commandContext.getHistoricActivityInstanceEntityManager().findById(p.getActInstId());
                    HistoricTaskInstanceEntity hitask = null;
                    if (!isUserTaskWithdraw || hiActInstanceEntity == null || (hitask = (HistoricTaskInstanceEntity)commandContext.getHistoricTaskInstanceEntityManager().findById(hiActInstanceEntity.getTaskId())) == null) continue;
                    HistoricProcessInstanceEntity historicProcessInstance = (HistoricProcessInstanceEntity)commandContext.getHistoricProcessInstanceEntityManager().findById(hitask.getProcessInstanceId());
                    Long superProcessInstanceId = historicProcessInstance.getSuperProcessInstanceId();
                    boolean isStrongControl = !withdrawByAbandonProc && i.getLastUserNodeActId().contains(STARTSIGNAL) && WfConfigurationUtil.isSupportStrongControl() && BpmnModelUtil.instanceofUserTaskOnly(hitask.getCategory()) && WfUtils.isEmpty(superProcessInstanceId);
                    if (!isStrongControl) continue;
                    HashMap<String, Object> restoredMap = new HashMap<String, Object>(4);
                    restoredMap.put("lastNodeActinstId", i.getLastNodeActinstId());
                    restoredMap.put("lastUserNodeActId", i.getLastUserNodeActId());
                    restoredMap.put("pathjson", i.getPathJson());
                    restoredMap.put("id", i.getId());
                    this.restoredMapList.add(restoredMap);
                    i.setLastNodeActinstId(p.getActInstId());
                    i.setLastUserNodeActId(p.getNodeId());
                    itr.remove();
                    i.setPathJson(SerializationUtils.toJsonString((Object)pathjsons));
                    this.strongControlHiUserActInstEntityList.add(i);
                    if (!WfUtils.isEmpty(this.hitaskId) || (this.executionId == null || this.executionId == 0L) && !WfUtils.isNotEmpty(businesskey)) break;
                    this.hitaskId = this.getHitaskId(this.executionId);
                    break;
                }
            }
            boolean canReturnTrue = true;
            boolean manualApproval = false;
            if (i.getCurrentActId().contains("YunzhijiaTask")) {
                if (!isUserTaskWithdraw || isUserTaskWithdraw && this.getYzjApprovaledCount(commandContext, i.getCurrentActinstId()) > 0) {
                    manualApproval = true;
                }
            } else {
                boolean bl = manualApproval = !isUserTaskWithdraw;
            }
            if (!i.getLastUserNodeActId().contains(STARTSIGNAL) && !i.getLastUserNodeActId().contains("CallActivity") || pathContainsCallActivity) {
                if (withdrawProcInAuditing && manualApproval) {
                    withdrawByAbandonProc = true;
                    this.strongControlHiUserActInstEntityList.clear();
                } else {
                    canReturnTrue = false;
                }
            }
            if (this.strongControlHiUserActInstEntityList != null && !this.strongControlHiUserActInstEntityList.isEmpty() && j == userActInsts.size() - 1) {
                return false;
            }
            if (this.strongControlHiUserActInstEntityList != null && !this.strongControlHiUserActInstEntityList.isEmpty() && j < userActInsts.size() - 1) continue;
            if (!canReturnTrue) {
                return false;
            }
            if (i.getCurrentActId().contains("SSCApprove")) {
                this.judgeCanWithdraw(i);
            }
            if (!withdrawByAbandonProc && i.getCurrentActId().contains("YunzhijiaTask") && (approvaledCount = this.getYzjApprovaledCount(commandContext, i.getCurrentActinstId())) != 0) {
                if (withdrawProcInAuditing) {
                    withdrawByAbandonProc = true;
                } else {
                    throw new KDException(WFErrorCode.withdrawError(), new Object[0]);
                }
            }
            this.businesskey = businesskey = i.getBusinesskey();
            actInstIds.add(i.getCurrentActinstId());
            this.proInstId = i.getProinstId();
        }
        if (withdrawByAbandonProc) {
            if (this.proInst == null) {
                this.proInst = (ExecutionEntity)this.executionMgr.findById(this.proInstId);
            }
            if (this.process == null) {
                this.process = ProcessDefinitionUtil.getProcess(this.proInst.getProcessDefinitionId(), this.proInstId);
            }
            this.proInst.setVariableLocal("exceptionEvent", this.operationName);
            this.proInst.setTransientVariable("exceptionEvent", this.operationName);
            commandContext.getProcessEngineConfiguration().getListenerNotificationHelper().executeExecutionListeners(this.process, this.proInst, "withdraw_audited_proc");
            if (WfConfigurationUtil.isSupportStrongControl() && WfConfigurationUtil.isBillWithdrawJumpToUserNode()) {
                new BillWithdrawJumpToUserNodeCmd(this.proInstId, false).execute(commandContext);
            } else {
                LocaleString cause = ResManager.getLocaleString((String)"\u6574\u5355\u64a4\u56de\u7ec8\u6b62\u6d41\u7a0b", (String)"UpgradeWithdrawTaskCmd_115", (String)"bos-wf-engine");
                new AbandonProcessCmd(this.proInstId, (ILocaleString)cause, "billAbort").execute(commandContext);
                this.proInst.setActive(false);
                this.executionMgr.update(this.proInst);
            }
            return true;
        }
        List<HistoricActivityInstanceEntity> actInsts = this.hisActivityManager.findByProcessInstanceId(this.proInstId);
        List<ExecutionEntity> childrenExecutions = this.executionMgr.findChildExecutionsByProcessInstanceId(this.proInstId);
        HashMap<String, ExecutionEntity> executionMap = new HashMap<String, ExecutionEntity>();
        for (ExecutionEntity e : childrenExecutions) {
            if (!WfUtils.isNotEmpty(e.getCurrentActInstId())) continue;
            executionMap.put(String.valueOf(e.getId()), e);
        }
        StringBuilder currentNodeNames = new StringBuilder();
        StringBuilder autoNodeNames = new StringBuilder();
        for (int j = actInsts.size() - 1; j >= 0; --j) {
            HistoricActivityInstanceEntity i = actInsts.get(j);
            if (actInstIds.contains(i.getId())) {
                currentNodeNames.append(i.getActivityName()).append('\uff0c');
                Long parentTaskId = i.getParentTaskId();
                if (WfUtils.isNotEmpty(parentTaskId)) {
                    List<TaskEntity> cts = commandContext.getTaskEntityManager().findTasksByParentTaskId(parentTaskId);
                    for (TaskEntity t : cts) {
                        this.deleteToDoMsg(commandContext, t);
                    }
                } else {
                    this.sendWithdrawMsg(commandContext, i.getTaskId());
                }
                this.executeWithdrawExecutionListeners(commandContext, (ExecutionEntity)executionMap.get(String.valueOf(i.getExecutionId())), "start", this.operationName, i.getActivityId(), i.getId());
                commandContext.getHistoricTaskInstanceEntityManager().delete(i.getTaskId());
                this.saveOperationLog(commandContext, i.getTaskId());
                if (currentActIsCallActivity) {
                    this.withdrawSubProcess(commandContext, this.proInstId);
                }
            }
            if (autoActInstIds.contains(i.getId())) {
                Object exeId;
                autoNodeNames.append(i.getActivityName()).append('\uff0c');
                String executionStr = String.valueOf(i.getExecutionId());
                if ("YunzhijiaTask".equals(i.getActivityType()) && WfUtils.isNotEmpty((Long)(exeId = this.yzjActInstGetExe(commandContext, i)))) {
                    executionStr = ((Long)exeId).toString();
                }
                this.executeWithdrawExecutionListeners(commandContext, (ExecutionEntity)executionMap.get(executionStr), "end", this.operationName, i.getActivityId(), i.getId());
                this.executeWithdrawExecutionListeners(commandContext, (ExecutionEntity)executionMap.get(executionStr), "start", this.operationName, i.getActivityId(), i.getId());
                this.withdrawAutoOperation(i);
            }
            if (!callActivityInstIds.contains(i.getId()) || i.getEndTime() == null) continue;
            throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{ResManager.loadKDString((String)"\u5b50\u6d41\u7a0b\u5df2\u7ed3\u675f\u3002", (String)"UpgradeWithdrawTaskCmd_111", (String)"bos-wf-engine", (Object[])new Object[0])});
        }
        this.operationLog.append(ResManager.loadKDString((String)"\u64a4\u56de\u6210\u529f\uff0c\u5f53\u524d\u8282\u70b9\uff1a", (String)"UpgradeWithdrawTaskCmd_86", (String)"bos-wf-engine", (Object[])new Object[0])).append((CharSequence)currentNodeNames).append(ResManager.loadKDString((String)"\u4e2d\u95f4\u81ea\u52a8\u8282\u70b9\uff1a", (String)"UpgradeWithdrawTaskCmd_87", (String)"bos-wf-engine", (Object[])new Object[0])).append((CharSequence)autoNodeNames);
        WfUtils.addOpLog("wf_task", "withdraw", new MultiLangEnumBridge("\u64a4\u56de", "UpgradeWithdrawTaskCmd_88", "bos-wf-engine"), null, this.operationLog.toString());
        commandContext.getHiUserActInstEntityManager().deleteByProinstId(this.proInstId);
        commandContext.getHistoricActivityInstanceEntityManager().deleteHistoricActivityInstancesByProcessInstanceId(this.proInstId);
        this.executeProcessInstanceWithdrawListeners(commandContext);
        commandContext.getExecutionEntityManager().deleteProcessInstance(this.proInstId, "process instance withdraw", false);
        commandContext.getMessageService().deleteProcessIntacne(this.proInstId);
        commandContext.getCommentEntityManager().deleteCommentsByProcessInstanceId(this.proInstId);
        commandContext.getEventLogEntryEntityManager().deleteByFilters(new QFilter[]{new QFilter("processinstanceid", "=", (Object)this.proInstId)});
        commandContext.getJobEntityManager().deleteByFilters(new QFilter[]{new QFilter("processInstanceId", "=", (Object)this.proInstId)});
        commandContext.getHistoricTaskInstanceEntityManager().deleteHistoricTaskInstancesByProcessInstanceId(this.proInstId);
        ActivitiEventDispatcher eventDispatcher = Context.getProcessEngineConfiguration().getEventDispatcher();
        if (eventDispatcher.isEnabled()) {
            QFilter[] filters = new QFilter[]{new QFilter("processInstanceId", "=", (Object)this.proInstId)};
            List historicTaskInstanceEntities = Context.getCommandContext().getHistoricTaskInstanceEntityManager().findByQueryFilters(filters);
            for (HistoricTaskInstanceEntity historicTaskInstanceEntity : historicTaskInstanceEntities) {
                if (historicTaskInstanceEntity.getAssigneeId() == null) continue;
                eventDispatcher.dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.TASK_DELETED, historicTaskInstanceEntity));
            }
        }
        commandContext.getHistoricVariableInstanceEntityManager().deleteHistoricVariableInstanceByProcessInstanceId(this.proInstId);
        ExecutionEntity execution = null;
        String eventName = "";
        try {
            execution = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(this.proInstId);
            if (execution != null) {
                eventName = execution.getEventName();
                execution.setEventName("terminate");
                logger.debug("MessageChannelProcessListener enter");
                new MessageChannelProcessListener().notify(execution);
            }
        }
        catch (Exception e) {
            logger.debug("MessageChannelProcessListener is error : " + WfUtils.getExceptionStacktrace(e));
        }
        finally {
            if (execution != null) {
                execution.setEventName(eventName);
            }
        }
        if (execution != null && (parentExec = execution.getSuperExecution()) != null && ModelType.BizFlow.name().equalsIgnoreCase(parentExec.getProcessType()) && (billExec = parentExec.getParent()) != null && billExec.isBillExecution()) {
            billExec.setAbortType(2);
            commandContext.getExecutionEntityManager().update(billExec);
        }
        if (this.calledByParentProcess) {
            return true;
        }
        WfCacheHelper.removeExecutingJobOfCurrentBusiness(businesskey, childrenExecutions.get(0).getEntityNumber());
        final String bk = businesskey;
        final String em = childrenExecutions.get(0).getEntityNumber();
        commandContext.addCloseListener(new DefaultCommandContextCloseListener("upgradeWithdraw"){

            @Override
            public void closed(CommandContext commandContext) {
                super.closed(commandContext);
                WfCacheHelper.removeExecutingJobGYEntityOfCurrentBusiness(bk, em);
            }
        });
        return true;
    }

    private void executeProcessInstanceWithdrawListeners(CommandContext commandContext) {
        if (this.proInst == null) {
            this.proInst = (ExecutionEntity)this.executionMgr.findById(this.proInstId);
        }
        if (this.proInst == null || !ModelType.NoCodeFlow.name().equals(this.proInst.getProcessType())) {
            return;
        }
        if (this.process == null) {
            this.process = ProcessDefinitionUtil.getProcess(this.proInst.getProcessDefinitionId(), this.proInstId);
        }
        if (this.process != null) {
            commandContext.getProcessEngineConfiguration().getListenerNotificationHelper().executeExecutionListeners(this.process, this.proInst, "procInstWithdraw");
        }
    }

    private int getYzjApprovaledCount(CommandContext commandContext, Long currentActinstId) {
        int approvaledCount = 0;
        HistoricActivityInstanceEntity currentActInst = (HistoricActivityInstanceEntity)commandContext.getHistoricActivityInstanceEntityManager().findById(currentActinstId);
        if (currentActInst != null && WfUtils.isNotEmpty(currentActInst.getParentTaskId())) {
            QFilter f = new QFilter("parentTaskId", "=", (Object)currentActInst.getParentTaskId());
            List yzjChildTasks = commandContext.getHistoricTaskInstanceEntityManager().findByQueryFilters(new QFilter[]{f});
            for (HistoricTaskInstanceEntity t : yzjChildTasks) {
                if (t.getEndTime() == null) continue;
                ++approvaledCount;
                break;
            }
        }
        return approvaledCount;
    }

    private Long yzjActInstGetExe(CommandContext ctx, HistoricActivityInstanceEntity yzjActInst) {
        Long parentTaskId = yzjActInst.getParentTaskId();
        if (WfUtils.isNotEmpty(parentTaskId)) {
            HistoricTaskInstanceEntity parentTask = (HistoricTaskInstanceEntity)ctx.getHistoricTaskInstanceEntityManager().findById(parentTaskId);
            return parentTask == null ? null : parentTask.getExecutionId();
        }
        return null;
    }

    private void updateFlagAndFirstExecution(Map<String, Integer> curNodesDeleteNoOfArrived, Map<String, Long> curNodesJoinNodeExecutionIds, Map<String, Long> needVoteFirstExecutionActInstIds, Set<Long> deleteActInstIds, Set<Long> deleteHiUserActInstIds) {
        for (Map.Entry<String, Integer> entry : curNodesDeleteNoOfArrived.entrySet()) {
            String joinFlag = entry.getKey();
            int noOfArrived = (Integer)ForkJoinUtils.getNoOfArrived(joinFlag, this.proInst);
            if ((noOfArrived -= entry.getValue().intValue()) < 1) {
                ForkJoinUtils.removeNoOfArrived(joinFlag, this.proInst);
                ForkJoinUtils.removeFirstEnterJoinExecution(joinFlag, this.proInst);
                continue;
            }
            ForkJoinUtils.setNoOfArrived(joinFlag, this.proInst, noOfArrived);
        }
        QFilter currentExeFilter = new QFilter("currentExecutionId", "in", curNodesJoinNodeExecutionIds.values());
        QFilter proInstFilter = new QFilter("proInstId", "=", (Object)this.proInstId);
        QFilter endTimeFilter = new QFilter("endTime", "is null", null);
        List needUpdCurExeIds = this.hiUserMgr.findByQueryFilters(new QFilter[]{proInstFilter, currentExeFilter, endTimeFilter});
        if (!needVoteFirstExecutionActInstIds.isEmpty()) {
            QFilter joinFilter = new QFilter("joinFlag", "in", needVoteFirstExecutionActInstIds.keySet());
            QFilter f = new QFilter("processInstanceId", "=", (Object)this.proInstId);
            List needUpdActInst = this.hisActivityManager.findByQueryFilters(new QFilter[]{f, joinFilter});
            HashMap<String, Long> newActiveExecutionMap = new HashMap<String, Long>();
            ArrayList<String> votedJoinFlags = new ArrayList<String>(10);
            for (HistoricActivityInstanceEntity i : needUpdActInst) {
                if (deleteActInstIds.contains(i.getId())) continue;
                String jf = i.getJoinFlag();
                Long oldExecutionId = (Long)ForkJoinUtils.getFirstEnterJoinExecution(jf, this.proInst);
                if (!needVoteFirstExecutionActInstIds.values().contains(i.getId()) && !votedJoinFlags.contains(jf)) {
                    votedJoinFlags.add(jf);
                    ExecutionEntity oldE = (ExecutionEntity)this.executionMgr.findById(oldExecutionId);
                    oldE.setActive(false);
                    newActiveExecutionMap.put(String.valueOf(oldExecutionId), i.getExecutionId());
                    ForkJoinUtils.setFirstEnterJoinExecution(i.getJoinFlag(), this.proInst, i.getExecutionId());
                }
                i.setEndTime(null);
                i.setDurationInMillis(0L);
                this.hisActivityManager.update(i);
            }
            QFilter exeFilter = new QFilter("id", "in", newActiveExecutionMap.values());
            QFilter executionf = new QFilter("processInstanceId", "=", (Object)this.proInstId);
            List newActiveExe = this.executionMgr.findByQueryFilters(new QFilter[]{executionf, exeFilter});
            for (ExecutionEntity i : newActiveExe) {
                i.setActive(true);
                this.executionMgr.update(i);
            }
        } else {
            List needSetEndTimeNull = this.hisActivityManager.findByQueryFilters(new QFilter[]{new QFilter("joinFlag", "in", curNodesDeleteNoOfArrived.keySet()), new QFilter("processInstanceId", "=", (Object)this.proInstId)});
            for (HistoricActivityInstanceEntity i : needSetEndTimeNull) {
                if (deleteActInstIds.contains(i.getId())) continue;
                i.setTaskId(null);
                i.setEndTime(null);
                i.setDurationInMillis(0L);
                this.hisActivityManager.update(i);
            }
        }
        for (HiUserActInstEntity i : needUpdCurExeIds) {
            String pj;
            if (deleteHiUserActInstIds.contains(i.getId()) || !WfUtils.isNotEmpty(pj = i.getPathJson())) continue;
            List pathjsons = SerializationUtils.fromJsonStringToList((String)pj, PathJson.class);
            int j = 0;
            boolean needSubPj = false;
            for (PathJson p : pathjsons) {
                ++j;
                if (!WfUtils.isNotEmpty(p.getJoinFlag()) || !curNodesJoinNodeExecutionIds.containsKey(p.getJoinFlag())) continue;
                i.setCurrentActId(p.getNodeId());
                i.setCurrentActinstId(p.getActInstId());
                i.setCurrentExecutionId(p.getExecutionId());
                ExecutionEntity execution = (ExecutionEntity)this.executionMgr.findById(p.getExecutionId());
                execution.setCurrentActInstId(p.getActInstId());
                execution.setCurrentTask(null);
                execution.setCurrentTaskId(null);
                execution.setActivityId(p.getNodeId());
                HistoricActivityInstanceEntity hactinst = (HistoricActivityInstanceEntity)this.hisActivityManager.findById(p.getActInstId());
                hactinst.setEndTime(null);
                hactinst.setDurationInMillis(0L);
                this.hisActivityManager.update(hactinst);
                Long fistEnterExe = (Long)ForkJoinUtils.getFirstEnterJoinExecution(p.getJoinFlag(), this.proInst);
                if (execution.getId().equals(fistEnterExe)) {
                    execution.setActive(true);
                }
                FlowElement flowElement = this.process.getFlowElement(p.getNodeId());
                execution.setCurrentFlowElement(flowElement);
                this.executionMgr.update(execution);
                needSubPj = true;
                break;
            }
            if (!needSubPj) continue;
            String pjson = "";
            if (j > 1) {
                pjson = SerializationUtils.toJsonString(pathjsons.subList(0, j - 1));
            }
            i.setPathJson(pjson);
            this.hiUserMgr.update(i);
        }
    }

    private void updateDynParticipant(ExecutionEntity oldE, ExecutionEntity newE, HistoricActivityInstanceEntity i) {
        String joinFlag = i.getJoinFlag();
        if (WfUtils.isNotEmpty(joinFlag)) {
            String selectFields = Context.getCommandContext().getHistoricActivityInstanceEntityManager().getSelectFields();
            QFilter proFilter = new QFilter("processInstanceId", "=", (Object)oldE.getProcessInstanceId());
            QFilter jfFilter = new QFilter("joinFlag", "=", (Object)joinFlag);
            List hisActs = Context.getCommandContext().getHistoricActivityInstanceEntityManager().findByQueryFilters(new QFilter[]{proFilter, jfFilter}, selectFields, "createDate ASC");
            Object dynParticipant = "";
            for (HistoricActivityInstanceEntity a : hisActs) {
                if (oldE.getId().equals(a.getExecutionId()) || newE.getId().equals(a.getExecutionId())) continue;
                Long eId = a.getExecutionId();
                ExecutionEntity tmp = (ExecutionEntity)Context.getCommandContext().getExecutionEntityManager().findById(eId);
                dynParticipant = tmp.getVariable("dynParticipant");
                if (!WfUtils.isNotEmptyString(dynParticipant)) continue;
                newE.setVariable("dynParticipant", dynParticipant);
                break;
            }
        }
    }

    public void recoveVariableCycleAndReject(String actId, CommandContext commandContext, List<HistoricActivityInstanceEntity> actInsts, String hisActId) {
        Map<String, NodeForkJoinModel> models = this.process.getForkJoinModels();
        FlowNode autoFNode = (FlowNode)this.process.getFlowElement(actId);
        if (autoFNode.getFork() != null && autoFNode.getFork().booleanValue() && "leavewhenallmeet".equals(autoFNode.getOutSet()) && "reject".equals(autoFNode.getPassTypeAfterInnerReject())) {
            if (!actInsts.isEmpty()) {
                if (actInsts.size() > 1) {
                    return;
                }
                NodeForkJoinModel cm = models.get(actInsts.get(0).getActivityId());
                NodeForkJoinModel hisNodeModel = models.get(hisActId);
                if (actId.equals(cm.getLatestForkNode())) {
                    if (hisNodeModel.getForkStructure().equals(cm.getForkStructure())) {
                        return;
                    }
                } else {
                    return;
                }
            }
            String forkNodeId = autoFNode.getId();
            int cycle = ForkJoinUtils.getEnterForkCycle(forkNodeId, this.proInst);
            String key = String.format("%s_%s_%s", ForkJoinUtils.getNumber(forkNodeId, this.proInst), cycle, "forkRejectKey");
            QFilter filter = new QFilter("processInstanceId", "=", (Object)this.proInstId);
            QFilter nameFilter = new QFilter("name", "=", (Object)key);
            HistoricVariableInstanceEntityManager hvme = commandContext.getHistoricVariableInstanceEntityManager();
            List hs = hvme.findByQueryFilters(new QFilter[]{filter, nameFilter}, hvme.getSelectFields(), "createdate desc");
            if (hs != null && !hs.isEmpty() && WfUtils.isNotEmptyString(((HistoricVariableInstanceEntity)hs.get(0)).getValue())) {
                ForkJoinUtils.setJoinNodeRejectKey(forkNodeId, cycle, this.proInst, String.valueOf(((HistoricVariableInstanceEntity)hs.get(0)).getValue()));
                logger.debug(forkNodeId + "JoinNodeRejectKey\u5df2\u6062\u590d\uff1a" + String.valueOf(((HistoricVariableInstanceEntity)hs.get(0)).getValue()));
            }
        }
    }

    private boolean validateTaskCanwithdraw(Long proInstId, CommandContext commandContext) {
        String ret;
        if (WfUtils.isEmpty(proInstId)) {
            proInstId = this.proInstId;
        }
        if (WfUtils.isNotEmpty(this.businesskey)) {
            List<ExecutionEntity> execs = this.executionMgr.findProcessInstanceByBusinessKey(this.businesskey);
            if (execs == null || execs.isEmpty()) {
                return true;
            }
            if (RuntimeUtil.isRetring(commandContext, this.businesskey) || RuntimeUtil.isRunning(commandContext, this.businesskey)) {
                throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{ResManager.loadKDString((String)"\u6d41\u7a0b\u6b63\u5728\u6d41\u8f6c\uff0c\u6216\u6b63\u5728\u91cd\u8bd5\u3002", (String)"UpgradeWithdrawTaskCmd_13", (String)"bos-wf-engine", (Object[])new Object[0])});
            }
            if (ManagementConstants.SUSPENDED.getStateCode().equals(this.executionMgr.findProcessInstanceByBusinessKey(this.businesskey).get(0).getSuspensionState())) {
                throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{ResManager.loadKDString((String)"\u6d41\u7a0b\u5df2\u6302\u8d77\u3002", (String)"UpgradeWithdrawTaskCmd_14", (String)"bos-wf-engine", (Object[])new Object[0])});
            }
            return true;
        }
        if (RuntimeUtil.isRunning(commandContext, proInstId) || RuntimeUtil.isRetring(commandContext, proInstId)) {
            throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{ResManager.loadKDString((String)"\u6d41\u7a0b\u6b63\u5728\u6d41\u8f6c\uff0c\u6216\u6b63\u5728\u91cd\u8bd5\u3002", (String)"UpgradeWithdrawTaskCmd_13", (String)"bos-wf-engine", (Object[])new Object[0])});
        }
        HistoricProcessInstance hp = (HistoricProcessInstance)commandContext.getHistoricProcessInstanceEntityManager().findById(proInstId);
        if (hp == null) {
            throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{ResManager.loadKDString((String)"\u672a\u627e\u5230\u76f8\u5e94\u6d41\u7a0b\u3002", (String)"UpgradeWithdrawTaskCmd_1", (String)"bos-wf-engine", (Object[])new Object[0])});
        }
        if (hp.getEndTime() != null) {
            throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{WFMultiLangConstants.flowOverText()});
        }
        if (ManagementConstants.SUSPENDED.getStateCode().equals(((ExecutionEntity)commandContext.getExecutionEntityManager().findById(proInstId)).getSuspensionState())) {
            throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{ResManager.loadKDString((String)"\u6d41\u7a0b\u5df2\u6302\u8d77\u3002", (String)"UpgradeWithdrawTaskCmd_14", (String)"bos-wf-engine", (Object[])new Object[0])});
        }
        if (!this.calledByParentProcess && WfUtils.isNotEmpty(hp.getSuperProcessInstanceId()) && (ret = this.validateSubProcessWithdraw(commandContext, hp)) != null) {
            throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{ret});
        }
        return true;
    }

    private boolean withdrawSubProcess(CommandContext commandContext, Long procInstId) {
        boolean subProcess = false;
        try {
            ExecutionEntityManager executionManager = commandContext.getExecutionEntityManager();
            List<ExecutionEntity> executions = executionManager.findActiveExecutionsByProcessInstanceId(procInstId);
            HistoricActivityInstanceEntityManager hisActInstManager = commandContext.getHistoricActivityInstanceEntityManager();
            if (executions == null || executions.isEmpty()) {
                return true;
            }
            for (ExecutionEntity execution : executions) {
                if (execution.isScope()) continue;
                if (RuntimeUtil.isBizRunning(commandContext, execution.getBusinessKey())) {
                    throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{ResManager.loadKDString((String)"\u5b50\u6d41\u7a0b\u6b63\u5728\u8fd0\u884c\u4e2d\u3002", (String)"UpgradeWithdrawTaskCmd_114", (String)"bos-wf-engine", (Object[])new Object[0])});
                }
                FlowElement flowElement = execution.getCurrentFlowElement();
                if (!(flowElement instanceof CallActivity)) {
                    logger.debug(String.format("Current FlowFlement is not CallActivity! ActivityId: %s", flowElement.getId()));
                    continue;
                }
                ExecutionEntity subProcessInstance = executionManager.findSubProcessInstanceBySuperExecutionId(execution.getId());
                List<ExecutionEntity> subExecutions = executionManager.findActiveExecutionsByProcessInstanceId(subProcessInstance.getId());
                if (subExecutions == null || subExecutions.isEmpty()) {
                    logger.debug(String.format("Can not found subprocess execution! superExecutionId: %s", execution.getId()));
                    continue;
                }
                BpmnModel subBpmnModel = null;
                for (ExecutionEntity subExecution : subExecutions) {
                    Long subExecutionId;
                    HistoricActivityInstanceEntity activityInstance;
                    if (subExecution.isScope()) continue;
                    subProcess = true;
                    Long subProcInstId = subExecution.getProcessInstanceId();
                    if (subBpmnModel == null) {
                        subBpmnModel = ProcessDefinitionUtil.getBpmnModel(subExecution.getProcessDefinitionId(), subProcInstId);
                    }
                    if ((activityInstance = this.getFirstUserTaskActivityInstance(hisActInstManager, subBpmnModel.getMainProcess(), subProcInstId)) == null) {
                        logger.debug(String.format("Can not found first UserTask ActivityInstanceEntity! ProcInstId: %s", subProcInstId));
                        continue;
                    }
                    Long subTaskId = this.hitaskId != null ? activityInstance.getTaskId() : null;
                    Long l = subExecutionId = this.executionId != null ? subExecution.getId() : null;
                    if (subExecutionId == null && subTaskId == null) {
                        subExecutionId = subExecution.getId();
                    }
                    new UpgradeWithdrawTaskCmd(subExecutionId, subTaskId, true).execute(commandContext);
                    HistoricActivityInstanceEntity actInstEntity = (HistoricActivityInstanceEntity)hisActInstManager.findById(execution.getCurrentActInstId());
                    hisActInstManager.delete(actInstEntity.getSourceElementId());
                    hisActInstManager.delete(actInstEntity);
                    break;
                }
                executionManager.delete(subProcessInstance.getSuperExecutionId());
            }
        }
        catch (Exception e) {
            if (subProcess) {
                ErrorCode canNotWithdraw = WFErrorCode.canNotWithdraw();
                String tip = e.getMessage();
                if (tip != null) {
                    tip = tip.replace(String.format(canNotWithdraw.getMessage(), ""), "");
                }
                logger.error(WfUtils.getExceptionStacktrace(e));
                throw new KDException(canNotWithdraw, new Object[]{String.format(ResManager.loadKDString((String)"\u64a4\u56de\u5b50\u6d41\u7a0b\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"UpgradeWithdrawTaskCmd_107", (String)"bos-wf-engine", (Object[])new Object[0]), tip)});
            }
            throw e;
        }
        return true;
    }

    private String validateSubProcessWithdraw(CommandContext commandContext, HistoricProcessInstance processInstance) {
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(processInstance.getProcessDefinitionId(), processInstance.getId());
        if (WfUtils.isNotEmpty(this.hitaskId)) {
            HistoricActivityInstanceEntity activityInstance = this.getFirstUserTaskActivityInstance(commandContext.getHistoricActivityInstanceEntityManager(), bpmnModel.getMainProcess(), processInstance.getId());
            if (activityInstance != null && this.hitaskId.equals(activityInstance.getTaskId())) {
                return ResManager.loadKDString((String)"\u5b58\u5728\u7236\u6d41\u7a0b\uff0c\u53ea\u80fd\u5728\u7236\u6d41\u7a0b\u64a4\u56de\u4efb\u52a1\u3002", (String)"UpgradeWithdrawTaskCmd_106", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
        } else if (WfUtils.isNotEmpty(this.executionId)) {
            ExecutionEntity execution = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(this.executionId);
            List<HiUserActInstEntity> hiUserActInsts = commandContext.getHiUserActInstEntityManager().findByActivityIdAndProinstId(execution.getCurrentActivityId(), execution.getProcessInstanceId());
            if (hiUserActInsts != null && !hiUserActInsts.isEmpty()) {
                HiUserActInstEntity manualTaskActInst = hiUserActInsts.get(0);
                List<StartEvent> startEvents = bpmnModel.getMainProcess().findFlowElementsOfType(StartEvent.class);
                if (startEvents != null && !startEvents.isEmpty() && startEvents.get(0).getId().equals(manualTaskActInst.getLastUserNodeActId())) {
                    return ResManager.loadKDString((String)"\u5b58\u5728\u7236\u6d41\u7a0b\uff0c\u53ea\u80fd\u5728\u7236\u6d41\u7a0b\u64a4\u9500\u6d41\u7a0b\u3002", (String)"UpgradeWithdrawTaskCmd_110", (String)"bos-wf-engine", (Object[])new Object[0]);
                }
            }
        }
        return null;
    }

    private HistoricActivityInstanceEntity getFirstUserTaskActivityInstance(HistoricActivityInstanceEntityManager hisActInstManager, Process process, Long procInstId) {
        UserTask firstUserTask = BpmnModelUtil.getFirstUserTask(process);
        EntityQueryBuilder queryBuilder = hisActInstManager.createQueryBuilder().addFilter("processInstanceId", procInstId).addFilter("activityId", firstUserTask.getId()).orderBy(String.format("%s DESC", "step"));
        List activityInstances = hisActInstManager.findByQueryBuilder(queryBuilder);
        if (activityInstances == null || activityInstances.isEmpty()) {
            logger.debug(String.format("Can not found first UserTask ActivityInstanceEntity! ActivityId: %s", firstUserTask.getId()));
            return null;
        }
        return (HistoricActivityInstanceEntity)activityInstances.get(0);
    }

    private void deleteToDoMsg(CommandContext commandContext, TaskEntity task) {
        if (task == null) {
            return;
        }
        Long taskId = task.getId();
        List<IdentityLinkEntity> identityLinks = commandContext.getIdentityLinkEntityManager().findIdentityLinksByTaskIds(new Long[]{taskId});
        ArrayList<Long> userIds = new ArrayList<Long>(identityLinks.size());
        for (IdentityLinkEntity iden : identityLinks) {
            userIds.add(iden.getUserId());
        }
        if (!userIds.isEmpty()) {
            commandContext.getMessageService().deleteToDo(taskId, userIds);
            this.sendWithdrawMsg(commandContext, task, userIds);
        }
    }

    protected void executeWithdrawExecutionListeners(CommandContext commandContext, ExecutionEntity execution, String eventType, String operationName, String flowNodeId, Long actInstId) {
        Process process = ProcessDefinitionUtil.getProcess(execution.getProcessDefinitionId(), execution.getProcessInstanceId());
        FlowNode flowNode = (FlowNode)process.getFlowElement(flowNodeId);
        commandContext.getProcessEngineConfiguration().getListenerNotificationHelper().executeWithdrawExecutionListeners(flowNode, execution, eventType, operationName, actInstId);
    }

    private void executeWithdrawTaskListeners(Long executionId) {
        CommandContext commandContext = Context.getCommandContext();
        ExecutionEntity execution = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(executionId);
        commandContext.getProcessEngineConfiguration().getListenerNotificationHelper().executeWithdrawTaskListeners(execution.getCurrentTask(), "complete");
    }

    private void withdrawAutoOperation(HistoricActivityInstanceEntity hisActInst) {
        ExecutionEntity execution;
        Long exeId = this.yzjActInstGetExe(Context.getCommandContext(), hisActInst);
        if (WfUtils.isEmpty(exeId)) {
            exeId = hisActInst.getExecutionId();
        }
        if (null != (execution = (ExecutionEntity)Context.getCommandContext().getExecutionEntityManager().findById(exeId))) {
            execution.setCurrentActInstId(hisActInst.getId());
            execution.setCurrentTask(null);
            execution.setActivityId(hisActInst.getActivityId());
            Process process = ProcessDefinitionUtil.getProcess(hisActInst.getProcessDefinitionId(), hisActInst.getProcessInstanceId());
            FlowElement flowElement = process.getFlowElement(hisActInst.getActivityId());
            if (flowElement instanceof AutoTask) {
                AutoTask autoTask = (AutoTask)flowElement;
                execution.setCurrentFlowElement(autoTask);
                AutoTaskUtil.executeExternalInterface(autoTask, execution, true);
            }
        }
    }

    protected void executeBoundaryEvents(Collection<BoundaryEvent> boundaryEvents, ExecutionEntity execution, CommandContext commandContext) {
        for (BoundaryEvent boundaryEvent : boundaryEvents) {
            if (CollectionUtil.isEmpty(boundaryEvent.getEventDefinitions()) || boundaryEvent.getEventDefinitions().get(0) instanceof CompensateEventDefinition) continue;
            ExecutionEntity childExecutionEntity = commandContext.getExecutionEntityManager().createChildExecution(execution);
            childExecutionEntity.setParentId(execution.getId());
            childExecutionEntity.setCurrentFlowElement(boundaryEvent);
            childExecutionEntity.setScope(false);
            ActivityBehavior boundaryEventBehavior = (ActivityBehavior)boundaryEvent.getBehavior();
            logger.debug(String.format("Executing boundary event activityBehavior %s with execution %s", boundaryEventBehavior.getClass(), childExecutionEntity.getId()));
            boundaryEventBehavior.execute(childExecutionEntity);
        }
    }

    protected void cleanupExecutions(FlowElement currentFlowElement, ExecutionEntity execution, CommandContext commandContext) {
        Activity activity;
        if (currentFlowElement instanceof Activity && CollectionUtil.isNotEmpty((activity = (Activity)currentFlowElement).getBoundaryEvents())) {
            ArrayList<String> notToDeleteEvents = new ArrayList<String>();
            for (BoundaryEvent event : activity.getBoundaryEvents()) {
                if (!CollectionUtil.isNotEmpty(event.getEventDefinitions()) || !(event.getEventDefinitions().get(0) instanceof CancelEventDefinition)) continue;
                notToDeleteEvents.add(event.getId());
            }
            List<ExecutionEntity> childExecutions = commandContext.getExecutionEntityManager().findChildExecutionsByParentExecutionId(execution.getId());
            for (ExecutionEntity childExecution : childExecutions) {
                if (childExecution.getCurrentFlowElement() != null && notToDeleteEvents.contains(childExecution.getCurrentFlowElement().getId())) continue;
                commandContext.getExecutionEntityManager().deleteExecutionAndRelatedData(childExecution, null, false);
            }
        }
    }

    private boolean validateCanWithdraw(Long executionId) {
        CommandContext commandContext = Context.getCommandContext();
        ExecutionEntity execution = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(executionId);
        TaskEntity taskEntity = execution.getCurrentTask();
        Process process = ProcessDefinitionUtil.getProcess(taskEntity.getProcessDefinitionId(), taskEntity.getProcessInstanceId());
        FlowElement flowElement = process.getFlowElement(taskEntity.getTaskDefinitionKey(), true);
        UserTask userTask = (UserTask)flowElement;
        return commandContext.getProcessEngineConfiguration().getListenerNotificationHelper().executeCanWithdrawListeners(userTask, taskEntity);
    }

    private void saveOperationLog(CommandContext commandContext, Long taskId) {
        OperationLogEntityImpl operationLog = new OperationLogEntityImpl();
        Date date = commandContext.getProcessEngineConfiguration().getClock().getCurrentTime();
        operationLog.setTaskId(taskId);
        operationLog.setCreateDate(date);
        operationLog.setType("withdraw");
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        operationLog.setOwnerId(userId);
        operationLog.setOwner(WfUtils.findUserName(userId));
        WfOperationLogUtil.recordOperationLog(commandContext, operationLog);
    }

    private Long getHitaskId(Long executionId2) {
        QFilter filter1 = new QFilter("processInstanceId", "=", (Object)this.proInstId);
        QFilter filter2 = new QFilter("activityType", "=", (Object)"UserTask");
        QFilter[] filters = new QFilter[]{filter1, filter2};
        EntityQueryBuilder queryBuilder = this.hisActivityManager.createQueryBuilder().addFilters(filters);
        queryBuilder.orderBy("step");
        List historicActivityInstanceList = this.hisActivityManager.findByQueryBuilder(queryBuilder);
        if (historicActivityInstanceList != null && !historicActivityInstanceList.isEmpty()) {
            return ((HistoricActivityInstanceEntity)historicActivityInstanceList.get(0)).getTaskId();
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u8be5\u4efb\u52a1\uff0c\u8bf7\u786e\u5b9a\u540e\u64a4\u56de", (String)"UpgradeWithdrawTaskCmd_81", (String)"bos-wf-engine", (Object[])new Object[0]));
    }

    private void recordNoCodeFlowEndEventLog(CommandContext commandContext, ExecutionEntity execution) {
        try {
            if (WfConfigurationUtil.isSupportStrongControl() && WfConfigurationUtil.isBillWithdrawJumpToUserNode()) {
                return;
            }
            if (this.proInst == null) {
                this.proInst = (ExecutionEntity)this.executionMgr.findById(this.proInstId);
            }
            if (this.proInst == null || !ModelType.NoCodeFlow.name().equals(this.proInst.getProcessType())) {
                return;
            }
            if (this.process == null) {
                this.process = ProcessDefinitionUtil.getProcess(this.proInst.getProcessDefinitionId(), this.proInstId);
            }
            if (this.process != null) {
                DetailLogEntityImpl detailLog = new DetailLogEntityImpl();
                detailLog.setProcInstId(execution.getProcessInstanceId());
                List<EndEvent> ends = this.process.findFlowElementsOfType(EndEvent.class);
                detailLog.setActivityId(ends.get(0).getId());
                commandContext.getDetailLogEntityManager().recordDetailLog(commandContext, detailLog);
            }
        }
        catch (Exception e) {
            logger.warn("UpgradeWithdrawTaskCmd.recordNoCodeFlowEndEventLog is error, errorInfo is : " + WfUtils.getExceptionStacktrace(e));
        }
    }
}

