/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task.withdraw.executor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.IWithdrawValidate;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.WithdrawContext;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.WithdrawResult;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.validate.WithdrawValidateRet;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.exception.WFErrorCode;

public abstract class AbstractWithdrawCmd
implements Command<Void> {
    protected static Log logger = LogFactory.getLog(AbstractWithdrawCmd.class);
    private boolean approved;
    private List<Long> subProcInstIds = new ArrayList<Long>();
    private boolean abandonProc;
    public WithdrawContext withdrawContext = new WithdrawContext();

    public void initData(CommandContext commandContext) {
    }

    @Override
    public Void execute(CommandContext commandContext) {
        try {
            logger.debug("\u6267\u884c\u6570\u636e\u521d\u59cb\u5316");
            this.initData(commandContext);
            this.withdrawContext.getDispatcher().dispatch("initData", this.withdrawContext, null);
            logger.debug("\u6267\u884c\u6821\u9a8c");
            List<IWithdrawValidate> validates = this.getValidate(commandContext);
            for (IWithdrawValidate validate : validates) {
                WithdrawValidateRet ret = validate.validate(commandContext);
                if (ret.isSuccess()) continue;
                throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{ret.getErrorInfo()});
            }
            this.withdrawContext.getDispatcher().dispatch("validate", this.withdrawContext, null);
            logger.debug("\u6267\u884c\u64a4\u56de");
            this.withdraw(commandContext);
            this.withdrawContext.getDispatcher().dispatch("withdrawOver", this.withdrawContext, null);
        }
        catch (Exception e) {
            logger.warn("AbstractWithdrawCmd \r\n" + WfUtils.getExceptionStacktrace(e));
            if (e instanceof KDException && ((KDException)((Object)e)).getErrorCode() != null) {
                throw e;
            }
            throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{e.getMessage()});
        }
        return null;
    }

    public List<IWithdrawValidate> getValidate(CommandContext commandContext) {
        return Collections.emptyList();
    }

    public WithdrawResult withdraw(CommandContext commandContext) {
        return null;
    }

    public void setAbandonProc(boolean abandonProc) {
        this.abandonProc = abandonProc;
    }

    public void setApproved(boolean approved) {
        this.approved = approved;
    }

    public void setSubProcInstIds(List<Long> subProcInstIds) {
        this.subProcInstIds = subProcInstIds;
    }

    public boolean isAbandonProc() {
        return this.abandonProc;
    }

    public boolean isApproved() {
        return this.approved;
    }

    public List<Long> getSubProcInstIds() {
        return this.subProcInstIds;
    }
}

