/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task.withdraw.executor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.IWithdrawValidate;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.WithdrawResult;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.executor.AbstractWithdrawCmd;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.op.AbandonWithdrawOp;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.op.AddressProcessWithdrawOp;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.op.BackPreTaskWithdrawOp;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.op.DeleteProcessWithdrawOp;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.op.SaveSubmitNodeWithdrawOp;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.validate.ContinueStateWithdrawValidator;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.HiUserActInstEntity;
import kd.bos.workflow.exception.WFErrorCode;

public class UnsubmitBillDealProcessCmd
extends AbstractWithdrawCmd {
    protected static Log logger = LogFactory.getLog(UnsubmitBillDealProcessCmd.class);
    public static final String PARAM_WITHDRAWTYPE = "withdrawType";
    public static final String PARAM_OPERATIONNAME = "operationName";
    public static final String WITHDRAWTYPE_ABANDON = "abandon";
    private String businesskey;
    private Map<String, Object> param;
    private HistoricProcessInstanceEntity historyProcInstance;

    public UnsubmitBillDealProcessCmd(String businesskey, Map<String, Object> param) {
        this.businesskey = businesskey;
        this.param = param;
    }

    @Override
    public void initData(CommandContext commandContext) {
        this.withdrawContext.setScene("billUnsubmit");
        List<HistoricProcessInstanceEntity> hiProcInsts = commandContext.getHistoricProcessInstanceEntityManager().findNotEndProcessesByBusinesskey(this.businesskey);
        for (HistoricProcessInstanceEntity i : hiProcInsts) {
            if (!ProcessType.AuditFlow.name().equals(i.getProcessType())) continue;
            this.historyProcInstance = i;
            break;
        }
        String withdrawType = (String)this.param.get(PARAM_WITHDRAWTYPE);
        this.withdrawContext.setWithdrawType(withdrawType);
        String operationName = (String)this.param.get(PARAM_OPERATIONNAME);
        this.withdrawContext.setOperationName(operationName);
    }

    @Override
    public List<IWithdrawValidate> getValidate(CommandContext commandContext) {
        ArrayList<IWithdrawValidate> validates = new ArrayList<IWithdrawValidate>();
        if (this.historyProcInstance != null) {
            FlowElement ele;
            boolean isSub;
            ExecutionEntity execution = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(this.historyProcInstance.getId());
            boolean bl = isSub = execution.getSuperExecution() != null && ProcessType.AuditFlow.name().equals(execution.getSuperExecution().getProcessType());
            if (isSub) {
                validates.add(new ContinueStateWithdrawValidator(execution.getSuperExecution()));
            }
            if ((ele = execution.getCurrentFlowElement()) != null && "CallActivity".equals(ele.getType())) {
                validates.add(new ContinueStateWithdrawValidator(execution, this.businesskey));
            } else {
                validates.add(new ContinueStateWithdrawValidator(execution));
            }
        }
        return validates;
    }

    @Override
    public WithdrawResult withdraw(CommandContext commandContext) {
        if (this.historyProcInstance == null) {
            new AddressProcessWithdrawOp(this.businesskey).withdraw(commandContext);
            return null;
        }
        Long superProcInstId = this.historyProcInstance.getSuperProcessInstanceId();
        boolean isSubProc = WfUtils.isNotEmpty(superProcInstId);
        if (isSubProc) {
            ExecutionEntity supExe = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(superProcInstId);
            isSubProc = ProcessType.AuditFlow.name().equals(supExe.getProcessType());
        }
        Long procInstId = this.historyProcInstance.getProcessInstanceId();
        logger.debug(String.format("\u6267\u884c%s\u7684\u64a4\u56de\uff0c\u5f53\u524d\u6d41\u7a0b\u5b9e\u4f8bId%s-\u7236\u6d41\u7a0b\u5b9e\u4f8bId", this.businesskey, procInstId, superProcInstId));
        this.doWithdraw(commandContext, procInstId, isSubProc, superProcInstId);
        if (isSubProc) {
            ExecutionEntity supExe = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(superProcInstId);
            if (ProcessType.AuditFlow.name().equals(supExe.getProcessType())) {
                logger.debug("\u6267\u884c\u7236\u6d41\u7a0b\u64a4\u56de\u3002");
                this.doWithdraw(commandContext, superProcInstId, false, null);
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doWithdraw(CommandContext commandContext, Long procInstId, boolean isSubProc, Long supProcId) {
        ExecutionEntity procInstance = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(procInstId);
        this.withdrawContext.setProcInst(procInstance);
        String withdrawType = (String)this.param.get(PARAM_WITHDRAWTYPE);
        if (WITHDRAWTYPE_ABANDON.equals(withdrawType)) {
            if (isSubProc) {
                logger.debug("\u5b50\u6d41\u7a0b\u7ec8\u6b62\u6709\u7236\u6d41\u7a0b\u89e6\u53d1\u3002");
                return;
            }
            logger.debug("\u6d41\u7a0b\u5df2\u5ba1\u6279\u3001\u6267\u884c\u7ec8\u6b62\u6d41\u7a0b\u3002");
            new AbandonWithdrawOp(procInstance, this.withdrawContext).withdraw(commandContext);
            return;
        }
        List<HiUserActInstEntity> userActInsts = commandContext.getHiUserActInstEntityManager().findCurrentUserActInsts(procInstId);
        logger.debug("\u5173\u952e\u4fe1\u606f\uff1a" + WfUtils.listToString(userActInsts, ","));
        boolean isApproved = false;
        for (HiUserActInstEntity userActInst : userActInsts) {
            if (userActInst.getLastUserNodeActId().contains("StartSignal")) continue;
            isApproved = true;
            break;
        }
        if (isApproved) {
            if (isSubProc) return;
            if (!WfConfigurationUtil.isAllowBillUnsubmitAfterUserNode()) throw new KDException(WFErrorCode.withdrawErrorWithMessage(), new Object[]{ResManager.loadKDString((String)"\u6d41\u7a0b\u5df2\u7ecf\u5ba1\u6279\uff0c\u4e0d\u80fd\u64a4\u56de\u3002", (String)"UnsubmitBillDealProcess_1", (String)"bos-wf-engine", (Object[])new Object[0])});
            ArrayList<Long> hiTaskActInstIds = new ArrayList<Long>();
            HistoricTaskInstanceEntity hiTask = this.getHistoricTask(commandContext, userActInsts, hiTaskActInstIds);
            logger.debug("\u6267\u884c\u9a73\u56de\u5230\u63d0\u4ea4\u8282\u70b9\u540e\u518d\u6b21\u63d0\u4ea4\u540e\u64a4\u56de\u3002\u627e\u6253\u5386\u53f2\u4efb\u52a1:" + hiTask.getId());
            ArrayList<HiUserActInstEntity> hiTaskUserActInsts = new ArrayList<HiUserActInstEntity>();
            for (HiUserActInstEntity userInst : userActInsts) {
                Long lastedNodeActInstId = userInst.getLastNodeActinstId();
                if (!hiTaskActInstIds.contains(lastedNodeActInstId)) continue;
                hiTaskUserActInsts.add(userInst);
            }
            logger.debug("\u5173\u952e\u4fe1\u606f\uff1a" + WfUtils.listToString(hiTaskUserActInsts, ","));
            new BackPreTaskWithdrawOp(procInstId, hiTask, hiTaskUserActInsts, this.withdrawContext).withdraw(commandContext);
            return;
        } else if (WfConfigurationUtil.isSupportStrongControl() && !isSubProc) {
            new SaveSubmitNodeWithdrawOp(procInstId, userActInsts, this.withdrawContext).withdraw(commandContext);
            return;
        } else {
            new DeleteProcessWithdrawOp(procInstId, this.businesskey, userActInsts, this.withdrawContext).withdraw(commandContext);
        }
    }

    private HistoricTaskInstanceEntity getHistoricTask(CommandContext commandContext, List<HiUserActInstEntity> userActInsts, List<Long> hiTaskActInstIds) {
        ArrayList<Long> lastedNodeActInstIds = new ArrayList<Long>();
        for (HiUserActInstEntity userInst : userActInsts) {
            Long lastedNodeActInstId = userInst.getLastNodeActinstId();
            if (lastedNodeActInstIds.contains(lastedNodeActInstId)) continue;
            lastedNodeActInstIds.add(lastedNodeActInstId);
        }
        QFilter idsFilter = new QFilter("id", "in", lastedNodeActInstIds);
        List actInsts = commandContext.getHistoricActivityInstanceEntityManager().findByQueryFilters(new QFilter[]{idsFilter});
        Long hiTaskId = null;
        for (HistoricActivityInstanceEntity actInst : actInsts) {
            String activityType = actInst.getActivityType();
            Long itemHiTaskId = actInst.getTaskId();
            if (WfUtils.isEmpty(itemHiTaskId)) continue;
            if ("UserTask".equals(activityType)) {
                hiTaskId = itemHiTaskId;
            }
            if (!itemHiTaskId.equals(hiTaskId)) continue;
            hiTaskActInstIds.add(actInst.getId());
        }
        if (WfUtils.isEmpty(hiTaskId)) {
            throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u63d0\u4ea4\u8282\u70b9\u4efb\u52a1\u3002", (String)"UnsubmitBillDealProcess_2", (String)"bos-wf-engine", (Object[])new Object[0])});
        }
        return (HistoricTaskInstanceEntity)commandContext.getHistoricTaskInstanceEntityManager().findById(hiTaskId);
    }
}

