/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task.withdraw.executor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.IWithdrawValidate;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.WithdrawResult;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.executor.AbstractWithdrawCmd;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.op.AbandonWithdrawOp;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.op.DeleteProcessWithdrawOp;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.op.SaveSubmitNodeWithdrawOp;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.validate.ContinueStateWithdrawValidator;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.validate.ExecutionWithdrawValidator;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.HiUserActInstEntity;
import kd.bos.workflow.exception.WFErrorCode;

public class WfWithdrawExecutionCmd
extends AbstractWithdrawCmd {
    private Long executionId;
    private Long userId;
    private ExecutionEntity procInst;
    private List<HiUserActInstEntity> userActInsts;

    public WfWithdrawExecutionCmd(Long executionId, Long userId) {
        this.executionId = executionId;
        this.userId = userId;
    }

    @Override
    public void initData(CommandContext commandContext) {
        super.initData(commandContext);
        this.withdrawContext.setScene("executionWithdraw");
        this.withdrawContext.setUserId(this.userId);
        ExecutionEntity execution = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(this.executionId);
        if (execution == null) {
            throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{ResManager.loadKDString((String)"\u5bf9\u5e94\u6d41\u7a0b\u6570\u636e\u88ab\u5220\u9664\uff0c\u6216\u6d41\u7a0b\u5df2\u7ed3\u675f\u3002", (String)"WfWithdrawExecutionCmd_1", (String)"bos-wf-engine", (Object[])new Object[0])});
        }
        Long procInstId = execution.getProcessInstanceId();
        this.procInst = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(procInstId);
        this.userActInsts = commandContext.getHiUserActInstEntityManager().findCurrentUserActInsts(procInstId);
        logger.debug(String.format("\u521d\u59cb\u5316\u6570\u636e%s-%s-%s", this.executionId, procInstId, WfUtils.listToString(this.userActInsts, ",")));
    }

    @Override
    public List<IWithdrawValidate> getValidate(CommandContext commandContext) {
        ArrayList<IWithdrawValidate> validates = new ArrayList<IWithdrawValidate>();
        validates.add(new ContinueStateWithdrawValidator(this.procInst));
        validates.add(new ExecutionWithdrawValidator(this.procInst, this.userActInsts, this));
        return validates;
    }

    @Override
    public WithdrawResult withdraw(CommandContext commandContext) {
        boolean isAbandon = this.isAbandonProc();
        List<Long> subProcInstIds = this.getSubProcInstIds();
        if (!subProcInstIds.isEmpty()) {
            List subProcInsts = commandContext.getExecutionEntityManager().findByQueryFilters(new QFilter[]{new QFilter("id", "in", subProcInstIds)});
            HashMap<Long, ArrayList<HiUserActInstEntity>> subProcHiUserActInsts = new HashMap<Long, ArrayList<HiUserActInstEntity>>(16);
            List allSubHiUserActInsts = commandContext.getHiUserActInstEntityManager().findByQueryFilters(new QFilter[]{new QFilter("proInstId", "in", subProcInstIds)});
            for (HiUserActInstEntity userActInst : allSubHiUserActInsts) {
                Long subProInstId = userActInst.getProinstId();
                ArrayList<HiUserActInstEntity> subUserActInsts = (ArrayList<HiUserActInstEntity>)subProcHiUserActInsts.get(subProInstId);
                if (subUserActInsts == null) {
                    subUserActInsts = new ArrayList<HiUserActInstEntity>(16);
                    subProcHiUserActInsts.put(subProInstId, subUserActInsts);
                }
                subUserActInsts.add(userActInst);
            }
            if (!isAbandon) {
                this.withdrawContext.setScene("billUnsubmit");
                for (ExecutionEntity subProcInst : subProcInsts) {
                    Long subProcInstId = subProcInst.getId();
                    new DeleteProcessWithdrawOp(subProcInstId, subProcInst.getBusinessKey(), (List)subProcHiUserActInsts.get(subProcInstId), this.withdrawContext).withdraw(commandContext);
                }
                this.withdrawContext.setScene("executionWithdraw");
            }
        }
        if (isAbandon) {
            new AbandonWithdrawOp(this.procInst, this.withdrawContext).withdraw(commandContext);
        } else {
            Long procInstId = this.procInst.getId();
            if (WfConfigurationUtil.isSupportStrongControl()) {
                new SaveSubmitNodeWithdrawOp(procInstId, this.userActInsts, this.withdrawContext).withdraw(commandContext);
            } else {
                new DeleteProcessWithdrawOp(procInstId, this.procInst.getBusinessKey(), this.userActInsts, this.withdrawContext).withdraw(commandContext);
            }
        }
        return null;
    }
}

