/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task.withdraw.executor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.IWithdrawValidate;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.WithdrawResult;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.executor.AbstractWithdrawCmd;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.op.BackPreTaskWithdrawOp;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.op.DeleteProcessWithdrawOp;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.op.SaveSubmitNodeWithdrawOp;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.validate.ContinueStateWithdrawValidator;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.validate.TaskWithdrawValidator;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.HiUserActInstEntity;

public class WfWithdrawTaskCmd
extends AbstractWithdrawCmd {
    private Long hiTaskId;
    private Long userId;
    private HistoricTaskInstanceEntity hiTask;
    private ExecutionEntity procInst;
    private List<HiUserActInstEntity> userActInsts;

    public WfWithdrawTaskCmd(Long hiTaskId, Long userId) {
        this.hiTaskId = hiTaskId;
        this.userId = userId;
    }

    @Override
    public void initData(CommandContext commandContext) {
        super.initData(commandContext);
        this.withdrawContext.setScene("hiTaskWithdraw");
        if (WfUtils.isNotEmpty(this.userId)) {
            this.withdrawContext.setUserId(this.userId);
        }
        this.hiTask = (HistoricTaskInstanceEntity)commandContext.getHistoricTaskInstanceEntityManager().findById(this.hiTaskId);
        if (this.hiTask != null) {
            this.procInst = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(this.hiTask.getProcessInstanceId());
            Long procInstId = this.hiTask.getProcessInstanceId();
            List<Object> hiTaskInsts = new ArrayList<HistoricActivityInstanceEntity>();
            HistoricActivityInstanceEntity hiTaskInst = commandContext.getHistoricActivityInstanceEntityManager().findActivityByTaskId(this.hiTaskId);
            if (WfUtils.isEmpty(hiTaskInst.getJoinFlag())) {
                hiTaskInsts.add(hiTaskInst);
            } else {
                hiTaskInsts = commandContext.getHistoricActivityInstanceEntityManager().findByProInstIdAndJoinFlag(procInstId, hiTaskInst.getJoinFlag(), 0L);
            }
            ArrayList<Long> hiTaskActInstIds = new ArrayList<Long>(16);
            for (HistoricActivityInstanceEntity historicActivityInstanceEntity : hiTaskInsts) {
                hiTaskActInstIds.add(historicActivityInstanceEntity.getId());
            }
            this.userActInsts = commandContext.getHiUserActInstEntityManager().findByProcAndLastNodeActInstIds(procInstId, hiTaskActInstIds);
            this.withdrawContext.setProcInst(this.procInst);
            this.withdrawContext.setHiTask(this.hiTask);
        }
    }

    @Override
    public WithdrawResult withdraw(CommandContext commandContext) {
        List<Long> subProcInstIds = this.getSubProcInstIds();
        if (!subProcInstIds.isEmpty()) {
            List subProcInsts = commandContext.getExecutionEntityManager().findByQueryFilters(new QFilter[]{new QFilter("id", "in", subProcInstIds)});
            HashMap<Long, ArrayList<HiUserActInstEntity>> subProcHiUserActInsts = new HashMap<Long, ArrayList<HiUserActInstEntity>>(16);
            List allSubHiUserActInsts = commandContext.getHiUserActInstEntityManager().findByQueryFilters(new QFilter[]{new QFilter("proInstId", "in", subProcInstIds)});
            for (HiUserActInstEntity userActInst : allSubHiUserActInsts) {
                Long subProInstId = userActInst.getProinstId();
                ArrayList<HiUserActInstEntity> subUserActInsts = (ArrayList<HiUserActInstEntity>)subProcHiUserActInsts.get(subProInstId);
                if (subUserActInsts == null) {
                    subUserActInsts = new ArrayList<HiUserActInstEntity>(16);
                    subProcHiUserActInsts.put(subProInstId, subUserActInsts);
                }
                subUserActInsts.add(userActInst);
            }
            this.withdrawContext.setScene("billUnsubmit");
            for (ExecutionEntity subProcInst : subProcInsts) {
                Long subProcInstId = subProcInst.getId();
                new DeleteProcessWithdrawOp(subProcInstId, subProcInst.getBusinessKey(), (List)subProcHiUserActInsts.get(subProcInstId), this.withdrawContext).withdraw(commandContext);
            }
            this.withdrawContext.setScene("hiTaskWithdraw");
        }
        Long procInstId = this.procInst.getId();
        if (this.isApproved()) {
            new BackPreTaskWithdrawOp(procInstId, this.hiTask, this.userActInsts, this.withdrawContext).withdraw(commandContext);
        } else if (WfConfigurationUtil.isSupportStrongControl()) {
            new SaveSubmitNodeWithdrawOp(procInstId, this.userActInsts, this.withdrawContext).withdraw(commandContext);
        } else {
            new DeleteProcessWithdrawOp(procInstId, this.procInst.getBusinessKey(), this.userActInsts, this.withdrawContext).withdraw(commandContext);
        }
        return null;
    }

    @Override
    public List<IWithdrawValidate> getValidate(CommandContext commandContext) {
        ArrayList<IWithdrawValidate> validates = new ArrayList<IWithdrawValidate>();
        validates.add(new ContinueStateWithdrawValidator(this.procInst));
        validates.add(new TaskWithdrawValidator(this.hiTask, this.procInst, this.userActInsts, this));
        return validates;
    }
}

