/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task.withdraw.listener;

import java.util.Date;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.job.EventTriggerCmd;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.IWithdrawListener;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.WithdrawContext;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.DefaultCommandContextCloseListener;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.WfOperationLogUtil;
import kd.bos.workflow.engine.task.TaskEventTypeEnum;

public class WithdrawEndListener
implements IWithdrawListener {
    @Override
    public void onEvent(final WithdrawContext withdrawContext, Object ... args) {
        CommandContext commandContext = Context.getCommandContext();
        this.triggerEvent(withdrawContext, commandContext);
        HistoricTaskInstanceEntity hiTask = withdrawContext.getHiTask();
        if (hiTask != null) {
            this.saveOperationLog(commandContext, hiTask.getId(), withdrawContext);
        }
        commandContext.addCloseListener(new DefaultCommandContextCloseListener(WithdrawEndListener.class.getName()){

            @Override
            public void closed(CommandContext commandContext) {
                super.closed(commandContext);
                WfUtils.addOpLog("wf_task", "withdraw", new MultiLangEnumBridge("\u64a4\u56de", "WithdrawEndListener_1", "bos-wf-engine"), null, withdrawContext.getOperationLog().toString());
            }
        });
    }

    private void triggerEvent(WithdrawContext withdrawContext, CommandContext commandContext) {
        ExecutionEntity procInst = withdrawContext.getProcInst();
        if (procInst == null) {
            return;
        }
        HashMap<String, Object> eventMap = new HashMap<String, Object>(16);
        String scene = withdrawContext.getScene();
        eventMap.put("billNo", procInst.getBillNo());
        eventMap.put("entityNum", procInst.getEntityNumber());
        eventMap.put("busKey", procInst.getBusinessKey());
        eventMap.put("processInstanceId", procInst.getId());
        eventMap.put("userId", RequestContext.get().getCurrUserId());
        switch (scene) {
            case "billUnsubmit": {
                eventMap.put("withdrawType", "withdrawByBusinessId");
                break;
            }
            case "executionWithdraw": {
                eventMap.put("withdrawType", "withdrawByProcessInstanceId");
                break;
            }
            case "hiTaskWithdraw": {
                eventMap.put("withdrawType", "withdrawByTaskId");
                eventMap.put("hisTaskId", withdrawContext.getHiTask().getId());
                eventMap.put("userId", withdrawContext.getHiTask().getAssignee());
            }
        }
        new EventTriggerCmd(TaskEventTypeEnum.TASK_WITHDRAE_EVENT.getCode(), SerializationUtils.toJsonString(eventMap)).execute(commandContext);
    }

    private void saveOperationLog(CommandContext commandContext, Long taskId, WithdrawContext withdrawContext) {
        OperationLogEntityImpl operationLog = new OperationLogEntityImpl();
        Date date = commandContext.getProcessEngineConfiguration().getClock().getCurrentTime();
        operationLog.setTaskId(taskId);
        operationLog.setCreateDate(date);
        operationLog.setType("withdraw");
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        if (WfUtils.isNotEmpty(withdrawContext.getUserId())) {
            userId = withdrawContext.getUserId();
        }
        operationLog.setOwnerId(userId);
        operationLog.setOwner(WfUtils.findUserName(userId));
        WfOperationLogUtil.recordOperationLog(commandContext, operationLog);
    }
}

