/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task.withdraw.listener;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpmn.listener.MessageChannelProcessListener;
import kd.bos.workflow.engine.impl.cmd.management.delegatesetting.ResumeDelegateTasksCmd;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.IWithdrawListener;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.WithdrawContext;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.AuditPointInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.AuditPointInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricVariableInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.TaskHelper;
import kd.bos.workflow.engine.task.TaskDelegateUtil;
import kd.bos.workflow.engine.task.auditpoint.AuditPointCheckResult;

public class WithdrawRecoverListener
implements IWithdrawListener {
    protected static Log logger = LogFactory.getLog(WithdrawRecoverListener.class);

    @Override
    public void onEvent(WithdrawContext withdrawContext, Object ... args) {
        if (withdrawContext.getProcInst() == null) {
            return;
        }
        CommandContext commandContext = Context.getCommandContext();
        HistoricTaskInstanceEntity hiTask = withdrawContext.getHiTask();
        ExecutionEntity procInstance = withdrawContext.getProcInst();
        if (hiTask != null) {
            Long hiTaskId = hiTask.getId();
            String historicTaskActId = hiTask.getTaskDefinitionKey();
            ExecutionEntity execution = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(hiTask.getExecutionId());
            this.recoverDynParticipant(historicTaskActId, commandContext, execution);
            AuditPointInstanceEntityManager auditPointInstanceEntityManager = commandContext.getAuditPointInstanceEntityManager();
            List<AuditPointInstanceEntity> auditPointInstances = auditPointInstanceEntityManager.findAuditPointInstancesByTaskId(hiTaskId);
            if (CollectionUtil.isNotEmpty(auditPointInstances)) {
                for (AuditPointInstanceEntity auditPointInstance : auditPointInstances) {
                    if ("automaticchecks".equals(auditPointInstance.getType())) continue;
                    auditPointInstance.setFailedReason((ILocaleString)new LocaleString());
                    auditPointInstance.setCheckResult(AuditPointCheckResult.UNCONFIRMED.getNumber());
                    auditPointInstanceEntityManager.update(auditPointInstance);
                }
            }
            QFilter varProcFilter = new QFilter("processInstanceId", "=", (Object)procInstance.getId());
            List rejectInnerVars = commandContext.getHistoricVariableInstanceEntityManager().findByQueryFilters(new QFilter[]{varProcFilter, new QFilter("name", "=", (Object)String.format("%s_%s", historicTaskActId, "rejectToForkInnerAndSkip"))});
            if (rejectInnerVars != null && !rejectInnerVars.isEmpty()) {
                procInstance.setVariable(String.format("%s_%s", historicTaskActId, "rejectToForkInnerAndSkip"), ((HistoricVariableInstanceEntity)rejectInnerVars.get(0)).getValue());
            }
            if (TaskHelper.isComposedTask(hiTaskId)) {
                TaskHelper.clearIdentityCompositeTaskId(hiTaskId);
            }
            new ResumeDelegateTasksCmd(hiTaskId).execute(commandContext);
            Object isDelegate = execution.getTransientVariable("isDelegate");
            if (isDelegate == null || !Boolean.TRUE.equals(execution.getTransientVariable("isDelegate"))) {
                TaskDelegateUtil.recoverTaskDelegate(commandContext, hiTaskId, Boolean.TRUE, "recoverTask");
            }
            execution.removeTransientVariable("isDelegate");
        }
        if ("deleteProcess".equals(withdrawContext.getWithdrawType())) {
            this.executeMessageChannelProcIntStateListener(procInstance);
        }
    }

    private void recoverDynParticipant(String activityId, CommandContext commandContext, ExecutionEntity executeExe) {
        String participantVarKey = activityId + "currentParticipant";
        String currentParticipant = (String)executeExe.getVariable(participantVarKey);
        if (currentParticipant != null) {
            Map instanceParticipant = (Map)SerializationUtils.fromJsonString((String)currentParticipant, Map.class);
            String dynamicParticipant = (String)instanceParticipant.get(activityId);
            if (dynamicParticipant != null) {
                executeExe.setVariable("dynParticipant", dynamicParticipant);
            } else {
                executeExe.removeVariable("dynParticipant");
            }
        } else {
            executeExe.removeVariable("dynParticipant");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeMessageChannelProcIntStateListener(ExecutionEntity procInstance) {
        String eventName = procInstance.getEventName();
        try {
            procInstance.setEventName("terminate");
            logger.debug("MessageChannelProcessListener enter");
            new MessageChannelProcessListener().notify(procInstance);
        }
        catch (Exception e) {
            logger.info("MessageChannelProcessListener is error : " + WfUtils.getExceptionStacktrace(e));
        }
        finally {
            procInstance.setEventName(eventName);
        }
    }
}

