/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task.withdraw.op;

import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.impl.cmd.management.AbandonProcessCmd;
import kd.bos.workflow.engine.impl.cmd.management.BillWithdrawJumpToUserNodeCmd;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.IWithdrawOp;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.WithdrawContext;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.WithdrawResult;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;

public class AbandonWithdrawOp
implements IWithdrawOp {
    protected static Log logger = LogFactory.getLog(AbandonWithdrawOp.class);
    private ExecutionEntity procInstance;
    private WithdrawContext withdrawContext;

    public AbandonWithdrawOp(ExecutionEntity procInstance, WithdrawContext withdrawContext) {
        this.procInstance = procInstance;
        this.withdrawContext = withdrawContext;
    }

    @Override
    public WithdrawResult withdraw(CommandContext commandContext) {
        this.withdrawContext.setProcInst(this.procInstance);
        this.withdrawContext.setWithdrawType("abandonProcess");
        StringBuilder operationLog = this.withdrawContext.getOperationLog();
        operationLog.append(String.format(ResManager.loadKDString((String)"\u5355\u636e\u3010%s\u3011", (String)"UnsubmitBillDealProcess_4", (String)"bos-wf-engine", (Object[])new Object[0]), this.procInstance.getBillNo()));
        Long procInstId = this.procInstance.getProcessInstanceId();
        Process process = ProcessDefinitionUtil.getProcess(this.procInstance.getProcessDefinitionId(), procInstId);
        if (StringUtils.isNotEmpty((CharSequence)this.withdrawContext.getOperationName())) {
            String operationName = this.withdrawContext.getOperationName();
            this.procInstance.setVariableLocal("exceptionEvent", operationName);
        }
        commandContext.getProcessEngineConfiguration().getListenerNotificationHelper().executeExecutionListeners(process, this.procInstance, "withdraw_audited_proc");
        if (WfConfigurationUtil.isSupportStrongControl() && WfConfigurationUtil.isBillWithdrawJumpToUserNode() && this.procInstance.getSuperExecution() == null) {
            logger.debug("procInstId:" + procInstId + "BillWithdrawJumpToUserNodeC");
            new BillWithdrawJumpToUserNodeCmd(procInstId, false).execute(commandContext);
        } else {
            LocaleString cause = ResManager.getLocaleString((String)"\u6574\u5355\u64a4\u56de\u7ec8\u6b62\u6d41\u7a0b", (String)"UpgradeWithdrawTaskCmd_115", (String)"bos-wf-engine");
            new AbandonProcessCmd(procInstId, (ILocaleString)cause, "billAbort").execute(commandContext);
            logger.debug("procInstId:" + procInstId + "AbandonProcessCmd");
            this.procInstance.setActive(false);
            commandContext.getExecutionEntityManager().update(this.procInstance);
        }
        operationLog.append(ResManager.loadKDString((String)"\u6574\u5355\u64a4\u56de\u6210\u529f", (String)"AbandonWithdrawOp_0", (String)"bos-wf-engine", (Object[])new Object[0]));
        return null;
    }
}

