/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task.withdraw.op;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.bpmn.model.AutoTask;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.IWithdrawOp;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.WithdrawContext;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.DefaultCommandContextCloseListener;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.HiUserActInstEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.PathJson;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.AutoTaskUtil;
import kd.bos.workflow.engine.impl.util.DynamicObjectJsonSerializer;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.msg.MessageTypeEnum;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.msg.info.MessageInfo;

public abstract class AbstractReveserWithdrawOp
implements IWithdrawOp {
    protected static Log logger = LogFactory.getLog(AbstractReveserWithdrawOp.class);
    protected List<Long> taskIds = new ArrayList<Long>();
    protected Map<String, Long> yzjMultiExecutions = new HashMap<String, Long>(16);
    protected WithdrawContext withdrawContext;

    public void reverseExecuteMessageAndListeners(CommandContext commandContext, List<HiUserActInstEntity> userActInsts, ExecutionEntity procInstance) {
        StringBuilder operationLog = this.withdrawContext.getOperationLog();
        if ("backPreNode".equals(this.withdrawContext.getWithdrawType())) {
            operationLog.append(String.format(ResManager.loadKDString((String)"\u5355\u636e\u4efb\u52a1\u3010%s\u3011", (String)"UnsubmitBillDealProcess_6", (String)"bos-wf-engine", (Object[])new Object[0]), procInstance.getBillNo()));
        } else {
            operationLog.append(String.format(ResManager.loadKDString((String)"\u5355\u636e\u3010%s\u3011", (String)"UnsubmitBillDealProcess_4", (String)"bos-wf-engine", (Object[])new Object[0]), procInstance.getBillNo()));
        }
        Long procInstId = procInstance.getProcessInstanceId();
        List<ExecutionEntity> childrenExecutions = commandContext.getExecutionEntityManager().findChildExecutionsByProcessInstanceId(procInstId);
        HashMap<Long, ExecutionEntity> executionMap = new HashMap<Long, ExecutionEntity>(16);
        for (ExecutionEntity e : childrenExecutions) {
            executionMap.put(e.getId(), e);
        }
        List<HistoricActivityInstanceEntity> allActInsts = commandContext.getHistoricActivityInstanceEntityManager().findByProcessInstanceId(procInstId);
        ArrayList<Long> currentNodeActInstIds = new ArrayList<Long>(16);
        ArrayList<Long> autoActInstIds = new ArrayList<Long>(16);
        this.collectCurrentAndAutoActInsts(userActInsts, currentNodeActInstIds, autoActInstIds, allActInsts);
        StringBuilder currentNodeNames = new StringBuilder();
        StringBuilder autoNodeNames = new StringBuilder();
        HashSet<Long> executeListenerParentTasks = new HashSet<Long>();
        for (int i = allActInsts.size() - 1; i >= 0; --i) {
            HistoricActivityInstanceEntity actinst = allActInsts.get(i);
            Long actInstId = actinst.getId();
            if (currentNodeActInstIds.contains(actInstId)) {
                this.executeReverse(commandContext, actinst, executionMap, currentNodeNames, executeListenerParentTasks, true, i, allActInsts);
                continue;
            }
            if (!autoActInstIds.contains(actInstId)) continue;
            this.executeReverse(commandContext, actinst, executionMap, autoNodeNames, executeListenerParentTasks, false, i, allActInsts);
        }
        this.reverseCurrentActInst(commandContext, executionMap);
        this.reverseAutoActInst(commandContext, executionMap);
        operationLog.append(String.format(ResManager.loadKDString((String)"\u64a4\u56de\u6210\u529f\uff0c\u5f53\u524d\u8282\u70b9\uff1a%1$s\u7ecf\u8fc7\u8282\u70b9\uff1a%2$s", (String)"UnsubmitBillDealProcess_5", (String)"bos-wf-engine", (Object[])new Object[0]), currentNodeNames, autoNodeNames));
    }

    protected void collectCurrentAndAutoActInsts(List<HiUserActInstEntity> userActInsts, List<Long> currentNodeActInstIds, List<Long> autoActInstIds, List<HistoricActivityInstanceEntity> allActInsts) {
        for (HiUserActInstEntity userInst : userActInsts) {
            String pathJsonStr;
            this.collectCurrentActInsts(userInst, currentNodeActInstIds);
            Long curActInstId = userInst.getCurrentActinstId();
            if (!currentNodeActInstIds.contains(curActInstId)) {
                currentNodeActInstIds.add(curActInstId);
            }
            if (!WfUtils.isNotEmpty(pathJsonStr = userInst.getPathJson())) continue;
            List pathJsons = SerializationUtils.fromJsonStringToList((String)pathJsonStr, PathJson.class);
            for (PathJson pathJson : pathJsons) {
                this.collectAutoActInsts(pathJson, autoActInstIds);
                Long autoActInstId = pathJson.getActInstId();
                if (autoActInstIds.contains(autoActInstId)) continue;
                autoActInstIds.add(autoActInstId);
            }
        }
        this.recoverCollectedCurrentAndAutoActInsts(userActInsts, currentNodeActInstIds, autoActInstIds, allActInsts);
        this.withdrawContext.getDispatcher().dispatch("collectData", this.withdrawContext, userActInsts, currentNodeActInstIds, autoActInstIds, allActInsts);
    }

    public void collectCurrentActInsts(HiUserActInstEntity userInst, List<Long> currentNodeActInstIds) {
        if (userInst.getCurrentActId().contains("YunzhijiaTask")) {
            this.yzjMultiExecutions.put(userInst.getCurrentActId(), userInst.getExecutionId());
        }
    }

    public void collectAutoActInsts(PathJson pathJson, List<Long> autoActInstIds) {
        if (pathJson.getNodeId().contains("YunzhijiaTask")) {
            this.yzjMultiExecutions.put(pathJson.getNodeId(), pathJson.getExecutionId());
        }
    }

    public void recoverCollectedCurrentAndAutoActInsts(List<HiUserActInstEntity> userActInsts, List<Long> currentNodeActInstIds, List<Long> autoActInstIds, List<HistoricActivityInstanceEntity> allActInsts) {
        if (!this.yzjMultiExecutions.isEmpty()) {
            HashMap recoverActinsts = new HashMap();
            HashMap<Long, Long> yzjActParentMappers = new HashMap<Long, Long>();
            for (HistoricActivityInstanceEntity historicActivityInstanceEntity : allActInsts) {
                Long parentTaskId = historicActivityInstanceEntity.getParentTaskId();
                if (!WfUtils.isNotEmpty(parentTaskId)) continue;
                Long actInstId = historicActivityInstanceEntity.getId();
                yzjActParentMappers.put(actInstId, parentTaskId);
                ArrayList<Long> ids = (ArrayList<Long>)recoverActinsts.get(parentTaskId);
                if (ids == null) {
                    ids = new ArrayList<Long>();
                    recoverActinsts.put(parentTaskId, ids);
                }
                if (ids.contains(actInstId)) continue;
                ids.add(actInstId);
            }
            ArrayList tmpCurrentActInstIds = new ArrayList();
            for (Long id : currentNodeActInstIds) {
                Long parentTaskId = (Long)yzjActParentMappers.get(id);
                List actInstIds = (List)recoverActinsts.get(parentTaskId);
                if (actInstIds == null) continue;
                tmpCurrentActInstIds.addAll(actInstIds);
            }
            for (Long id : tmpCurrentActInstIds) {
                if (currentNodeActInstIds.contains(id)) continue;
                currentNodeActInstIds.add(id);
            }
            ArrayList arrayList = new ArrayList();
            for (Long id : autoActInstIds) {
                Long parentTaskId = (Long)yzjActParentMappers.get(id);
                List actInstIds = (List)recoverActinsts.get(parentTaskId);
                if (actInstIds == null) continue;
                arrayList.addAll(actInstIds);
            }
            for (Long id : arrayList) {
                if (autoActInstIds.contains(id)) continue;
                autoActInstIds.add(id);
            }
        }
    }

    public void executeReverse(CommandContext commandContext, HistoricActivityInstanceEntity actinst, Map<Long, ExecutionEntity> executionMap, StringBuilder activityNames, Set<Long> executeListenerParentTasks, boolean isCurrent, int i, List<HistoricActivityInstanceEntity> allActInsts) {
        Long actInstId = actinst.getId();
        String activityId = actinst.getActivityId();
        ILocaleString activityName = actinst.getActivityName();
        activityNames.append(activityName).append('\uff0c');
        ExecutionEntity executeExe = executionMap.get(actinst.getExecutionId());
        Long parentTaskId = actinst.getParentTaskId();
        logger.debug(activityId + "-" + parentTaskId);
        if (WfUtils.isNotEmpty(parentTaskId) && "YunzhijiaTask".equals(actinst.getActivityType())) {
            executeExe = executionMap.get(this.yzjMultiExecutions.get(activityId));
        } else if (executeExe == null && "CallActivity".equals(actinst.getActivityType()) && i < allActInsts.size() - 1) {
            executeExe = executionMap.get(allActInsts.get(i + 1).getExecutionId());
        }
        if (executeExe != null && (WfUtils.isEmpty(parentTaskId) || executeListenerParentTasks.add(parentTaskId))) {
            this.executeWithdrawExecutionListeners(commandContext, executeExe, "start", activityId, actInstId);
            if (!isCurrent) {
                this.executeWithdrawExecutionListeners(commandContext, executeExe, "end", activityId, actInstId);
            }
        }
        if (isCurrent) {
            this.reverseCurrentActInstIter(commandContext, actinst, executionMap);
        } else {
            this.reverseAutoActInstIter(commandContext, actinst, executionMap);
        }
    }

    public void reverseCurrentActInstIter(CommandContext commandContext, HistoricActivityInstanceEntity actinst, Map<Long, ExecutionEntity> executionMap) {
        Long taskId = actinst.getTaskId();
        if (WfUtils.isNotEmpty(taskId)) {
            this.taskIds.add(taskId);
        }
    }

    public void reverseAutoActInstIter(CommandContext commandContext, HistoricActivityInstanceEntity actinst, Map<Long, ExecutionEntity> executionMap) {
        if ("AutoTask".equals(actinst.getActivityType())) {
            String activityId = actinst.getActivityId();
            AutoTask autoTask = (AutoTask)ProcessDefinitionUtil.getFlowElement(actinst.getProcessDefinitionId(), actinst.getProcessInstanceId(), activityId);
            if (autoTask != null) {
                ExecutionEntity executeExe = executionMap.get(actinst.getExecutionId());
                Long curActInstId = executeExe.getCurrentActInstId();
                String curActivityId = executeExe.getActivityId();
                TaskEntity curTask = executeExe.getCurrentTask();
                FlowElement ele = executeExe.getCurrentFlowElement();
                executeExe.setCurrentActInstId(actinst.getId());
                executeExe.setCurrentTask(null);
                executeExe.setActivityId(activityId);
                executeExe.setCurrentFlowElement(autoTask);
                AutoTaskUtil.executeExternalInterface(autoTask, executeExe, true);
                executeExe.setCurrentFlowElement(ele);
                executeExe.setCurrentActInstId(curActInstId);
                executeExe.setCurrentTask(curTask);
                executeExe.setActivityId(curActivityId);
            }
        }
    }

    public void reverseCurrentActInst(CommandContext commandContext, Map<Long, ExecutionEntity> executionMap) {
        logger.debug(String.format("\u64a4\u56de\u4efb\u52a1%s\u7684\u6d88\u606f\u3002", WfUtils.listToString(this.taskIds, ",")));
        if (!this.taskIds.isEmpty()) {
            List<IdentityLinkEntity> identityLinks = commandContext.getIdentityLinkEntityManager().findIdentityLinksByTaskIds(this.taskIds.toArray(new Long[0]));
            HashMap userIdsMap = new HashMap();
            for (IdentityLinkEntity identityLinkEntity : identityLinks) {
                Long uid;
                Long taskId = identityLinkEntity.getTaskId();
                ArrayList<Long> uids = (ArrayList<Long>)userIdsMap.get(taskId);
                if (uids == null) {
                    uids = new ArrayList<Long>();
                    userIdsMap.put(taskId, uids);
                }
                if (uids.contains(uid = identityLinkEntity.getUserId())) continue;
                uids.add(uid);
            }
            for (Map.Entry entry : userIdsMap.entrySet()) {
                commandContext.getMessageService().deleteToDo((Long)entry.getKey(), (List)entry.getValue());
            }
            this.sendWithdrawMsg(commandContext, this.taskIds);
        }
    }

    public void reverseAutoActInst(CommandContext commandContext, Map<Long, ExecutionEntity> executionMap) {
    }

    public void executeWithdrawExecutionListeners(CommandContext commandContext, ExecutionEntity execution, String eventType, String flowNodeId, Long actInstId) {
        logger.debug(String.format("executeWithdrawExecutionListeners- %s - %s - %s - %s", execution.getId(), flowNodeId, eventType, actInstId));
        Process process = ProcessDefinitionUtil.getProcess(execution.getProcessDefinitionId(), execution.getProcessInstanceId());
        FlowNode flowNode = (FlowNode)process.getFlowElement(flowNodeId);
        String operationName = "";
        if ("billUnsubmit".equals(this.withdrawContext.getScene())) {
            operationName = StringUtils.isNotEmpty((CharSequence)this.withdrawContext.getOperationName()) ? this.withdrawContext.getOperationName() : "unsubmit";
        }
        commandContext.getProcessEngineConfiguration().getListenerNotificationHelper().executeWithdrawExecutionListeners(flowNode, execution, eventType, operationName, actInstId);
    }

    public void sendWithdrawMsg(CommandContext commandContext, List<Long> taskIds) {
        List<Long> userIds;
        Long taskId;
        List<TaskEntity> tasks = commandContext.getTaskEntityManager().findByTaskIds(taskIds);
        List<IdentityLinkEntity> identityLinks = commandContext.getIdentityLinkEntityManager().findIdentityLinksByTaskIds(taskIds.toArray(new Long[0]));
        HashMap<Long, ArrayList<Long>> taskMapUserIds = new HashMap<Long, ArrayList<Long>>();
        for (IdentityLinkEntity i : identityLinks) {
            taskId = i.getTaskId();
            userIds = (ArrayList<Long>)taskMapUserIds.get(taskId);
            if (userIds == null) {
                userIds = new ArrayList<Long>();
                taskMapUserIds.put(taskId, (ArrayList<Long>)userIds);
            }
            userIds.add(i.getUserId());
        }
        if (WfConfigurationUtil.needWithdrawMsg() && !tasks.isEmpty()) {
            for (TaskEntity task : tasks) {
                taskId = task.getId();
                userIds = (List)taskMapUserIds.get(taskId);
                if (userIds == null || userIds.isEmpty()) continue;
                this.sendWithdrawMsgImmediately(commandContext, task, userIds);
            }
        }
    }

    public void sendWithdrawMsgImmediately(CommandContext commandContext, TaskEntity task, List<Long> userIds) {
        logger.debug(String.format("sendWithdrawMsgImmediately - %s - %s", task.getId(), WfUtils.listToString(userIds, ",")));
        ILocaleString billName = task.getEntityName();
        ILocaleString nodeName = task.getName();
        LocaleString titleValue = ResManager.getLocaleString((String)"\u8282\u70b9%1$s\u7684\u5f85\u529e\u4efb\u52a1%2$s[%3$s]\u88ab\u64a4\u56de\u3002", (String)"UpgradeWithdrawTaskCmd_120", (String)"bos-wf-engine");
        ILocaleString title = WfMultiLangUtils.getMultiLangValue(new ILocaleString[]{titleValue, nodeName, billName, new LocaleString(task.getBillNo())});
        MessageContext ctx = MessageServiceUtil.buildMessageContext(task.getId());
        final MessageInfo info = new MessageInfo();
        info.setNotifyType(MessageServiceUtil.getNotifyTypeByNode("message"));
        info.setMessageTitle(title);
        info.setMessageContent(title);
        info.setUserIds(userIds);
        info.setBizDataId(task.getId());
        info.setEntityNumber("wf_task");
        info.setPubaccNumber("flowassist");
        TaskEntity taskEntity = (TaskEntity)commandContext.getTaskEntityManager().findById(task.getId());
        info.getParams().put("bizEntityObject", DynamicObjectJsonSerializer.convertDynamicObjectToJson(taskEntity.getDynamicObject()));
        info.setTplScene(MessageTypeEnum.WITHDRAW.getNumber());
        info.setMessageTag(WfUtils.getPromptWordLocaleString("\u5de5\u4f5c\u6d41", "MessageScheduleHelper_1", "bos-wf-engine"));
        boolean showUrlInWFSmsMessgae = WfConfigurationUtil.isShowUrlInWFSmsMessgae();
        info.getParams().put("showurlinwfsms", showUrlInWFSmsMessgae);
        commandContext.addCloseListener(new DefaultCommandContextCloseListener(""){

            @Override
            public void closed(CommandContext commandContext) {
                MessageCenterServiceHelper.sendMessage((MessageInfo)info);
            }
        });
        logger.debug(String.format("sendWithdrawMessge task[%s],bk[%s]", ctx.getTaskId(), ctx.getBusinessKey()));
    }
}

