/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task.withdraw.op;

import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.IWithdrawOp;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.WithdrawResult;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.job.DeadLetterJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.TimerJobEntity;

public class AddressProcessWithdrawOp
implements IWithdrawOp {
    protected static Log logger = LogFactory.getLog(AddressProcessWithdrawOp.class);
    private String businesskey;

    public AddressProcessWithdrawOp(String businesskey) {
        this.businesskey = businesskey;
    }

    @Override
    public WithdrawResult withdraw(CommandContext commandContext) {
        List deadLetterJob = commandContext.getDeadLetterJobEntityManager().findByQueryFilters(new QFilter[]{new QFilter("businessKey", "=", (Object)this.businesskey), new QFilter("jobHandlerType", "=", (Object)"address-process-event")});
        if (deadLetterJob.isEmpty()) {
            List<TimerJobEntity> timerJob = commandContext.getTimerJobEntityManager().findJobsByBusinessKey(this.businesskey, "id,businesskey,entitynumber,jobhandlertype");
            for (TimerJobEntity tJob : timerJob) {
                String handlerType = tJob.getJobHandlerType();
                if (!"address-process-event".equals(handlerType)) continue;
                commandContext.getTimerJobEntityManager().delete(tJob.getId());
                String entityNumber = tJob.getEntityNumber();
                WfCacheHelper.removeExecutingJobGYEntityOfCurrentBusiness(this.businesskey, entityNumber);
                WfCacheHelper.removeWithdrawTimerOrDeadJobRootId(entityNumber, new String[]{String.valueOf(tJob.getId())});
            }
            logger.debug(this.businesskey + "\u6267\u884c\u5bfb\u5740\u64a4\u56de\u3001\u5220\u9664timerjob\u8868\u6570\u636e\u548c\u7f13\u5b58");
        } else {
            String entityNumber = ((DeadLetterJobEntity)deadLetterJob.get(0)).getEntityNumber();
            for (DeadLetterJobEntity job : deadLetterJob) {
                commandContext.getDeadLetterJobEntityManager().delete(job);
                WfCacheHelper.removeWithdrawTimerOrDeadJobRootId(entityNumber, new String[]{String.valueOf(job.getId())});
            }
            WfCacheHelper.removeExecutingJobGYEntityOfCurrentBusiness(this.businesskey, entityNumber);
            logger.debug(this.businesskey + "\u6267\u884c\u5bfb\u5740\u64a4\u56de\u3001\u5220\u9664deadletterjob\u8868\u6570\u636e\u548c\u7f13\u5b58");
        }
        return null;
    }
}

