/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task.withdraw.op;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.Activity;
import kd.bos.workflow.bpmn.model.BoundaryEvent;
import kd.bos.workflow.bpmn.model.CancelEventDefinition;
import kd.bos.workflow.bpmn.model.CompensateEventDefinition;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.domain.model.NodeForkJoinModel;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.event.ActivitiEventDispatcher;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.impl.agenda.ForkJoinUtils;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.WithdrawContext;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.WithdrawResult;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.op.AbstractReveserWithdrawOp;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.op.Node;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.delegate.ActivityBehavior;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricVariableInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricVariableInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.DynamicResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.DynamicResourceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.HiUserActInstEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.HiUserActInstEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.PathJson;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.VariableInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.DynamicProcessDefinitionHelper;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.TaskHelper;

public class BackPreTaskWithdrawOp
extends AbstractReveserWithdrawOp {
    protected Map<String, Integer> nodesDeleteNoOfArrived = new HashMap<String, Integer>(16);
    protected Map<String, Long> firstExeIds = new HashMap<String, Long>(16);
    protected List<Long> allActInstIds = new ArrayList<Long>(16);
    protected List<Long> allFlowActInstIds = new ArrayList<Long>(16);
    protected List<Long> allHiuserInstIds = new ArrayList<Long>(16);
    protected List<Long> allUsedExecutionIds = new ArrayList<Long>(16);
    protected Set<String> curActivityIds = new HashSet<String>(16);
    protected Set<String> autoActivityIds = new LinkedHashSet<String>(16);
    protected static final String STARTSIGNAL = "StartSignal";
    private Long procInstId;
    private HistoricTaskInstanceEntity hiTask;
    private List<HiUserActInstEntity> userActInsts;
    private ExecutionEntity procInstance;

    public BackPreTaskWithdrawOp(Long procInstId, HistoricTaskInstanceEntity hiTask, List<HiUserActInstEntity> userActInsts, WithdrawContext withdrawContext) {
        this.procInstId = procInstId;
        this.hiTask = hiTask;
        this.userActInsts = userActInsts;
        this.withdrawContext = withdrawContext;
    }

    @Override
    public WithdrawResult withdraw(CommandContext commandContext) {
        this.procInstance = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(this.procInstId);
        this.withdrawContext.setProcInst(this.procInstance);
        this.withdrawContext.setHiTask(this.hiTask);
        this.withdrawContext.setWithdrawType("backPreNode");
        this.reverseExecuteMessageAndListeners(commandContext, this.userActInsts, this.procInstance);
        this.withdrawContext.getDispatcher().dispatch("deleteCurrent", this.withdrawContext, this.userActInsts, this.taskIds, this.allActInstIds);
        this.recoverProcHiTask(commandContext, this.procInstance, this.hiTask, this.procInstId);
        this.withdrawContext.getDispatcher().dispatch("recoverHistory", this.withdrawContext, new Object[0]);
        return null;
    }

    @Override
    public void collectCurrentActInsts(HiUserActInstEntity userInst, List<Long> actInstIds) {
        super.collectCurrentActInsts(userInst, actInstIds);
        Long currentActInstId = userInst.getCurrentActinstId();
        String joinFlag = userInst.getJoinFlag();
        if (WfUtils.isNotEmpty(joinFlag) && !actInstIds.contains(currentActInstId) && ForkJoinUtils.getFirstEnterJoinExecution(joinFlag, this.procInstance) != null) {
            int deleteNoOfArrivedCount = this.nodesDeleteNoOfArrived.get(joinFlag) == null ? 1 : this.nodesDeleteNoOfArrived.get(joinFlag) + 1;
            this.nodesDeleteNoOfArrived.put(joinFlag, deleteNoOfArrivedCount);
        }
        this.allHiuserInstIds.add(userInst.getId());
        this.curActivityIds.add(userInst.getCurrentActId());
    }

    @Override
    public void collectAutoActInsts(PathJson pathJson, List<Long> autoActInstIds) {
        super.collectAutoActInsts(pathJson, autoActInstIds);
        String joinFlag = pathJson.getJoinFlag();
        if (WfUtils.isNotEmpty(joinFlag) && !autoActInstIds.contains(pathJson.getActInstId()) && ForkJoinUtils.getFirstEnterJoinExecution(joinFlag, this.procInstance) != null) {
            int deleteNoOfArrivedCount = this.nodesDeleteNoOfArrived.get(joinFlag) == null ? 1 : this.nodesDeleteNoOfArrived.get(joinFlag) + 1;
            this.nodesDeleteNoOfArrived.put(joinFlag, deleteNoOfArrivedCount);
            this.firstExeIds.putIfAbsent(joinFlag, (Long)ForkJoinUtils.getFirstEnterJoinExecution(joinFlag, this.procInstance));
        }
        this.autoActivityIds.add(pathJson.getNodeId());
    }

    @Override
    public void reverseCurrentActInstIter(CommandContext commandContext, HistoricActivityInstanceEntity actinst, Map<Long, ExecutionEntity> executionMap) {
        super.reverseCurrentActInstIter(commandContext, actinst, executionMap);
        this.collectedUsedIds(commandContext, actinst, executionMap);
        if ("YunzhijiaTask".equals(actinst.getActivityType())) {
            Long parentExeId = (Long)this.yzjMultiExecutions.get(actinst.getActivityId());
            ExecutionEntity multiExe = executionMap.get(parentExeId);
            if (multiExe.isMultiInstanceRoot()) {
                if (!this.taskIds.contains(multiExe.getCurrentTaskId())) {
                    this.taskIds.add(multiExe.getCurrentTaskId());
                }
                multiExe.setMultiInstanceRoot(false);
                multiExe.setActive(true);
                multiExe.removeVariable("loopCounter");
                multiExe.removeVariable("nrOfCompletedInstances");
                multiExe.removeVariable("nrOfInstances");
                multiExe.removeVariable("nrOfActiveInstances");
                commandContext.getExecutionEntityManager().update(multiExe);
                logger.debug(String.format("\u6062\u590d\u6267\u884cmulti\u5b9e\u4f8b%s\u4e3a\u6267\u884c\u5b9e\u4f8b\uff0c\u5e76\u5220\u9664\u5b50\u5b9e\u4f8b%s, \u5e76\u5220\u9664\u4f1a\u5ba1\u53d8\u91cf", multiExe, actinst.getExecutionId()));
            }
            commandContext.getExecutionEntityManager().delete(actinst.getExecutionId());
        }
    }

    @Override
    public void reverseAutoActInstIter(CommandContext commandContext, HistoricActivityInstanceEntity actinst, Map<Long, ExecutionEntity> executionMap) {
        super.reverseAutoActInstIter(commandContext, actinst, executionMap);
        this.collectedUsedIds(commandContext, actinst, executionMap);
        Long taskId = actinst.getTaskId();
        if (WfUtils.isNotEmpty(taskId)) {
            this.taskIds.add(taskId);
        }
    }

    private void collectedUsedIds(CommandContext commandContext, HistoricActivityInstanceEntity actinst, Map<Long, ExecutionEntity> executionMap) {
        this.allActInstIds.add(actinst.getId());
        this.allFlowActInstIds.add(actinst.getSourceElementId());
        this.allUsedExecutionIds.add(actinst.getExecutionId());
        if ("YunzhijiaTask".equals(actinst.getActivityType())) {
            Long parentExeId = (Long)this.yzjMultiExecutions.get(actinst.getActivityId());
            this.allUsedExecutionIds.add(parentExeId);
        }
    }

    @Override
    public void reverseCurrentActInst(CommandContext commandContext, Map<Long, ExecutionEntity> executionMap) {
        super.reverseCurrentActInst(commandContext, executionMap);
        this.deleteData(commandContext, executionMap);
    }

    private void deleteData(CommandContext commandContext, Map<Long, ExecutionEntity> executionMap) {
        this.deleteTask(commandContext, executionMap);
        this.deleteDynResourceAndActInst(commandContext);
        HiUserActInstEntityManager hiUserActInstMgr = commandContext.getHiUserActInstEntityManager();
        for (Long id : this.allHiuserInstIds) {
            hiUserActInstMgr.delete(id);
        }
        logger.debug("\u5220\u9664hiuser:" + WfUtils.listToString(this.allHiuserInstIds, "\uff0c"));
        this.deleteExecutions(commandContext, executionMap);
        this.backJoinVarsAndActinst(commandContext, executionMap);
    }

    private void deleteTask(CommandContext commandContext, Map<Long, ExecutionEntity> executionMap) {
        if (!this.taskIds.isEmpty()) {
            List<TaskEntity> tasks = commandContext.getTaskEntityManager().findByTaskIds(this.taskIds);
            if (!tasks.isEmpty()) {
                Process process = ProcessDefinitionUtil.getProcess(tasks.get(0).getProcessDefinitionId(), tasks.get(0).getProcessInstanceId());
                for (TaskEntity task : tasks) {
                    this.cleanupExecutions(process.getFlowElement(task.getTaskDefinitionKey()), executionMap.get(task.getExecutionId()), commandContext);
                }
            }
            TaskHelper taskHelper = commandContext.getTaskHelper();
            CommentEntityManager commentMgr = commandContext.getCommentEntityManager();
            HistoricIdentityLinkEntityManager historicIdentityLinkMgr = commandContext.getHistoricIdentityLinkEntityManager();
            HistoricVariableInstanceEntityManager historicVariableMgr = commandContext.getHistoricVariableInstanceEntityManager();
            logger.debug("delete task \u3001hitask \u3001identityLink\u3001comment\u3001variable\u3001" + WfUtils.listToString(this.taskIds, ","));
            for (Long taskId : this.taskIds) {
                taskHelper.deleteTask(taskId, "task withdraw", true);
                historicIdentityLinkMgr.deleteHistoricIdentityLinksByTaskId(taskId);
                commentMgr.deleteCommentsByTaskId(taskId);
                historicVariableMgr.deleteHistoricVariableInstancesByTaskId(taskId);
            }
        }
    }

    private void deleteDynResourceAndActInst(CommandContext commandContext) {
        HistoricActivityInstanceEntityManager activityInstanceMgr = commandContext.getHistoricActivityInstanceEntityManager();
        if (!this.allFlowActInstIds.isEmpty()) {
            DynamicResourceEntityManager dynamicResourceEntityManager = commandContext.getDynamicResourceEntityManager();
            List<DynamicResourceEntity> dynamicResources = dynamicResourceEntityManager.findByProcessInstanceId(this.procInstance.getProcessInstanceId());
            DynamicProcessDefinitionHelper dynProcessHelper = commandContext.getProcessEngineConfiguration().getDynamicProcessDefinitionHelper();
            if (dynamicResources != null && !dynamicResources.isEmpty()) {
                for (DynamicResourceEntity d : dynamicResources) {
                    if (!this.allFlowActInstIds.contains(d.getActivityInstanceId())) continue;
                    logger.debug("delete dynResource " + d + "-" + d.getActivityInstanceId());
                    dynamicResourceEntityManager.delete(d);
                    dynProcessHelper.deleteSequenceFlow(d.getProcessDefineId(), d.getProcessInstanceId(), d, "task withdraw");
                }
            }
            for (Long id : this.allFlowActInstIds) {
                activityInstanceMgr.delete(id);
            }
            logger.debug("\u5220\u9664\u6d3b\u52a8\u5b9e\u4f8b\uff1a" + WfUtils.listToString(this.allFlowActInstIds, ","));
        }
        if (!this.allActInstIds.isEmpty()) {
            for (Long id : this.allActInstIds) {
                activityInstanceMgr.delete(id);
            }
            logger.debug("\u5220\u9664\u6d3b\u52a8\u5b9e\u4f8b\uff1a" + WfUtils.listToString(this.allActInstIds, ","));
        }
    }

    private void deleteExecutions(CommandContext commandContext, Map<Long, ExecutionEntity> executionMap) {
        QFilter exeQfilter = new QFilter("executionId", "in", this.allUsedExecutionIds);
        QFilter proQfilter = new QFilter("processInstanceId", "=", (Object)this.procInstance.getProcessInstanceId());
        HashSet<Long> usedActInstIds = new HashSet<Long>(this.allActInstIds);
        usedActInstIds.addAll(this.allFlowActInstIds);
        QFilter idQfilter = new QFilter("id", "not in", usedActInstIds);
        List hasUsedExeIdActInsts = commandContext.getHistoricActivityInstanceEntityManager().findByQueryFilters(new QFilter[]{proQfilter, idQfilter, exeQfilter});
        HashSet<Long> usedExecutionIds = new HashSet<Long>(16);
        for (HistoricActivityInstanceEntity i : hasUsedExeIdActInsts) {
            usedExecutionIds.add(i.getExecutionId());
        }
        ExecutionEntityManager executionMgr = commandContext.getExecutionEntityManager();
        for (Long exeId : this.allUsedExecutionIds) {
            ExecutionEntity exe;
            if (usedExecutionIds.contains(exeId) || (exe = executionMap.get(exeId)) == null) continue;
            executionMgr.deleteExecutionAndRelatedData(exe, "task withdraw", true);
        }
    }

    protected void cleanupExecutions(FlowElement currentFlowElement, ExecutionEntity execution, CommandContext commandContext) {
        Activity activity;
        if (currentFlowElement instanceof Activity && CollectionUtil.isNotEmpty((activity = (Activity)currentFlowElement).getBoundaryEvents())) {
            ArrayList<String> notToDeleteEvents = new ArrayList<String>();
            for (BoundaryEvent event : activity.getBoundaryEvents()) {
                if (!CollectionUtil.isNotEmpty(event.getEventDefinitions()) || !(event.getEventDefinitions().get(0) instanceof CancelEventDefinition)) continue;
                notToDeleteEvents.add(event.getId());
            }
            logger.debug("\u6536\u96c6\u7684events\uff1a" + WfUtils.listToString(notToDeleteEvents, ""));
            List<ExecutionEntity> childExecutions = commandContext.getExecutionEntityManager().findChildExecutionsByParentExecutionId(execution.getId());
            for (ExecutionEntity childExecution : childExecutions) {
                if (childExecution.getCurrentFlowElement() != null && notToDeleteEvents.contains(childExecution.getCurrentFlowElement().getId())) continue;
                logger.debug(String.format("delete Execution %s", childExecution));
                commandContext.getExecutionEntityManager().deleteExecutionAndRelatedData(childExecution, null, false);
            }
        }
    }

    private void backJoinVarsAndActinst(CommandContext commandContext, Map<Long, ExecutionEntity> executionMap) {
        HistoricActivityInstanceEntityManager activityInstanceMgr = commandContext.getHistoricActivityInstanceEntityManager();
        if (this.nodesDeleteNoOfArrived.isEmpty()) {
            return;
        }
        logger.debug(WfUtils.mapToString(this.nodesDeleteNoOfArrived));
        for (Map.Entry<String, Integer> entry : this.nodesDeleteNoOfArrived.entrySet()) {
            String joinFlag = entry.getKey();
            int noOfArrived = (Integer)ForkJoinUtils.getNoOfArrived(joinFlag, this.procInstance);
            if ((noOfArrived -= entry.getValue().intValue()) < 1) {
                ForkJoinUtils.removeNoOfArrived(joinFlag, this.procInstance);
                ForkJoinUtils.removeFirstEnterJoinExecution(joinFlag, this.procInstance);
                logger.debug(String.format("\u5220\u9664\u6c47\u805a\u6570\u76ee\uff1a" + joinFlag, new Object[0]));
                continue;
            }
            ForkJoinUtils.setNoOfArrived(joinFlag, this.procInstance, noOfArrived);
            logger.debug(String.format("\u6062\u590d\u6c47\u805a\u6570\u76ee\uff1a" + joinFlag + noOfArrived, new Object[0]));
        }
        QFilter procFilter = new QFilter("processInstanceId", "=", (Object)this.procInstId);
        QFilter flagFilter = new QFilter("joinFlag", "in", this.nodesDeleteNoOfArrived.keySet());
        QFilter idsFilter = new QFilter("id", "not in", this.allActInstIds);
        QFilter endFilter = new QFilter("endTime", "is not null", null);
        List actInstNeedSetEndTimeNull = activityInstanceMgr.findByQueryFilters(new QFilter[]{procFilter, idsFilter, flagFilter, endFilter});
        for (HistoricActivityInstanceEntity actInst : actInstNeedSetEndTimeNull) {
            actInst.setTaskId(null);
            actInst.setEndTime(null);
            actInst.setDurationInMillis(0L);
            actInst.setTargetElementId(0L);
            actInst.setAssigneeId(0L);
            ExecutionEntity execution = executionMap.get(actInst.getExecutionId());
            execution.setCurrentActInstId(actInst.getId());
            execution.setActivityId(actInst.getActivityId());
            execution.setActivityName(actInst.getActivityName());
            commandContext.getExecutionEntityManager().update(execution);
            activityInstanceMgr.update(actInst);
        }
        logger.debug("\u6062\u590d\u6c47\u805a\u8282\u70b9\u6d3b\u52a8\u5b9e\u4f8b\uff1a" + WfUtils.listToString(actInstNeedSetEndTimeNull, ","));
    }

    @Override
    protected void collectCurrentAndAutoActInsts(List<HiUserActInstEntity> userActInsts, List<Long> currentNodeActInstIds, List<Long> autoActInstIds, List<HistoricActivityInstanceEntity> allActInsts) {
        super.collectCurrentAndAutoActInsts(userActInsts, currentNodeActInstIds, autoActInstIds, allActInsts);
    }

    @Override
    public void reverseAutoActInst(CommandContext commandContext, Map<Long, ExecutionEntity> executionMap) {
        this.backAutoJoinNodeUserActInst(commandContext);
    }

    private void backAutoJoinNodeUserActInst(CommandContext commandContext) {
        if (this.firstExeIds.isEmpty()) {
            return;
        }
        QFilter currentExeFilter = new QFilter("currentExecutionId", "in", this.firstExeIds.values());
        QFilter proInstFilter = new QFilter("proInstId", "=", (Object)this.procInstance.getProcessInstanceId());
        QFilter endTimeFilter = new QFilter("endTime", "is null", null);
        QFilter notIdFilter = new QFilter("id", "not in", this.allHiuserInstIds);
        HiUserActInstEntityManager userActInstMgr = commandContext.getHiUserActInstEntityManager();
        List needUpdCurExeIds = userActInstMgr.findByQueryFilters(new QFilter[]{proInstFilter, currentExeFilter, endTimeFilter, notIdFilter});
        logger.debug("\u6062\u590dpatchJson\uff1a" + WfUtils.listToString(needUpdCurExeIds, ","));
        for (HiUserActInstEntity userInst : needUpdCurExeIds) {
            String pjStr = userInst.getPathJson();
            if (pjStr.isEmpty()) continue;
            List pathJsons = SerializationUtils.fromJsonStringToList((String)pjStr, PathJson.class);
            int index = 0;
            boolean needSubPj = false;
            for (PathJson p : pathJsons) {
                ++index;
                if (!WfUtils.isNotEmpty(p.getJoinFlag()) || !this.firstExeIds.containsKey(p.getJoinFlag())) continue;
                userInst.setCurrentActId(p.getNodeId());
                userInst.setCurrentActinstId(p.getActInstId());
                userInst.setCurrentExecutionId(p.getExecutionId());
                needSubPj = true;
                break;
            }
            if (!needSubPj) continue;
            String pjson = "";
            if (index > 1) {
                pjson = SerializationUtils.toJsonString(pathJsons.subList(0, index - 1));
            }
            userInst.setPathJson(pjson);
            userActInstMgr.update(userInst);
        }
        logger.debug("\u6062\u590dpatchJson\uff1a" + WfUtils.listToString(needUpdCurExeIds, ","));
    }

    private void recoverProcHiTask(CommandContext commandContext, ExecutionEntity procInstance, HistoricTaskInstanceEntity hiTask, Long procInstId) {
        if (hiTask == null) {
            return;
        }
        this.withdrawContext.getOperationLog().append(ResManager.loadKDString((String)"\u6062\u590d\u4efb\u52a1\uff1a", (String)"BackPreTaskWithdrawOp_0", (String)"bos-wf-engine", (Object[])new Object[0])).append(hiTask.getName());
        String historicTaskActId = hiTask.getTaskDefinitionKey();
        Long recoverExeId = hiTask.getExecutionId();
        Long hiTaskId = hiTask.getId();
        logger.debug(String.format("\u6062\u590d\u4efb\u52a1%s-%s-%s", historicTaskActId, hiTaskId, recoverExeId));
        this.dealRejectKeyAndNoOfShould(commandContext);
        Long proInstId = hiTask.getProcessInstanceId();
        HistoricActivityInstanceEntity hiTaskActInst = this.recoverHistoricActinst(commandContext, hiTask, proInstId);
        ExecutionEntity recoverExe = this.recoverExecution(commandContext, hiTask, proInstId, hiTaskActInst);
        Long hiTaskActInstId = hiTaskActInst.getId();
        this.executeWithdrawExecutionListeners(commandContext, recoverExe, "end", historicTaskActId, hiTaskActInstId);
        this.recoverTask(commandContext, hiTask, recoverExeId, hiTaskId, recoverExe);
        List<HiUserActInstEntity> recoverUserActInsts = this.recoverUserActInsts(commandContext, procInstId, hiTaskActInst);
        if (!recoverUserActInsts.isEmpty()) {
            this.recoverVars(commandContext, procInstance, hiTaskActInst, recoverExe, hiTaskId, recoverUserActInsts.get(0).getLastUserNodeActId());
        }
    }

    private void dealRejectKeyAndNoOfShould(CommandContext commandContext) {
        Node lastNode = this.linedNode();
        Process process = ProcessDefinitionUtil.getProcess(this.procInstance.getProcessDefinitionId(), this.procInstance.getProcessInstanceId());
        Map<String, NodeForkJoinModel> models = process.getForkJoinModels();
        HashMap<String, List<String>> forkNodeDealInfo = new HashMap<String, List<String>>();
        HashMap<String, Integer> throughCycle = new HashMap<String, Integer>();
        LinkedList<Node> line = new LinkedList<Node>();
        HashSet<Node> usedNodes = new HashSet<Node>();
        line.add(lastNode);
        usedNodes.add(lastNode);
        int i = 0;
        while (!line.isEmpty()) {
            String nextStruct;
            if (++i >= 30) {
                logger.warn("\u8fd9\u91cc\u4e0d\u6b63\u5e38\uff0c\u81ea\u52a8\u8282\u70b9\u8d85\u8fc720\u4e2a\uff01");
                break;
            }
            Node node = (Node)line.pop();
            List<Node> nextNodes = node.getNextNodes();
            if (nextNodes.isEmpty()) continue;
            boolean addNextNode = false;
            for (Node n : nextNodes) {
                if (!usedNodes.add(n)) continue;
                addNextNode = true;
                line.add(n);
            }
            if (nextNodes.size() > 1) {
                this.addForkDealInfo(forkNodeDealInfo, node.getId(), "resetJoinRejectKeyOrRemoveforkVar");
                String forkId = node.getId();
                Integer cycle = (Integer)throughCycle.get(forkId);
                if (cycle == null) {
                    throughCycle.put(forkId, 1);
                    continue;
                }
                Integer n = cycle;
                Integer n2 = cycle = Integer.valueOf(cycle + 1);
                throughCycle.put(forkId, cycle);
                continue;
            }
            Node nextNode = nextNodes.get(0);
            NodeForkJoinModel model = models.get(node.getId());
            NodeForkJoinModel nextModel = models.get(nextNode.getId());
            if (model == null || nextModel == null) {
                return;
            }
            String struct = model.getForkStructure();
            if (struct.equals(nextStruct = nextModel.getForkStructure())) {
                if (!model.isJoinNode()) continue;
                this.addForkDealInfo(forkNodeDealInfo, model.getPairForkNodeId(), "removeJoinRejectKey");
                continue;
            }
            if (struct.contains(nextStruct)) {
                if (!model.getLatestJoinNode().equals(nextNode.getId())) {
                    this.addForkDealInfo(forkNodeDealInfo, model.getLatestForkNode(), "removeRejectKey");
                    if (!model.isJoinNode()) continue;
                    this.addForkDealInfo(forkNodeDealInfo, model.getPairForkNodeId(), "removeJoinRejectKey");
                    continue;
                }
                if (!addNextNode) continue;
                String forkId = model.getLatestForkNode();
                Integer cycle = (Integer)throughCycle.get(forkId);
                if (cycle == null) {
                    throughCycle.put(forkId, 1);
                    continue;
                }
                Integer n = cycle;
                Integer n3 = cycle = Integer.valueOf(cycle + 1);
                throughCycle.put(forkId, cycle);
                continue;
            }
            this.addForkDealInfo(forkNodeDealInfo, node.getId(), "resetRejectKey");
        }
        this.opForkVar(commandContext, process, forkNodeDealInfo, throughCycle, models);
    }

    private void addForkDealInfo(Map<String, List<String>> forkNodeDealInfo, String forkId, String dealInfo) {
        List<String> infos = forkNodeDealInfo.get(forkId);
        if (infos == null) {
            infos = new ArrayList<String>();
            forkNodeDealInfo.put(forkId, infos);
        }
        infos.add(dealInfo);
    }

    private void opForkVar(CommandContext commandContext, Process process, Map<String, List<String>> forkNodeDealInfo, Map<String, Integer> throughCycle, Map<String, NodeForkJoinModel> models) {
        for (Map.Entry<String, List<String>> entry : forkNodeDealInfo.entrySet()) {
            String forkId = entry.getKey();
            FlowNode forkNode = (FlowNode)process.getFlowElement(forkId);
            if ("all".equals(forkNode.getPassTypeAfterInnerReject())) {
                this.deleteForkNoofShould(forkId, process);
                continue;
            }
            List<String> ops = entry.getValue();
            int count = 0;
            block13: for (int i = ops.size() - 1; i > -1; --i) {
                String op;
                switch (op = ops.get(i)) {
                    case "removeRejectKey": {
                        --count;
                        continue block13;
                    }
                    case "resetRejectKey": {
                        ++count;
                        continue block13;
                    }
                    case "removeJoinRejectKey": {
                        int curCycle = ForkJoinUtils.getEnterForkCycle(forkId, this.procInstance);
                        String joinRejectKey = ForkJoinUtils.getJoinNodeRejectKey(forkId, curCycle, this.procInstance);
                        if (!WfUtils.isNotEmpty(joinRejectKey) || !joinRejectKey.startsWith("JOIN_")) continue block13;
                        ForkJoinUtils.removeJoinNodeRejectKey(forkId, curCycle, this.procInstance, true);
                        count = 2;
                        continue block13;
                    }
                    case "resetJoinRejectKeyOrRemoveforkVar": {
                        if (this.recoverRejectKey(forkId, commandContext, true)) {
                            count = 2;
                            continue block13;
                        }
                        this.deleteForkNoofShould(forkId, process);
                    }
                }
            }
            int cycle = ForkJoinUtils.getEnterForkCycle(forkId, this.procInstance);
            if (count < 0) {
                ForkJoinUtils.removeJoinNodeRejectKey(forkId, ForkJoinUtils.getEnterForkCycle(forkId, this.procInstance), this.procInstance, true);
                continue;
            }
            Integer tmpCycle = throughCycle.get(forkId);
            tmpCycle = tmpCycle != null ? Integer.valueOf(tmpCycle / 2) : Integer.valueOf(-1);
            if (cycle > tmpCycle && cycle != 1) {
                String joinFlag;
                int noOfShouldSurvive;
                int beforeCycle = cycle - tmpCycle;
                QFilter procFilter = new QFilter("processInstanceId", "=", (Object)this.procInstance.getProcessInstanceId());
                String key = String.format("%s_%s_%s", ForkJoinUtils.getNumber(forkId, this.procInstance), beforeCycle, "forkRejectKey");
                QFilter keyFilter = new QFilter("name", "=", (Object)key);
                HistoricVariableInstanceEntityManager historicVariableManager = commandContext.getHistoricVariableInstanceEntityManager();
                List vars = historicVariableManager.findByQueryFilters(new QFilter[]{procFilter, keyFilter}, historicVariableManager.getSelectFields(), "createdate desc");
                if (vars == null || vars.isEmpty() || WfUtils.isEmptyString(((HistoricVariableInstanceEntity)vars.get(0)).getValue())) continue;
                String beforeRejectKey = (String)((HistoricVariableInstanceEntity)vars.get(0)).getValue();
                String rejectKey = ForkJoinUtils.getJoinNodeRejectKey(forkId, cycle, this.procInstance);
                if ((count != 0 || !WfUtils.isNotEmpty(rejectKey)) && count <= 0) continue;
                ForkJoinUtils.removeJoinNodeRejectKey(forkId, cycle, this.procInstance, true);
                ForkJoinUtils.setJoinNodeRejectKey(forkId, beforeCycle, this.procInstance, beforeRejectKey);
                ForkJoinUtils.setEnterForkCycle(forkId, this.procInstance, beforeCycle);
                if (models.get(forkId) == null || (noOfShouldSurvive = ((Integer)ForkJoinUtils.getNoOfShouldSurvive(joinFlag = forkId + "$" + beforeCycle + "$" + models.get(forkId).getPairJoinNodeId(), this.procInstance)).intValue()) <= 1) continue;
                ForkJoinUtils.setNoOfArrived(joinFlag, this.procInstance, noOfShouldSurvive - 1);
                continue;
            }
            if (count == 0) continue;
            this.recoverRejectKey(forkId, commandContext, false);
        }
    }

    private Node linedNode() {
        LinkedHashMap<String, Node> nodes = new LinkedHashMap<String, Node>();
        Node lastNode = null;
        for (HiUserActInstEntity userAct : this.userActInsts) {
            String lastNodeId = userAct.getLastUserNodeActId();
            Long lastActInstId = userAct.getLastNodeActinstId();
            lastNode = (Node)nodes.get(String.valueOf(lastActInstId));
            if (lastNode == null) {
                lastNode = new Node(lastNodeId);
                nodes.put(String.valueOf(lastActInstId), lastNode);
            }
            Node preNode = lastNode;
            String pathJsonStr = userAct.getPathJson();
            if (WfUtils.isNotEmpty(pathJsonStr)) {
                List pathJsons = SerializationUtils.fromJsonStringToList((String)pathJsonStr, PathJson.class);
                for (PathJson pathJson : pathJsons) {
                    String nodeId = pathJson.getNodeId();
                    String key = WfUtils.isNotEmpty(pathJson.getJoinFlag()) ? pathJson.getJoinFlag() : String.valueOf(pathJson.getActInstId());
                    Node node = (Node)nodes.get(key);
                    if (node == null) {
                        node = new Node(nodeId);
                        nodes.put(key, node);
                    }
                    preNode.addNextNode(node);
                    preNode = node;
                }
            }
            String curNodeId = userAct.getCurrentActId();
            String key = WfUtils.isNotEmpty(userAct.getJoinFlag()) ? userAct.getJoinFlag() : String.valueOf(userAct.getCurrentActinstId());
            Node curNode = (Node)nodes.get(key);
            if (curNode == null) {
                curNode = new Node(curNodeId);
                nodes.put(key, curNode);
            }
            preNode.addNextNode(curNode);
        }
        try {
            logger.debug(WfUtils.mapToString(nodes));
        }
        catch (Exception e) {
            logger.debug(WfUtils.getExceptionStacktrace(e));
        }
        return lastNode;
    }

    public boolean recoverRejectKey(String forkId, CommandContext commandContext, boolean isJoin) {
        int cycle = ForkJoinUtils.getEnterForkCycle(forkId, this.procInstance);
        QFilter procFilter = new QFilter("processInstanceId", "=", (Object)this.procInstance.getProcessInstanceId());
        String key = String.format("%s_%s_%s", ForkJoinUtils.getNumber(forkId, this.procInstance), cycle, "forkRejectKey");
        QFilter keyFilter = new QFilter("name", "=", (Object)key);
        HistoricVariableInstanceEntityManager historicVariableManager = commandContext.getHistoricVariableInstanceEntityManager();
        List var = historicVariableManager.findByQueryFilters(new QFilter[]{procFilter, keyFilter}, historicVariableManager.getSelectFields(), "createdate desc");
        if (!var.isEmpty() && WfUtils.isNotEmptyString(((HistoricVariableInstanceEntity)var.get(0)).getValue())) {
            String rejectKey = (String)((HistoricVariableInstanceEntity)var.get(0)).getValue();
            if (!isJoin || rejectKey.startsWith("JOIN_")) {
                ForkJoinUtils.setJoinNodeRejectKey(forkId, cycle, this.procInstance, rejectKey);
                logger.debug(forkId + "JoinNodeRejectKey\u5df2\u6062\u590d\uff1a" + rejectKey);
                return true;
            }
        }
        return false;
    }

    private void deleteForkNoofShould(String pathNodeId, Process process) {
        int cycle = ForkJoinUtils.getEnterForkCycle(pathNodeId, this.procInstance);
        String joinFlag = pathNodeId + "$" + cycle + "$" + process.getForkJoinModels().get(pathNodeId).getPairJoinNodeId();
        logger.debug("\u5220\u9664\u5230\u8fbe\u6570\u91cf" + joinFlag);
        ForkJoinUtils.removeNoOfShouldSurvive(joinFlag, this.procInstance);
    }

    private List<HiUserActInstEntity> recoverUserActInsts(CommandContext commandContext, Long procInstId, HistoricActivityInstanceEntity hiTaskActInst) {
        Long hiTaskActInstId = hiTaskActInst.getId();
        QFilter userProcF = new QFilter("proInstId", "=", (Object)procInstId);
        QFilter curActInstF = new QFilter("currentActInstId", "=", (Object)hiTaskActInstId);
        if (WfUtils.isNotEmpty(hiTaskActInst.getJoinFlag())) {
            curActInstF = new QFilter("joinFlag", "=", (Object)hiTaskActInst.getJoinFlag());
        }
        HiUserActInstEntityManager hiUserActInstMgr = commandContext.getHiUserActInstEntityManager();
        List<HiUserActInstEntity> recoverUserActInsts = hiUserActInstMgr.findByQueryFilters(new QFilter[]{userProcF, curActInstF});
        for (HiUserActInstEntity i : recoverUserActInsts) {
            i.setEndTime(null);
            hiUserActInstMgr.update(i);
        }
        logger.debug("\u6062\u590dhiuser%s" + WfUtils.listToString(recoverUserActInsts, ","));
        return recoverUserActInsts;
    }

    private void recoverTask(CommandContext commandContext, HistoricTaskInstanceEntity hiTask, Long recoverExeId, Long hiTaskId, ExecutionEntity recoverExe) {
        logger.debug("\u6062\u590d\u4efb\u52a1 :" + hiTask);
        hiTask.setEndTime(null);
        hiTask.setDurationInMillis(0L);
        hiTask.setRealDurationInMillis(0L);
        hiTask.setHandleState("willApproval");
        hiTask.setExecutionType("byHand");
        TaskEntity task = commandContext.getTaskEntityManager().recoverTask(hiTask);
        recoverExe.setCurrentTask(task);
        this.dispatchTaskWithdrawRestoreListener(task);
        commandContext.getTaskEntityManager().changeTaskAssignee(task, null, null);
        commandContext.getMessageService().deleteDealToDoAndCreateToDo(hiTaskId);
        this.executeWithdrawTaskListeners(recoverExeId);
        commandContext.getCommentEntityManager().deleteCommentsByTaskId(hiTaskId);
        commandContext.getHistoricTaskInstanceEntityManager().update(hiTask);
        logger.debug("\u6062\u590d\u4efb\u52a1\u3001\u6062\u590d\u5904\u7406\u4eba\u3001\u521b\u5efa\u5f85\u529e\u6d88\u606f\u3001\u6267\u884c\u76d1\u542c\u3001\u5220\u9664\u5904\u7406\u610f\u89c1\u3002");
    }

    private ExecutionEntity recoverExecution(CommandContext commandContext, HistoricTaskInstanceEntity hiTask, Long proInstId, HistoricActivityInstanceEntity hiTaskActInst) {
        String historicTaskActId = hiTask.getTaskDefinitionKey();
        Long recoverExeId = hiTask.getExecutionId();
        Long hiTaskId = hiTask.getId();
        Long hiTaskActInstId = hiTaskActInst.getId();
        ((HistoricTaskInstanceEntityImpl)hiTask).setCurrentActInst(hiTaskActInstId);
        ExecutionEntity recoverExe = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(recoverExeId);
        recoverExe.setCurrentActInstId(hiTaskActInstId);
        recoverExe.setCurrentTaskId(hiTaskId);
        recoverExe.setCurrentTask(null);
        recoverExe.setActivityId(historicTaskActId);
        recoverExe.setActive(true);
        Process process = ProcessDefinitionUtil.getProcess(hiTask.getProcessDefinitionId(), proInstId);
        FlowElement flowElement = process.getFlowElement(historicTaskActId);
        recoverExe.setCurrentFlowElement(flowElement);
        List<BoundaryEvent> boundaryEvents = ((Activity)flowElement).getBoundaryEvents();
        if (CollectionUtil.isNotEmpty(boundaryEvents)) {
            this.executeBoundaryEvents(boundaryEvents, recoverExe, commandContext);
        }
        recoverExe.removeVariable("priority");
        logger.debug("\u6062\u590d\u5f53\u524dexecution\u3002");
        return recoverExe;
    }

    private HistoricActivityInstanceEntity recoverHistoricActinst(CommandContext commandContext, HistoricTaskInstanceEntity hiTask, Long proInstId) {
        QFilter procFilter = new QFilter("processInstanceId", "=", (Object)proInstId);
        QFilter taskFilter = new QFilter("taskId", "=", (Object)hiTask.getId());
        HistoricActivityInstanceEntityManager historicActivityManager = commandContext.getHistoricActivityInstanceEntityManager();
        List hiActInsts = historicActivityManager.findByQueryFilters(new QFilter[]{procFilter, taskFilter});
        HistoricActivityInstanceEntity hiTaskActInst = (HistoricActivityInstanceEntity)hiActInsts.get(0);
        for (HistoricActivityInstanceEntity actInst : hiActInsts) {
            if (actInst.getExecutionId().equals(hiTask.getExecutionId())) {
                hiTaskActInst = actInst;
            }
            actInst.setTargetElementId(null);
            actInst.setEndTime(null);
            actInst.setDurationInMillis(0L);
            actInst.setRealDurationInMillis(0L);
            historicActivityManager.update(actInst);
        }
        logger.debug("\u6062\u590d\u5f53\u524d\u6d3b\u52a8\u5b9e\u4f8b" + WfUtils.listToString(hiActInsts, ","));
        return hiTaskActInst;
    }

    private void recoverVars(CommandContext commandContext, ExecutionEntity procInstance, HistoricActivityInstanceEntity hiTaskActInst, ExecutionEntity recoverExe, Long hiTaskId, String lastUserNodeActId) {
        Long procInstId = procInstance.getProcessInstanceId();
        Long recoverExeId = hiTaskActInst.getExecutionId();
        String historicTaskActId = hiTaskActInst.getActivityId();
        HistoricVariableInstanceEntityManager historicVarManager = commandContext.getHistoricVariableInstanceEntityManager();
        historicVarManager.deleteHistoricVariableInstancesByTaskId(hiTaskId);
        QFilter varExecutionFilter = new QFilter("executionId", "=", (Object)recoverExeId);
        QFilter varProcFilter = new QFilter("processInstanceId", "=", (Object)procInstId);
        QFilter varNameFilter = new QFilter("name", "=", (Object)"lastUserDealNode");
        QFilter[] filters = new QFilter[]{varProcFilter, varExecutionFilter, varNameFilter};
        List vars = commandContext.getVariableInstanceEntityManager().findByQueryFilters(filters);
        String value = historicTaskActId;
        if (lastUserNodeActId.contains(STARTSIGNAL)) {
            value = "start";
        }
        for (VariableInstanceEntity var : vars) {
            var.setTextValue(value);
            commandContext.getVariableInstanceEntityManager().update(var);
        }
        List hiVars = historicVarManager.findByQueryFilters(filters);
        for (HistoricVariableInstanceEntity var : hiVars) {
            var.setTextValue(value);
            historicVarManager.update(var);
        }
        logger.debug("\u6062\u590d\u53d8\u91cf" + value);
    }

    private void dispatchTaskWithdrawRestoreListener(TaskEntity task) {
        ActivitiEventDispatcher eventDispatcher = Context.getProcessEngineConfiguration().getEventDispatcher();
        if (eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.TASKWITHDRAW_RESTORE, task));
        }
    }

    private void executeWithdrawTaskListeners(Long executionId) {
        CommandContext commandContext = Context.getCommandContext();
        ExecutionEntity execution = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(executionId);
        commandContext.getProcessEngineConfiguration().getListenerNotificationHelper().executeWithdrawTaskListeners(execution.getCurrentTask(), "complete");
    }

    private void executeBoundaryEvents(Collection<BoundaryEvent> boundaryEvents, ExecutionEntity execution, CommandContext commandContext) {
        for (BoundaryEvent boundaryEvent : boundaryEvents) {
            if (CollectionUtil.isEmpty(boundaryEvent.getEventDefinitions()) || boundaryEvent.getEventDefinitions().get(0) instanceof CompensateEventDefinition) continue;
            ExecutionEntity childExecutionEntity = commandContext.getExecutionEntityManager().createChildExecution(execution);
            childExecutionEntity.setParentId(execution.getId());
            childExecutionEntity.setCurrentFlowElement(boundaryEvent);
            childExecutionEntity.setScope(false);
            ActivityBehavior boundaryEventBehavior = (ActivityBehavior)boundaryEvent.getBehavior();
            logger.debug(String.format("Executing boundary event activityBehavior %s with execution %s", boundaryEventBehavior.getClass(), childExecutionEntity.getId()));
            boundaryEventBehavior.execute(childExecutionEntity);
        }
    }
}

