/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task.withdraw.op;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.WithdrawContext;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.WithdrawResult;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.op.AbstractReveserWithdrawOp;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.DefaultCommandContextCloseListener;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.HiUserActInstEntity;
import kd.bos.workflow.engine.impl.util.WfOperationLogUtil;

public class DeleteProcessWithdrawOp
extends AbstractReveserWithdrawOp {
    protected static Log logger = LogFactory.getLog(DeleteProcessWithdrawOp.class);
    private Long procInstId;
    private String businesskey;
    private List<HiUserActInstEntity> userActInsts;

    public DeleteProcessWithdrawOp(Long procInstId, String businesskey, List<HiUserActInstEntity> userActInsts, WithdrawContext withdrawContext) {
        this.procInstId = procInstId;
        this.businesskey = businesskey;
        this.userActInsts = userActInsts;
        this.withdrawContext = withdrawContext;
    }

    @Override
    public WithdrawResult withdraw(CommandContext commandContext) {
        ExecutionEntity procInstance = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(this.procInstId);
        this.withdrawContext.setProcInst(procInstance);
        this.withdrawContext.setWithdrawType("deleteProcess");
        this.reverseExecuteMessageAndListeners(commandContext, this.userActInsts, procInstance);
        this.withdrawContext.getDispatcher().dispatch("deleteCurrent", this.withdrawContext, this.userActInsts, this.taskIds);
        this.deleteProcess(commandContext, procInstance);
        this.withdrawContext.getDispatcher().dispatch("recoverHistory", this.withdrawContext, new Object[0]);
        return null;
    }

    @Override
    public void reverseCurrentActInstIter(CommandContext commandContext, HistoricActivityInstanceEntity actinst, Map<Long, ExecutionEntity> executionMap) {
        Long taskId = actinst.getTaskId();
        if (WfUtils.isNotEmpty(taskId)) {
            OperationLogEntityImpl operationLog = new OperationLogEntityImpl();
            Date date = commandContext.getProcessEngineConfiguration().getClock().getCurrentTime();
            operationLog.setTaskId(taskId);
            operationLog.setCreateDate(date);
            operationLog.setType("withdraw");
            Long userId = Long.parseLong(RequestContext.get().getUserId());
            if (WfUtils.isNotEmpty(this.withdrawContext.getUserId())) {
                userId = this.withdrawContext.getUserId();
            }
            operationLog.setOwnerId(userId);
            operationLog.setOwner(WfUtils.findUserName(userId));
            WfOperationLogUtil.recordOperationLog(commandContext, operationLog);
        }
        super.reverseCurrentActInstIter(commandContext, actinst, executionMap);
    }

    private void deleteProcess(CommandContext commandContext, ExecutionEntity procInstance) {
        ExecutionEntity billExec;
        commandContext.getExecutionEntityManager().deleteProcessInstance(this.procInstId, "process instance withdraw", false);
        commandContext.getHiUserActInstEntityManager().deleteByProinstId(this.procInstId);
        commandContext.getHistoricActivityInstanceEntityManager().deleteHistoricActivityInstancesByProcessInstanceId(this.procInstId);
        commandContext.getMessageService().deleteProcessIntacne(this.procInstId);
        commandContext.getCommentEntityManager().deleteCommentsByProcessInstanceId(this.procInstId);
        commandContext.getHistoricTaskInstanceEntityManager().deleteHistoricTaskInstancesByProcessInstanceId(this.procInstId);
        commandContext.getHistoricVariableInstanceEntityManager().deleteHistoricVariableInstanceByProcessInstanceId(this.procInstId);
        commandContext.getEventLogEntryEntityManager().deleteLogsByBusinessKey(this.businesskey);
        final String pk = this.businesskey;
        final String entityNumber = procInstance.getEntityNumber();
        WfCacheHelper.removeExecutingJobOfCurrentBusiness(pk, entityNumber);
        logger.debug("\u5220\u9664\u6d41\u7a0b\u6570\u636e\uff0c\u5e76\u5220\u9664\u7f13\u5b58\u3002");
        ExecutionEntity parentExec = procInstance.getSuperExecution();
        if (parentExec != null && ModelType.BizFlow.name().equalsIgnoreCase(parentExec.getProcessType()) && (billExec = parentExec.getParent()) != null && billExec.isBillExecution()) {
            billExec.setAbortType(2);
            commandContext.getExecutionEntityManager().update(billExec);
        }
        commandContext.addCloseListener(new DefaultCommandContextCloseListener(DeleteProcessWithdrawOp.class.getName()){

            @Override
            public void closed(CommandContext commandContext) {
                super.closed(commandContext);
                WfCacheHelper.removeExecutingJobGYEntityOfCurrentBusiness(pk, entityNumber);
            }
        });
    }
}

