/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task.withdraw.op;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.IWithdrawOp;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.WithdrawContext;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.WithdrawResult;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.op.BackPreTaskWithdrawOp;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricVariableInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricVariableInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.HiUserActInstEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.HiUserActInstEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.PathJson;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.VariableInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.VariableInstanceEntityManager;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.exception.WFErrorCode;

public class SaveSubmitNodeWithdrawOp
implements IWithdrawOp {
    protected static Log logger = LogFactory.getLog(SaveSubmitNodeWithdrawOp.class);
    private List<HiUserActInstEntity> userActInsts;
    private Long procInstId;
    private WithdrawContext withdrawContext;

    public SaveSubmitNodeWithdrawOp(Long procInstId, List<HiUserActInstEntity> userActInsts, WithdrawContext withdrawContext) {
        this.userActInsts = userActInsts;
        this.procInstId = procInstId;
        this.withdrawContext = withdrawContext;
    }

    @Override
    public WithdrawResult withdraw(CommandContext commandContext) {
        List<HiUserActInstEntity> buildUserActInsts = this.buildFirstUserTaskUserInsts();
        logger.debug(String.format("\u6267\u884c\u5f3a\u7ba1\u63a7\u64a4\u56de%s", WfUtils.listToString(buildUserActInsts, ",")));
        HistoricActivityInstanceEntity userTaskActInst = (HistoricActivityInstanceEntity)commandContext.getHistoricActivityInstanceEntityManager().findById(buildUserActInsts.get(0).getLastNodeActinstId());
        HistoricTaskInstanceEntity hiTask = (HistoricTaskInstanceEntity)commandContext.getHistoricTaskInstanceEntityManager().findById(userTaskActInst.getTaskId());
        new BackPreTaskWithdrawOp(this.procInstId, hiTask, buildUserActInsts, this.withdrawContext).withdraw(commandContext);
        this.recoverHiUserActInsts(commandContext, userTaskActInst);
        this.recoverVars(commandContext, hiTask);
        return null;
    }

    private void recoverVars(CommandContext commandContext, HistoricTaskInstanceEntity hiTask) {
        QFilter varExecutionFilter = new QFilter("executionId", "=", (Object)hiTask.getExecutionId());
        QFilter varProcFilter = new QFilter("processInstanceId", "=", (Object)this.procInstId);
        QFilter varNameFilter = new QFilter("name", "=", (Object)"lastUserDealNode");
        QFilter[] filters = new QFilter[]{varProcFilter, varExecutionFilter, varNameFilter};
        VariableInstanceEntityManager variableMgr = commandContext.getVariableInstanceEntityManager();
        List vars = variableMgr.findByQueryFilters(filters);
        for (VariableInstanceEntity var : vars) {
            var.setTextValue("startStrongControl");
            variableMgr.update(var);
        }
        HistoricVariableInstanceEntityManager historicVarManager = commandContext.getHistoricVariableInstanceEntityManager();
        List hiVars = historicVarManager.findByQueryFilters(filters);
        for (HistoricVariableInstanceEntity var : hiVars) {
            var.setTextValue("startStrongControl");
            historicVarManager.update(var);
        }
    }

    private List<HiUserActInstEntity> buildFirstUserTaskUserInsts() {
        Process process = ProcessDefinitionUtil.getProcessByProcInstId(this.procInstId);
        UserTask firstUserTask = BpmnModelUtil.getFirstUserTask(process);
        if (firstUserTask == null) {
            throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{ResManager.loadKDString((String)"\u6ca1\u6709\u7b2c\u4e00\u4e2a\u4eba\u5de5\u8282\u70b9\uff0c\u4e0d\u80fd\u5f3a\u7ba1\u63a7\u64a4\u56de", (String)"SaveSubmitNodeWithdrawOp_0", (String)"bos-wf-engine", (Object[])new Object[0])});
        }
        String firstUserNodeId = firstUserTask.getId();
        ArrayList<HiUserActInstEntity> buildFirstUserTaskUserActInsts = new ArrayList<HiUserActInstEntity>();
        ORM orm = ORM.create();
        block0: for (HiUserActInstEntity userActInst : this.userActInsts) {
            HiUserActInstEntity copyUserActInst = this.copy(userActInst);
            String pathJsonStr = copyUserActInst.getPathJson();
            if (!WfUtils.isNotEmpty(pathJsonStr)) continue;
            List pathJsons = SerializationUtils.fromJsonStringToList((String)pathJsonStr, PathJson.class);
            Iterator iter = pathJsons.iterator();
            while (iter.hasNext()) {
                PathJson pathJson = (PathJson)iter.next();
                if (!firstUserNodeId.equals(pathJson.getNodeId())) continue;
                Long userTaskActInstId = pathJson.getActInstId();
                copyUserActInst.setLastNodeActinstId(userTaskActInstId);
                copyUserActInst.setLastUserNodeActId(pathJson.getNodeId());
                iter.remove();
                if (pathJsons.isEmpty()) {
                    copyUserActInst.setPathJson("");
                } else {
                    copyUserActInst.setPathJson(SerializationUtils.toJsonString((Object)pathJsons));
                }
                Long id = orm.genLongId("wf_hiuseractinst");
                copyUserActInst.setId(id);
                buildFirstUserTaskUserActInsts.add(copyUserActInst);
                continue block0;
            }
        }
        if (buildFirstUserTaskUserActInsts.size() != this.userActInsts.size()) {
            throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{ResManager.loadKDString((String)"\u5f53\u524d\u6d41\u7a0b\u8bbe\u7f6e\u4e86\u4fdd\u7559\u6d41\u7a0b\u5b9e\u4f8b\u4e14\u5df2\u7ecf\u5728\u7b2c\u4e00\u4e2a\u4eba\u5de5\u8282\u70b9\u3002", (String)"SaveSubmitNodeWithdrawOp_1", (String)"bos-wf-engine", (Object[])new Object[0])});
        }
        return buildFirstUserTaskUserActInsts;
    }

    private HiUserActInstEntity copy(HiUserActInstEntity userActInst) {
        HiUserActInstEntity newUserInst = (HiUserActInstEntity)Context.getCommandContext().getHiUserActInstEntityManager().create();
        newUserInst.setBusinesskey(userActInst.getBusinesskey());
        newUserInst.setCurrentActId(userActInst.getCurrentActId());
        newUserInst.setCurrentActinstId(userActInst.getCurrentActinstId());
        newUserInst.setCurrentExecutionId(userActInst.getExecutionId());
        newUserInst.setCurrentNodeName(userActInst.getCurrentNodeName().getLocaleValue());
        newUserInst.setExecutionId(userActInst.getExecutionId());
        newUserInst.setJoinFlag(userActInst.getJoinFlag());
        newUserInst.setLastNodeActinstId(userActInst.getLastNodeActinstId());
        newUserInst.setLastNodeCid(userActInst.getLastNodeCid());
        newUserInst.setLastNodeName(userActInst.getLastNodeName().getLocaleValue());
        newUserInst.setLastUserNodeActId(userActInst.getLastUserNodeActId());
        newUserInst.setPathJson(userActInst.getPathJson());
        newUserInst.setProinstId(userActInst.getProinstId());
        newUserInst.setTaskId(userActInst.getTaskId());
        return newUserInst;
    }

    private void recoverHiUserActInsts(CommandContext commandContext, HistoricActivityInstanceEntity userTaskActInst) {
        logger.debug("\u56de\u590dhiuser\uff0c\u8bbe\u7f6eendtype\u4e3astrongControlWithdraw");
        HiUserActInstEntityManager userActInstMgr = commandContext.getHiUserActInstEntityManager();
        for (HiUserActInstEntity userActInst : this.userActInsts) {
            userActInst.setCurrentActId(userTaskActInst.getActivityId());
            userActInst.setCurrentActinstId(userTaskActInst.getId());
            userActInst.setExecutionId(userTaskActInst.getExecutionId());
            userActInst.setCurrentNodeName(userTaskActInst.getActivityName().getLocaleValue());
            userActInst.setPathJson("");
            userActInst.setEndType("strongControlWithdraw");
            userActInstMgr.update(userActInst);
        }
    }
}

