/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task.withdraw.validate;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.IWithdrawValidate;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.validate.WithdrawValidateRet;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.TimerJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ManagementConstants;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.RuntimeUtil;

public class ContinueStateWithdrawValidator
implements IWithdrawValidate {
    private ExecutionEntity procInst;
    private String businessKey;

    public ContinueStateWithdrawValidator(ExecutionEntity procInst) {
        this.procInst = procInst;
    }

    public ContinueStateWithdrawValidator(ExecutionEntity procInst, String businessKey) {
        this.procInst = procInst;
        this.businessKey = businessKey;
    }

    @Override
    public WithdrawValidateRet validate(CommandContext commandContext) {
        WithdrawValidateRet ret = new WithdrawValidateRet(true, "");
        String errorInfo = this.validateContinueState(commandContext, this.procInst);
        if (WfUtils.isNotEmpty(errorInfo)) {
            ret.setSuccess(false);
            ret.setErrorInfo(errorInfo);
        }
        return ret;
    }

    private String validateContinueState(CommandContext commandContext, ExecutionEntity procInst) {
        if (procInst == null) {
            return ResManager.loadKDString((String)"\u672a\u627e\u5230\u8fd0\u884c\u7684\u6d41\u7a0b\uff0c\u6b64\u6d41\u7a0b\u5df2\u7ecf\u7ed3\u675f\u3002", (String)"UpgradeWithdrawTaskCmd2_2", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        if (ProcessType.BizFlow.name().equals(procInst.getProcessType())) {
            return ResManager.loadKDString((String)"\u4e1a\u52a1\u6d41\u4e0d\u652f\u6301\u64a4\u56de\u3002", (String)"UpgradeWithdrawTaskCmd2_1", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        if (ManagementConstants.SUSPENDED.getStateCode().equals(procInst.getSuspensionState())) {
            return ResManager.loadKDString((String)"\u6d41\u7a0b\u5df2\u6302\u8d77\u3002", (String)"UpgradeWithdrawTaskCmd2_3", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        if (WfUtils.isNotEmpty(this.businessKey) ? RuntimeUtil.isRunning(commandContext, this.businessKey) || RuntimeUtil.isRetring(commandContext, this.businessKey) : this.isRunning(commandContext, procInst.getProcessInstanceId()) || this.isRetring(commandContext, procInst.getProcessInstanceId())) {
            return ResManager.loadKDString((String)"\u6d41\u7a0b\u6b63\u5728\u6d41\u8f6c\uff0c\u6216\u6b63\u5728\u91cd\u8bd5\u3002", (String)"UpgradeWithdrawTaskCmd2_4", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        if (WfUtils.isNotEmptyString(procInst.getVariableLocal("enterBoundaryErrorNodeId"))) {
            return ResManager.loadKDString((String)"\u6d41\u7a0b\u5df2\u8fdb\u5165\u5f02\u5e38\u5206\u652f\uff0c\u4e0d\u80fd\u64a4\u56de\u3002", (String)"UpgradeWithdrawTaskCmd2_5", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        return "";
    }

    public boolean isRunning(CommandContext commandContext, Long processInstanceId) {
        List<JobEntity> jobs = commandContext.getJobEntityManager().findJobsByProcessInstanceId(processInstanceId);
        if (jobs != null && !jobs.isEmpty()) {
            for (JobEntity job : jobs) {
                if (!this.isRunningJob(job.getJobHandlerType())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isRetring(CommandContext commandContext, Long processInstanceId) {
        List<TimerJobEntity> timerJobs = commandContext.getTimerJobEntityManager().findJobsByProcessInstanceId(processInstanceId);
        if (timerJobs != null && !timerJobs.isEmpty()) {
            for (TimerJobEntity timer : timerJobs) {
                if (!this.isRunningJob(timer.getJobHandlerType())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isRunningJob(String type) {
        return "async-continuation".equalsIgnoreCase(type) || "async-trigger".equalsIgnoreCase(type) || "start-process-event".equalsIgnoreCase(type) || "execute-behavior".equalsIgnoreCase(type) || "async-executionConversion".equalsIgnoreCase(type) || "start-callactivity-event".equalsIgnoreCase(type) || "async-compensationTaskJob".equalsIgnoreCase(type) || "multi-async-continuation".equalsIgnoreCase(type);
    }
}

