/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task.withdraw.validate;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.IWithdrawValidate;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.executor.AbstractWithdrawCmd;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.validate.WithdrawValidateRet;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.HiUserActInstEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.PathJson;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;

public class ExecutionWithdrawValidator
implements IWithdrawValidate {
    protected static Log logger = LogFactory.getLog(ExecutionWithdrawValidator.class);
    private ExecutionEntity procInst;
    private List<HiUserActInstEntity> userActInsts;
    private AbstractWithdrawCmd withdrawCmd;

    public ExecutionWithdrawValidator(ExecutionEntity procInst, List<HiUserActInstEntity> userActInsts, AbstractWithdrawCmd withdrawCmd) {
        this.procInst = procInst;
        this.userActInsts = userActInsts;
        this.withdrawCmd = withdrawCmd;
    }

    public ExecutionWithdrawValidator(ExecutionEntity procInst, List<HiUserActInstEntity> userActInsts) {
        this.procInst = procInst;
        this.userActInsts = userActInsts;
    }

    @Override
    public WithdrawValidateRet validate(CommandContext commandContext) {
        WithdrawValidateRet ret = new WithdrawValidateRet(true, "");
        if (WfUtils.isNotEmpty(this.procInst.getSuperExecutionId())) {
            ret.setSuccess(false);
            ret.setErrorInfo(ResManager.loadKDString((String)"\u5b50\u6d41\u7a0b\u4e0d\u652f\u6301\u64a4\u56de\uff0c\u8bf7\u5728\u7236\u6d41\u7a0b\u4e2d\u64a4\u56de\u3002", (String)"ExecutionWithdrawValidator_0", (String)"bos-wf-engine", (Object[])new Object[0]));
            return ret;
        }
        boolean isApproved = false;
        Process process = ProcessDefinitionUtil.getProcessByProcInstId(this.procInst.getId());
        boolean isAbandon = process.getWithdrawProcInAuditing();
        ArrayList<Long> subHiProcInstIds = new ArrayList<Long>(16);
        ArrayList<String> activityIds = new ArrayList<String>(16);
        for (HiUserActInstEntity userInst : this.userActInsts) {
            HistoricActivityInstanceEntity curArcInst;
            Object flowElement;
            String curActId;
            if (!isApproved && !userInst.getLastUserNodeActId().contains("StartSignal")) {
                if (!isAbandon) {
                    ret.setSuccess(false);
                    ret.setErrorInfo(ResManager.loadKDString((String)"\u6d41\u7a0b\u5df2\u7ecf\u5ba1\u6279\u8fc7\u3002", (String)"ExecutionWithdrawValidator_1", (String)"bos-wf-engine", (Object[])new Object[0]));
                    return ret;
                }
                if (this.withdrawCmd != null) {
                    this.withdrawCmd.setAbandonProc(true);
                    isApproved = true;
                    this.withdrawCmd.setApproved(isApproved);
                }
            }
            if ((curActId = userInst.getCurrentActId()).contains("SSCApprove")) {
                Long taskId = ((HistoricActivityInstanceEntity)commandContext.getHistoricActivityInstanceEntityManager().findById(userInst.getCurrentActinstId())).getTaskId();
                TaskEntity task = (TaskEntity)commandContext.getTaskEntityManager().findById(taskId);
                flowElement = process.getFlowElement(curActId);
                if (!commandContext.getProcessEngineConfiguration().getListenerNotificationHelper().executeCanWithdrawListeners((UserTask)flowElement, task)) {
                    ret.setSuccess(false);
                    ret.setErrorInfo(String.format(ResManager.loadKDString((String)"%s\u8282\u70b9\u4e0d\u5141\u8bb8\u64a4\u56de \u3002", (String)"ExecutionWithdrawValidator_4", (String)"bos-wf-engine", (Object[])new Object[0]), task.getName()));
                    return ret;
                }
            } else if (curActId.contains("YunzhijiaTask") && (curArcInst = (HistoricActivityInstanceEntity)commandContext.getHistoricActivityInstanceEntityManager().findById(userInst.getCurrentActinstId())) != null && "YunzhijiaTask".equals(curArcInst.getActivityType())) {
                List<HistoricActivityInstanceEntity> actInsts = commandContext.getHistoricActivityInstanceEntityManager().findBySourceId(curArcInst.getProcessInstanceId(), curArcInst.getSourceElementId());
                flowElement = actInsts.iterator();
                while (flowElement.hasNext()) {
                    HistoricActivityInstanceEntity i = (HistoricActivityInstanceEntity)flowElement.next();
                    if (i.getEndTime() == null) continue;
                    if (!isAbandon) {
                        ret.setSuccess(false);
                        ret.setErrorInfo(ResManager.loadKDString((String)"\u4f1a\u5ba1\u8282\u70b9\u5df2\u7ecf\u5ba1\u6279\u8fc7\u3002", (String)"ExecutionWithdrawValidator_5", (String)"bos-wf-engine", (Object[])new Object[0]));
                        return ret;
                    }
                    this.withdrawCmd.setAbandonProc(true);
                    this.withdrawCmd.setApproved(true);
                }
            }
            if (!activityIds.contains(curActId) && curActId.contains("CallActivity")) {
                List<HistoricProcessInstanceEntity> subHiProcInsts = commandContext.getHistoricProcessInstanceEntityManager().findChildExecutionsByProcessInstanceId(this.procInst.getId());
                for (HistoricProcessInstanceEntity hiProcInst : subHiProcInsts) {
                    if (hiProcInst.getEndTime() != null) continue;
                    subHiProcInstIds.add(hiProcInst.getId());
                }
                if (!subHiProcInstIds.isEmpty()) {
                    QFilter procfilter = new QFilter("proInstId", "in", subHiProcInstIds);
                    QFilter endfilter = new QFilter("endTime", "is not null", null);
                    boolean subProcIsApproved = commandContext.getHiUserActInstEntityManager().exist(new QFilter[]{procfilter, endfilter});
                    if (subProcIsApproved) {
                        if (!isAbandon) {
                            ret.setSuccess(false);
                            ret.setErrorInfo(ResManager.loadKDString((String)"\u5b58\u5728\u5b50\u6d41\u7a0b\u4e14\u5b50\u6d41\u7a0b\u5df2\u7ecf\u5ba1\u6279\u3002", (String)"ExecutionWithdrawValidator_2", (String)"bos-wf-engine", (Object[])new Object[0]));
                            return ret;
                        }
                        if (this.withdrawCmd != null) {
                            this.withdrawCmd.setAbandonProc(true);
                            this.withdrawCmd.setApproved(true);
                        }
                    }
                    logger.debug("\u627e\u5230\u5b50\u6d41\u7a0b\uff1a" + WfUtils.listToString(subHiProcInstIds, ","));
                }
            }
            activityIds.add(curActId);
            String json = userInst.getPathJson();
            if (!WfUtils.isNotEmpty(json)) continue;
            List pathJsons = SerializationUtils.fromJsonStringToList((String)json, PathJson.class);
            for (PathJson pj : pathJsons) {
                HistoricActivityInstanceEntity actInst;
                String nodeId = pj.getNodeId();
                if (!nodeId.contains("CallActivity") || (actInst = (HistoricActivityInstanceEntity)commandContext.getHistoricActivityInstanceEntityManager().findById(pj.getActInstId())).getExecutionType().equals("skip")) continue;
                if (!isAbandon) {
                    ret.setSuccess(false);
                    ret.setErrorInfo(ResManager.loadKDString((String)"\u7ecf\u8fc7\u5b50\u6d41\u7a0b\u4e14\u5df2\u7ecf\u5b50\u6d41\u7a0b\u5df2\u7ecf\u5ba1\u6279\u7ed3\u675f\u3002", (String)"ExecutionWithdrawValidator_3", (String)"bos-wf-engine", (Object[])new Object[0]));
                    return ret;
                }
                this.withdrawCmd.setAbandonProc(true);
                this.withdrawCmd.setApproved(true);
            }
        }
        if (this.withdrawCmd != null) {
            this.withdrawCmd.setSubProcInstIds(subHiProcInstIds);
        }
        return ret;
    }
}

