/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task.withdraw.validate;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.BoundaryEvent;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.IWithdrawValidate;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.executor.AbstractWithdrawCmd;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.validate.WithdrawValidateRet;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricVariableInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.HiUserActInstEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.PathJson;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.exception.WFErrorCode;

public class TaskWithdrawValidator
implements IWithdrawValidate {
    protected static Log logger = LogFactory.getLog(TaskWithdrawValidator.class);
    private static final String UPGRADEWITHDRAWTASKCMD_7 = "UpgradeWithdrawTaskCmd_7";
    private HistoricTaskInstanceEntity hiTask;
    private ExecutionEntity procInst;
    private List<HiUserActInstEntity> hiUserActInsts;
    private AbstractWithdrawCmd withdrawCmd;

    public TaskWithdrawValidator(HistoricTaskInstanceEntity hiTask, ExecutionEntity procInst, List<HiUserActInstEntity> hiUserActInsts, AbstractWithdrawCmd withdrawCmd) {
        this.hiTask = hiTask;
        this.procInst = procInst;
        this.hiUserActInsts = hiUserActInsts;
        this.withdrawCmd = withdrawCmd;
    }

    @Override
    public WithdrawValidateRet validate(CommandContext commandContext) {
        WithdrawValidateRet ret = new WithdrawValidateRet(true, "");
        String errorInfo = this.validateProcessState(commandContext);
        if (WfUtils.isEmpty(errorInfo)) {
            errorInfo = this.validateTask(commandContext);
        }
        if (WfUtils.isNotEmpty(errorInfo)) {
            ret.setSuccess(false);
            ret.setErrorInfo(errorInfo);
        }
        return ret;
    }

    private String validateProcessState(CommandContext commandContext) {
        BpmnModel bpmnModel;
        FlowElement curFlowElement;
        Long hiTaskId = this.hiTask.getId();
        if ("YunzhijiaTask".equals(this.hiTask.getCategory())) {
            return ResManager.loadKDString((String)"\u4f1a\u5ba1\u8282\u70b9\u4e0d\u80fd\u64a4\u56de\u3002", (String)"UpgradeWithdrawTaskCmd_4", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        HistoricVariableInstanceEntity dynType = commandContext.getHistoricVariableInstanceEntityManager().findHistoricVariableInstancesByTaskIdAndVarName(hiTaskId, "dynType");
        if (dynType != null && "rejectToForkInner".equals(dynType.getValue())) {
            return ResManager.loadKDString((String)"\u9a73\u56de\u5230\u5206\u652f\u5185\u90e8\uff0c\u4e0d\u80fd\u64a4\u56de\u3002", (String)"UpgradeWithdrawTaskCmd_129", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        if (WfUtils.isNotEmptyString(this.procInst.getVariableLocal("canNotWithdrawTasks")) && ((String)this.procInst.getVariableLocal("canNotWithdrawTasks")).contains(String.valueOf(hiTaskId))) {
            return ResManager.loadKDString((String)"\u62c6\u5206\u7b56\u7565\u4e3a\u9a73\u56de\u8d70\u5168\u90e8\u4e0e\u8df3\u8f6c\u4e0d\u652f\u6301\u64a4\u56de\u3002", (String)"UpgradeWithdrawTaskCmd2_8", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        if (WfUtils.isNotEmptyString(this.procInst.getVariableLocal("enterBoundaryErrorNodeId"))) {
            return ResManager.loadKDString((String)"\u6d41\u7a0b\u5df2\u8fdb\u5165\u5f02\u5e38\u5206\u652f\uff0c\u4e0d\u80fd\u64a4\u56de\u3002", (String)"UpgradeWithdrawTaskCmd_10", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        if (WfConfigurationUtil.isSupportStrongControl() && BpmnModelUtil.isFirstNodeByModel((FlowNode)(curFlowElement = (bpmnModel = ProcessDefinitionUtil.getBpmnModel(this.procInst.getProcessDefinitionId(), this.procInst.getProcessInstanceId())).getFlowElement(this.hiTask.getTaskDefinitionKey()))) && commandContext.getTaskEntityManager().findById(hiTaskId) != null) {
            return ResManager.loadKDString((String)"\u4eba\u5de5\u8282\u70b9\u4e0d\u80fd\u64a4\u56de\u3002", (String)"UpgradeWithdrawTaskCmd_30", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        return "";
    }

    private String validateTask(CommandContext commandContext) {
        List<BoundaryEvent> event;
        if (this.hiUserActInsts.isEmpty()) {
            BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(this.procInst.getProcessDefinitionId(), this.procInst.getProcessInstanceId());
            FlowElement curFlowElement = bpmnModel.getFlowElement(this.hiTask.getTaskDefinitionKey());
            boolean isFirstNodeWithdraw = true;
            if (BpmnModelUtil.isFirstNodeByModel((FlowNode)curFlowElement)) {
                List<HiUserActInstEntity> allUserActInsts = commandContext.getHiUserActInstEntityManager().findCurrentUserActInsts(this.procInst.getId());
                for (HiUserActInstEntity userActInst : allUserActInsts) {
                    if (userActInst.getLastUserNodeActId().contains("StartSignal")) continue;
                    isFirstNodeWithdraw = false;
                    break;
                }
                if (isFirstNodeWithdraw) {
                    this.hiUserActInsts.addAll(allUserActInsts);
                    logger.debug("\u4fee\u590dhisuers" + WfUtils.listToString(this.hiUserActInsts, ","));
                }
            }
            if (!isFirstNodeWithdraw) {
                return ResManager.loadKDString((String)"\u8be5\u8282\u70b9\u4e0d\u80fd\u64a4\u56de\uff08\u540e\u7eed\u5df2\u7ecf\u88ab\u5904\u7406\u6216\u6d41\u7a0b\u5df2\u7ecf\u8fdb\u5165\u8fb9\u754c\uff09\u3002", (String)"UpgradeWithdrawTaskCmd_6", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
        }
        ArrayList<Long> actInstIds = new ArrayList<Long>();
        HashSet<String> activityIds = new HashSet<String>();
        this.collectDataAndValidateExecuteType(this.procInst, this.hiUserActInsts, actInstIds, activityIds, commandContext);
        ArrayList<Long> taskIds = new ArrayList<Long>();
        if (!actInstIds.isEmpty()) {
            logger.debug(WfUtils.listToString(actInstIds, ","));
            List actInsts = commandContext.getHistoricActivityInstanceEntityManager().findByQueryFilters(new QFilter[]{new QFilter("id", "in", actInstIds)});
            for (HistoricActivityInstanceEntity actInst : actInsts) {
                if (!WfUtils.isNotEmpty(actInst.getTaskId())) continue;
                taskIds.add(actInst.getTaskId());
            }
        }
        if (taskIds.isEmpty()) {
            return "";
        }
        logger.debug(WfUtils.listToString(taskIds, ","));
        BpmnModel bpmnModel = null;
        ArrayList<Long> yzjParentTaskIds = new ArrayList<Long>();
        Long procInstId = this.procInst.getProcessInstanceId();
        List tasks = commandContext.getHistoricTaskInstanceEntityManager().findByQueryFilters(new QFilter[]{new QFilter("processInstanceId", "=", (Object)procInstId), new QFilter("id", "in", taskIds)});
        for (HistoricTaskInstanceEntity hiTask : tasks) {
            String handleState = hiTask.getHandleState();
            String category = hiTask.getCategory();
            if ("freeze".equals(handleState)) {
                throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{ResManager.loadKDString((String)"\u51bb\u7ed3\u4efb\u52a1\u4e0d\u80fd\u64a4\u56de\u3002", (String)"UpgradeWithdrawTaskCmd_11", (String)"bos-wf-engine", (Object[])new Object[0])});
            }
            if ("UserTask".equals(category) && "dismissed".equals(handleState) && !WfConfigurationUtil.canWithdrawWhenRejectToUserTask()) {
                throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{ResManager.loadKDString((String)"\u9a73\u56de\u5230\u4eba\u5de5\u8282\u70b9\u540e\u4e0d\u80fd\u64a4\u56de\u3002", (String)"UpgradeWithdrawTaskCmd_113", (String)"bos-wf-engine", (Object[])new Object[0])});
            }
            if ("SSCApprove".equals(category)) {
                if (bpmnModel == null) {
                    bpmnModel = ProcessDefinitionUtil.getBpmnModel(this.procInst.getProcessDefinitionId(), procInstId);
                }
                FlowElement flowElement = bpmnModel.getFlowElement(hiTask.getTaskDefinitionKey());
                TaskEntity task = (TaskEntity)commandContext.getTaskEntityManager().findById(hiTask.getId());
                if (commandContext.getProcessEngineConfiguration().getListenerNotificationHelper().executeCanWithdrawListeners((UserTask)flowElement, task)) continue;
                return String.format(ResManager.loadKDString((String)"\u539f\u56e0\uff1a%s\u8282\u70b9\u4e0d\u5141\u8bb8\u64a4\u56de \u3002", (String)"ExecutionWithdrawValidator_6", (String)"bos-wf-engine", (Object[])new Object[0]), hiTask.getTaskDefinitionKey());
            }
            if (!"YunzhijiaTask".equals(category)) continue;
            yzjParentTaskIds.add(hiTask.getParentTaskId());
        }
        if (!yzjParentTaskIds.isEmpty()) {
            QFilter[] filters = new QFilter[]{new QFilter("processInstanceId", "=", (Object)procInstId), new QFilter("parentTaskId", "in", yzjParentTaskIds), new QFilter("endTime", "is not null", null)};
            if (commandContext.getHistoricTaskInstanceEntityManager().exist(filters)) {
                return ResManager.loadKDString((String)"\u4f1a\u5ba1\u8282\u70b9\u5df2\u7ecf\u5ba1\u6279\u3002", (String)"UpgradeWithdrawTaskCmd_69", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
        }
        if (bpmnModel == null) {
            bpmnModel = ProcessDefinitionUtil.getBpmnModel(this.procInst.getProcessDefinitionId(), procInstId);
        }
        if (!(event = bpmnModel.getMainProcess().findFlowElementsOfType(BoundaryEvent.class, false)).isEmpty()) {
            Set<String> notInBoundaryNodeIds = bpmnModel.getMainProcess().getNonBoundaryNodes();
            for (String activityId : activityIds) {
                if (notInBoundaryNodeIds.contains(activityId)) continue;
                return ResManager.loadKDString((String)"\u65e0\u6cd5\u8de8\u8fb9\u754c\u64a4\u56de\u3002", (String)"UpgradeWithdrawTaskCmd_9", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
        }
        return "";
    }

    private void collectDataAndValidateExecuteType(ExecutionEntity procInst, List<HiUserActInstEntity> hiUserActInsts, List<Long> curActInstIds, Set<String> activityIds, CommandContext commandContext) {
        boolean hasCallActivity = false;
        boolean isApproved = false;
        for (HiUserActInstEntity h : hiUserActInsts) {
            String pathJson;
            Object type;
            if (!isApproved && !h.getLastUserNodeActId().contains("StartSignal")) {
                isApproved = true;
                this.withdrawCmd.setApproved(isApproved);
            }
            if ("jump".equals(type = h.getEndType())) {
                throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{String.format(ResManager.loadKDString((String)"%1$s\u7684\u540e\u7eed\u8282\u70b9\u5df2\u5904\u7406\u3002", (String)UPGRADEWITHDRAWTASKCMD_7, (String)"bos-wf-engine", (Object[])new Object[0]), WfMultiLangUtils.getValueFromLocalString(h.getLastNodeName(), RequestContext.get().getLang().toString()))});
            }
            if ("forkJumpOrReject".equals(type)) {
                throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{ResManager.loadKDString((String)"\u5f53\u524d\u5206\u652f\u4e0d\u80fd\u64a4\u56de\u3002\u539f\u56e0\uff1a\u5176\u4ed6\u5206\u652f\u5df2\u8df3\u8f6c\uff0c\u6216\u5df2\u9a73\u56de\u5230\u62c6\u5206\u8282\u70b9/\u62c6\u5206\u4e4b\u524d\u7684\u8282\u70b9\u3002", (String)"UpgradeWithdrawTaskCmd_20", (String)"bos-wf-engine", (Object[])new Object[0])});
            }
            if (h.getEndTime() != null) {
                throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{String.format(ResManager.loadKDString((String)"%1$s\u7684\u540e\u7eed\u8282\u70b9\u5df2\u5904\u7406\u3002", (String)UPGRADEWITHDRAWTASKCMD_7, (String)"bos-wf-engine", (Object[])new Object[0]), WfMultiLangUtils.getValueFromLocalString(h.getLastNodeName(), RequestContext.get().getLang().toString()))});
            }
            String currentActId = h.getCurrentActId();
            if (currentActId.contains("CallActivity")) {
                hasCallActivity = true;
            }
            if (WfUtils.isNotEmpty(pathJson = h.getPathJson())) {
                List paths = SerializationUtils.fromJsonStringToList((String)pathJson, PathJson.class);
                for (PathJson pj : paths) {
                    HistoricActivityInstanceEntity actInst;
                    String nodeId = pj.getNodeId();
                    activityIds.add(nodeId);
                    if (!nodeId.contains("CallActivity") || (actInst = (HistoricActivityInstanceEntity)commandContext.getHistoricActivityInstanceEntityManager().findById(pj.getActInstId())).getExecutionType().equals("skip")) continue;
                    throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{ResManager.loadKDString((String)"\u7ecf\u8fc7\u5b50\u6d41\u7a0b\u4e14\u5df2\u7ecf\u5b50\u6d41\u7a0b\u5df2\u7ecf\u5ba1\u6279\u7ed3\u675f\u3002", (String)"ExecutionWithdrawValidator_3", (String)"bos-wf-engine", (Object[])new Object[0])});
                }
            }
            activityIds.add(currentActId);
            activityIds.add(h.getLastUserNodeActId());
            curActInstIds.add(h.getCurrentActinstId());
        }
        if (!isApproved && WfUtils.isNotEmpty(procInst.getSuperExecutionId())) {
            throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{ResManager.loadKDString((String)"\u5b58\u5728\u7236\u6d41\u7a0b\uff0c\u53ea\u80fd\u5728\u7236\u6d41\u7a0b\u64a4\u56de\u4efb\u52a1\u3002", (String)"UpgradeWithdrawTaskCmd_106", (String)"bos-wf-engine", (Object[])new Object[0])});
        }
        if (hasCallActivity) {
            List<HistoricProcessInstanceEntity> subHiProcInsts = commandContext.getHistoricProcessInstanceEntityManager().findChildExecutionsByProcessInstanceId(procInst.getId());
            ArrayList<Long> subHiProcInstIds = new ArrayList<Long>(16);
            for (HistoricProcessInstanceEntity hiProcInst : subHiProcInsts) {
                if (hiProcInst.getEndTime() != null) continue;
                subHiProcInstIds.add(hiProcInst.getId());
            }
            if (!subHiProcInstIds.isEmpty()) {
                this.withdrawCmd.setSubProcInstIds(subHiProcInstIds);
                QFilter procfilter = new QFilter("proInstId", "in", subHiProcInstIds);
                QFilter endfilter = new QFilter("endTime", "is not null", null);
                boolean subProcIsApproved = commandContext.getHiUserActInstEntityManager().exist(new QFilter[]{procfilter, endfilter});
                logger.debug("\u5b58\u5728\u5b50\u6d41\u7a0b" + subProcIsApproved + WfUtils.listToString(subHiProcInstIds, ","));
                if (subProcIsApproved) {
                    throw new KDException(WFErrorCode.canNotWithdraw(), new Object[]{ResManager.loadKDString((String)"\u5b58\u5728\u5b50\u6d41\u7a0b\u4e14\u5b50\u6d41\u7a0b\u5df2\u7ecf\u5ba1\u6279\u3002", (String)"ExecutionWithdrawValidator_2", (String)"bos-wf-engine", (Object[])new Object[0])});
                }
            }
        }
    }
}

