/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.testing;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.entity.SaveEntityCmd;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.cases.PathItem;
import kd.bos.workflow.engine.impl.persistence.entity.cases.TestingCaseEntity;
import kd.bos.workflow.engine.impl.persistence.entity.cases.TestingDecisionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.cases.TestingPathEntity;
import kd.bos.workflow.engine.impl.persistence.entity.cases.TestingPlanEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;

public class ConvertSchemeToCaseCmd
implements Command<TestingPlanEntity>,
Serializable {
    private static final long serialVersionUID = 32706514480687865L;
    private Long schemeId;
    private Long businessKey;
    private Map<String, Object> param;
    private static final String DECISIONS = "decisions";

    public ConvertSchemeToCaseCmd(Long schemeId, Long businessKey, Map<String, Object> param) {
        this.schemeId = schemeId;
        this.businessKey = businessKey;
        this.param = param;
    }

    @Override
    public TestingPlanEntity execute(CommandContext commandContext) {
        List decisionList;
        if (WfUtils.isEmpty(this.schemeId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65b9\u6848\u4e3a\u7a7a", (String)"ConvertSchemeToCaseCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        DynamicConfigSchemeEntity scheme = (DynamicConfigSchemeEntity)commandContext.getDynamicConfigSchemeEntityManager().findById(this.schemeId);
        Long procDefId = scheme.getProcDefId();
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)commandContext.getProcessDefinitionEntityManager().findById(procDefId);
        ResourceEntity resource = (ResourceEntity)commandContext.getResourceEntityManager().findById(processDefinition.getResourceId());
        String entityNumber = processDefinition.getEntraBill();
        LocaleString entityName = WfUtils.getEntityName(entityNumber, this.businessKey.toString());
        String processKey = processDefinition.getKey();
        String version = processDefinition.getVersion();
        String processName = processDefinition.getName().getLocaleValue();
        DeployFile deployfile = Context.getProcessEngineConfiguration().getRepositoryService().getExportScheme(procDefId);
        String processresource = deployfile.getFileContent();
        DynamicObject billObj = WfUtils.findBusinessObject(this.businessKey.toString(), entityNumber);
        String billJson = DataEntitySerializer.serializerToString((Object)billObj, (boolean)false, (boolean)true);
        TestingCaseEntity testingCase = null;
        QFilter[] filters = new QFilter[]{new QFilter("procdefid", "=", (Object)procDefId)};
        List testingCases = commandContext.getTestingCaseEntityManager().findByQueryFilters(filters);
        long count = 0L;
        if (testingCases != null && !testingCases.isEmpty()) {
            testingCase = (TestingCaseEntity)testingCases.get(0);
            filters = new QFilter[]{new QFilter("caseid", "=", (Object)testingCase.getId())};
            count = commandContext.getTestingPlanEntityManager().countByFilter("caseid", filters, false);
        } else {
            testingCase = (TestingCaseEntity)commandContext.getTestingCaseEntityManager().create();
            testingCase.setEnable(true);
            testingCase.setName((ILocaleString)new LocaleString(String.format(ResManager.loadKDString((String)"%s\u6d4b\u8bd5\u6848\u4f8b", (String)"ConvertSchemeToCaseCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]), processName)));
            testingCase.setNumber(String.format("%s-%s-TESTCASE", processKey, version));
            testingCase.setProcDefId(procDefId);
            testingCase.setProcessResource(processresource);
            new SaveEntityCmd<TestingCaseEntity>(testingCase).execute(commandContext);
        }
        TestingPlanEntity testingPlan = (TestingPlanEntity)commandContext.getTestingPlanEntityManager().create();
        testingPlan.setCaseId(testingCase.getId());
        testingPlan.setBusinesskey(this.businessKey.toString());
        testingPlan.setEntityNumber(entityNumber);
        testingPlan.setEntityName((ILocaleString)entityName);
        testingPlan.setBillJson(billJson);
        testingPlan.setEnable(true);
        testingPlan.setAutoTest(true);
        testingPlan.setName((ILocaleString)new LocaleString(String.format(ResManager.loadKDString((String)"%s\u9ed8\u8ba4\u6d4b\u8bd5\u8ba1\u5212", (String)"ConvertProcessInstanceToCaseCmd_4", (String)"bos-wf-engine", (Object[])new Object[0]), processName)));
        testingPlan.setNumber(String.format("%s-%s-TESTPLAN-%s", processKey, version, count));
        String currentUserId = RequestContext.get().getUserId();
        Long userId = currentUserId == null ? 0L : Long.parseLong(currentUserId);
        ILocaleString userName = WfUtils.findUserName(userId);
        testingPlan.setStarterId(userId);
        testingPlan.setStarterName(userName);
        testingPlan.setSchemeId(this.schemeId);
        ILocaleString schemeName = scheme.getName();
        for (String key : schemeName.keySet()) {
            schemeName.setItem(key, (Object)String.format("%s/%s/%s", processKey, version, schemeName.get((Object)key)));
        }
        testingPlan.setSchemeName(schemeName);
        testingPlan.setState("notrunning");
        if (WfUtils.isNotEmptyString(this.param.get("testingplandes"))) {
            String desStr = (String)this.param.get("testingplandes");
            LocaleString description = new LocaleString();
            description = WfUtils.getMultiLangValue(desStr);
            testingPlan.setDescription((ILocaleString)description);
        }
        new SaveEntityCmd<TestingPlanEntity>(testingPlan).execute(commandContext);
        String paths = (String)this.param.get("paths");
        List pathList = SerializationUtils.fromJsonStringToList((String)paths, PathItem.class);
        if (null != pathList && !pathList.isEmpty()) {
            for (PathItem i : pathList) {
                TestingPathEntity pathItem = this.getPathItem(commandContext, processKey, resource, i);
                pathItem.setPlanId(testingPlan.getId());
                new SaveEntityCmd<TestingPathEntity>(pathItem).execute(commandContext);
            }
        }
        if (WfUtils.isNotEmptyString(this.param.get(DECISIONS)) && null != (decisionList = (List)JSONArray.parse((String)((String)this.param.get(DECISIONS)))) && !decisionList.isEmpty()) {
            for (Map m : decisionList) {
                TestingDecisionEntity testingDecision = (TestingDecisionEntity)commandContext.getTestingDecisionEntityManager().create();
                testingDecision.setPlanId(testingPlan.getId());
                testingDecision.setNodeId((String)m.get("nodeid"));
                testingDecision.setDecisions((String)m.get(DECISIONS));
                new SaveEntityCmd<TestingDecisionEntity>(testingDecision).execute(commandContext);
            }
        }
        return testingPlan;
    }

    private TestingPathEntity getPathItem(CommandContext commandContext, String procNum, ResourceEntity resource, PathItem pathItem) {
        TestingPathEntity item = (TestingPathEntity)commandContext.getTestingPathEntityManager().create();
        String displayNameMultiKey = String.format("%s_%s.name", procNum, pathItem.getNodeId());
        ILocaleString nodeName = BpmnModelUtil.getMultiLangFieldValueFromResource(resource, displayNameMultiKey, null);
        item.setNodeName(nodeName);
        item.setNodeId(pathItem.getNodeId());
        item.setActivityType(pathItem.getActivityType());
        item.setExecutionType(pathItem.getExecutionType());
        item.setDecision("");
        item.setAssigneeId(pathItem.getAssigneeId());
        item.setVariables(JSON.toJSONString(pathItem.getVariables()));
        item.setModifyExp(pathItem.getModifyExp());
        item.setSourceId(pathItem.getSourceId());
        item.setTargetId(pathItem.getTargetId());
        item.setStep(pathItem.getStep());
        item.setCycle(pathItem.getCycle());
        item.setLevel(pathItem.getLevel());
        return item;
    }
}

