/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.testing;

import java.io.Serializable;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.GetProcInstIdByBusinessKeyCMD;
import kd.bos.workflow.engine.impl.cmd.execution.DeleteAllRuntimeDatasByProcessInstanceIdCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.cases.TestingPlanEntity;

public class DeleteAllTestingPlanRunningDatasCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 3290926391281829723L;
    private Long testingPlanId;

    public DeleteAllTestingPlanRunningDatasCmd(Long testingPlanId) {
        this.testingPlanId = testingPlanId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        TestingPlanEntity testingPlanEntity = (TestingPlanEntity)commandContext.getTestingPlanEntityManager().findById(this.testingPlanId);
        if ("running".equals(testingPlanEntity.getState())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6d4b\u8bd5\u8ba1\u5212\u6b63\u5728\u8fd0\u884c\u4e2d\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"DeleteAllTestingPlanRunningDatasCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        commandContext.getTestingPlanEntityManager().delete(testingPlanEntity);
        String businessKey = testingPlanEntity.getNewBusinesskey();
        if (WfUtils.isNotEmpty(businessKey)) {
            Long procInstId = new GetProcInstIdByBusinessKeyCMD(businessKey).execute(commandContext);
            if (null != procInstId) {
                new DeleteAllRuntimeDatasByProcessInstanceIdCmd(procInstId).execute(commandContext);
            }
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)testingPlanEntity.getEntityNumber());
            DeleteServiceHelper.delete((IDataEntityType)type, (Object[])new Object[]{businessKey});
            QFilter[] qFilters = new QFilter[]{new QFilter("planid", "=", (Object)testingPlanEntity.getId())};
            commandContext.getTestingPathEntityManager().deleteByFilters(qFilters);
            commandContext.getTestingDecisionEntityManager().deleteByFilters(qFilters);
        }
        return null;
    }
}

