/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.testing;

import java.io.Serializable;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.job.HandleResult;
import kd.bos.workflow.engine.impl.cmd.testing.RunTestingPlanCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.cases.TestingPlanEntity;

public class RunTestingCaseCmd
implements Command<HandleResult>,
Serializable {
    private static final long serialVersionUID = 2051604285325559299L;
    private Log log = LogFactory.getLog(this.getClass());
    private List<Long> caseIds;
    private boolean republish;

    public RunTestingCaseCmd(List<Long> caseIds, boolean republish) {
        this.caseIds = caseIds;
        this.republish = republish;
    }

    @Override
    public HandleResult execute(CommandContext commandContext) {
        if (this.caseIds == null || this.caseIds.isEmpty()) {
            this.log.warn("\u8981\u8fd0\u884c\u7684\u6d4b\u8bd5\u6848\u4f8b\u96c6\u5408\u4e3a\u7a7a\uff01");
            return null;
        }
        HandleResult ret = new HandleResult();
        int successed = 0;
        int failed = 0;
        QFilter[] filters = null;
        filters = this.caseIds.size() == 1 ? new QFilter[]{new QFilter("caseid", "=", (Object)this.caseIds.get(0))} : new QFilter[]{new QFilter("caseid", "in", this.caseIds)};
        List planEntitys = commandContext.getTestingPlanEntityManager().findByQueryFilters(filters);
        int i = 0;
        for (TestingPlanEntity testingPlanEntity : planEntitys) {
            Long testingPlanId = testingPlanEntity.getId();
            try {
                new RunTestingPlanCmd(testingPlanId, i == 0 && this.republish, this.republish).execute(commandContext);
                ++successed;
            }
            catch (Exception e) {
                --i;
                ++failed;
                ret.setReason(e.getMessage());
                this.log.error(String.format("\u8fd0\u884c(\u542f\u52a8)\u6d4b\u8bd5\u8ba1\u5212 %s \u5931\u8d25\uff0c \u539f\u56e0\uff1a %s", testingPlanId, WfUtils.getExceptionStacktrace(e)));
            }
            ++i;
        }
        ret.setSuccessed(successed);
        ret.setFailed(failed);
        return ret;
    }
}

