/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.testing;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.EndEvent;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.deploy.ExportScheme;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.GetProcInstIdByBusinessKeyCMD;
import kd.bos.workflow.engine.impl.cmd.execution.DeleteAllRuntimeDatasByProcessInstanceIdCmd;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandConfig;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.CommandContextCloseListener;
import kd.bos.workflow.engine.impl.interceptor.CommandExecutor;
import kd.bos.workflow.engine.impl.persistence.entity.cases.TestingCaseEntity;
import kd.bos.workflow.engine.impl.persistence.entity.cases.TestingPathEntity;
import kd.bos.workflow.engine.impl.persistence.entity.cases.TestingPlanEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.service.WfTraceType;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class RunTestingPlanCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 2051604285325559299L;
    private static final String BILLNO = "billno";
    private Log log = LogFactory.getLog(this.getClass());
    private Long testingPlanId;
    private boolean republish;
    private boolean delay;
    private Random random;

    public RunTestingPlanCmd(Long testingPlanId, boolean republish) {
        this.testingPlanId = testingPlanId;
        this.republish = republish;
        this.random = new SecureRandom();
    }

    public RunTestingPlanCmd(Long testingPlanId, boolean republish, boolean delay) {
        this(testingPlanId, republish);
        this.delay = delay;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        TestingPlanEntity testPlan = (TestingPlanEntity)commandContext.getTestingPlanEntityManager().findById(this.testingPlanId);
        if ("running".equals(testPlan.getState())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6d4b\u8bd5\u8ba1\u5212\u6b63\u5728\u8fd0\u884c\u4e2d\uff0c\u4e0d\u80fd\u91cd\u590d\u8fd0\u884c\u3002", (String)"RunTestingPlanCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        try {
            WfTraceType.getOrCreate().setTesting(true);
            this.runTestingPlan(testPlan, commandContext);
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6d4b\u8bd5\u8ba1\u5212%1$s\u201c%2$s\u201d\u542f\u52a8\u5931\u8d25\uff0c\u539f\u56e0\uff1a%3$s\u3002", (String)"RunTestingPlanCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]), testPlan.getNumber(), testPlan.getId(), e.getMessage()));
        }
        finally {
            WfTraceType.getOrCreate().setTesting(false);
        }
        return null;
    }

    private void runTestingPlan(TestingPlanEntity testPlan, CommandContext commandContext) {
        Long procDefId;
        TestingCaseEntity testCase = (TestingCaseEntity)commandContext.getTestingCaseEntityManager().findById(testPlan.getCaseId());
        Long oriSchemeId = testPlan.getSchemeId();
        Long newSchemeId = null;
        boolean republished = false;
        if (this.republish) {
            newSchemeId = this.getRepublishedSchemeId(commandContext, testCase, oriSchemeId);
            republished = true;
        } else if (WfUtils.isNotEmpty(testCase.getSchemeMapJson())) {
            newSchemeId = this.getNewSchemeId(testCase.getSchemeMapJson(), oriSchemeId);
        } else if (commandContext.getDynamicConfigSchemeEntityManager().exist(oriSchemeId)) {
            newSchemeId = oriSchemeId;
        } else {
            newSchemeId = this.getRepublishedSchemeId(commandContext, testCase, oriSchemeId);
            republished = true;
        }
        Long l = procDefId = WfUtils.isNotEmpty(testCase.getNewProcdefId()) ? testCase.getNewProcdefId() : testCase.getProcDefId();
        if (republished || this.delay) {
            commandContext.addCloseListener(new TestingPlanRepublishedProcessListener(testPlan, procDefId, newSchemeId));
        } else {
            this.submitBillAndUpdateTestingPlan(commandContext, testPlan, procDefId, newSchemeId);
        }
    }

    private void submitBillAndUpdateTestingPlan(CommandContext commandContext, TestingPlanEntity testPlan, Long procDefId, Long newSchemeId) {
        BillInfo bill = this.submitBill(commandContext, testPlan.getEntityNumber(), testPlan, newSchemeId);
        ProcessDefinitionEntity procDef = (ProcessDefinitionEntity)commandContext.getProcessDefinitionEntityManager().findById(procDefId);
        this.startProcessInstance(bill.getBusinessKey(), testPlan.getStarterId(), newSchemeId, procDef.getKey(), procDef.getVersion());
        this.updateTestingPlan(commandContext, testPlan, bill, newSchemeId, procDef);
    }

    private Long getRepublishedSchemeId(CommandContext commandContext, TestingCaseEntity testCase, Long oriSchemeId) {
        this.log.debug(String.format("\u91cd\u65b0\u5bfc\u5165\u65b9\u6848... \u6d4b\u8bd5\u8ba1\u5212ID\uff1a%s", this.testingPlanId));
        this.importSchemeAndUpdateTestcase(commandContext, testCase);
        return this.getNewSchemeId(testCase.getSchemeMapJson(), oriSchemeId);
    }

    private Long getNewSchemeId(String schemeMapJson, Long oriSchemeId) {
        JSONObject schemeIdMap = JSONObject.parseObject((String)schemeMapJson);
        Long schemeId = schemeIdMap.getLong(String.valueOf(oriSchemeId));
        return schemeId;
    }

    private void updateTestingPlan(CommandContext commandContext, TestingPlanEntity testPlan, BillInfo bill, Long schemeId, ProcessDefinitionEntity procDef) {
        testPlan.setNewSchemeId(schemeId);
        this.cleanOldBillInfo(commandContext, testPlan);
        testPlan.setNewBusinesskey(bill.getBusinessKey());
        testPlan.setBillNo(bill.getBillNo());
        ILocaleString schemeName = this.getSchemeName(testPlan, procDef);
        testPlan.setSchemeName(schemeName);
        testPlan.setResultInfo(null);
        testPlan.setErrorInfo(null);
        testPlan.setState("running");
        testPlan.setStartTime(WfUtils.now());
        testPlan.setEndTime(null);
        commandContext.getTestingPlanEntityManager().update(testPlan);
    }

    private ILocaleString getSchemeName(TestingPlanEntity testPlan, ProcessDefinitionEntity procDef) {
        ILocaleString schemeName = testPlan.getSchemeName();
        for (String key : schemeName.keySet()) {
            String name = (String)schemeName.get((Object)key);
            if (!WfUtils.isNotEmpty(name)) continue;
            String schemeNameRep = name.replaceFirst(".+/.+/(.+)", "$1");
            String newSchemeName = String.format("%s/%s/%s", procDef.getKey(), procDef.getVersion(), schemeNameRep);
            schemeName.setItem(key, (Object)newSchemeName);
        }
        return schemeName;
    }

    private void startProcessInstance(String businessKey, Long initiator, Long schemeId, String procKey, String procVersion) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("_businessKey_", businessKey);
        variables.put("_initiator_", String.valueOf(initiator));
        variables.put("SCHEMEID", schemeId);
        variables.put("testingPlanId", this.testingPlanId);
        this.log.debug(String.format("\u6d4b\u8bd5\u8ba1\u5212\u542f\u52a8\u6d41\u7a0b\uff1aKey-Version\uff1a%s-%s  Param\uff1a%s", procKey, procVersion, variables));
        WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        service.startProcessInstanceByKeyAndVersion(businessKey, procKey, procVersion, variables);
    }

    private void importSchemeAndUpdateTestcase(CommandContext commandContext, TestingCaseEntity testCase) {
        DcxmlSerializer serializer = new DcxmlSerializer(ExportScheme.getDCBinder());
        serializer.setColloctionIgnorePKValue(true);
        ExportScheme exportScheme = (ExportScheme)serializer.deserializeFromString(testCase.getProcessResource(), null);
        Map<String, Object> newProcDefIdAndSchemes = Context.getProcessEngineConfiguration().getRepositoryService().importScheme(exportScheme, false);
        Long newProcDefId = (Long)newProcDefIdAndSchemes.get("newProcDefId");
        testCase.setNewProcdefId(newProcDefId);
        JSONObject schemeIdMap = new JSONObject();
        List schemes = (List)newProcDefIdAndSchemes.get("configSchemeEntities");
        for (DynamicConfigSchemeEntity scheme : schemes) {
            schemeIdMap.put(String.valueOf(scheme.getOldSchemeId()), (Object)scheme.getId());
        }
        testCase.setSchemeMapJson(JSONObject.toJSONString((Object)schemeIdMap));
        commandContext.getTestingCaseEntityManager().update(testCase);
    }

    private BillInfo submitBill(CommandContext commandContext, String entityNumber, TestingPlanEntity testPlan, Long newSchemeId) {
        DynamicObject billObj = WfUtils.findBusinessObject(testPlan.getBusinesskey(), entityNumber);
        if (null == billObj) {
            String billJson = testPlan.getBillJson();
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            billObj = (DynamicObject)DataEntitySerializer.deSerializerFromString((String)billJson, (IDataEntityType)entityType);
        }
        String billno = null;
        OperationResult ret = null;
        OperateOption options = OperateOption.create();
        options.setVariableValue("WF", "TRUE");
        options.setVariableValue("ishasright", String.valueOf(true));
        options.setVariableValue("isStrict", String.valueOf(false));
        options.setVariableValue("ignoreinteraction", String.valueOf(true));
        options.setVariableValue("ignorewarn", String.valueOf(true));
        if (WfUtils.isEmptyString(testPlan.getNewBusinesskey()) && "A".equals(billObj.get("billstatus"))) {
            billno = (String)billObj.get(BILLNO);
            ret = this.doSubmitOperate(entityNumber, billObj, options, newSchemeId);
        } else {
            if (billObj.getDynamicObjectType().getProperty(BILLNO) != null) {
                String currentDate = new SimpleDateFormat("MMdd").format(new Date());
                Integer suffix = this.random.nextInt(100000);
                String entityNumberPre = entityNumber;
                if (entityNumberPre.length() > 19) {
                    entityNumberPre = entityNumberPre.substring(0, 19);
                }
                billno = String.format("%s-%s-%s", entityNumberPre, currentDate, suffix.toString());
                billObj.set(BILLNO, (Object)billno);
                billObj.set("billstatus", (Object)"A");
            }
            Object newBill = OrmUtils.clone((IDataEntityBase)billObj, (boolean)false, (boolean)true);
            this.log.debug(String.format("\u6d4b\u8bd5\u8ba1\u5212\u63d0\u4ea4\u5355\u636e\uff1a%s %s", entityNumber, billno));
            ret = this.doSubmitOperate(entityNumber, (DynamicObject)newBill, options, newSchemeId);
        }
        if (null != ret && ret.isSuccess()) {
            return new BillInfo(String.valueOf(ret.getSuccessPkIds().get(0)), billno);
        }
        StringBuilder sb = new StringBuilder();
        if (null != ret) {
            List validateResults;
            if (WfUtils.isNotEmpty(ret.getMessage())) {
                sb.append(ret.getMessage()).append("[");
            }
            if (null != (validateResults = ret.getValidateResult().getValidateErrors()) && !validateResults.isEmpty()) {
                for (ValidateResult vr : validateResults) {
                    List errorInfos = vr.getAllErrorInfo();
                    if (null == errorInfos || errorInfos.isEmpty()) continue;
                    for (OperateErrorInfo oei : errorInfos) {
                        sb.append(oei.getMessage()).append(" ");
                    }
                }
            }
            sb.append("]");
        }
        throw new KDBizException(sb.toString());
    }

    private OperationResult doSubmitOperate(String entityNumber, DynamicObject billObj, OperateOption options, Long schemeId) {
        List<EndEvent> endEventList;
        EndEvent endEvent;
        String optNumber = "";
        WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        BpmnModel bpmnModel = service.getManagementService().getDynamicConfigSchemeBpmnModel(schemeId);
        List<FlowElement> allNodes = bpmnModel.getPreviousNodes((endEvent = (endEventList = bpmnModel.getMainProcess().findFlowElementsOfType(EndEvent.class)).get(0)).getId());
        if (null != allNodes && !allNodes.isEmpty()) {
            for (FlowElement element : allNodes) {
                if (null == element || !"UserTask".equals(element.getType()) || null == element.getDecisionOptions() || element.getDecisionOptions().isEmpty()) continue;
                DecisionOption dOption = (DecisionOption)element.getDecisionOptions().get(0);
                optNumber = dOption.getNumber();
                break;
            }
        }
        if (WfUtils.isEmptyString(optNumber)) {
            optNumber = "submit";
        }
        OperationResult ret = OperationServiceHelper.executeOperate((String)optNumber, (String)entityNumber, (DynamicObject[])new DynamicObject[]{billObj}, (OperateOption)options);
        return ret;
    }

    private Map<String, String> getFirstModifyExp(List<TestingPathEntity> pathList) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        if (null != pathList && !pathList.isEmpty()) {
            for (TestingPathEntity item : pathList) {
                String[] kvSet;
                if (!"UserTask".equals(item.getActivityType()) || !WfUtils.isNotEmpty(item.getModifyExp())) continue;
                String expStr = item.getModifyExp().trim();
                if (expStr.length() <= 1 || !expStr.startsWith("{") || !expStr.endsWith("}") || (kvSet = (expStr = expStr.substring(1, expStr.length() - 1)).split("==")).length < 1) break;
                String key = kvSet[0];
                String value = kvSet.length > 1 ? kvSet[1] : "";
                retMap.put(key, value);
                break;
            }
        }
        return retMap;
    }

    private void cleanOldBillInfo(CommandContext commandContext, TestingPlanEntity testPlan) {
        String oldBusinessKey = testPlan.getNewBusinesskey();
        if (WfUtils.isNotEmptyString(oldBusinessKey) && !oldBusinessKey.equals(testPlan.getBusinesskey())) {
            Long procInstId = new GetProcInstIdByBusinessKeyCMD(oldBusinessKey).execute(commandContext);
            if (null != procInstId) {
                new DeleteAllRuntimeDatasByProcessInstanceIdCmd(procInstId).execute(commandContext);
            }
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)testPlan.getEntityNumber());
            DeleteServiceHelper.delete((IDataEntityType)type, (Object[])new Object[]{oldBusinessKey});
        }
    }

    class TestingPlanRepublishedProcessListener
    implements CommandContextCloseListener {
        private TestingPlanEntity testPlan;
        private Long procDefId;
        private Long newSchemeId;

        public TestingPlanRepublishedProcessListener(TestingPlanEntity testPlan, Long procDefId, Long newSchemeId) {
            this.testPlan = testPlan;
            this.procDefId = procDefId;
            this.newSchemeId = newSchemeId;
        }

        @Override
        public void closing(CommandContext commandContext) {
        }

        @Override
        public void afterSessionsFlush(CommandContext commandContext) {
        }

        @Override
        public void closed(CommandContext commandContext) {
            CommandExecutor commandExecutor = commandContext.getProcessEngineConfiguration().getCommandExecutor();
            CommandConfig commandConfig = commandExecutor.getDefaultConfig().transactionRequiresNew();
            commandExecutor.execute(commandConfig, new Command<Void>(){

                @Override
                public Void execute(CommandContext commandContext) {
                    RunTestingPlanCmd.this.submitBillAndUpdateTestingPlan(commandContext, TestingPlanRepublishedProcessListener.this.testPlan, TestingPlanRepublishedProcessListener.this.procDefId, TestingPlanRepublishedProcessListener.this.newSchemeId);
                    return null;
                }
            });
        }

        @Override
        public void closeFailure(CommandContext commandContext) {
        }
    }

    static class BillInfo {
        private String businessKey;
        private String billNo;

        public BillInfo(String businessKey, String billNo) {
            this.businessKey = businessKey;
            this.billNo = billNo;
        }

        public String getBusinessKey() {
            return this.businessKey;
        }

        public void setBusinessKey(String businessKey) {
            this.businessKey = businessKey;
        }

        public String getBillNo() {
            return this.billNo;
        }

        public void setBillNo(String billNo) {
            this.billNo = billNo;
        }
    }
}

