/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.testing;

import java.lang.reflect.InvocationTargetException;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.validation.validator.util.BpmnNodeValidateUtil;
import org.apache.commons.beanutils.MethodUtils;

public class ValidateBpmnNodeCmd
implements Command<Void> {
    private Long procInstId;
    private Long executionId;
    private Long taskId;

    public ValidateBpmnNodeCmd(Long procInstId, Long executionId, Long taskId) {
        this.procInstId = procInstId;
        this.executionId = executionId != null ? executionId : 0L;
        this.taskId = taskId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (!this.canValidate(commandContext)) {
            return null;
        }
        HistoricProcessInstanceEntity procInstEntity = (HistoricProcessInstanceEntity)commandContext.getHistoricProcessInstanceEntityManager().findById(this.procInstId);
        Long testingPlanId = procInstEntity.getTestingPlanId();
        try {
            Object obj = TypesContainer.createInstance((String)"kd.bos.workflow.validator.BpmnNodeValidator");
            if (obj != null) {
                MethodUtils.invokeMethod((Object)obj, (String)"validate", (Object[])new Object[]{this.procInstId, this.executionId, testingPlanId, this.taskId});
            }
        }
        catch (InvocationTargetException e) {
            String error = WfUtils.getExceptionStacktrace(e);
            this.recordValidateFailed(commandContext, testingPlanId, error);
        }
        catch (Exception e) {
            String error = WfUtils.getExceptionStacktrace(e);
            this.recordValidateFailed(commandContext, testingPlanId, error);
        }
        return null;
    }

    private boolean canValidate(CommandContext commandContext) {
        if (WfUtils.isEmpty(this.executionId)) {
            return true;
        }
        ExecutionEntity execution = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(this.executionId);
        if (!execution.isActive()) {
            return false;
        }
        HistoricActivityInstanceEntity hiactInst = commandContext.getHistoricActivityInstanceEntityManager().findActivityByTaskId(execution.getCurrentTaskId());
        ExecutionEntity parentExecution = execution.getParent();
        String VALIDATED_KEY = String.format("%s_%s", "validated", execution.getBusinessKey());
        if (null != hiactInst && "YunzhijiaTask".equals(hiactInst.getActivityType())) {
            try (DLock lock = DLock.create((String)String.format("wf/testingPlanMultiInstNode/%s", parentExecution.getId()), (String)String.format(ResManager.loadKDString((String)"\u4f1a\u5ba1\u8282\u70b9\u662f\u5426\u53ef\u6821\u9a8c[%s]", (String)"ValidateBpmnNodeCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]), parentExecution.getId())).fastMode();){
                boolean canValidate;
                lock.lock();
                Long taskParentId = execution.getCurrentTask().getParentTaskId();
                String[] validatedIds = WfCacheHelper.getTestingPlanData(VALIDATED_KEY);
                if (null != validatedIds && validatedIds.length > 0) {
                    for (String id : validatedIds) {
                        if (!id.equals(taskParentId + "")) continue;
                        boolean bl = false;
                        return bl;
                    }
                }
                QFilter[] filters = new QFilter[]{new QFilter("parentTaskId", "=", (Object)parentExecution.getCurrentTaskId())};
                int number = (Integer)parentExecution.getVariable("nrOfInstances");
                long taskCount = commandContext.getTaskEntityManager().countByFilter("id", filters, true);
                boolean bl = canValidate = Long.parseLong("" + number) == taskCount;
                if (canValidate) {
                    WfCacheHelper.putTestingPlanData(VALIDATED_KEY, new String[]{taskParentId + ""});
                }
                boolean bl2 = canValidate;
                return bl2;
            }
        }
        return true;
    }

    private void recordValidateFailed(CommandContext commandContext, Long testingPlanId, String message) {
        BpmnNodeValidateUtil.recordValidateFailed(testingPlanId, message);
    }
}

