/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.concurrent;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.channel.cache.MsgServiceCacheHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.concurrent.ConcurrentBizPluginFactory;
import kd.bos.workflow.engine.impl.concurrent.ConcurrentBizType;
import kd.bos.workflow.engine.impl.concurrent.ConcurrentData;
import kd.bos.workflow.engine.impl.concurrent.ConcurrentDataDealResult;
import kd.bos.workflow.engine.impl.concurrent.ConcurrentDataDealService;
import kd.bos.workflow.engine.impl.concurrent.ConcurrentDataState;
import kd.bos.workflow.engine.impl.concurrent.RegulationConfig;

public class ConcurrentDataThread
implements Runnable {
    private Log logger = LogFactory.getLog(this.getClass());
    private static final int maxEmptyLoopTimes = 100;
    public static final int MAXDEALQSINFOS = 500000;
    private ConcurrentDataDealService concurrentDataDealService = null;
    private ConcurrentBizType bizType;

    public ConcurrentDataThread(ConcurrentBizType bizType) {
        this.bizType = bizType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.logger.debug(String.format("dealConcurrentBizData_thread, ready for start newThread, bizType[%s] ", this.bizType.getType()));
            String key = "wf_dealConcurrentData_" + this.bizType.getType();
            String descption = "use lock and traceId_" + RequestContext.get().getTraceId();
            try (DLock lock = DLock.create((String)String.format(key, new Object[0]), (String)descption).fastMode();){
                boolean lockSuccess = lock.tryLock(60000L);
                if (lockSuccess) {
                    this.logger.debug(String.format("dealConcurrentBizData_thread, get lock, bizType[%s] ", this.bizType.getType()));
                    this.dealBizData();
                }
            }
        }
        catch (Exception e) {
            this.logger.error("dealConcurrentBizData_thread, run thread to deal biz data has error:" + WfUtils.getExceptionStacktrace(e));
        }
        finally {
            MsgServiceCacheHelper.removeConcurrentDataSign((String)this.bizType.getType());
        }
    }

    private void dealBizData() {
        boolean isBreakLoops = Boolean.FALSE;
        int emptyLoopTimes = 0;
        int dealQSInfosCount = 0;
        int max_dealQSInfosCount = WfConfigurationUtil.getMaxDealQSInfos();
        do {
            try {
                QFilter f2;
                if (emptyLoopTimes >= 100) {
                    this.logger.debug("ConcurrentDataThread_emptyLoopTimes_break:");
                    break;
                }
                this.concurrentDataDealService = ConcurrentBizPluginFactory.getPlugin(this.bizType);
                QFilter f1 = new QFilter("type", "=", (Object)this.bizType.getType());
                DynamicObject[] dataArray = BusinessDataServiceHelper.load((String)"wf_concurrentdata", (String)"id,data,param,modifydate,state,createdate,creater", (QFilter[])new QFilter[]{f1, f2 = new QFilter("state", "=", (Object)ConcurrentDataState.CREATE.getState())}, (String)"createdate", (int)this.concurrentDataDealService.maxQueryDatas());
                if (dataArray != null && dataArray.length > 0) {
                    emptyLoopTimes = 0;
                    ConcurrentDataDealResult dealResult = this.dealData(dataArray);
                    if (dealResult == null || dealResult.getConcurrentDataIds() == null || dealResult.getConcurrentDataIds().isEmpty()) {
                        isBreakLoops = Boolean.TRUE;
                        continue;
                    }
                    if ((dealQSInfosCount += dealResult.getConcurrentDataIds().size()) < max_dealQSInfosCount) continue;
                    this.logger.debug(String.format("dealConcurrentBizData_thread dealData count[%s] more than [%s], so break loop.", dealQSInfosCount, max_dealQSInfosCount));
                    isBreakLoops = Boolean.TRUE;
                    continue;
                }
                Thread.sleep(50L);
                String concurrentCounter = MsgServiceCacheHelper.getConcurrentCounter((String)this.bizType.getType());
                if (concurrentCounter != null && Integer.parseInt(concurrentCounter) > 0) {
                    this.logger.debug("ConcurrentDataThread_emptyLoopTimes:" + emptyLoopTimes);
                    ++emptyLoopTimes;
                    continue;
                }
                isBreakLoops = Boolean.TRUE;
            }
            catch (Exception e) {
                this.logger.error("dealConcurrentBizData_thread has error" + WfUtils.getExceptionStacktrace(e));
                isBreakLoops = Boolean.TRUE;
            }
        } while (!isBreakLoops);
    }

    private ConcurrentDataDealResult dealData(DynamicObject[] dataArray) {
        ArrayList<ConcurrentData> concurrentDatas = new ArrayList<ConcurrentData>(dataArray.length);
        for (DynamicObject dc : dataArray) {
            concurrentDatas.add(this.packageConcurrentData(dc));
        }
        if (!this.canContinueDealData(concurrentDatas)) {
            return null;
        }
        ConcurrentDataDealResult dealResult = this.concurrentDataDealService.dealConcurrentDataToBizDB(concurrentDatas);
        if (dealResult == null) {
            return dealResult;
        }
        this.afterDealData(dealResult, dataArray);
        return dealResult;
    }

    private boolean canContinueDealData(List<ConcurrentData> concurrentDatas) {
        Date lastDate;
        long lastTime;
        RegulationConfig regulationConfig = this.concurrentDataDealService.getRegulationConfig();
        if (regulationConfig == null) {
            return true;
        }
        int minDataSize = regulationConfig.getMinDataSize();
        if (minDataSize <= 0) {
            return true;
        }
        if (concurrentDatas.size() >= minDataSize) {
            return true;
        }
        long minTimeSpan = regulationConfig.getMinTimeSpan();
        if (minTimeSpan <= 0L) {
            return false;
        }
        Date firstDate = concurrentDatas.get(0).getCreaterDate();
        long firstTime = firstDate.getTime();
        if (firstTime + minTimeSpan * 1000L > (lastTime = (lastDate = concurrentDatas.get(concurrentDatas.size() - 1).getCreaterDate()).getTime())) {
            this.logger.debug(String.format("dealConcurrentBizData_thread canContinueDealData size[%s]", concurrentDatas.size()));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void afterDealData(ConcurrentDataDealResult dealResult, DynamicObject[] dataArray) {
        List<Long> concurrentDataIds = dealResult.getConcurrentDataIds();
        if (concurrentDataIds == null || concurrentDataIds.isEmpty()) {
            return;
        }
        try (TXHandle tx = TX.requiresNew((String)"ConcurrentDataThread_afterDealData");){
            boolean isClear = dealResult.isClear();
            if (isClear) {
                QFilter[] filters = new QFilter[]{new QFilter("id", "in", concurrentDataIds)};
                DeleteServiceHelper.delete((String)"wf_concurrentdata", (QFilter[])filters);
            } else {
                ArrayList<DynamicObject> updateDynamicObjects = new ArrayList<DynamicObject>(concurrentDataIds.size());
                for (DynamicObject dataObject : dataArray) {
                    if (!concurrentDataIds.contains(dataObject.getLong("id"))) continue;
                    dataObject.set("state", (Object)ConcurrentDataState.DEALDONE.getState());
                    dataObject.set("modifydate", (Object)WfUtils.now());
                    updateDynamicObjects.add(dataObject);
                }
                if (!updateDynamicObjects.isEmpty()) {
                    DynamicObject[] data = new DynamicObject[updateDynamicObjects.size()];
                    SaveServiceHelper.save((DynamicObject[])updateDynamicObjects.toArray(data));
                }
            }
            MsgServiceCacheHelper.decrConcurrentCounter((String)this.bizType.getType(), (int)concurrentDataIds.size());
        }
    }

    private ConcurrentData packageConcurrentData(DynamicObject data) {
        ConcurrentData concurrentData = new ConcurrentData();
        concurrentData.setId(data.getLong("id"));
        concurrentData.setData(data.getString("data"));
        concurrentData.setCreator(data.getLong("creater"));
        concurrentData.setCreaterDate(data.getDate("createdate"));
        Map params = null;
        String param = data.getString("param");
        if (WfUtils.isNotEmpty(param)) {
            params = (Map)SerializationUtils.fromJsonString((String)param, Map.class);
        }
        concurrentData.setParam(params);
        return concurrentData;
    }
}

