/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.concurrent.impl;

import java.util.Arrays;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.clean.calculator.CleanDataCalculator;
import kd.bos.workflow.engine.impl.concurrent.ConcurrentData;
import kd.bos.workflow.engine.impl.concurrent.ConcurrentDataDealResult;
import kd.bos.workflow.engine.impl.concurrent.ConcurrentDataDealService;
import kd.bos.workflow.engine.impl.concurrent.RegulationConfig;

public class BecDealConsumerServiceImpl
implements ConcurrentDataDealService {
    private Log logger = LogFactory.getLog(this.getClass());
    private String traceId = null;
    public static final String DATASIZE = "dataSize";
    public static final String TIMESDPAN = "timeSpan";
    RegulationConfig regulationConfig = new RegulationConfig();

    @Override
    public RegulationConfig getRegulationConfig() {
        String currentTraceId = RequestContext.get().getTraceId();
        if (!currentTraceId.equalsIgnoreCase(this.traceId)) {
            this.traceId = currentTraceId;
            int[] configs = WfConfigurationUtil.getBecTransformConfig();
            if (configs != null) {
                this.regulationConfig.setMinDataSize(configs[0]);
                this.regulationConfig.setMinTimeSpan(configs[1]);
            }
        }
        return this.regulationConfig;
    }

    @Override
    public ConcurrentDataDealResult dealConcurrentDataToBizDB(List<ConcurrentData> concurrentDatas) {
        ConcurrentDataDealResult dealResult = new ConcurrentDataDealResult();
        if (concurrentDatas == null || concurrentDatas.isEmpty()) {
            return null;
        }
        int size = concurrentDatas.size();
        Long[] dataIds = new Long[size];
        Long[] concurrentIds = new Long[size];
        try {
            for (int i = 0; i < size; ++i) {
                String data = concurrentDatas.get(i).getData();
                if (WfUtils.isNotEmpty(data)) {
                    dataIds[i] = Long.valueOf(data);
                }
                concurrentIds[i] = concurrentDatas.get(i).getId();
            }
            this.logger.debug(String.format("becConsumer_dealConcurrentData totalSize: [%s]", concurrentDatas.size()));
            String sourceEntityNumber = "evt_job";
            String targetEntityNumber = "evt_hijob";
            String sourceTableName = "t_evt_jobrecord";
            QFilter filter0 = new QFilter("id", "in", (Object)dataIds);
            QFilter[] filters = new QFilter[]{filter0};
            CleanDataCalculator.create().executeTransfer(sourceEntityNumber, targetEntityNumber, filters, false, sourceTableName);
        }
        catch (Exception e) {
            this.logger.error("msgqs_dealConcurrentData error:" + WfUtils.getExceptionStacktrace(e));
        }
        dealResult.setConcurrentDataIds(Arrays.asList(concurrentIds));
        dealResult.setDealSuccess(true);
        dealResult.setClear(true);
        return dealResult;
    }
}

