/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.concurrent.impl;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.dlock.DLockInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.channel.cache.MsgServiceCacheHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.concurrent.ConcurrentBizType;
import kd.bos.workflow.engine.impl.concurrent.ConcurrentDataService;
import kd.bos.workflow.engine.impl.concurrent.ConcurrentDataState;
import kd.bos.workflow.engine.impl.concurrent.ConcurrentDataThread;

public class ConcurrentDataServiceImpl
implements ConcurrentDataService {
    private Log logger = LogFactory.getLog(this.getClass());

    @Override
    public void gatherConcurrentData(String data, ConcurrentBizType bizType, Map<String, Object> param) {
        this.gatherConcurrentData(null, data, bizType, param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void gatherConcurrentData(Long creator, String data, ConcurrentBizType bizType, Map<String, Object> param) {
        if (bizType == null) {
            return;
        }
        this.logger.debug(String.format("gatherConcurrentData and data[%s]", data));
        DynamicObject concurrentData = BusinessDataServiceHelper.newDynamicObject((String)"wf_concurrentdata");
        concurrentData.set("type", (Object)bizType.getType());
        if (WfUtils.isNotEmpty(data)) {
            concurrentData.set("data", (Object)data);
        }
        concurrentData.set("state", (Object)ConcurrentDataState.CREATE.getState());
        if (WfUtils.isNotEmpty(creator)) {
            concurrentData.set("creater", (Object)creator);
        }
        concurrentData.set("param", (Object)(WfUtils.isEmptyForMap(param) ? " " : SerializationUtils.toJsonString(param)));
        try {
            try (TXHandle h = TX.requiresNew();){
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{concurrentData});
            }
            boolean isImmediatelyhandle = true;
            if (param != null && param.containsKey("isImmediatelyhandle")) {
                isImmediatelyhandle = (Boolean)param.get("isImmediatelyhandle");
            }
            if (isImmediatelyhandle) {
                MsgServiceCacheHelper.incConcurrentCounter((String)bizType.getType(), (int)172800);
                this.dealConcurrentBizData(bizType);
            }
        }
        catch (Exception e) {
            this.logger.error("gatherConcurrentData is error " + WfUtils.getExceptionStacktrace(e));
        }
    }

    private void dealConcurrentBizData(ConcurrentBizType bizType) {
        try {
            String concurrentDataSign = MsgServiceCacheHelper.getConcurrentDataSign((String)bizType.getType());
            if (WfUtils.isNotEmpty(concurrentDataSign)) {
                this.logger.debug("no redis sign and the deal thread exist");
                return;
            }
        }
        catch (Exception e) {
            this.logger.warn("query concurrent sign from redis is error " + WfUtils.getExceptionStacktrace(e));
        }
        MsgServiceCacheHelper.putConcurrentDatdSign((String)bizType.getType());
        String key = "wf_dealConcurrentData_" + bizType.getType();
        DLockInfo lockInfo = DLock.getLockInfo((String)key);
        if (lockInfo == null) {
            ThreadPools.executeOnceIncludeRequestContext((String)key, (Runnable)new ConcurrentDataThread(bizType));
            this.logger.debug(String.format("dealConcurrentBizData_thread, begine newThread deal data, bizType[%s]", bizType.getType()));
        } else {
            this.logger.debug("find lockinfo and the deal thread exist");
        }
    }
}

