/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.concurrent.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.concurrent.ConcurrentData;
import kd.bos.workflow.engine.impl.concurrent.ConcurrentDataDealResult;
import kd.bos.workflow.engine.impl.concurrent.ConcurrentDataDealService;
import kd.bos.workflow.engine.impl.concurrent.RegulationConfig;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.msg.quantitysum.MessageQuantitySummaryServcie;

public class CorrectLoginUserQSInfoServiceImpl
implements ConcurrentDataDealService {
    private static final Log logger = LogFactory.getLog(CorrectLoginUserQSInfoServiceImpl.class);
    public static final String BEFORECORRECTQSINFOS = "beforeCorrectQSInfos";
    public static final String AFTERCORRECTQSINFOS = "afterCorrectQSInfos";
    public static final String CORRECTCOMPARERESULT = "correctCompareResult";
    public static final String ENTITY_LOGINUSER = "msg_usercorrectlog";
    public static final int USERLOGINSAMPLESPACING_VALUE = 4;
    public static final String USERLOGINSAMPLESPACING = "userLoginSampleSpacing";
    public static final String TRIGGERUSERSIZE = "triggerUserSize";
    public static final String TRIGGERSPACING = "triggerSpacing";
    public static final String CLEARLOGINUSERSPACING = "clearLoginUserSpacing";
    private String traceId = null;
    private Map<String, Integer> userConfigs = new HashMap<String, Integer>();

    private void initLoginUserCorrectConfig() {
        String currentTraceId = RequestContext.get().getTraceId();
        if (this.traceId == null || !currentTraceId.equalsIgnoreCase(this.traceId)) {
            this.traceId = currentTraceId;
            String config = WfConfigurationUtil.getLoginUserCorrectConfig();
            if (config != null) {
                String[] configs = config.split(",");
                this.userConfigs.put(USERLOGINSAMPLESPACING, Integer.parseInt(configs[0]));
                this.userConfigs.put(TRIGGERUSERSIZE, Integer.parseInt(configs[1]));
                this.userConfigs.put(TRIGGERSPACING, Integer.parseInt(configs[2]));
                this.userConfigs.put(CLEARLOGINUSERSPACING, Integer.parseInt(configs[3]));
            } else {
                this.userConfigs.put(USERLOGINSAMPLESPACING, 2);
                this.userConfigs.put(TRIGGERUSERSIZE, 10);
                this.userConfigs.put(TRIGGERSPACING, 4);
                this.userConfigs.put(CLEARLOGINUSERSPACING, 30);
            }
        }
    }

    private int userLogsClearLine() {
        this.initLoginUserCorrectConfig();
        return this.userConfigs.get(CLEARLOGINUSERSPACING);
    }

    private int batchHandlePageSize() {
        this.initLoginUserCorrectConfig();
        return this.userConfigs.get(TRIGGERUSERSIZE);
    }

    @Override
    public RegulationConfig getRegulationConfig() {
        this.initLoginUserCorrectConfig();
        RegulationConfig regulationConfig = new RegulationConfig();
        regulationConfig.setMinDataSize(this.userConfigs.get(TRIGGERUSERSIZE));
        regulationConfig.setMinTimeSpan((long)this.userConfigs.get(TRIGGERSPACING).intValue() * 3600L);
        return regulationConfig;
    }

    @Override
    public int maxQueryDatas() {
        return 100;
    }

    @Override
    public ConcurrentDataDealResult dealConcurrentDataToBizDB(List<ConcurrentData> concurrentDatas) {
        ConcurrentDataDealResult dealResult = new ConcurrentDataDealResult();
        try {
            ArrayList<Long> concurrentDataIds = new ArrayList<Long>(concurrentDatas.size());
            HashMap<Long, Date> loginUser = new HashMap<Long, Date>();
            for (ConcurrentData concurrentData : concurrentDatas) {
                Long userId = concurrentData.getCreator();
                if (!loginUser.containsKey(userId)) {
                    loginUser.put(userId, concurrentData.getCreaterDate());
                }
                concurrentDataIds.add(concurrentData.getId());
            }
            ArrayList<Long> userIds = new ArrayList<Long>(loginUser.keySet());
            Map<Long, Map<String, Object>> correctResult = this.correctUserQSInfos(userIds);
            this.handleLoginUserLogs(loginUser, correctResult);
            dealResult.setDealSuccess(true);
            dealResult.setConcurrentDataIds(concurrentDataIds);
            dealResult.setClear(true);
            logger.debug(String.format("CorrectLoginUserQSInfoServiceImpl loginUser size[%s][%s]", concurrentDatas.size(), RequestContext.get().getTraceId()));
        }
        catch (Exception e) {
            logger.warn(String.format("CorrectLoginUserQSInfoServiceImpl has error:[%s]", WfUtils.getExceptionStacktrace(e)));
            try {
                this.clearLoginUserDatas();
            }
            catch (Exception e1) {
                logger.error(String.format("clearLoginUserDatas has error:[%s]", WfUtils.getExceptionStacktrace(e1)));
            }
            return null;
        }
        return dealResult;
    }

    private Map<Long, Map<String, Object>> correctUserQSInfos(List<Long> userIds) {
        HashMap<Long, Map<String, Object>> correctResult = new HashMap<Long, Map<String, Object>>();
        MessageQuantitySummaryServcie messageQuantitySummaryService = MessageServiceUtil.getMessageQuantitySummaryService();
        int batchCount = this.batchHandlePageSize();
        int totalCount = userIds.size();
        int pageCount = totalCount % batchCount != 0 ? totalCount / batchCount + 1 : totalCount / batchCount;
        for (int i = 0; i < pageCount; ++i) {
            List<Long> uIds = userIds.subList(i * batchCount, (i + 1) * batchCount > totalCount ? totalCount : (i + 1) * batchCount);
            Map<Long, Map<String, Object>> result = messageQuantitySummaryService.correctQuantitySummaryFromBizData(uIds);
            correctResult.putAll(result);
        }
        logger.debug("user correct over!");
        return correctResult;
    }

    private void handleLoginUserLogs(Map<Long, Date> loginUser, Map<Long, Map<String, Object>> correctResult) {
        Date correctTime = TimeServiceHelper.now();
        Set<Map.Entry<Long, Map<String, Object>>> entries = correctResult.entrySet();
        ArrayList<DynamicObject> updateUserLogins = new ArrayList<DynamicObject>(entries.size());
        for (Map.Entry<Long, Map<String, Object>> entry : entries) {
            Long userId = entry.getKey();
            Map<String, Object> ret = correctResult.get(userId);
            DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_LOGINUSER);
            log.set("userid", (Object)userId);
            log.set("correcttime", (Object)correctTime);
            log.set("logintime", (Object)loginUser.get(userId));
            log.set("config", ret.get(CORRECTCOMPARERESULT));
            updateUserLogins.add(log);
        }
        logger.debug(String.format("user correctResult calculate over![%s]", RequestContext.get().getTraceId()));
        if (!updateUserLogins.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])updateUserLogins.toArray(new DynamicObject[0]));
        }
        this.clearLoginUserDatas();
    }

    private void clearLoginUserDatas() {
        Date currentTime = TimeServiceHelper.now();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentTime);
        calendar.add(5, -this.userLogsClearLine());
        Date clearDate = calendar.getTime();
        QFilter[] filters = new QFilter[]{new QFilter("logintime", "<=", (Object)clearDate)};
        DeleteServiceHelper.delete((String)ENTITY_LOGINUSER, (QFilter[])filters);
    }
}

