/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.concurrent.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.channel.cache.MsgServiceCacheHelper;
import kd.bos.message.utils.personalSetting.MessageBussinessInfo;
import kd.bos.message.utils.personalSetting.MessageBussinessPublishUtil;
import kd.bos.message.utils.personalSetting.MessagePersonalSettingUtils;
import kd.bos.message.utils.personalSetting.PersonalSettingInfo;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.concurrent.ConcurrentData;
import kd.bos.workflow.engine.impl.concurrent.ConcurrentDataDealResult;
import kd.bos.workflow.engine.impl.concurrent.ConcurrentDataDealService;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.msg.quantitysum.IdModifyRecord;
import kd.bos.workflow.engine.msg.quantitysum.MessageQuantitySummaryServcie;
import kd.bos.workflow.engine.msg.quantitysum.QuantitySummary;
import kd.bos.workflow.engine.msg.quantitysum.QuantitySummaryInfo;

public class MessageQSConsurrentDataDealServiceImpl
implements ConcurrentDataDealService {
    private Log logger = LogFactory.getLog(this.getClass());

    @Override
    public ConcurrentDataDealResult dealConcurrentDataToBizDB(List<ConcurrentData> concurrentDatas) {
        ConcurrentDataDealResult dealResult = new ConcurrentDataDealResult();
        if (concurrentDatas == null || concurrentDatas.isEmpty()) {
            return dealResult;
        }
        ArrayList<Long> dataIds = new ArrayList<Long>(concurrentDatas.size());
        ArrayList<QuantitySummaryInfo> quantitySummaryInfos = new ArrayList<QuantitySummaryInfo>();
        for (ConcurrentData concurrentData : concurrentDatas) {
            String data = concurrentData.getData();
            List fromJsonStringToList = SerializationUtils.fromJsonStringToList((String)data, QuantitySummaryInfo.class);
            quantitySummaryInfos.addAll(fromJsonStringToList);
            dataIds.add(concurrentData.getId());
        }
        this.logger.debug(String.format("msgqs_dealConcurrentData totalSize: [%s]", concurrentDatas.size()));
        try {
            MessageQuantitySummaryServcie service = MessageServiceUtil.getMessageQuantitySummaryService();
            service.dealConcurrentQuantitySummary(quantitySummaryInfos);
        }
        catch (Exception e) {
            this.logger.error("msgqs_dealConcurrentData error:" + WfUtils.getExceptionStacktrace(e));
            dealResult.setDealSuccess(false);
        }
        dealResult.setConcurrentDataIds(dataIds);
        try {
            this.dealUserPersonalSettingData(quantitySummaryInfos);
        }
        catch (Exception e) {
            this.logger.error("msgqs_dealUserPersonalSettingData error:" + WfUtils.getExceptionStacktrace(e));
        }
        return dealResult;
    }

    private void dealUserPersonalSettingData(List<QuantitySummaryInfo> quantitySummaryInfos) {
        Object idModifyRecords;
        if (!MessagePersonalSettingUtils.enablePersonalSettingCache()) {
            return;
        }
        HashMap personalSettingInfos = new HashMap();
        HashSet<Long> directUpdatePersonalCacheUserIds = new HashSet<Long>();
        for (QuantitySummaryInfo qsInfo : quantitySummaryInfos) {
            idModifyRecords = qsInfo.getIdModifyRecords();
            Long userId = qsInfo.getUserId();
            if ("msg".equals(qsInfo.getDataType()) && (qsInfo.getQuantitysum() > 300 || qsInfo.getQuantitysum() < -300)) {
                directUpdatePersonalCacheUserIds.add(userId);
            }
            if (directUpdatePersonalCacheUserIds.contains(userId) || idModifyRecords.isEmpty() || !"tohandle".equals(qsInfo.getDataType()) && !"msg".equals(qsInfo.getDataType())) continue;
            ArrayList<PersonalSettingInfo> psList = new ArrayList<PersonalSettingInfo>(idModifyRecords.size());
            Iterator iterator = idModifyRecords.iterator();
            while (iterator.hasNext()) {
                IdModifyRecord idModifyRecord = (IdModifyRecord)iterator.next();
                Long sourceId = idModifyRecord.getId();
                Date date = idModifyRecord.getDate();
                PersonalSettingInfo.UpdateTypeEnum updateType = idModifyRecord.getQs() == QuantitySummary.PLUS ? PersonalSettingInfo.UpdateTypeEnum.ADDONE : PersonalSettingInfo.UpdateTypeEnum.DELETEONE;
                PersonalSettingInfo.SourceTypeEnum sourceType = idModifyRecord.getType() == IdModifyRecord.IdTypeEnum.TASK ? PersonalSettingInfo.SourceTypeEnum.TASK : PersonalSettingInfo.SourceTypeEnum.MESSAGE;
                PersonalSettingInfo personalSettingInfo = new PersonalSettingInfo(userId, sourceId, sourceType, updateType, date);
                String taskType = idModifyRecord.getParams().get("taskType");
                if (WfUtils.isNotEmpty(taskType)) {
                    personalSettingInfo.getParams().put("taskType", taskType);
                }
                psList.add(personalSettingInfo);
            }
            if (personalSettingInfos.containsKey(userId)) {
                ((List)personalSettingInfos.get(userId)).addAll(psList);
                continue;
            }
            personalSettingInfos.put(userId, psList);
        }
        if (personalSettingInfos.isEmpty() && directUpdatePersonalCacheUserIds.isEmpty()) {
            return;
        }
        HashMap<Long, List> canUpdatePersonalSettings = new HashMap<Long, List>(personalSettingInfos.size());
        if (!personalSettingInfos.isEmpty()) {
            Set entrySet = personalSettingInfos.entrySet();
            idModifyRecords = entrySet.iterator();
            while (idModifyRecords.hasNext()) {
                Map.Entry entry = (Map.Entry)idModifyRecords.next();
                Long userId = (Long)entry.getKey();
                String value = MsgServiceCacheHelper.getMsgPersonalSettingDataTopIdsCache((Long)userId);
                if (WfUtils.isEmpty(value)) continue;
                List psInfos = (List)entry.getValue();
                Collections.sort(psInfos, new Comparator<PersonalSettingInfo>(){

                    @Override
                    public int compare(PersonalSettingInfo ps1, PersonalSettingInfo ps2) {
                        Date date1 = ps1.getDate();
                        Date date2 = ps2.getDate();
                        return date2.compareTo(date1);
                    }
                });
                canUpdatePersonalSettings.put(userId, psInfos);
            }
        }
        if (!directUpdatePersonalCacheUserIds.isEmpty()) {
            for (Long userId : directUpdatePersonalCacheUserIds) {
                String value = MsgServiceCacheHelper.getMsgPersonalSettingDataTopIdsCache((Long)userId);
                if (WfUtils.isEmpty(value)) continue;
                ArrayList psInfos = new ArrayList();
                canUpdatePersonalSettings.put(userId, psInfos);
            }
        }
        if (canUpdatePersonalSettings.isEmpty()) {
            return;
        }
        try {
            MessageBussinessInfo messageBussinessInfo = new MessageBussinessInfo();
            messageBussinessInfo.setType(MessageBussinessInfo.Type.UPDATEPERSONALSETTINGDATAIDSCACHE.getNumber());
            messageBussinessInfo.setData(canUpdatePersonalSettings);
            MessageBussinessPublishUtil.publishBizMessage((MessageBussinessInfo)messageBussinessInfo);
        }
        catch (Exception e) {
            this.logger.warn(String.format("msgqs_dealConcurrentData_dealps error:[%s]", WfUtils.getExceptionStacktrace(e)));
        }
    }
}

