/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.context;

import java.util.Stack;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cfg.TransactionContext;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.runtime.ActivitiAgenda;

public class Context {
    protected static ThreadLocal<Stack<CommandContext>> commandContextThreadLocal = new ThreadLocal();
    protected static ThreadLocal<Stack<ProcessEngineConfigurationImpl>> processEngineConfigurationStackThreadLocal = new ThreadLocal();
    protected static ThreadLocal<Stack<TransactionContext>> transactionContextThreadLocal = new ThreadLocal();

    public static CommandContext getCommandContext() {
        Stack stack = Context.getStack(commandContextThreadLocal);
        if (stack.isEmpty()) {
            return null;
        }
        return (CommandContext)stack.peek();
    }

    public static ActivitiAgenda getAgenda() {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null) {
            return commandContext.getAgenda();
        }
        return null;
    }

    public static void setCommandContext(CommandContext commandContext) {
        Context.getStack(commandContextThreadLocal).push(commandContext);
    }

    public static void removeCommandContext() {
        Context.getStack(commandContextThreadLocal).pop();
    }

    public static ProcessEngineConfigurationImpl getProcessEngineConfiguration() {
        Stack stack = Context.getStack(processEngineConfigurationStackThreadLocal);
        if (stack.isEmpty()) {
            return null;
        }
        return (ProcessEngineConfigurationImpl)stack.peek();
    }

    public static void setProcessEngineConfiguration(ProcessEngineConfigurationImpl processEngineConfiguration) {
        Context.getStack(processEngineConfigurationStackThreadLocal).push(processEngineConfiguration);
    }

    public static void removeProcessEngineConfiguration() {
        Context.getStack(processEngineConfigurationStackThreadLocal).pop();
    }

    public static TransactionContext getTransactionContext() {
        Stack stack = Context.getStack(transactionContextThreadLocal);
        if (stack.isEmpty()) {
            return null;
        }
        return (TransactionContext)stack.peek();
    }

    public static void setTransactionContext(TransactionContext transactionContext) {
        Context.getStack(transactionContextThreadLocal).push(transactionContext);
    }

    public static void removeTransactionContext() {
        Context.getStack(transactionContextThreadLocal).pop();
    }

    protected static <T> Stack<T> getStack(ThreadLocal<Stack<T>> threadLocal) {
        Stack<Object> stack = threadLocal.get();
        if (stack == null) {
            stack = new Stack();
            threadLocal.set(stack);
        }
        return stack;
    }
}

