/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;

public class ModelProcessorContext {
    private Log logger = LogFactory.getLog(this.getClass());
    private Map<String, List<Long>> actDataMap = null;
    private Set<String> processedParticipantActs = new HashSet<String>();
    private Map<String, List<Object[]>> sqlParamMap = new HashMap<String, List<Object[]>>(16);

    public void addSqlParams(String sql, List<Object[]> params) {
        List<Object[]> sqlParams = this.sqlParamMap.get(sql);
        if (sqlParams == null) {
            sqlParams = new ArrayList<Object[]>();
            this.sqlParamMap.put(sql, sqlParams);
        }
        sqlParams.addAll(params);
    }

    public List<Long> getParticipantModelIdsByActId(Long modelId, Long schemeId, String activityId) {
        if (this.actDataMap == null) {
            this.actDataMap = new HashMap<String, List<Long>>(32);
            Object[] params = null;
            StringBuilder sql = new StringBuilder("SELECT FID,FTASKACTIVITYID FROM T_WF_PARTICIPANTMODEL WHERE  ");
            if (WfUtils.isNotEmpty(modelId)) {
                sql.append("FMODELID = ? ");
                params = new Object[]{modelId};
            } else if (WfUtils.isNotEmpty(schemeId)) {
                sql.append("FSCHEMEID = ? ");
                params = new Object[]{schemeId};
            } else {
                this.logger.debug("modelId or schemeId is empty!");
                return null;
            }
            try (DataSet ds = DB.queryDataSet((String)"wf.engine.queryParticipantModel", (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])params);){
                for (Row row : ds) {
                    Long id = row.getLong("FID");
                    String actId = row.getString("FTASKACTIVITYID");
                    List<Long> ids = this.actDataMap.get(actId);
                    if (ids == null) {
                        ids = new ArrayList<Long>();
                        this.actDataMap.put(actId, ids);
                    }
                    ids.add(id);
                }
            }
        }
        return this.actDataMap.get(activityId);
    }

    public Map<String, List<Object[]>> getSqlParamMap() {
        return this.sqlParamMap;
    }

    public void addProcessedParticipantActId(String activityId) {
        this.processedParticipantActs.add(activityId);
    }

    public boolean isParticipantProcessed(String activityId) {
        return this.processedParticipantActs.contains(activityId);
    }
}

