/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.LogORM;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.engine.EntityUtil;
import kd.bos.workflow.engine.WfDBUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.Page;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.db.BatchSQLInfo;
import kd.bos.workflow.engine.impl.db.BatchVerifySqlInfo;
import kd.bos.workflow.engine.impl.db.EntityDependencyOrder;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.Session;
import kd.bos.workflow.engine.impl.persistence.cache.CachedEntity;
import kd.bos.workflow.engine.impl.persistence.cache.EntityCache;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.job.DeadLetterJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.TimerJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFVerifySqlSaveException;

public class DbSqlSession
implements Session {
    private Log log = LogFactory.getLog(this.getClass());
    protected EntityCache entityCache;
    protected Map<Class<? extends Entity>, Map<Long, Entity>> insertedObjects = new HashMap<Class<? extends Entity>, Map<Long, Entity>>(32);
    protected Map<Class<? extends Entity>, Map<Long, Entity>> deletedObjects = new HashMap<Class<? extends Entity>, Map<Long, Entity>>(32);
    protected Map<Class, List<Entity>> logInsterObjects = new HashMap<Class, List<Entity>>(32);
    protected Map<String, List<QFilter[]>> logDeleteObjects = new HashMap<String, List<QFilter[]>>(32);
    protected Map<String, List<QFilter>> deletedFilters = new HashMap<String, List<QFilter>>();
    protected List<Entity> updatedObjects = new ArrayList<Entity>(32);
    protected List<BatchSQLInfo> batchSqlInfos = new ArrayList<BatchSQLInfo>();
    protected List<BatchSQLInfo> verifySqlInfos = new ArrayList<BatchSQLInfo>();
    protected static Map<String, String[]> entityToTables = null;

    public static void init() {
        entityToTables = new HashMap<String, String[]>(32);
        entityToTables.put("wf_participant", new String[]{"T_WF_PARTICIPANT", "T_WF_PARTICIPANT_L"});
        entityToTables.put("wf_variableinstance", new String[]{"T_WF_VARIABLE"});
        entityToTables.put("wf_hivarinst", new String[]{"T_WF_HIVARINST"});
        entityToTables.put("wf_hiconditioninst", new String[]{"t_wf_hiconditioninst"});
        entityToTables.put("wf_hiparticipant", new String[]{"T_WF_HIPARTICIPANT", "T_WF_HIPARTICIPANT_L"});
        entityToTables.put("wf_task", new String[]{"T_WF_TASK", "T_WF_TASK_L", "T_WF_TASK_A"});
        entityToTables.put("wf_hitaskinst", new String[]{"T_WF_HITASKINST", "T_WF_HITASKINST_L", "T_WF_HITASKINST_A"});
        entityToTables.put("wf_hiactinst", new String[]{"T_WF_HIACTINST", "T_WF_HIACTINST_L"});
        entityToTables.put("wf_hiuseractinst", new String[]{"t_wf_hiuseractinst", "t_wf_hiuseractinst_l"});
        entityToTables.put("wf_eventlogentry", new String[]{"T_WF_EVTLOG"});
        entityToTables.put("wf_job", new String[]{"t_wf_jobrecord"});
        entityToTables.put("wf_timerjob", new String[]{"t_wf_timerjob"});
        entityToTables.put("wf_deadletterjob", new String[]{"t_wf_deadletterjob", "t_wf_deadletterjob_l"});
        entityToTables.put("wf_suspendedjob", new String[]{"t_wf_suspendedjob"});
        entityToTables.put("wf_execution", new String[]{"t_wf_execution", "t_wf_execution_l"});
        entityToTables.put("wf_hicomment", new String[]{"t_wf_hicomment", "t_wf_hicomment_l", "t_wf_hicomment_A"});
        entityToTables.put("wf_failedjob", new String[]{"t_wf_failedjob", "t_wf_failedjob_l"});
        entityToTables.put("wf_dynamicresource", new String[]{"t_wf_dynresource", "t_wf_dynresource_l"});
        entityToTables.put("wf_hidynamicresource", new String[]{"t_wf_hidynresource", "t_wf_hidynresource_l"});
        entityToTables.put("wf_operationlog", new String[]{"t_wf_operationlog", "t_wf_operationlog_l"});
        entityToTables.put("wf_hiattachment", new String[]{"t_wf_hiattachment", "t_wf_hiattachment_l"});
        entityToTables.put("wf_taskhandlelog", new String[]{"t_wf_taskhandlelog", "t_wf_taskhandlelog_l"});
        entityToTables.put("wf_appmodelrelation", new String[]{"t_wf_appmodelrelation"});
        entityToTables.put("wf_tohandlegroup", new String[]{"t_wf_tohandlegroup"});
        entityToTables.put("wf_nocode_hitaskinst", new String[]{"t_wf_nocode_hitaskinst", "t_wf_nocode_hitaskinst_l", "t_wf_nocode_hitaskinst_A"});
        entityToTables.put("wf_nocode_hiactinst", new String[]{"t_wf_nocode_hiactinst", "t_wf_nocode_hiactinst_l"});
        entityToTables.put("wf_nocode_hiparticipant", new String[]{"t_wf_nocode_hiparticipant", "t_wf_nocode_hiparticipant_l"});
        entityToTables.put("wf_nocode_hivarinst", new String[]{"t_wf_nocode_hivarinst"});
        entityToTables.put("wf_nocode_hiuseractinst", new String[]{"t_wf_nocode_hiuseractinst", "t_wf_nocode_hiuseractinst_l"});
        entityToTables.put("wf_nocode_hicomment", new String[]{"t_wf_nocode_hicomment", "t_wf_nocode_hicomment_l", "t_wf_nocode_hicomment_A"});
        entityToTables.put("wf_nocode_hidynresource", new String[]{"t_wf_nocode_hidynresource", "t_wf_nocode_hidynresource_l"});
        entityToTables.put("wf_nocode_taskjob", new String[]{"t_wf_nocode_taskjob", "t_wf_nocode_taskjob_l"});
    }

    public static Map<String, String[]> getEntityToTables() {
        if (entityToTables == null || entityToTables.isEmpty()) {
            DbSqlSession.init();
        }
        return entityToTables;
    }

    public DbSqlSession(EntityCache entityCache) {
        this.entityCache = entityCache;
    }

    public <T extends Entity> List<T> selectCachedEntitys(Class<? extends Entity> clazz) {
        Map<Long, Entity> em = this.insertedObjects.get(clazz);
        if (em == null || em.isEmpty()) {
            return Collections.emptyList();
        }
        Collection<Entity> entitys = em.values();
        Map<Long, Entity> deleteEntitys = this.deletedObjects.get(clazz);
        ArrayList<Entity> result = new ArrayList<Entity>();
        for (Entity e : entitys) {
            if (deleteEntitys != null && deleteEntitys.containsKey(e.getId())) continue;
            result.add(e);
        }
        return result;
    }

    public void insert(Entity entity) {
        if (WfUtils.isEmpty(entity.getId())) {
            Long id = ORM.create().genLongId(entity.getDynObjTypeName());
            entity.setId(id);
        }
        this.log.debug("--\uff1ainsert entity: " + entity);
        EntityUtil.addCreateAndModifyInfo(entity.getDynamicObject(), true);
        Class<?> clazz = entity.getClass();
        if (!this.insertedObjects.containsKey(clazz)) {
            this.insertedObjects.put(clazz, new LinkedHashMap());
        }
        this.insertedObjects.get(clazz).put(entity.getId(), entity);
        this.entityCache.put(entity, false);
        entity.setInserted(true);
    }

    public void insertLog(Entity entity) {
        Class<?> clazz;
        if (WfUtils.isEmpty(entity.getId())) {
            Long id = ORM.create().genLongId(entity.getDynObjTypeName());
            entity.setId(id);
        }
        if (!this.logInsterObjects.containsKey(clazz = entity.getClass())) {
            this.logInsterObjects.put(clazz, new ArrayList());
        }
        this.logInsterObjects.get(clazz).add(entity);
        entity.setInserted(true);
    }

    public void update(Entity entity) {
        this.entityCache.put(entity, false);
        entity.setUpdated(true);
        EntityUtil.addCreateAndModifyInfo(entity.getDynamicObject(), false);
    }

    public void delete(Entity entity) {
        if (entity != null) {
            Class<?> clazz = entity.getClass();
            if (!this.deletedObjects.containsKey(clazz)) {
                this.deletedObjects.put(clazz, new LinkedHashMap());
            }
            this.deletedObjects.get(clazz).put(entity.getId(), entity);
            entity.setDeleted(true);
        }
    }

    public void deleteLog(String entityNumber, QFilter[] qFilters) {
        List<QFilter[]> filter = this.logDeleteObjects.get(entityNumber);
        if (filter == null) {
            filter = new ArrayList<QFilter[]>(10);
        }
        filter.add(qFilters);
        this.logDeleteObjects.put(entityNumber, filter);
    }

    public void deleteByFilters(String entityNumber, QFilter[] qFilters) {
        EntityQueryBuilder qb = new EntityQueryBuilder(entityNumber, qFilters, "id", null);
        List entities = this.selectCollection(qb, null, false);
        if (entities != null) {
            for (Entity entity : entities) {
                this.delete(entity);
            }
        }
    }

    public void deleteByCacheFilter(String entityNumber, QFilter filter) {
        if (entityNumber != null && filter != null) {
            List<QFilter> filters = this.deletedFilters.get(entityNumber);
            if (filters == null) {
                filters = new ArrayList<QFilter>();
            }
            filters.add(filter);
            this.deletedFilters.put(entityNumber, filters);
        }
    }

    public void addBatchSQLInfo(BatchSQLInfo batchSqlInfo) {
        this.batchSqlInfos.add(batchSqlInfo);
    }

    public void addVerifySqlInfos(BatchSQLInfo conditionSqlInfo) {
        this.verifySqlInfos.add(conditionSqlInfo);
    }

    private void removeVerifySqlConflictInfos() {
        for (BatchSQLInfo verifySqlInfo : this.verifySqlInfos) {
            if (!(verifySqlInfo instanceof BatchVerifySqlInfo)) continue;
            Long id = ((BatchVerifySqlInfo)verifySqlInfo).getId();
            Class<? extends Entity> entityClass = ((BatchVerifySqlInfo)verifySqlInfo).getEntityClass();
            boolean isInsert = !((BatchVerifySqlInfo)verifySqlInfo).isUpdate();
            Iterator<Entity> iter = this.updatedObjects.iterator();
            while (iter.hasNext()) {
                Entity entity = iter.next();
                if (!entity.getClass().equals(entityClass) || !entity.getId().equals(id)) continue;
                iter.remove();
            }
            if (!isInsert || entityClass == null || !this.insertedObjects.containsKey(entityClass) || !WfUtils.isNotEmpty(id) || !this.insertedObjects.get(entityClass).containsKey(id)) continue;
            this.insertedObjects.get(entityClass).remove(id);
        }
    }

    public <T extends Entity> List<T> selectCollection(EntityQueryBuilder<T> qb, Page page) {
        return this.selectCollection(qb, page, true);
    }

    public <T extends Entity> List<T> selectCollection(EntityQueryBuilder<T> qb, Page page, boolean useCache) {
        if (page != null) {
            return this.selectCollectionWithRawParameter(qb, page.getFirstResult(), page.getMaxResults(), useCache);
        }
        return this.selectCollectionWithRawParameter(qb, 0, Integer.MAX_VALUE, useCache);
    }

    public <T extends Entity> List<T> selectCollectionWithRawParameter(EntityQueryBuilder<T> qb, int firstResult, int maxResults, boolean useCache) {
        ArrayList list = new ArrayList(16);
        if (qb == null || qb.getEntityName() == null || firstResult == -1 || maxResults == -1) {
            return list;
        }
        DynamicObject[] dynObjects = BusinessDataServiceHelper.load((String)qb.getEntityName(), (String)qb.getSelectFields(), (QFilter[])qb.getFilters(), (String)qb.getOrderBys(), (int)qb.getLimit());
        return this.cacheLoadOrStoreWithCollection(qb.getEntityName(), dynObjects, useCache);
    }

    public <T extends Entity> List<T> selectCollection(String sql, Object[] params, String entityName, String selectFields) {
        try (DataSet ds = DB.queryDataSet((String)entityName, (DBRoute)DBRoute.workflow, (String)sql, (Object[])params);){
            DynamicObjectType type = this.getDynamicObject(entityName, selectFields);
            ArrayList<Long> listIds = new ArrayList<Long>(16);
            while (ds.hasNext()) {
                Row row = ds.next();
                listIds.add(row.getLong("fid"));
            }
            DynamicObject[] objs = BusinessDataReader.load((Object[])listIds.toArray(new Object[listIds.size()]), (DynamicObjectType)type, (Boolean)true);
            List<T> list = this.cacheLoadOrStoreWithCollection(entityName, objs, true);
            return list;
        }
    }

    public <T extends Entity> T selectById(Class<T> entityClass, Long id) {
        return this.selectById(entityClass, id, null);
    }

    public <T extends Entity> T selectById(Class<T> entityClass, Long id, String fields) {
        return this.selectById(entityClass, id, fields, true);
    }

    public <T extends Entity> T selectById(Class<T> entityClass, Long id, String fields, boolean useCache) {
        boolean putCache;
        Object entity = null;
        AbstractEntityManager entityMgr = this.getEntityMgr(entityClass);
        String entityName = entityMgr.getEntityName();
        String selectFields = entityMgr.getSelectFields();
        if (useCache && (entity = (Entity)this.entityCache.findInCache(entityClass, id)) != null) {
            return (T)entity;
        }
        DynamicObject dynObj = null;
        try {
            dynObj = WfUtils.isNotEmpty(fields) ? BusinessDataServiceHelper.loadSingle((Object)id, (String)entityName, (String)fields) : BusinessDataServiceHelper.loadSingle((Object)id, (String)entityName, (String)selectFields);
        }
        catch (Exception e) {
            this.log.debug(e.getMessage());
        }
        this.log.debug("The Object[" + id + "] of " + entityName + " in db is " + dynObj);
        if (dynObj == null) {
            return null;
        }
        entity = entityMgr.create(dynObj);
        boolean bl = putCache = WfUtils.isEmpty(fields) || fields.equalsIgnoreCase(selectFields);
        if (putCache) {
            this.entityCache.put((Entity)entity, true);
        }
        return (T)entity;
    }

    public boolean exist(String entiyNumber, Long id) {
        return QueryServiceHelper.exists((String)entiyNumber, (Object)id);
    }

    public boolean exist(String entiyNumber, QFilter[] qFilters) {
        return QueryServiceHelper.exists((String)entiyNumber, (QFilter[])qFilters);
    }

    protected <T extends Entity> List<T> cacheLoadOrStoreWithCollection(String entityNumber, DynamicObject[] loadedObjects, boolean useCache) {
        ArrayList filteredObjects = new ArrayList(16);
        if (loadedObjects == null || loadedObjects.length == 0) {
            return filteredObjects;
        }
        for (DynamicObject loadedObject : loadedObjects) {
            Object entity = this.getEntityMgr(entityNumber).create(loadedObject);
            if (useCache) {
                Object cachedEntity = this.cacheLoadOrStore(entity);
                filteredObjects.add(cachedEntity);
                continue;
            }
            filteredObjects.add(entity);
        }
        return filteredObjects;
    }

    protected <T extends Entity> T cacheLoadOrStore(T entity) {
        Entity cachedEntity = (Entity)this.entityCache.findInCache(entity.getClass(), entity.getId());
        if (cachedEntity != null) {
            return (T)cachedEntity;
        }
        this.entityCache.put(entity, true);
        return entity;
    }

    @Override
    public void flushLog() {
        LogORM logORM = LogORM.create();
        this.flushInsertLog(logORM);
        this.flushDeleteLog(logORM);
    }

    @Override
    public void flush() {
        this.determineUpdatedObjects();
        this.removeUnnecessaryOperations();
        this.removeVerifySqlConflictInfos();
        Map<Class, List<DynamicObject>> dyInserts = this.transferInserts();
        Map<Class, List<DynamicObject>> dyupdates = this.transferUpdates();
        Map<String, Long[]> dydeletesByDt = null;
        try {
            dydeletesByDt = this.collectDeletesByDt();
        }
        catch (Exception e) {
            this.log.info(WfUtils.getExceptionStacktrace(e));
        }
        Map<Class, Long[]> dydeletes = this.transferDeletes();
        if (dyInserts != null || dyupdates != null || dydeletes != null || dydeletesByDt != null || !this.verifySqlInfos.isEmpty() || this.batchSqlInfos != null && !this.batchSqlInfos.isEmpty()) {
            this.flushAll(dyInserts, dyupdates, dydeletes, dydeletesByDt);
        }
    }

    private void flushInsertLog(LogORM logORM) {
        Map<Class, List<DynamicObject>> dyLogInserts = this.transferLogInserts();
        if (dyLogInserts == null || dyLogInserts.size() == 0) {
            return;
        }
        for (Map.Entry<Class, List<DynamicObject>> entity : dyLogInserts.entrySet()) {
            try {
                if (entity.getValue().size() <= 0) continue;
                logORM.insert(entity.getValue());
            }
            catch (Throwable e) {
                this.log.error("insert runtimelog is faile : message :" + WfUtils.getExceptionStacktrace(e));
            }
        }
    }

    private void flushDeleteLog(LogORM logORM) {
        try {
            if (this.logDeleteObjects.size() == 0) {
                return;
            }
            for (Map.Entry<String, List<QFilter[]>> entry : this.logDeleteObjects.entrySet()) {
                List<QFilter[]> filterList = entry.getValue();
                String entityNumber = entry.getKey();
                if (!WfUtils.isNotEmptyForCollection(filterList)) continue;
                for (QFilter[] qFilter : filterList) {
                    logORM.delete(entityNumber, qFilter);
                }
            }
            this.logDeleteObjects.clear();
        }
        catch (Throwable e) {
            this.log.error("delete logEntity is fail : message :" + WfUtils.getExceptionStacktrace(e));
        }
    }

    private Map<String, Long[]> collectDeletesByDt() {
        if (this.deletedObjects.size() == 0) {
            return null;
        }
        this.log.debug("the size of batch delete object is " + this.deletedObjects.size());
        HashMap<String, ArrayList<Long>> batDeletesTmp = new HashMap<String, ArrayList<Long>>();
        Collection<Map<Long, Entity>> entitys = this.deletedObjects.values();
        for (Map<Long, Entity> entityMaps : entitys) {
            for (Entity entity : entityMaps.values()) {
                String dt = null;
                if (entity instanceof JobEntity && "event".equals(((JobEntity)entity).getJobType())) {
                    dt = "evt_job";
                } else if (entity instanceof TimerJobEntity && "event".equals(((TimerJobEntity)entity).getJobType())) {
                    dt = "evt_timerjob";
                } else if (entity instanceof DeadLetterJobEntity) {
                    dt = "evt_deadletterjob";
                }
                if (!WfUtils.isNotEmpty(dt)) continue;
                ArrayList<Long> ids = (ArrayList<Long>)batDeletesTmp.get(dt);
                if (ids == null) {
                    ids = new ArrayList<Long>();
                    batDeletesTmp.put(dt, ids);
                }
                ids.add(entity.getId());
            }
        }
        HashMap<String, Long[]> batDeletes = new HashMap<String, Long[]>(batDeletesTmp.size());
        for (Map.Entry entry : batDeletesTmp.entrySet()) {
            List ids = (List)entry.getValue();
            batDeletes.put((String)entry.getKey(), ids.toArray(new Long[ids.size()]));
        }
        return batDeletes;
    }

    private void flushAll(Map<Class, List<DynamicObject>> dyInserts, Map<Class, List<DynamicObject>> dyupdates, Map<Class, Long[]> dydeletes, Map<String, Long[]> dydeletesByDt) {
        TXHandle h = TX.requiresNew();
        long txNo = System.currentTimeMillis();
        try {
            ORM orm = ORM.create();
            StringBuilder sb = new StringBuilder();
            sb.append("starting new transcation,No is ").append(txNo);
            if (!this.deletedFilters.isEmpty()) {
                for (Map.Entry<String, List<QFilter>> entry : this.deletedFilters.entrySet()) {
                    List<QFilter> filters = entry.getValue();
                    QFilter filter = null;
                    for (QFilter f : filters) {
                        if (filter == null) {
                            filter = f;
                            continue;
                        }
                        filter.or(f);
                    }
                    QueryServiceHelper.query((String)entry.getKey(), (String)"id", (QFilter[])new QFilter[]{filter});
                    DeleteServiceHelper.delete((String)entry.getKey(), (QFilter[])new QFilter[]{filter});
                }
            }
            if (this.verifySqlInfos != null && !this.verifySqlInfos.isEmpty()) {
                for (BatchSQLInfo batchSQLInfo : this.verifySqlInfos) {
                    if (batchSQLInfo instanceof BatchVerifySqlInfo && ((BatchVerifySqlInfo)batchSQLInfo).isUpdate()) continue;
                    int count = WfDBUtils.executeBatch(batchSQLInfo.getBatchSql(), batchSQLInfo.getParamsList(), batchSQLInfo.getBatchCount());
                    if (count < batchSQLInfo.getBatchCount()) {
                        throw new WFVerifySqlSaveException(null, WFErrorCode.conditonSaveError(), new Object[]{String.format("VerifySql insert count : %s-%s sql : %s", count, batchSQLInfo.getBatchCount(), batchSQLInfo.getBatchSql())});
                    }
                    sb.append(String.format("excute VerifySql [%s]  [%s] nums", batchSQLInfo.getBatchSql(), count));
                }
            }
            if (dyInserts != null && dyInserts.size() > 0) {
                for (Map.Entry entry : dyInserts.entrySet()) {
                    DynamicObject[] dyns = ((List)entry.getValue()).toArray(new DynamicObject[0]);
                    this.batchInsertOrUpdate(dyns);
                }
            }
            if (dyupdates != null && dyupdates.size() > 0) {
                for (Map.Entry entry : dyupdates.entrySet()) {
                    Class key = (Class)entry.getKey();
                    DynamicObject[] dyns = dyupdates.get(key).toArray(new DynamicObject[0]);
                    sb.append(String.format("update [%s]  [%s] nums", key, dyns == null ? 0 : dyns.length));
                    this.batchInsertOrUpdate(dyns);
                }
            }
            if (this.verifySqlInfos != null && !this.verifySqlInfos.isEmpty()) {
                for (BatchSQLInfo batchSQLInfo : this.verifySqlInfos) {
                    if (batchSQLInfo instanceof BatchVerifySqlInfo && !((BatchVerifySqlInfo)batchSQLInfo).isUpdate()) continue;
                    int count = WfDBUtils.executeBatch(batchSQLInfo.getBatchSql(), batchSQLInfo.getParamsList(), batchSQLInfo.getBatchCount());
                    if (count < batchSQLInfo.getBatchCount()) {
                        throw new WFVerifySqlSaveException(null, WFErrorCode.conditonSaveError(), new Object[]{String.format("VerifySql update count : %s-%s sql : %s", count, batchSQLInfo.getBatchCount(), batchSQLInfo.getBatchSql())});
                    }
                    sb.append(String.format("excute VerifySql [%s]  [%s] nums", batchSQLInfo.getBatchSql(), count));
                }
            }
            if (dydeletes != null && dydeletes.size() > 0) {
                for (Map.Entry entry : dydeletes.entrySet()) {
                    Class key = (Class)entry.getKey();
                    AbstractEntityManager dataMgr = this.getEntityMgr(key);
                    IDataEntityType type = orm.getDataEntityType(dataMgr.getEntityName());
                    Object[] ids = dydeletes.get(key);
                    sb.append(String.format("delete [%s]  [%s] nums", key, ids == null ? 0 : ids.length));
                    if (ids == null || ids.length == 0 || this.matchBatchInfo((Long[])ids, type.getName())) continue;
                    DeleteServiceHelper.delete((IDataEntityType)type, (Object[])ids);
                    sb.append(String.format("cannot match batchdel [%s]", type.getName()));
                }
            }
            if (dydeletesByDt != null && !dydeletesByDt.isEmpty()) {
                for (Map.Entry entry : dydeletesByDt.entrySet()) {
                    String dt = (String)entry.getKey();
                    IDataEntityType type = orm.getDataEntityType(dt);
                    Object[] ids = dydeletesByDt.get(dt);
                    sb.append(String.format("delete [%s]  [%s] nums", dt, ids == null ? 0 : ids.length));
                    DeleteServiceHelper.delete((IDataEntityType)type, (Object[])ids);
                }
            }
            if (this.batchSqlInfos != null && !this.batchSqlInfos.isEmpty()) {
                for (BatchSQLInfo batchSQLInfo : this.batchSqlInfos) {
                    int count = WfDBUtils.executeBatch(batchSQLInfo.getBatchSql(), batchSQLInfo.getParamsList(), batchSQLInfo.getBatchCount());
                    sb.append(String.format("excute batchsql [%s]  [%s] nums", batchSQLInfo.getBatchSql(), count));
                }
            }
            sb.append("end to flush transcation,No is ").append(txNo);
            this.log.debug(sb.toString());
        }
        catch (WFVerifySqlSaveException exception) {
            this.log.error("conditionSql excute error");
            h.markRollback();
            throw exception;
        }
        catch (Exception e) {
            this.log.error("flush transcation to be occured, the msg is" + e.getMessage() + ",and transcation No is " + txNo);
            h.markRollback();
            throw e;
        }
        finally {
            h.close();
            this.log.debug("successful to flush transcation,No is " + txNo);
        }
    }

    private boolean matchBatchInfo(Long[] ids, String dtName) {
        String[] tableNames = this.getTableNames(dtName);
        if (tableNames.length == 0) {
            return false;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(ids.length);
        for (int i = 0; i < ids.length; ++i) {
            params.add(new Object[]{ids[i]});
        }
        for (String tName : tableNames) {
            BatchSQLInfo batch = new BatchSQLInfo(String.format("DELETE FROM %s WHERE FID = ?", tName), params, 200);
            this.batchSqlInfos.add(batch);
        }
        return true;
    }

    private String[] getTableNames(String dtName) {
        Map<String, String[]> t = DbSqlSession.getEntityToTables();
        if (t != null && t.get(dtName) != null) {
            return t.get(dtName);
        }
        return new String[0];
    }

    private void batchInsertOrUpdate(DynamicObject[] dyns) {
        if (dyns == null || dyns.length == 0) {
            this.log.debug("empty dyns to save");
            return;
        }
        if (dyns.length == 1) {
            SaveServiceHelper.save((DynamicObject[])dyns);
            return;
        }
        boolean batch = true;
        IDataEntityType last = null;
        for (DynamicObject obj : dyns) {
            IDataEntityType dt = obj.getDataEntityType();
            if (last == null) {
                last = dt;
            }
            if (last == dt) continue;
            batch = false;
            String traceNo = RequestContext.getOrCreate().getTraceId();
            this.log.debug(String.format("lastisnot equlas cur [%s],curJob[%s] ", last.getName(), traceNo));
            break;
        }
        if (batch) {
            SaveServiceHelper.save(last, (Object[])dyns);
        } else {
            for (DynamicObject obj : dyns) {
                SaveServiceHelper.save((IDataEntityType)obj.getDataEntityType(), (Object[])new DynamicObject[]{obj});
            }
        }
    }

    private Map<Class, Long[]> transferDeletes() {
        if (this.deletedObjects.size() == 0) {
            return null;
        }
        this.log.debug("the size of batch delete object is " + this.deletedObjects.size());
        HashMap<Class, Long[]> batDeletes = new HashMap<Class, Long[]>(16);
        for (Class<? extends Entity> clazz : EntityDependencyOrder.DELETE_ORDER) {
            if (!this.deletedObjects.containsKey(clazz)) continue;
            Map<Long, Entity> deletedObject = this.deletedObjects.remove(clazz);
            this.transferDeleteEntities(batDeletes, clazz, deletedObject.values());
        }
        if (this.deletedObjects.size() > 0) {
            for (Map.Entry entry : this.deletedObjects.entrySet()) {
                this.transferDeleteEntities(batDeletes, (Class)entry.getKey(), ((Map)entry.getValue()).values());
            }
        }
        this.deletedObjects.clear();
        return batDeletes;
    }

    private void transferDeleteEntities(Map<Class, Long[]> batDeletes, Class<? extends Entity> entityClass, Collection<Entity> entitiesToDelete) {
        if (entitiesToDelete != null && !entitiesToDelete.isEmpty()) {
            Long[] ids = new Long[entitiesToDelete.size()];
            int i = 0;
            for (Entity entity : entitiesToDelete) {
                ids[i] = entity.getId();
                ++i;
            }
            batDeletes.put(entityClass, ids);
        }
    }

    private Map<Class, List<DynamicObject>> transferUpdates() {
        if (this.updatedObjects != null && !this.updatedObjects.isEmpty()) {
            HashMap<Class, List<DynamicObject>> dyUpdates = new HashMap<Class, List<DynamicObject>>(this.updatedObjects.size());
            for (Entity entity : this.updatedObjects) {
                ArrayList<DynamicObject> dyObjs = (ArrayList<DynamicObject>)dyUpdates.get(entity.getClass());
                if (dyObjs == null) {
                    dyObjs = new ArrayList<DynamicObject>(16);
                }
                DynamicObject dynObj = entity.getDynamicObject();
                dyObjs.add(dynObj);
                dyUpdates.put(entity.getClass(), dyObjs);
            }
            this.updatedObjects.clear();
            return dyUpdates;
        }
        return null;
    }

    private Map<Class, List<DynamicObject>> transferInserts() {
        if (this.insertedObjects.size() == 0) {
            return null;
        }
        HashMap<Class, List<DynamicObject>> dyInserts = new HashMap<Class, List<DynamicObject>>(16);
        if (this.insertedObjects.size() > 0) {
            for (Map.Entry<Class<? extends Entity>, Map<Long, Entity>> entity : this.insertedObjects.entrySet()) {
                this.transferInsertEntities(dyInserts, entity.getValue().values());
            }
        }
        this.insertedObjects.clear();
        return dyInserts;
    }

    private Map<Class, List<DynamicObject>> transferLogInserts() {
        if (this.logInsterObjects.size() == 0) {
            return null;
        }
        HashMap<Class, List<DynamicObject>> dyInserts = new HashMap<Class, List<DynamicObject>>(16);
        if (this.logInsterObjects.size() > 0) {
            for (Map.Entry<Class, List<Entity>> entity : this.logInsterObjects.entrySet()) {
                this.transferInsertEntities(dyInserts, (Collection<Entity>)entity.getValue());
            }
        }
        this.logInsterObjects.clear();
        return dyInserts;
    }

    private void transferInsertEntities(Map<Class, List<DynamicObject>> dyInserts, Collection<Entity> entities) {
        if (entities != null && !entities.isEmpty()) {
            for (Entity tmp : entities) {
                List<DynamicObject> dyObjects = dyInserts.get(tmp.getClass());
                if (dyObjects == null) {
                    dyObjects = new ArrayList<DynamicObject>(16);
                }
                DynamicObject dynObj = tmp.getDynamicObject();
                dyObjects.add(dynObj);
                dyInserts.put(tmp.getClass(), dyObjects);
            }
        }
    }

    protected void removeUnnecessaryOperations() {
        for (Map.Entry<Class<? extends Entity>, Map<Long, Entity>> entity : this.deletedObjects.entrySet()) {
            Class<? extends Entity> entityClass = entity.getKey();
            HashSet<Long> ids = new HashSet<Long>(16);
            Iterator<Entity> entitiesToDeleteIterator = entity.getValue().values().iterator();
            while (entitiesToDeleteIterator.hasNext()) {
                Entity entityToDelete = entitiesToDeleteIterator.next();
                if (!ids.contains(entityToDelete.getId())) {
                    ids.add(entityToDelete.getId());
                    continue;
                }
                entitiesToDeleteIterator.remove();
            }
            for (Long id : ids) {
                if (!this.insertedObjects.containsKey(entityClass) || !this.insertedObjects.get(entityClass).containsKey(id)) continue;
                this.insertedObjects.get(entityClass).remove(id);
                this.deletedObjects.get(entityClass).remove(id);
            }
        }
    }

    public void determineUpdatedObjects() {
        this.updatedObjects = new ArrayList<Entity>(16);
        Map<Class<?>, Map<Long, CachedEntity>> cachedObjects = this.entityCache.getAllCachedEntities();
        for (Map.Entry<Class<?>, Map<Long, CachedEntity>> entry : cachedObjects.entrySet()) {
            Map<Long, CachedEntity> classCache = entry.getValue();
            for (CachedEntity cachedObject : classCache.values()) {
                Entity cachedEntity = cachedObject.getEntity();
                if (this.isEntityInserted(cachedEntity) || !ExecutionEntity.class.isAssignableFrom(cachedEntity.getClass()) && this.isEntityToBeDeleted(cachedEntity) || !cachedObject.hasChanged()) continue;
                this.updatedObjects.add(cachedEntity);
            }
        }
    }

    public boolean isEntityInserted(Entity entity) {
        return this.insertedObjects.containsKey(entity.getClass()) && this.insertedObjects.get(entity.getClass()).containsKey(entity.getId());
    }

    public boolean isEntityToBeDeleted(Entity entity) {
        return this.deletedObjects.containsKey(entity.getClass()) && this.deletedObjects.get(entity.getClass()).containsKey(entity.getId());
    }

    @Override
    public void close() {
        this.log.debug("close session");
    }

    private DynamicObjectType getDynamicObject(String entityName, String selectFields) {
        String[] properties = selectFields.split(",");
        HashSet<String> select = new HashSet<String>(properties.length);
        for (String prop : properties) {
            select.add(prop.trim());
        }
        return EntityMetadataCache.getSubDataEntityType((String)entityName, select);
    }

    public AbstractEntityManager getEntityMgr(String entityNumber) {
        CommandContext commandContext = Context.getCommandContext();
        return commandContext.getEntityManagerByEntityNumber(entityNumber);
    }

    public AbstractEntityManager getEntityMgr(Class<? extends Entity> entityClass) {
        CommandContext commandContext = Context.getCommandContext();
        return commandContext.getEntityManagerByClass(entityClass);
    }
}

