/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.db;

import java.util.Arrays;
import java.util.List;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.entity.CountEntityCmd;
import kd.bos.workflow.engine.impl.cmd.entity.FindEntityCmd;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;

public class EntityQueryBuilder<T extends Entity> {
    private String entityName;
    private String selectFields;
    private QFilter[] filters;
    private String orderBys;
    private int start;
    private int limit = -1;
    private ProcessEngineConfigurationImpl configurationImpl;

    public EntityQueryBuilder(String entityNumber, QFilter[] filters, String selectFields, Class<? extends Entity> entityClass) {
        this.entityName = entityNumber;
        this.selectFields = selectFields;
        this.filters = filters;
    }

    public EntityQueryBuilder(String entityNumber, QFilter[] filters, String orderBys, String selectFields, Class<? extends Entity> entityClass) {
        this.entityName = entityNumber;
        this.selectFields = selectFields;
        this.filters = filters;
        this.orderBys = orderBys;
    }

    public EntityQueryBuilder(String entityNumber, String selectFields) {
        this.entityName = entityNumber;
        this.selectFields = selectFields;
    }

    public EntityQueryBuilder(String entityNumber) {
        this.entityName = entityNumber;
    }

    public EntityQueryBuilder<T> addFilter(String fieldName, Object value) {
        int len = this.filters == null ? 0 : this.filters.length;
        this.filters = this.filters == null ? new QFilter[len] : Arrays.copyOf(this.filters, ++len);
        this.filters[len - 1] = new QFilter(fieldName, "=", value);
        return this;
    }

    public EntityQueryBuilder<T> addFilter(String fieldName, String qcp, Object value) {
        int len = this.filters == null ? 0 : this.filters.length;
        this.filters = this.filters == null ? new QFilter[len] : Arrays.copyOf(this.filters, ++len);
        this.filters[len - 1] = new QFilter(fieldName, qcp, value);
        return this;
    }

    public EntityQueryBuilder<T> addFilters(QFilter[] filters) {
        this.filters = filters;
        return this;
    }

    public EntityQueryBuilder<T> orderBy(String orderBy) {
        if (WfUtils.isEmpty(orderBy)) {
            return this;
        }
        StringBuilder sb = new StringBuilder();
        String s1 = this.orderBys == null ? "" : this.orderBys;
        sb.append(s1);
        sb.append(" ").append(orderBy);
        this.orderBys = sb.toString();
        return this;
    }

    public EntityQueryBuilder<T> setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public EntityQueryBuilder<T> setStart(int start) {
        this.start = start;
        return this;
    }

    public EntityQueryBuilder<T> setSelectFields(String selectFields) {
        if (selectFields != null) {
            this.selectFields = selectFields;
        }
        return this;
    }

    public String getOrderBys() {
        return this.orderBys;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public QFilter[] getFilters() {
        return this.filters;
    }

    public int getLimit() {
        return this.limit;
    }

    public String getSelectFields() {
        return this.selectFields;
    }

    public int getStart() {
        return this.start;
    }

    public T singleResult() {
        List tx;
        if (this.configurationImpl == null) {
            this.configurationImpl = Context.getProcessEngineConfiguration();
        }
        if ((tx = (List)this.configurationImpl.getCommandExecutor().execute(new FindEntityCmd(this, this.getEntityName()))) != null && tx.size() > 0) {
            return (T)((Entity)tx.get(0));
        }
        return null;
    }

    public List<T> list() {
        if (this.configurationImpl == null) {
            this.configurationImpl = Context.getProcessEngineConfiguration();
        }
        return (List)this.configurationImpl.getCommandExecutor().execute(new FindEntityCmd(this, this.getEntityName()));
    }

    public long count() {
        if (this.configurationImpl == null) {
            this.configurationImpl = Context.getProcessEngineConfiguration();
        }
        return this.configurationImpl.getCommandExecutor().execute(new CountEntityCmd(this.getEntityName(), this));
    }

    public void setConfigurationImpl(ProcessEngineConfigurationImpl configurationImpl) {
        this.configurationImpl = configurationImpl;
    }
}

