/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.dynprocess;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.workflow.bpmn.converter.BpmnJsonConverter;
import kd.bos.workflow.bpmn.model.Activity;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.BillSetting;
import kd.bos.workflow.bpmn.model.BoundaryEvent;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.GraphicInfo;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.SignatureModel;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.engine.TaskService;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.dynprocess.AddSignInfo;
import kd.bos.workflow.engine.dynprocess.freeflow.WFCallActivity;
import kd.bos.workflow.engine.impl.cmd.task.GetTasksByProcessInstanceCmd;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.dynprocess.DynProcessAbstractProcessor;
import kd.bos.workflow.engine.impl.dynprocess.DynProcessProcessorUtil;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.util.WfCommonUtil;
import org.apache.commons.lang.BooleanUtils;

public abstract class AddSignAbstractProcessor
extends DynProcessAbstractProcessor {
    public static FlowElement getNextFlowElement(BpmnModel newBpmnModel, BpmnModel dynBpmnModel, SequenceFlow outgoingFlow) {
        FlowElement flowElement = newBpmnModel.getMainProcess().getFlowElement(outgoingFlow.getTargetRef());
        if (flowElement == null) {
            flowElement = dynBpmnModel.getMainProcess().getFlowElement(outgoingFlow.getTargetRef());
            List<SequenceFlow> outgoingFlows = ((FlowNode)flowElement).getOutgoingFlows();
            for (SequenceFlow sequenceFlow : outgoingFlows) {
                flowElement = AddSignAbstractProcessor.getNextFlowElement(newBpmnModel, dynBpmnModel, sequenceFlow);
            }
        }
        return flowElement;
    }

    public static FlowElement getBeforeFlowElement(BpmnModel newBpmnModel, BpmnModel dynBpmnModel, SequenceFlow incomingFlow) {
        FlowElement flowElement = newBpmnModel.getMainProcess().getFlowElement(incomingFlow.getSourceRef());
        if (flowElement == null) {
            flowElement = dynBpmnModel.getMainProcess().getFlowElement(incomingFlow.getSourceRef());
            List<SequenceFlow> incomingFlows = ((FlowNode)flowElement).getIncomingFlows();
            for (SequenceFlow sequenceFlow : incomingFlows) {
                flowElement = AddSignAbstractProcessor.getNextFlowElement(newBpmnModel, dynBpmnModel, sequenceFlow);
            }
        }
        return flowElement;
    }

    public static void adjustElementPosition(FlowElement flowElement, BpmnModel newBpmnModel, BpmnModel dynBpmnModel, double moveHeight, JSONArray movedNodeIds) {
        movedNodeIds.add((Object)flowElement.getId());
        GraphicInfo graphicInfo = newBpmnModel.getGraphicInfo(flowElement.getId());
        if (graphicInfo == null) {
            graphicInfo = dynBpmnModel.getGraphicInfo(flowElement.getId());
        }
        graphicInfo.setY(graphicInfo.getY() + moveHeight);
        newBpmnModel.addGraphicInfo(flowElement.getId(), graphicInfo);
        if (flowElement instanceof FlowNode) {
            Object boundaryEvents;
            List<SequenceFlow> outgoingFlows = ((FlowNode)flowElement).getOutgoingFlows();
            if (flowElement instanceof Activity && CollectionUtil.isNotEmpty(boundaryEvents = ((Activity)flowElement).getBoundaryEvents())) {
                Iterator<FlowElement> iterator = boundaryEvents.iterator();
                while (iterator.hasNext()) {
                    BoundaryEvent boundaryEvent = (BoundaryEvent)iterator.next();
                    List<SequenceFlow> boundaryEventOutGoings = boundaryEvent.getOutgoingFlows();
                    outgoingFlows.addAll(boundaryEventOutGoings);
                }
            }
            if (outgoingFlows != null && !outgoingFlows.isEmpty()) {
                for (SequenceFlow sequenceFlow : outgoingFlows) {
                    AddSignAbstractProcessor.adjustSequenceFlowPosition(newBpmnModel, moveHeight, sequenceFlow, movedNodeIds);
                    if (!AddSignAbstractProcessor.isNeedAdjustElementPostion(sequenceFlow, newBpmnModel)) continue;
                    FlowElement nextFlowElement = newBpmnModel.getFlowElement(sequenceFlow.getTargetRef());
                    if (nextFlowElement == null) {
                        nextFlowElement = dynBpmnModel.getFlowElement(sequenceFlow.getTargetRef());
                    }
                    if (movedNodeIds.contains((Object)nextFlowElement.getId())) continue;
                    AddSignAbstractProcessor.adjustElementPosition(nextFlowElement, newBpmnModel, dynBpmnModel, moveHeight, movedNodeIds);
                }
            }
            List<SequenceFlow> incomingFlows = ((FlowNode)flowElement).getIncomingFlows();
            for (SequenceFlow sequenceFlow : incomingFlows) {
                AddSignAbstractProcessor.adjustSequenceFlowPosition(newBpmnModel, moveHeight, sequenceFlow, movedNodeIds);
            }
        }
    }

    private static boolean isNeedAdjustElementPostion(SequenceFlow sequenceFlow, BpmnModel newBpmnModel) {
        if (sequenceFlow.isDynamic()) {
            return false;
        }
        if (sequenceFlow.getConditionalRule() != null && sequenceFlow.getConditionalRule().getExpression() != null && !sequenceFlow.isDynamic()) {
            GraphicInfo sourceGraphicInfo = newBpmnModel.getGraphicInfo(sequenceFlow.getSourceRef());
            GraphicInfo targetGraphicInfo = newBpmnModel.getGraphicInfo(sequenceFlow.getTargetRef());
            if (sourceGraphicInfo != null && targetGraphicInfo != null && targetGraphicInfo.getY() < sourceGraphicInfo.getY() - sourceGraphicInfo.getHeight() * 2.0) {
                return false;
            }
        }
        return true;
    }

    private static void adjustSequenceFlowPosition(BpmnModel newBpmnModel, double moveHeight, SequenceFlow sequenceFlow, JSONArray movedNodeIds) {
        if (movedNodeIds.contains((Object)sequenceFlow.getId())) {
            return;
        }
        List<GraphicInfo> graphicInfos = newBpmnModel.getFlowLocationGraphicInfo(sequenceFlow.getId());
        GraphicInfo sourceGraphicInfo = newBpmnModel.getGraphicInfo(sequenceFlow.getSourceRef());
        GraphicInfo targetGraphicInfo = newBpmnModel.getGraphicInfo(sequenceFlow.getTargetRef());
        if (graphicInfos != null && graphicInfos.size() >= 2) {
            ArrayList<GraphicInfo> newGraphicInfos = new ArrayList<GraphicInfo>(graphicInfos.size());
            for (int i = 0; i < graphicInfos.size(); ++i) {
                GraphicInfo graphic = graphicInfos.get(i);
                if (sourceGraphicInfo.getY() > targetGraphicInfo.getY() && i % 2 == 1) continue;
                graphic.setY(graphic.getY() + moveHeight);
                newGraphicInfos.add(graphic);
            }
            newBpmnModel.addFlowGraphicInfoList(sequenceFlow.getId(), newGraphicInfos);
        } else if (graphicInfos != null && graphicInfos.size() == 1 && sourceGraphicInfo != null && targetGraphicInfo != null && sourceGraphicInfo.getHeight() == targetGraphicInfo.getHeight()) {
            ArrayList<GraphicInfo> newGraphicInfos = new ArrayList<GraphicInfo>(graphicInfos.size());
            for (GraphicInfo graphic : graphicInfos) {
                if (Double.compare(graphic.getY(), 0.0) == 1) {
                    graphic.setY(graphic.getY() + moveHeight);
                }
                newGraphicInfos.add(graphic);
            }
            newBpmnModel.addFlowGraphicInfoList(sequenceFlow.getId(), newGraphicInfos);
        }
        movedNodeIds.add((Object)sequenceFlow.getId());
    }

    protected AuditTask createDynamicAuditEvent(ExecutionEntity execution, FlowNode flowNode, BpmnModel bpmnModel, AddSignInfo addSignInfo, List<Long> userIds, Process dynProcess) {
        Map extProps;
        AuditTask auditTask = DynProcessProcessorUtil.createBaseDynamicAuditEvent(execution, flowNode, bpmnModel, userIds, addSignInfo);
        auditTask.setAddSign(true);
        auditTask.setCountersigned(addSignInfo.getAllowAddSign());
        auditTask.setAddSignMsg(addSignInfo.getAddSingMsg());
        if (flowNode instanceof AuditTask) {
            auditTask.setBtnModel(((AuditTask)flowNode).getBtnModel());
        }
        if (flowNode instanceof AuditTask) {
            auditTask.setAllowTransfer(((AuditTask)flowNode).isAllowTransfer());
            if (((AuditTask)flowNode).getBillSetting() != null) {
                if (auditTask.getBillSetting() == null) {
                    auditTask.setBillSetting(new BillSetting());
                }
                auditTask.getBillSetting().setMobilFormKey(((AuditTask)flowNode).getBillSetting().getMobilFormKey());
                auditTask.getBillSetting().setFormKey(((AuditTask)flowNode).getBillSetting().getFormKey());
            }
            if (auditTask instanceof UserTask && flowNode instanceof UserTask) {
                auditTask.setProcessingMobilePage(((UserTask)flowNode).getProcessingMobilePage());
                auditTask.setProcessingPage(((UserTask)flowNode).getProcessingPage());
            }
            this.handleSignatureFromTask(auditTask, execution);
        }
        if (!(extProps = addSignInfo.getExtProps()).isEmpty()) {
            new BpmnJsonConverter().parseAddSignFlowJsonNode(auditTask.getType(), extProps, auditTask, dynProcess);
        }
        return auditTask;
    }

    private <T extends AuditTask> void handleSignatureFromTask(T auditTask, ExecutionEntity execution) {
        TaskEntity currentTask = execution.getCurrentTask();
        if (WfUtils.isNullObject(currentTask)) {
            List<TaskEntity> tasks;
            CommandContext commandContext = Context.getCommandContext();
            if (WfUtils.isNullObject(commandContext)) {
                WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
                TaskService taskService = wfService.getTaskService();
                tasks = taskService.getTasksByProcessInstanceId(execution.getProcessInstanceId());
            } else {
                tasks = new GetTasksByProcessInstanceCmd(execution.getProcessInstanceId()).execute(commandContext);
            }
            if (tasks.size() > 0) {
                currentTask = tasks.get(0);
            }
        }
        if (WfUtils.isNotNullObject(currentTask)) {
            String control = currentTask.getControl();
            Map valueFromMapJson = WfCommonUtil.getValueFromMapJson((String)control);
            Boolean allowSignature = WfCommonUtil.getBooleanValueFromJson((Map)valueFromMapJson, (String)"aS");
            Boolean forceSignature = WfCommonUtil.getBooleanValueFromJson((Map)valueFromMapJson, (String)"fS");
            auditTask.setSignatureModel(new SignatureModel(BooleanUtils.toBoolean((Boolean)allowSignature), BooleanUtils.toBoolean((Boolean)forceSignature)));
        }
    }

    protected YunzhijiaTask createDynamicYunzhijiaEvent(ExecutionEntity execution, FlowNode flowNode, BpmnModel bpmnModel, AddSignInfo addSignInfo, Process dynProcess) {
        List userIds = addSignInfo.getUserIds();
        String businessModel = addSignInfo.getYzjType();
        YunzhijiaTask yunzhijiaTask = DynProcessProcessorUtil.createBaseDynamicYunzhijiaEvent(execution, flowNode, bpmnModel, userIds, businessModel, addSignInfo);
        yunzhijiaTask.setAddSign(true);
        yunzhijiaTask.setCountersigned(addSignInfo.getAllowAddSign());
        yunzhijiaTask.setAddSignMsg(addSignInfo.getAddSingMsg());
        if (flowNode instanceof AuditTask) {
            yunzhijiaTask.setBtnModel(((AuditTask)flowNode).getBtnModel());
        }
        if (yunzhijiaTask instanceof AuditTask) {
            yunzhijiaTask.setAllowTransfer(((AuditTask)flowNode).isAllowTransfer());
            if (((AuditTask)flowNode).getBillSetting() != null) {
                if (yunzhijiaTask.getBillSetting() == null) {
                    yunzhijiaTask.setBillSetting(new BillSetting());
                }
                yunzhijiaTask.getBillSetting().setMobilFormKey(((AuditTask)flowNode).getBillSetting().getMobilFormKey());
                yunzhijiaTask.getBillSetting().setFormKey(((AuditTask)flowNode).getBillSetting().getFormKey());
            }
            if (yunzhijiaTask instanceof UserTask && flowNode instanceof UserTask) {
                yunzhijiaTask.setProcessingMobilePage(((UserTask)flowNode).getProcessingMobilePage());
                yunzhijiaTask.setProcessingPage(((UserTask)flowNode).getProcessingPage());
            }
        }
        this.handleSignatureFromTask(yunzhijiaTask, execution);
        Map extProps = addSignInfo.getExtProps();
        if (!extProps.isEmpty()) {
            new BpmnJsonConverter().parseAddSignFlowJsonNode(yunzhijiaTask.getType(), extProps, yunzhijiaTask, dynProcess);
        }
        return yunzhijiaTask;
    }

    protected CallActivity createDynamicCallEvent(ExecutionEntity execution, FlowNode flowNode, BpmnModel bpmnModel, AddSignInfo addSignInfo, List<Long> userIds, Process dynProcess) {
        CallActivity callActivity = DynProcessProcessorUtil.createBaseDynamicCallEvent(execution, flowNode, bpmnModel, userIds, addSignInfo);
        callActivity.setAddSign(true);
        WFCallActivity wfFlowNode = addSignInfo.getWfFlowNode();
        if (WfUtils.isNotEmpty((ILocaleString)wfFlowNode.getName())) {
            callActivity.setName(wfFlowNode.getName().toString());
        }
        callActivity.setEntityNumber(wfFlowNode.getEntityNumber());
        callActivity.setCalledWay(wfFlowNode.getCalledWay());
        callActivity.setEntityName(wfFlowNode.getEntityName());
        callActivity.setEntityId(wfFlowNode.getEntityId());
        callActivity.setBlockMainProcess(wfFlowNode.isBlockMainProcess());
        callActivity.setCallProcessName(wfFlowNode.getCallProcessName());
        callActivity.setCallProcessId(wfFlowNode.getCallProcessId());
        callActivity.setCallProcessNumber(wfFlowNode.getCallProcessNumber());
        callActivity.setAddSignMsg(addSignInfo.getAddSingMsg());
        Map extProps = wfFlowNode.getExtProps();
        if (!extProps.isEmpty()) {
            new BpmnJsonConverter().parseAddSignFlowJsonNode(callActivity.getType(), extProps, callActivity, dynProcess);
        }
        return callActivity;
    }

    protected void handleMulBpmnModel(Process dynProcess, Map<String, BpmnModel> mulBpmnModel, AddSignInfo addSignInfo, ExecutionEntity execution) {
        HashMap<String, LocaleString> nodeLocaleStringNames = new HashMap<String, LocaleString>();
        for (Map.Entry<String, BpmnModel> entry : mulBpmnModel.entrySet()) {
            String lang = entry.getKey();
            Process cloneProcess = dynProcess.clone();
            List<FlowElement> flowElementList = cloneProcess.getFlowElementList();
            for (int i = 0; i < flowElementList.size(); ++i) {
                FlowElement flowElement = flowElementList.get(i);
                if (flowElement instanceof UserTask) {
                    if (!flowElement.isAddSign()) continue;
                    List nodeNames = addSignInfo.getNodeNames();
                    if (nodeNames != null && i < nodeNames.size()) {
                        LocaleString nodeName = (LocaleString)nodeNames.get(i);
                        flowElement.setName((String)nodeName.get((Object)lang));
                        nodeLocaleStringNames.put(flowElement.getNumber(), nodeName);
                    } else {
                        flowElement.setName(WfConfigurationUtil.getAddSignNameLocaleString().getLocaleValue());
                        nodeLocaleStringNames.put(flowElement.getNumber(), WfConfigurationUtil.getAddSignNameLocaleString());
                    }
                    List decisionOptions = flowElement.getDecisionOptions();
                    for (DecisionOption decisionOption : decisionOptions) {
                        String decisionNumber = decisionOption.getNumber();
                        if ("reject".equals(decisionOption.getAuditType()) && "Reject".equals(decisionNumber)) {
                            decisionOption.setName((String)WFMultiLangConstants.getRejectName().get((Object)lang));
                            continue;
                        }
                        if ("approve".equals(decisionOption.getAuditType()) && "Consent".equals(decisionNumber)) {
                            decisionOption.setName((String)WFMultiLangConstants.getAgreeName().get((Object)lang));
                            continue;
                        }
                        if (!"reject".equals(decisionOption.getAuditType()) || !"RejectToFlowNode".equals(decisionNumber)) continue;
                        decisionOption.setName((String)WFMultiLangConstants.getRejectToAddSignName().get((Object)lang));
                    }
                    continue;
                }
                if (flowElement instanceof SequenceFlow && "addSign".equals(flowElement.getName())) {
                    flowElement.setName((String)WFMultiLangConstants.getAddSignName().get((Object)lang));
                    continue;
                }
                if (!(flowElement instanceof CallActivity) || !flowElement.isAddSign()) continue;
                LocaleString nodeName = addSignInfo.getWfFlowNode().getName();
                if (WfUtils.isNotEmpty((ILocaleString)nodeName)) {
                    flowElement.setName((String)nodeName.get((Object)lang));
                    nodeLocaleStringNames.put(flowElement.getNumber(), nodeName);
                    continue;
                }
                flowElement.setName(WfConfigurationUtil.getAddSignNameLocaleString().getLocaleValue());
                nodeLocaleStringNames.put(flowElement.getNumber(), WfConfigurationUtil.getAddSignNameLocaleString());
            }
            entry.getValue().addProcess(cloneProcess);
        }
        ExecutionEntity processInstance = execution.getProcessInstance();
        Map variable = (Map)processInstance.getVariable("addsigninfonodename");
        if (variable != null) {
            nodeLocaleStringNames.putAll(variable);
        }
        processInstance.setVariable("addsigninfonodename", nodeLocaleStringNames);
    }
}

