/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.dynprocess;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.workflow.bpmn.model.Activity;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.BoundaryEvent;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.GraphicInfo;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.engine.dynprocess.AddSignInfo;
import kd.bos.workflow.engine.impl.dynprocess.AddSignAbstractProcessor;
import kd.bos.workflow.engine.impl.dynprocess.DynProcessProcessorUtil;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;

public class AddSignAfterProcessor
extends AddSignAbstractProcessor {
    @Override
    public SequenceFlow createDynProcess(ExecutionEntity execution, String flowNodeId, BpmnModel newBpmnModel, BpmnModel dynBpmnModel, Process dynProcess, Map<String, BpmnModel> mulBpmnModel, Map<String, Object> params) {
        String addSignInfoStr = (String)execution.getVariable("addsigninfo");
        AddSignInfo addSignInfo = (AddSignInfo)SerializationUtils.fromJsonString((String)addSignInfoStr, AddSignInfo.class);
        FlowNode currentFlowNode = (FlowNode)newBpmnModel.getFlowElement(flowNodeId);
        this.createAddSignAfterElements(execution, currentFlowNode, newBpmnModel, dynProcess, addSignInfo);
        this.handleMulBpmnModel(dynProcess, mulBpmnModel, addSignInfo, execution);
        return null;
    }

    @Override
    public void mergeDynBpmnModel(BpmnModel newBpmnModel, String content) {
        block24: {
            if (content != null) {
                try (TraceSpan ts = Tracer.create((String)"ProcessDefinitionUtil", (String)"mergeBpmnModel");){
                    ts.addTag("content", content);
                    BpmnModel dynBpmnModel = ProcessDefinitionUtil.getBpmnModel(content);
                    if (dynBpmnModel == null) break block24;
                    Process newProcess = newBpmnModel.getMainProcess();
                    for (FlowElement dynFlowElement : dynBpmnModel.getMainProcess().getFlowElementList()) {
                        FlowElement flowElement;
                        SequenceFlow dynSequenceFlow;
                        if (newProcess.getFlowElement(dynFlowElement.getId()) != null) {
                            if (dynFlowElement instanceof SequenceFlow) {
                                dynSequenceFlow = (SequenceFlow)dynFlowElement;
                                SequenceFlow dyn = (SequenceFlow)newProcess.getFlowElement(dynSequenceFlow.getId());
                                dyn.setSourceRef(dynSequenceFlow.getSourceRef());
                                dyn.setSourceFlowElement(dynBpmnModel.getFlowElement(dynSequenceFlow.getTargetRef()));
                                continue;
                            }
                            if (!(dynFlowElement instanceof AuditTask)) continue;
                            List<SequenceFlow> outgoingFlows = ((AuditTask)dynBpmnModel.getFlowElement(dynFlowElement.getId())).getOutgoingFlows();
                            ((FlowNode)newBpmnModel.getFlowElement(dynFlowElement.getId())).setOutgoingFlows(outgoingFlows);
                            flowElement = newBpmnModel.getFlowElement(dynFlowElement.getId());
                            List<BoundaryEvent> boundaryEvents = ((Activity)flowElement).getBoundaryEvents();
                            if (!CollectionUtil.isNotEmpty(boundaryEvents)) continue;
                            GraphicInfo graphicInfo = newBpmnModel.getGraphicInfo(flowElement.getId());
                            double moveHeight = graphicInfo.getHeight() * 2.0;
                            for (BoundaryEvent boundaryEvent : boundaryEvents) {
                                List<SequenceFlow> outgoingFlows2 = boundaryEvent.getOutgoingFlows();
                                for (SequenceFlow outgoingFlow : outgoingFlows2) {
                                    FlowElement targetFlowElement = outgoingFlow.getTargetFlowElement();
                                    JSONArray movedNodeIds = new JSONArray();
                                    AddSignAfterProcessor.adjustElementPosition(targetFlowElement, newBpmnModel, dynBpmnModel, moveHeight, movedNodeIds);
                                }
                            }
                            continue;
                        }
                        if (dynFlowElement instanceof SequenceFlow) {
                            dynSequenceFlow = (SequenceFlow)dynFlowElement;
                            if (dynSequenceFlow.getTargetFlowElement() == null) {
                                flowElement = dynBpmnModel.getFlowElement(dynSequenceFlow.getTargetRef());
                                if (flowElement == null) {
                                    flowElement = newBpmnModel.getFlowElement(dynSequenceFlow.getTargetRef());
                                }
                                dynSequenceFlow.setTargetFlowElement(flowElement);
                            }
                            if (dynSequenceFlow.getSourceFlowElement() == null && (flowElement = dynBpmnModel.getFlowElement(dynSequenceFlow.getSourceRef())) == null) {
                                flowElement = newBpmnModel.getFlowElement(dynSequenceFlow.getSourceRef());
                            }
                            newBpmnModel.addFlowGraphicInfoList(dynFlowElement.getId(), dynBpmnModel.getFlowLocationMap().get(dynFlowElement.getId()));
                            newProcess.addFlowElement(dynFlowElement);
                            continue;
                        }
                        if (!(dynFlowElement instanceof FlowNode)) continue;
                        FlowNode dynFlowNode = (FlowNode)dynFlowElement;
                        List<SequenceFlow> incomingFlows = dynFlowNode.getIncomingFlows();
                        for (SequenceFlow incomingFlow : incomingFlows) {
                            FlowElement flowElement2;
                            if (incomingFlow.isDynamic() || (flowElement2 = AddSignAfterProcessor.getBeforeFlowElement(newBpmnModel, dynBpmnModel, incomingFlow)) == null) continue;
                            GraphicInfo graphicInfo = newBpmnModel.getGraphicInfo(flowElement2.getId());
                            GraphicInfo graphicInfoClone = graphicInfo.clone();
                            newBpmnModel.addGraphicInfo(dynFlowNode.getId(), graphicInfoClone);
                            double moveHeight = graphicInfo.getHeight() * 2.0;
                            JSONArray movedNodeIds = new JSONArray();
                            AddSignAfterProcessor.adjustElementPosition(dynFlowNode, newBpmnModel, dynBpmnModel, moveHeight, movedNodeIds);
                            incomingFlow.setSourceFlowElement(newBpmnModel.getMainProcess().getFlowElement(incomingFlow.getSourceRef()));
                        }
                        List<SequenceFlow> outcomingFlows = dynFlowNode.getOutgoingFlows();
                        for (SequenceFlow sequence : outcomingFlows) {
                            if (sequence.isDynamic()) continue;
                            sequence.setTargetFlowElement(newBpmnModel.getMainProcess().getFlowElement(sequence.getTargetRef()));
                        }
                        newProcess.addFlowElement(dynFlowNode);
                    }
                }
            }
        }
    }

    private void createAddSignAfterElements(ExecutionEntity execution, FlowNode flowNode, BpmnModel newBpmnModel, Process dynProcess, AddSignInfo addSignInfo) {
        if ("node".equals(addSignInfo.getAddSignMod())) {
            this.createAddSignAfterInfoForCallActivity(execution, flowNode, newBpmnModel, dynProcess, addSignInfo);
        } else {
            String addSignDealType = addSignInfo.getAddSignDealType();
            if ("one".equals(addSignDealType) || "anyone".equals(addSignDealType)) {
                this.createAddSignAfterInfoForOneAuditTask(execution, flowNode, newBpmnModel, dynProcess, addSignInfo);
            } else if ("yzj".equals(addSignDealType)) {
                this.createAddSignAfterInfoforOneYunzhijiaTask(execution, flowNode, newBpmnModel, dynProcess, addSignInfo);
            } else {
                this.createAddSignAfterInfoForManyAuditTask(execution, flowNode, newBpmnModel, dynProcess, addSignInfo);
            }
        }
    }

    private void createAddSignAfterInfoForCallActivity(ExecutionEntity execution, FlowNode flowNode, BpmnModel newBpmnModel, Process dynProcess, AddSignInfo addSignInfo) {
        CallActivity callActivity = this.createDynamicCallEvent(execution, flowNode, newBpmnModel, addSignInfo, addSignInfo.getUserIds(), dynProcess);
        newBpmnModel.getMainProcess().addFlowElement(callActivity);
        dynProcess.addFlowElement(callActivity);
        this.adjustOutgoingFlows(callActivity, flowNode, newBpmnModel, dynProcess);
        SequenceFlow staticSequenceFlow = DynProcessProcessorUtil.createStaticSequenceFlow(flowNode.getId(), callActivity.getId(), "addSign", newBpmnModel, dynProcess);
        this.saveFlowNodeOutgoingInfoToNewBmpnModel(staticSequenceFlow, flowNode, newBpmnModel, dynProcess);
    }

    private void createAddSignAfterInfoForManyAuditTask(ExecutionEntity execution, FlowNode flowNode, BpmnModel newBpmnModel, Process dynProcess, AddSignInfo addSignInfo) {
        List userIds = addSignInfo.getUserIds();
        ArrayList<AuditTask> auditTasks = new ArrayList<AuditTask>(userIds.size());
        for (int i = 0; i < userIds.size(); ++i) {
            ArrayList<Long> list = new ArrayList<Long>();
            list.add((Long)userIds.get(i));
            AuditTask auditTask = this.createDynamicAuditEvent(execution, flowNode, newBpmnModel, addSignInfo, list, dynProcess);
            auditTasks.add(auditTask);
            newBpmnModel.getMainProcess().addFlowElement(auditTask);
            dynProcess.addFlowElement(auditTask);
        }
        this.adjustOutgoingFlows((FlowNode)auditTasks.get(auditTasks.size() - 1), flowNode, newBpmnModel, dynProcess);
        SequenceFlow firstSequence = null;
        for (int i = 0; i < auditTasks.size(); ++i) {
            if (i == 0) {
                firstSequence = DynProcessProcessorUtil.createStaticSequenceFlow(flowNode.getId(), ((AuditTask)auditTasks.get(0)).getId(), "addSign", newBpmnModel, dynProcess);
                continue;
            }
            DynProcessProcessorUtil.createStaticSequenceFlow(((AuditTask)auditTasks.get(i - 1)).getId(), ((AuditTask)auditTasks.get(i)).getId(), "", newBpmnModel, dynProcess);
        }
        this.saveFlowNodeOutgoingInfoToNewBmpnModel(firstSequence, flowNode, newBpmnModel, dynProcess);
    }

    private void createAddSignAfterInfoforOneYunzhijiaTask(ExecutionEntity execution, FlowNode flowNode, BpmnModel newBpmnModel, Process dynProcess, AddSignInfo addSignInfo) {
        YunzhijiaTask yunzhijiaTask = this.createDynamicYunzhijiaEvent(execution, flowNode, newBpmnModel, addSignInfo, dynProcess);
        newBpmnModel.getMainProcess().addFlowElement(yunzhijiaTask);
        dynProcess.addFlowElement(yunzhijiaTask);
        this.adjustOutgoingFlows(yunzhijiaTask, flowNode, newBpmnModel, dynProcess);
        SequenceFlow staticSequenceFlow = DynProcessProcessorUtil.createStaticSequenceFlow(flowNode.getId(), yunzhijiaTask.getId(), "addSign", newBpmnModel, dynProcess);
        this.saveFlowNodeOutgoingInfoToNewBmpnModel(staticSequenceFlow, flowNode, newBpmnModel, dynProcess);
    }

    private void createAddSignAfterInfoForOneAuditTask(ExecutionEntity execution, FlowNode flowNode, BpmnModel newBpmnModel, Process dynProcess, AddSignInfo addSignInfo) {
        AuditTask auditTask = this.createDynamicAuditEvent(execution, flowNode, newBpmnModel, addSignInfo, addSignInfo.getUserIds(), dynProcess);
        newBpmnModel.getMainProcess().addFlowElement(auditTask);
        dynProcess.addFlowElement(auditTask);
        this.adjustOutgoingFlows(auditTask, flowNode, newBpmnModel, dynProcess);
        SequenceFlow staticSequenceFlow = DynProcessProcessorUtil.createStaticSequenceFlow(flowNode.getId(), auditTask.getId(), "addSign", newBpmnModel, dynProcess);
        this.saveFlowNodeOutgoingInfoToNewBmpnModel(staticSequenceFlow, flowNode, newBpmnModel, dynProcess);
    }

    private void adjustOutgoingFlows(FlowNode newFlowNode, FlowNode flowNode, BpmnModel bpmnModel, Process dynProcess) {
        List<SequenceFlow> outgoingFlows = flowNode.getOutgoingFlows();
        for (SequenceFlow sequenceFlow : outgoingFlows) {
            if (sequenceFlow.isDynamic()) continue;
            sequenceFlow.setSourceRef(newFlowNode.getId());
            sequenceFlow.setSourceFlowElement(newFlowNode);
            Process mainProcess = bpmnModel.getMainProcess();
            ((FlowNode)mainProcess.getFlowElement(newFlowNode.getId())).getOutgoingFlows().add(sequenceFlow);
            mainProcess.addFlowElement(sequenceFlow);
            dynProcess.addFlowElement(sequenceFlow);
        }
    }

    private void saveFlowNodeOutgoingInfoToNewBmpnModel(SequenceFlow staticSequenceFlow, FlowNode flowNode, BpmnModel newBpmnModel, Process dynProcess) {
        ArrayList<SequenceFlow> outgoingFlows = new ArrayList<SequenceFlow>();
        outgoingFlows.add(staticSequenceFlow);
        flowNode.setOutgoingFlows(outgoingFlows);
        newBpmnModel.getMainProcess().addFlowElement(flowNode);
        dynProcess.addFlowElement(flowNode);
    }
}

