/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.dynprocess;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.GraphicInfo;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.engine.dynprocess.AddSignInfo;
import kd.bos.workflow.engine.impl.dynprocess.AddSignAbstractProcessor;
import kd.bos.workflow.engine.impl.dynprocess.DynProcessProcessorUtil;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.DynamicFlowUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;

public class AddSignBeforeProcessor
extends AddSignAbstractProcessor {
    @Override
    public SequenceFlow createDynProcess(ExecutionEntity execution, String flowNodeId, BpmnModel newBpmnModel, BpmnModel dynBpmnModel, Process dynProcess, Map<String, BpmnModel> mulBpmnModel, Map<String, Object> params) {
        String addSignInfoStr = DynamicFlowUtil.getDynamicVariableValue(execution, "addsigninfo");
        AddSignInfo addSignInfo = (AddSignInfo)SerializationUtils.fromJsonString((String)addSignInfoStr, AddSignInfo.class);
        FlowNode flowNode = (FlowNode)newBpmnModel.getFlowElement(flowNodeId);
        SequenceFlow sequenceFlow = this.createAddSignBeforeElements(execution, flowNode, newBpmnModel, dynProcess, addSignInfo);
        this.handleMulBpmnModel(dynProcess, mulBpmnModel, addSignInfo, execution);
        return sequenceFlow;
    }

    private SequenceFlow createAddSignBeforeElements(ExecutionEntity execution, FlowNode flowNode, BpmnModel newBpmnModel, Process dynProcess, AddSignInfo addSignInfo) {
        if ("node".equals(addSignInfo.getAddSignMod())) {
            return this.createAddSignBeforeInfoForCallActuvity(execution, flowNode, newBpmnModel, dynProcess, addSignInfo);
        }
        String addSignDealType = addSignInfo.getAddSignDealType();
        if ("one".equals(addSignDealType) || "anyone".equals(addSignDealType)) {
            return this.createAddSignBeforeInfoForOneAuditTask(execution, flowNode, newBpmnModel, dynProcess, addSignInfo);
        }
        if ("yzj".equals(addSignDealType)) {
            return this.createAddSignBeforeInfoForOneYunzhijiaTask(execution, flowNode, newBpmnModel, dynProcess, addSignInfo);
        }
        return this.createAddSignBeforeInfoForManyAuditTask(execution, flowNode, newBpmnModel, dynProcess, addSignInfo);
    }

    private SequenceFlow createAddSignBeforeInfoForCallActuvity(ExecutionEntity execution, FlowNode flowNode, BpmnModel bpmnModel, Process dynProcess, AddSignInfo addSignInfo) {
        CallActivity callActivity = this.createDynamicCallEvent(execution, flowNode, bpmnModel, addSignInfo, addSignInfo.getUserIds(), dynProcess);
        bpmnModel.getMainProcess().addFlowElement(callActivity);
        dynProcess.addFlowElement(callActivity);
        this.adjustIncomingFlows(callActivity, flowNode, bpmnModel, dynProcess);
        SequenceFlow staticSequenceFlow = DynProcessProcessorUtil.createStaticSequenceFlow(callActivity.getId(), flowNode.getId(), "", bpmnModel, dynProcess);
        this.saveFlowNodeInfoToNewBmpnModel(staticSequenceFlow, flowNode, bpmnModel, dynProcess);
        return DynProcessProcessorUtil.createSequenceFlow(flowNode.getId(), callActivity.getId(), "addSign", bpmnModel, dynProcess);
    }

    @Override
    public void mergeDynBpmnModel(BpmnModel newBpmnModel, String content) {
        if (content != null) {
            try (TraceSpan ts = Tracer.create((String)"ProcessDefinitionUtil", (String)"mergeBpmnModel");){
                ts.addTag("content", content);
                BpmnModel dynBpmnModel = ProcessDefinitionUtil.getBpmnModel(content);
                if (dynBpmnModel != null) {
                    Process newProcess = newBpmnModel.getMainProcess();
                    for (FlowElement dynFlowElement : dynBpmnModel.getMainProcess().getFlowElementList()) {
                        SequenceFlow dynSequenceFlow;
                        if (newProcess.getFlowElement(dynFlowElement.getId()) != null) {
                            if (dynFlowElement instanceof SequenceFlow) {
                                dynSequenceFlow = (SequenceFlow)dynFlowElement;
                                SequenceFlow dyn = (SequenceFlow)newProcess.getFlowElement(dynSequenceFlow.getId());
                                dyn.setTargetRef(dynSequenceFlow.getTargetRef());
                                dyn.setTargetFlowElement(dynBpmnModel.getFlowElement(dynSequenceFlow.getTargetRef()));
                                continue;
                            }
                            if (!(dynFlowElement instanceof AuditTask)) continue;
                            List<SequenceFlow> incomingFlows = ((AuditTask)dynBpmnModel.getFlowElement(dynFlowElement.getId())).getIncomingFlows();
                            ((FlowNode)newBpmnModel.getFlowElement(dynFlowElement.getId())).setIncomingFlows(incomingFlows);
                            continue;
                        }
                        if (dynFlowElement instanceof SequenceFlow) {
                            FlowElement flowElement;
                            dynSequenceFlow = (SequenceFlow)dynFlowElement;
                            if (dynSequenceFlow.getTargetFlowElement() == null) {
                                flowElement = dynBpmnModel.getFlowElement(dynSequenceFlow.getTargetRef());
                                if (flowElement == null) {
                                    flowElement = newBpmnModel.getFlowElement(dynSequenceFlow.getTargetRef());
                                }
                                dynSequenceFlow.setTargetFlowElement(flowElement);
                            }
                            if (dynSequenceFlow.getSourceFlowElement() == null && (flowElement = dynBpmnModel.getFlowElement(dynSequenceFlow.getSourceRef())) == null) {
                                flowElement = newBpmnModel.getFlowElement(dynSequenceFlow.getSourceRef());
                            }
                            newBpmnModel.addFlowGraphicInfoList(dynFlowElement.getId(), dynBpmnModel.getFlowLocationMap().get(dynFlowElement.getId()));
                            newProcess.addFlowElement(dynFlowElement);
                            continue;
                        }
                        if (!(dynFlowElement instanceof FlowNode)) continue;
                        FlowNode dynFlowNode = (FlowNode)dynFlowElement;
                        List<SequenceFlow> outgoingFlows = dynFlowNode.getOutgoingFlows();
                        for (SequenceFlow sequenceFlow : outgoingFlows) {
                            FlowElement flowElement = AddSignBeforeProcessor.getNextFlowElement(newBpmnModel, dynBpmnModel, sequenceFlow);
                            if (flowElement == null) continue;
                            GraphicInfo graphicInfo = newBpmnModel.getGraphicInfo(flowElement.getId());
                            if (graphicInfo == null) {
                                graphicInfo = dynBpmnModel.getGraphicInfo(flowElement.getId());
                            }
                            GraphicInfo graphicInfoClone = graphicInfo.clone();
                            newBpmnModel.addGraphicInfo(dynFlowNode.getId(), graphicInfoClone);
                            double moveHeight = graphicInfo.getHeight() * 2.0;
                            JSONArray movedNodeIds = new JSONArray();
                            List<SequenceFlow> incomingFlows = ((FlowNode)flowElement).getIncomingFlows();
                            for (SequenceFlow sequenceFlow2 : incomingFlows) {
                                movedNodeIds.add((Object)sequenceFlow2.getId());
                            }
                            AddSignBeforeProcessor.adjustElementPosition(flowElement, newBpmnModel, dynBpmnModel, moveHeight, movedNodeIds);
                        }
                        List<SequenceFlow> incomingFlows = dynFlowNode.getIncomingFlows();
                        for (SequenceFlow sequenceFlow : incomingFlows) {
                            if (sequenceFlow.isDynamic()) continue;
                            sequenceFlow.setSourceFlowElement(newBpmnModel.getMainProcess().getFlowElement(sequenceFlow.getSourceRef()));
                        }
                        List<SequenceFlow> list = dynFlowNode.getOutgoingFlows();
                        for (SequenceFlow sequence : list) {
                            if (sequence.isDynamic()) continue;
                            sequence.setTargetFlowElement(newBpmnModel.getMainProcess().getFlowElement(sequence.getTargetRef()));
                        }
                        newProcess.addFlowElement(dynFlowNode);
                    }
                }
            }
        }
    }

    private SequenceFlow createAddSignBeforeInfoForManyAuditTask(ExecutionEntity execution, FlowNode flowNode, BpmnModel newBpmnModel, Process dynProcess, AddSignInfo addSignInfo) {
        List userIds = addSignInfo.getUserIds();
        ArrayList<AuditTask> auditTasks = new ArrayList<AuditTask>(userIds.size());
        for (int i = 0; i < userIds.size(); ++i) {
            ArrayList<Long> list = new ArrayList<Long>();
            list.add((Long)userIds.get(i));
            AuditTask auditTask = this.createDynamicAuditEvent(execution, flowNode, newBpmnModel, addSignInfo, list, dynProcess);
            auditTasks.add(auditTask);
            newBpmnModel.getMainProcess().addFlowElement(auditTask);
            dynProcess.addFlowElement(auditTask);
        }
        this.adjustIncomingFlows((FlowNode)auditTasks.get(0), flowNode, newBpmnModel, dynProcess);
        SequenceFlow lastSequence = null;
        for (int i = 0; i < auditTasks.size(); ++i) {
            if (i == auditTasks.size() - 1) {
                lastSequence = DynProcessProcessorUtil.createStaticSequenceFlow(((AuditTask)auditTasks.get(auditTasks.size() - 1)).getId(), flowNode.getId(), "", newBpmnModel, dynProcess);
                continue;
            }
            DynProcessProcessorUtil.createStaticSequenceFlow(((AuditTask)auditTasks.get(i)).getId(), ((AuditTask)auditTasks.get(i + 1)).getId(), "", newBpmnModel, dynProcess);
        }
        this.saveFlowNodeInfoToNewBmpnModel(lastSequence, flowNode, newBpmnModel, dynProcess);
        return DynProcessProcessorUtil.createSequenceFlow(flowNode.getId(), ((AuditTask)auditTasks.get(0)).getId(), "addSign", newBpmnModel, dynProcess);
    }

    private SequenceFlow createAddSignBeforeInfoForOneYunzhijiaTask(ExecutionEntity execution, FlowNode flowNode, BpmnModel newBpmnModel, Process dynProcess, AddSignInfo addSignInfo) {
        YunzhijiaTask yunzhijiaTask = this.createDynamicYunzhijiaEvent(execution, flowNode, newBpmnModel, addSignInfo, dynProcess);
        newBpmnModel.getMainProcess().addFlowElement(yunzhijiaTask);
        dynProcess.addFlowElement(yunzhijiaTask);
        this.adjustIncomingFlows(yunzhijiaTask, flowNode, newBpmnModel, dynProcess);
        SequenceFlow staticSequenceFlow = DynProcessProcessorUtil.createStaticSequenceFlow(yunzhijiaTask.getId(), flowNode.getId(), "", newBpmnModel, dynProcess);
        this.saveFlowNodeInfoToNewBmpnModel(staticSequenceFlow, flowNode, newBpmnModel, dynProcess);
        return DynProcessProcessorUtil.createSequenceFlow(flowNode.getId(), yunzhijiaTask.getId(), "addSign", newBpmnModel, dynProcess);
    }

    private SequenceFlow createAddSignBeforeInfoForOneAuditTask(ExecutionEntity execution, FlowNode flowNode, BpmnModel newBpmnModel, Process dynProcess, AddSignInfo addSignInfo) {
        AuditTask auditTask = this.createDynamicAuditEvent(execution, flowNode, newBpmnModel, addSignInfo, addSignInfo.getUserIds(), dynProcess);
        newBpmnModel.getMainProcess().addFlowElement(auditTask);
        dynProcess.addFlowElement(auditTask);
        this.adjustIncomingFlows(auditTask, flowNode, newBpmnModel, dynProcess);
        SequenceFlow staticSequenceFlow = DynProcessProcessorUtil.createStaticSequenceFlow(auditTask.getId(), flowNode.getId(), "", newBpmnModel, dynProcess);
        this.saveFlowNodeInfoToNewBmpnModel(staticSequenceFlow, flowNode, newBpmnModel, dynProcess);
        return DynProcessProcessorUtil.createSequenceFlow(flowNode.getId(), auditTask.getId(), "addSign", newBpmnModel, dynProcess);
    }

    private void saveFlowNodeInfoToNewBmpnModel(SequenceFlow staticSequenceFlow, FlowNode flowNode, BpmnModel newBpmnModel, Process dynProcess) {
        ArrayList<SequenceFlow> incomingFlows = new ArrayList<SequenceFlow>();
        incomingFlows.add(staticSequenceFlow);
        flowNode.setIncomingFlows(incomingFlows);
        newBpmnModel.getMainProcess().addFlowElement(flowNode);
        dynProcess.addFlowElement(flowNode);
    }

    private void adjustIncomingFlows(FlowNode newFlowNode, FlowNode flowNode, BpmnModel bpmnModel, Process dynProcess) {
        List<SequenceFlow> incomingFlows = flowNode.getIncomingFlows();
        for (SequenceFlow sequenceFlow : incomingFlows) {
            if (sequenceFlow.isDynamic()) continue;
            sequenceFlow.setTargetRef(newFlowNode.getId());
            sequenceFlow.setTargetFlowElement(newFlowNode);
            Process mainProcess = bpmnModel.getMainProcess();
            ((FlowNode)mainProcess.getFlowElement(newFlowNode.getId())).getIncomingFlows().add(sequenceFlow);
            mainProcess.addFlowElement(sequenceFlow);
            dynProcess.addFlowElement(sequenceFlow);
        }
    }
}

