/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.dynprocess;

import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.dynprocess.DynProcessAbstractProcessor;
import kd.bos.workflow.engine.impl.dynprocess.DynProcessProcessorUtil;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.DynamicFlowUtil;

public class DynFlowProcessor
extends DynProcessAbstractProcessor {
    @Override
    public SequenceFlow createDynProcess(ExecutionEntity execution, String flowNodeId, BpmnModel newBpmnModel, BpmnModel dynBpmnModel, Process dynProcess, Map<String, BpmnModel> mulBpmnModel, Map<String, Object> params) {
        String nextNodeId = null;
        if (params != null && params.get("nextnodeid") != null) {
            nextNodeId = (String)params.get("nextnodeid");
        }
        if (WfUtils.isEmpty(nextNodeId) && execution.getCurrentTask() != null) {
            nextNodeId = (String)execution.getCurrentTask().getVariable("nextNodeId");
        }
        ILocaleString nameLocale = this.getSequenceFlowName(execution);
        SequenceFlow flow = DynProcessProcessorUtil.createSequenceFlow(flowNodeId, nextNodeId, nameLocale.toString(), newBpmnModel, dynProcess);
        this.handleMulBpmnModel(flow, nameLocale, mulBpmnModel);
        return flow;
    }

    private void handleMulBpmnModel(SequenceFlow flow, ILocaleString nameLocale, Map<String, BpmnModel> mulBpmnModel) {
        for (Map.Entry<String, BpmnModel> entry : mulBpmnModel.entrySet()) {
            String lang = entry.getKey();
            SequenceFlow cloneSequenceFlow = flow.clone();
            cloneSequenceFlow.setName((String)nameLocale.get((Object)lang));
            Process process = new Process();
            process.addFlowElement(cloneSequenceFlow);
            entry.getValue().addProcess(process);
        }
    }

    private ILocaleString getSequenceFlowName(ExecutionEntity execution) {
        LocaleString nameLocale = new LocaleString();
        FlowElement flowElement = execution.getCurrentFlowElement();
        String type = DynamicFlowUtil.getDynamicType(execution);
        if (type == null) {
            return nameLocale;
        }
        switch (type) {
            case "dynReject": {
                nameLocale = WfUtils.getPromptWordLocaleString("\u9a73\u56de", "DynamicFlowUtil_4", "bos-wf-engine");
                break;
            }
            case "dynJump": {
                nameLocale = WfUtils.getPromptWordLocaleString("\u8df3\u8f6c", "DynamicFlowUtil_3", "bos-wf-engine");
                break;
            }
            case "billWithdrawJump": {
                nameLocale = WfUtils.getPromptWordLocaleString("\u6574\u5355\u64a4\u56de", "DynFlowProcessor_3", "bos-wf-engine");
                break;
            }
            case "dynBackToRejectNode": {
                if (flowElement != null && BpmnModelUtil.instanceofUserTaskOnly(flowElement.getType())) {
                    nameLocale = WfUtils.getPromptWordLocaleString("\u63d0\u4ea4", "UserTaskActivityBehavior_1", "bos-wf-engine");
                    break;
                }
                nameLocale = WfUtils.getPromptWordLocaleString("\u91cd\u65b0\u5ba1\u6279", "DynFlowProcessor_0", "bos-wf-engine");
                break;
            }
            case "expireSkip": {
                break;
            }
        }
        return nameLocale;
    }
}

