/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.dynprocess;

import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.lang.Lang;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.impl.dynprocess.IDynProcessProcessor;
import kd.bos.workflow.engine.impl.persistence.entity.management.ParticipantModelEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;

public class DynProcessAbstractProcessor
implements IDynProcessProcessor {
    protected String localeLang = RequestContext.get().getLang().name();
    protected String zhLang = Lang.zh_CN.name();
    protected String twLang = Lang.zh_TW.name();
    protected String enLang = Lang.en_US.name();

    @Override
    public void mergeDynBpmnModel(BpmnModel newBpmnModel, String content) {
        if (content != null) {
            try (TraceSpan ts = Tracer.create((String)"ProcessDefinitionUtil", (String)"mergeBpmnModel");){
                ts.addTag("content", content);
                BpmnModel dynBpmnModel = ProcessDefinitionUtil.getBpmnModel(content);
                if (dynBpmnModel != null) {
                    Process newProcess = newBpmnModel.getMainProcess();
                    for (FlowElement dynFlowElement : dynBpmnModel.getMainProcess().getFlowElementList()) {
                        List<ParticipantModelEntityImpl> participants;
                        UserTask u;
                        if (newProcess.getFlowElement(dynFlowElement.getId()) == null) {
                            newProcess.addFlowElement(dynFlowElement);
                        }
                        if (dynFlowElement instanceof SequenceFlow) {
                            newBpmnModel.addFlowGraphicInfoList(dynFlowElement.getId(), dynBpmnModel.getFlowLocationMap().get(dynFlowElement.getId()));
                            FlowNode source = newProcess.findFlowElementsOfTypeAndId(FlowNode.class, ((SequenceFlow)dynFlowElement).getSourceRef(), true);
                            source.getOutgoingFlows().add((SequenceFlow)dynFlowElement);
                            ((SequenceFlow)dynFlowElement).setSourceFlowElement(source);
                            newProcess.addFlowElementToMap(source);
                            FlowNode target = newProcess.findFlowElementsOfTypeAndId(FlowNode.class, ((SequenceFlow)dynFlowElement).getTargetRef(), true);
                            target.getIncomingFlows().add((SequenceFlow)dynFlowElement);
                            ((SequenceFlow)dynFlowElement).setTargetFlowElement(target);
                            newProcess.addFlowElementToMap(target);
                            continue;
                        }
                        if (!(dynFlowElement instanceof FlowNode)) continue;
                        if (dynFlowElement.isDynamic()) {
                            newBpmnModel.addGraphicInfo(dynFlowElement.getId(), dynBpmnModel.getLocationMap().get(dynFlowElement.getId()));
                            continue;
                        }
                        if (!(dynFlowElement instanceof UserTask) || (u = (UserTask)dynFlowElement) == null || u.getParticipant() == null || !CollectionUtil.isNotEmpty(participants = u.getParticipant().getParticipant())) continue;
                        ((UserTask)newBpmnModel.getFlowElement(u.getId())).getParticipant().setParticipant(participants);
                    }
                }
            }
        }
    }

    @Override
    public SequenceFlow createDynProcess(ExecutionEntity execution, String flowNodeId, BpmnModel newBpmnModel, BpmnModel dynBpmnModel, Process dynProcess, Map<String, BpmnModel> mulBpmnModel, Map<String, Object> params) {
        return null;
    }
}

