/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.dynprocess;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.dynprocess.AddSignAfterProcessor;
import kd.bos.workflow.engine.impl.dynprocess.AddSignBeforeProcessor;
import kd.bos.workflow.engine.impl.dynprocess.DynFlowProcessor;
import kd.bos.workflow.engine.impl.dynprocess.DynProcessAbstractProcessor;
import kd.bos.workflow.engine.impl.dynprocess.DynProcessProcessorUtil;
import kd.bos.workflow.engine.impl.dynprocess.FreeFlowProcessor;
import kd.bos.workflow.engine.impl.dynprocess.IDynProcessProcessor;
import kd.bos.workflow.engine.impl.dynprocess.TerminateProcessor;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandConfig;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.CommandExecutor;
import kd.bos.workflow.engine.impl.interceptor.DefaultCommandContextCloseListener;
import kd.bos.workflow.engine.impl.persistence.IDynamicResourceItem;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricDynamicResourceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.DynamicResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.DynamicResourceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.DynamicFlowUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class DynProcessProcessorHelper {
    private static final String NORESOURCE = "noresource";
    public static final String CLEARSUCESS = "clearSuccess";

    public static SequenceFlow createDynProcess(ExecutionEntity execution, FlowNode flowNode, String dynamicType, Map<String, Object> params) {
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(execution.getProcessDefinitionId(), execution.getProcessInstanceId());
        BpmnModel newBpmnModel = bpmnModel.clone();
        BpmnModel dynBpmnModel = new BpmnModel();
        Process dynProcess = new Process();
        dynBpmnModel.addProcess(dynProcess);
        String type = DynamicFlowUtil.getDynamicType(execution);
        Lang[] supportLangs = WfUtils.getSupportLangs();
        HashMap<String, BpmnModel> mulBpmnModel = new HashMap<String, BpmnModel>(supportLangs.length);
        for (Lang lang : supportLangs) {
            mulBpmnModel.put(lang.name(), new BpmnModel());
        }
        IDynProcessProcessor dynProcessHandler = DynProcessProcessorHelper.getDynProcessHandler(dynamicType);
        SequenceFlow flow = dynProcessHandler.createDynProcess(execution, flowNode.getId(), newBpmnModel, dynBpmnModel, dynProcess, mulBpmnModel, params);
        LocaleString content = new LocaleString();
        for (Lang lang : WfUtils.getSupportLangs()) {
            String key = lang.name();
            DynProcessProcessorUtil.addFlowGraphicInfo(newBpmnModel, (BpmnModel)mulBpmnModel.get(key), dynProcess);
            String dynBpmnModelJson = GraphCodecUtils.convertBpmnModelToJSON((BpmnModel)mulBpmnModel.get(key));
            content.put((Object)key, (Object)dynBpmnModelJson);
        }
        CommandContext commandContext = Context.getCommandContext();
        DynamicResourceEntityManager dynamicResourceEntityManager = commandContext.getDynamicResourceEntityManager();
        DynamicResourceEntity dynamicResourceEntity = (DynamicResourceEntity)dynamicResourceEntityManager.create();
        dynamicResourceEntity.setName("dyn." + newBpmnModel.getMainProcess().getNumber() + ".bpmn20.json");
        dynamicResourceEntity.setProcessDefineId(execution.getProcessDefinitionId());
        dynamicResourceEntity.setProcessInstanceId(execution.getProcessInstanceId());
        if (!"dynBackToRejectNode".equals(type) && !"dynReject".equals(type)) {
            dynamicResourceEntity.setActivityInstanceId(execution.getCurrentActInstId());
        }
        if (flow != null) {
            dynamicResourceEntity.setActivityId(flow.getId());
        }
        if ("freeflow".equals(dynamicType) || "freeflowafternode".equals(dynamicType) || "addsignafter".equals(dynamicType)) {
            dynamicResourceEntity.setActivityId(flowNode.getId());
        }
        dynamicResourceEntity.setContent((ILocaleString)content);
        dynamicResourceEntity.setType(dynamicType);
        dynamicResourceEntity.setOwnerId(Long.parseLong(RequestContext.get().getUserId()));
        dynamicResourceEntity.setTaskId(execution.getCurrentTaskId());
        dynamicResourceEntityManager.insert(dynamicResourceEntity);
        DynProcessProcessorHelper.updateBpmnModel(execution, commandContext);
        return flow;
    }

    public static String clearDynProcess(ExecutionEntity execution, String dynamicType) {
        QFilter qInstanceId = new QFilter("processinstanceid", "=", (Object)execution.getProcessInstanceId());
        QFilter qActivityId = new QFilter("activityid", "=", (Object)execution.getActivityId());
        QFilter qActInstId = new QFilter("activityinstanceid", "=", (Object)execution.getCurrentActInstId());
        QFilter qType = new QFilter("type", "=", (Object)dynamicType);
        QFilter[] qFilters = new QFilter[]{qActivityId, qActInstId, qType, qInstanceId};
        CommandContext commandContext = Context.getCommandContext();
        List findByQueryFilters = commandContext.getDynamicResourceEntityManager().findByQueryFilters(qFilters);
        if (findByQueryFilters == null || findByQueryFilters.isEmpty()) {
            return NORESOURCE;
        }
        commandContext.getDynamicResourceEntityManager().deleteByFilters(qFilters);
        commandContext.getHistoricDynamicResourceEntityManager().deleteByFilters(qFilters);
        DynProcessProcessorHelper.updateBpmnModel(execution, commandContext);
        return CLEARSUCESS;
    }

    public static void clearAddsignAfterByTaskIdAndOwerId(Long processInstanceId, Long taskId, List<Long> trusteeIds, CommandContext commandContext) {
        DynamicResourceEntityManager dynamicResourceEntityManager = commandContext.getDynamicResourceEntityManager();
        HistoricDynamicResourceEntityManager historicDynamicResourceEntityManager = commandContext.getHistoricDynamicResourceEntityManager();
        QFilter taskQFilter = new QFilter("taskId", "=", (Object)taskId);
        QFilter ownerQFilter = new QFilter("ownerId", "in", trusteeIds);
        QFilter[] qFilters = new QFilter[]{taskQFilter, ownerQFilter};
        dynamicResourceEntityManager.deleteByFilters(qFilters);
        historicDynamicResourceEntityManager.deleteByFilters(qFilters);
        ExecutionEntity execution = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(processInstanceId);
        DynProcessProcessorHelper.updateBpmnModel(execution, commandContext);
    }

    public static String clearDynProcess(Long procInstId, String activityId, String dynamicType) {
        QFilter qInstanceId = new QFilter("processinstanceid", "=", (Object)procInstId);
        QFilter qActInstId = new QFilter("activityinstanceid", "=", (Object)0);
        QFilter qActivityId = new QFilter("activityid", "=", (Object)activityId);
        QFilter qType = new QFilter("type", "=", (Object)dynamicType);
        QFilter[] qFilters = new QFilter[]{qInstanceId, qType, qActivityId, qActInstId};
        CommandContext commandContext = Context.getCommandContext();
        List findByQueryFilters = commandContext.getDynamicResourceEntityManager().findByQueryFilters(qFilters);
        if (findByQueryFilters == null || findByQueryFilters.isEmpty()) {
            return NORESOURCE;
        }
        commandContext.getDynamicResourceEntityManager().deleteByFilters(qFilters);
        commandContext.getHistoricDynamicResourceEntityManager().deleteByFilters(qFilters);
        ExecutionEntity execution = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(procInstId);
        DynProcessProcessorHelper.updateBpmnModel(execution, commandContext);
        return CLEARSUCESS;
    }

    public static void updateBpmnModel(ExecutionEntity execution, CommandContext commandContext) {
        Date modifyDate = commandContext.getProcessEngineConfiguration().getClock().getCurrentTime();
        execution.setModifyDate(modifyDate);
        ExecutionEntity processInstance = execution.getProcessInstance();
        processInstance.setModifyDate(modifyDate);
        commandContext.getExecutionEntityManager().update(processInstance);
        HistoricProcessInstanceEntityManager hisProcInstManager = commandContext.getHistoricProcessInstanceEntityManager();
        HistoricProcessInstanceEntity historicProcessInstance = (HistoricProcessInstanceEntity)hisProcInstManager.findById(execution.getProcessInstanceId());
        historicProcessInstance.setModifyDate(modifyDate);
        hisProcInstManager.update(historicProcessInstance);
        final Long processInstanceId = execution.getProcessInstanceId();
        DynProcessProcessorHelper.clearCacheAndReload(commandContext, processInstanceId);
        commandContext.addCloseListener(new DefaultCommandContextCloseListener(""){

            @Override
            public void closed(CommandContext commandContext) {
                CommandExecutor commandExecutor = commandContext.getProcessEngineConfiguration().getCommandExecutor();
                CommandConfig commandConfig = commandExecutor.getDefaultConfig().transactionRequiresNew();
                commandExecutor.execute(commandConfig, new Command<Void>(){

                    @Override
                    public Void execute(CommandContext commandContext) {
                        DynProcessProcessorHelper.clearCacheAndReload(commandContext, processInstanceId);
                        return null;
                    }
                });
            }
        });
    }

    private static void clearCacheAndReload(CommandContext commandContext, Long processInstanceId) {
        WfCacheHelper.removeCachedDynamicProcessInstance(processInstanceId);
        commandContext.getDeploymentManager().getProcessDefinitionCache().remove(processInstanceId);
        HistoricProcessInstanceEntity procInst = (HistoricProcessInstanceEntity)commandContext.getHistoricProcessInstanceEntityManager().findById(processInstanceId);
        if (procInst != null && WfUtils.isNotEmpty(procInst.getSchemeId())) {
            Long schemeId = procInst.getSchemeId();
            commandContext.getDeploymentManager().getProcessDefinitionCache().remove(schemeId);
        }
        ProcessDefinitionUtil.getBpmnModel(null, processInstanceId);
    }

    public static void mergeDynBpmnModel(BpmnModel bpmnModel, String content, String dynResourceType) {
        IDynProcessProcessor dynProcessHandler = DynProcessProcessorHelper.getDynProcessHandler(dynResourceType);
        dynProcessHandler.mergeDynBpmnModel(bpmnModel, content);
    }

    public static List<IDynamicResourceItem> getDynamicResourceItem(Long taskId, String dynResourceType) {
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        return wfService.getTaskService().getDynProcessContent(taskId, dynResourceType);
    }

    private static IDynProcessProcessor getDynProcessHandler(String type) {
        if ("addsignbefore".equals(type)) {
            return new AddSignBeforeProcessor();
        }
        if ("addsignafter".equals(type)) {
            return new AddSignAfterProcessor();
        }
        if ("freeflow".equals(type) || "freeflowafternode".equals(type)) {
            return new FreeFlowProcessor();
        }
        if ("terminateEvent".equals(type)) {
            return new TerminateProcessor();
        }
        if ("sequenceFlow".equals(type)) {
            return new DynFlowProcessor();
        }
        return new DynProcessAbstractProcessor();
    }
}

