/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.dynprocess;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.AutoTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.EndEvent;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.ParticipatantModel;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SelectNodesModel;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.dynprocess.AddSignInfo;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;
import kd.bos.workflow.engine.impl.bpmn.parser.factory.ActivityBehaviorFactory;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.ParticipantModelEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;

public class DynProcessProcessorUtil {
    private static List<DecisionOption> setDefaultDecisionOptions(BpmnModel bpmnModel) {
        ArrayList<DecisionOption> options = new ArrayList<DecisionOption>();
        options.add(DynProcessProcessorUtil.getConsentOption());
        DecisionOption rejectOption = new DecisionOption();
        rejectOption.setId(BpmnDiffUtil.getListElementId("decisionOptions"));
        rejectOption.setNumber("Reject");
        rejectOption.setAuditType("reject");
        SelectNodesModel snm = new SelectNodesModel();
        UserTask firstUserTask = BpmnModelUtil.getFirstUserTask(bpmnModel.getMainProcess());
        if (firstUserTask == null) {
            return options;
        }
        snm.setName(firstUserTask.getName());
        snm.setDocumentation("");
        snm.setItemId(firstUserTask.getId());
        ArrayList<SelectNodesModel> rejectOptions = new ArrayList<SelectNodesModel>();
        rejectOptions.add(snm);
        rejectOption.setRejectOptions(rejectOptions);
        options.add(rejectOption);
        return options;
    }

    private static List<DecisionOption> setConsentDecisionOptions() {
        ArrayList<DecisionOption> options = new ArrayList<DecisionOption>();
        options.add(DynProcessProcessorUtil.getConsentOption());
        return options;
    }

    private static DecisionOption getConsentOption() {
        DecisionOption decisionOption = new DecisionOption();
        decisionOption.setId(BpmnDiffUtil.getListElementId("decisionOptions"));
        decisionOption.setNumber("Consent");
        decisionOption.setDefaultDecision(true);
        decisionOption.setAuditType("approve");
        return decisionOption;
    }

    private static DecisionOption getRejectOption(BpmnModel bpmnModel, FlowNode flowNode) {
        DecisionOption decisionOption = new DecisionOption();
        decisionOption.setId(BpmnDiffUtil.getListElementId("decisionOptions"));
        decisionOption.setNumber("RejectToFlowNode");
        decisionOption.setDefaultDecision(false);
        decisionOption.setAuditType("reject");
        SelectNodesModel snm = new SelectNodesModel();
        ArrayList<SelectNodesModel> rejectOptions = new ArrayList<SelectNodesModel>();
        snm.setName(flowNode.getName());
        snm.setDocumentation("");
        snm.setItemId(flowNode.getId());
        rejectOptions.add(snm);
        decisionOption.setRejectOptions(rejectOptions);
        return decisionOption;
    }

    public static void initBillInfo(ExecutionEntity execution, Map<String, Object> config) {
        String entityNumber = execution.getEntityNumber();
        DynamicObject billInfo = BusinessDataServiceHelper.loadSingle((String)"bos_formmeta", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)entityNumber)});
        config.put("entityId", billInfo.get("id"));
        config.put("entityName", billInfo.getLocaleString("name").getLocaleValue());
        config.put("entityNumber", entityNumber);
    }

    private static ParticipatantModel getParticipantModel(List<Long> userIds) {
        ParticipatantModel model = new ParticipatantModel();
        if (userIds != null && !userIds.isEmpty()) {
            ArrayList<ParticipantModelEntityImpl> list = new ArrayList<ParticipantModelEntityImpl>(userIds.size());
            for (Long userId : userIds) {
                ParticipantModelEntityImpl participant = new ParticipantModelEntityImpl();
                participant.setType("person");
                participant.setValue(String.valueOf(userId));
                participant.setProperty("participant");
                participant.setId(Long.valueOf(BpmnDiffUtil.getListElementId("participant")));
                list.add(participant);
            }
            model.setParticipant(list);
        }
        return model;
    }

    public static SequenceFlow createSequenceFlow(String from, String to, String name, BpmnModel bpmnModel, Process dynProcess) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("is_dynamic_node", Boolean.TRUE);
        SequenceFlow flow = (SequenceFlow)GraphCodecUtils.getDefaultElement(SequenceFlow.class, bpmnModel, config);
        flow.setType("SequenceFlow");
        flow.setDynamic(true);
        flow.setName(name);
        flow.setSourceRef(from);
        Process mainProcess = bpmnModel.getMainProcess();
        FlowNode source = mainProcess.findFlowElementsOfTypeAndId(FlowNode.class, from, false);
        flow.setSourceFlowElement(source);
        flow.setTargetRef(to);
        FlowNode target = mainProcess.findFlowElementsOfTypeAndId(FlowNode.class, to, false);
        flow.setTargetFlowElement(target);
        source.getOutgoingFlows().add(flow);
        target.getIncomingFlows().add(flow);
        ConditionalRuleEntityImpl conditionalRule = new ConditionalRuleEntityImpl();
        conditionalRule.setElementid(flow.getId());
        conditionalRule.setType(ConditionalRuleType.sequenceFlow.toString());
        conditionalRule.setExpression(String.format("${ %s %s \"%s\" }", "nextNodeId", "==", to));
        ArrayList<ConditionalEntity> entryentity = new ArrayList<ConditionalEntity>();
        ConditionalEntityImpl conditional = new ConditionalEntityImpl();
        conditional.setParamnumber("nextNodeId");
        conditional.setOperation("==");
        conditional.setValue(to);
        entryentity.add(conditional);
        conditionalRule.setEntryentity(entryentity);
        flow.setConditionalRule(conditionalRule);
        mainProcess.addFlowElement(flow);
        mainProcess.addFlowElementToMap(source);
        mainProcess.addFlowElementToMap(target);
        dynProcess.addFlowElement(flow);
        return flow;
    }

    public static EndEvent createEndEvent(BpmnModel bpmnModel) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("is_dynamic_node", Boolean.TRUE);
        String modelType = GraphCodecUtils.getModelTypeByProcessType(bpmnModel.getMainProcess().getProcessType());
        EndEvent endEvent = (EndEvent)GraphCodecUtils.getDefaultElement(modelType, "EndTerminateEvent", bpmnModel, config);
        endEvent.setDynamic(true);
        ActivityBehaviorFactory activityBehaviorFactory = Context.getCommandContext().getProcessEngineConfiguration().getActivityBehaviorFactory();
        endEvent.setBehavior(activityBehaviorFactory.createTerminateEndEventActivityBehavior(endEvent));
        return endEvent;
    }

    public static SequenceFlow createStaticSequenceFlow(String from, String to, String name, BpmnModel bpmnModel, Process dynProcess) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("is_dynamic_node", Boolean.TRUE);
        SequenceFlow flow = (SequenceFlow)GraphCodecUtils.getDefaultElement(SequenceFlow.class, bpmnModel, config);
        flow.setType("SequenceFlow");
        flow.setDynamic(false);
        flow.setAddSign(true);
        flow.setName(name);
        flow.setSourceRef(from);
        Process mainProcess = bpmnModel.getMainProcess();
        FlowNode source = mainProcess.findFlowElementsOfTypeAndId(FlowNode.class, from, false);
        flow.setSourceFlowElement(source);
        flow.setTargetRef(to);
        FlowNode target = mainProcess.findFlowElementsOfTypeAndId(FlowNode.class, to, false);
        flow.setTargetFlowElement(target);
        source.getOutgoingFlows().add(flow);
        target.getIncomingFlows().add(flow);
        flow.setConditionalRule(null);
        mainProcess.addFlowElement(flow);
        mainProcess.addFlowElementToMap(source);
        mainProcess.addFlowElementToMap(target);
        dynProcess.addFlowElement(flow);
        return flow;
    }

    public static void addFlowGraphicInfo(BpmnModel newBpmnModel, BpmnModel dynBpmnModel, Process dynProcess) {
        for (FlowElement flowElement : dynProcess.getFlowElementList()) {
            if (flowElement instanceof SequenceFlow) {
                dynBpmnModel.addFlowGraphicInfoList(flowElement.getId(), newBpmnModel.getFlowLocationMap().get(flowElement.getId()));
                continue;
            }
            if (!(flowElement instanceof FlowNode)) continue;
            dynBpmnModel.addGraphicInfo(flowElement.getId(), newBpmnModel.getLocationMap().get(flowElement.getId()));
        }
    }

    public static UserTask createBaseDynamicUserEvent(ExecutionEntity execution, BpmnModel bpmnModel, List<Long> userIds) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("is_dynamic_node", Boolean.TRUE);
        DynProcessProcessorUtil.initBillInfo(execution, config);
        String modelType = GraphCodecUtils.getModelTypeByProcessType(bpmnModel.getMainProcess().getProcessType());
        UserTask userTask = (UserTask)GraphCodecUtils.getDefaultElement(modelType, "UserTask", bpmnModel, config);
        ParticipatantModel model = DynProcessProcessorUtil.getParticipantModel(userIds);
        userTask.setParticipant(model);
        List<DecisionOption> decisionOptions = DynProcessProcessorUtil.setConsentDecisionOptions();
        decisionOptions.get(0).setNumber("submit");
        userTask.setDecisionOptions(decisionOptions);
        return userTask;
    }

    public static AuditTask createBaseDynamicAuditEvent(ExecutionEntity execution, FlowNode flowNode, BpmnModel bpmnModel, List<Long> userIds, AddSignInfo addSignInfo) {
        Map participant;
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("is_dynamic_node", Boolean.TRUE);
        DynProcessProcessorUtil.initBillInfo(execution, config);
        Process mainProcess = bpmnModel.getMainProcess();
        String modelType = GraphCodecUtils.getModelTypeByProcessType(mainProcess.getProcessType());
        AuditTask auditTask = (AuditTask)GraphCodecUtils.getDefaultElement(modelType, "AuditTask", bpmnModel, config);
        auditTask.setDynamic(false);
        ParticipatantModel model = DynProcessProcessorUtil.getParticipantModel(userIds);
        Map extProps = addSignInfo.getExtProps();
        if (extProps != null && extProps.get("participant") != null && (participant = (Map)extProps.get("participant")) != null && participant.get("displaySetting") != null && participant.get("displayInfo") != null) {
            Object displayInfo;
            Object displaySetting = participant.get("displaySetting");
            if (displaySetting instanceof Boolean) {
                model.setDisplaySetting((Boolean)displaySetting);
            }
            if ((displayInfo = participant.get("displayInfo")) instanceof String) {
                model.setDisplayInfo(String.valueOf(displayInfo));
            }
            extProps.remove("participant");
        }
        auditTask.setParticipant(model);
        String boundaryEventId = mainProcess.getBoundaryEventId(flowNode.getId());
        if (WfUtils.isNotEmpty(boundaryEventId)) {
            auditTask.setDecisionOptions(DynProcessProcessorUtil.setConsentDecisionOptions());
        } else {
            auditTask.setDecisionOptions(DynProcessProcessorUtil.setDefaultDecisionOptions(bpmnModel));
            if ("addsignafter".equals(addSignInfo.getAddSignType())) {
                List<DecisionOption> options = auditTask.getDecisionOptions();
                options.add(DynProcessProcessorUtil.getRejectOption(bpmnModel, flowNode));
            }
        }
        return auditTask;
    }

    public static YunzhijiaTask createBaseDynamicYunzhijiaEvent(ExecutionEntity execution, FlowNode flowNode, BpmnModel bpmnModel, List<Long> userIds, String businessModel, AddSignInfo addSignInfo) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("is_dynamic_node", Boolean.TRUE);
        DynProcessProcessorUtil.initBillInfo(execution, config);
        Process mainProcess = bpmnModel.getMainProcess();
        String modelType = GraphCodecUtils.getModelTypeByProcessType(mainProcess.getProcessType());
        YunzhijiaTask yunzhijiaTask = (YunzhijiaTask)GraphCodecUtils.getDefaultElement(modelType, "YunzhijiaTask", bpmnModel, config);
        yunzhijiaTask.setDynamic(false);
        yunzhijiaTask.setBusinessModel(businessModel);
        ParticipatantModel model = DynProcessProcessorUtil.getParticipantModel(userIds);
        yunzhijiaTask.setParticipant(model);
        String boundaryEventId = mainProcess.getBoundaryEventId(flowNode.getId());
        if (WfUtils.isNotEmpty(boundaryEventId)) {
            yunzhijiaTask.setDecisionOptions(DynProcessProcessorUtil.setConsentDecisionOptions());
        } else {
            yunzhijiaTask.setDecisionOptions(DynProcessProcessorUtil.setDefaultDecisionOptions(bpmnModel));
            if ("addsignafter".equals(addSignInfo.getAddSignType()) && !"passByOne".equals(addSignInfo.getYzjType())) {
                List<DecisionOption> options = yunzhijiaTask.getDecisionOptions();
                options.add(DynProcessProcessorUtil.getRejectOption(bpmnModel, flowNode));
            }
        }
        return yunzhijiaTask;
    }

    public static SequenceFlow createBaseDynamicSequenceFlow(String from, String to, BpmnModel bpmnModel) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("is_dynamic_node", Boolean.TRUE);
        SequenceFlow flow = (SequenceFlow)GraphCodecUtils.getDefaultElement(SequenceFlow.class, bpmnModel, config);
        flow.setType("SequenceFlow");
        flow.setDynamic(false);
        flow.setSourceRef(from);
        Process mainProcess = bpmnModel.getMainProcess();
        FlowNode source = mainProcess.findFlowElementsOfTypeAndId(FlowNode.class, from, false);
        flow.setSourceFlowElement(source);
        flow.setTargetRef(to);
        FlowNode target = mainProcess.findFlowElementsOfTypeAndId(FlowNode.class, to, false);
        flow.setTargetFlowElement(target);
        flow.setConditionalRule(null);
        return flow;
    }

    public static AutoTask createBaseDynamicAutoEvent(ExecutionEntity execution, BpmnModel bpmnModel) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("is_dynamic_node", Boolean.TRUE);
        DynProcessProcessorUtil.initBillInfo(execution, config);
        String modelType = GraphCodecUtils.getModelTypeByProcessType(bpmnModel.getMainProcess().getProcessType());
        AutoTask autoTask = (AutoTask)GraphCodecUtils.getDefaultElement(modelType, "AutoTask", bpmnModel, config);
        autoTask.setDynamic(false);
        return autoTask;
    }

    public static CallActivity createBaseDynamicCallEvent(ExecutionEntity execution, FlowNode flowNode, BpmnModel bpmnModel, List<Long> userIds, AddSignInfo addSignInfo) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("is_dynamic_node", Boolean.TRUE);
        DynProcessProcessorUtil.initBillInfo(execution, config);
        Process mainProcess = bpmnModel.getMainProcess();
        String modelType = GraphCodecUtils.getModelTypeByProcessType(mainProcess.getProcessType());
        CallActivity callActivity = (CallActivity)GraphCodecUtils.getDefaultElement(modelType, "CallActivity", bpmnModel, config);
        callActivity.setDynamic(false);
        return callActivity;
    }
}

