/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.dynprocess;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.workflow.bpmn.converter.BpmnJsonConverter;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.model.ActivitiListener;
import kd.bos.workflow.bpmn.model.Artifact;
import kd.bos.workflow.bpmn.model.BillExceptionOp;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.EventListener;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.GraphicInfo;
import kd.bos.workflow.bpmn.model.Lane;
import kd.bos.workflow.bpmn.model.Macro;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SelectNodesModel;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.StartEvent;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.ValuedDataObject;
import kd.bos.workflow.bpmn.model.Variable;
import kd.bos.workflow.domain.model.NodeForkJoinModel;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.dynprocess.DynProcessAbstractProcessor;
import kd.bos.workflow.engine.impl.dynprocess.DynProcessProcessorUtil;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFException;

public class FreeFlowProcessor
extends DynProcessAbstractProcessor {
    protected static Log log = LogFactory.getLog(FreeFlowProcessor.class);
    private static final String NEXTNODES = "nextNodes";
    private static final String SOURCEREF = "sourceRef";

    @Override
    public SequenceFlow createDynProcess(ExecutionEntity execution, String flowNodeId, BpmnModel newBpmnModel, BpmnModel dynBpmnModel, Process dynProcess, Map<String, BpmnModel> mulBpmnModel, Map<String, Object> params) {
        String freeFlowModelJson = (String)params.get("freeflowmodelstr");
        boolean isFromPlugin = "freeflowsourceplugin".equals(params.get("freeflowsource"));
        BpmnJsonConverter converter = new BpmnJsonConverter();
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(freeFlowModelJson.getBytes(StandardCharsets.UTF_8));
            ObjectNode modelNode = (ObjectNode)new ObjectMapper().readTree((InputStream)inputStream);
            this.initProcess(modelNode, dynBpmnModel, dynProcess, mulBpmnModel, converter, isFromPlugin, newBpmnModel);
            ArrayNode nextNodes = (ArrayNode)modelNode.get(NEXTNODES);
            FlowNode flowNode = (FlowNode)newBpmnModel.getFlowElement(flowNodeId);
            this.parseFreeFlowElement(execution, newBpmnModel, dynProcess, converter, nextNodes, flowNode, true, mulBpmnModel, false, isFromPlugin);
        }
        catch (Exception e) {
            log.error(String.format("convert freeFlowJsonError,exception is {%s}", WfUtils.getExceptionStacktrace(e)), (Throwable)e);
            throw new WFException(e, WFErrorCode.parseFreeFlowProcessError(), e.getMessage());
        }
        if (isFromPlugin) {
            this.getResultSequenceFlow(flowNodeId, dynProcess, params);
        }
        return null;
    }

    private void getResultSequenceFlow(String flowNodeId, Process dynProcess, Map<String, Object> params) {
        List<FlowElement> flowElementList = dynProcess.getFlowElementList();
        if (CollectionUtil.isNotEmpty(flowElementList)) {
            ArrayList<SequenceFlow> sequenceFlows = new ArrayList<SequenceFlow>();
            for (FlowElement flowElement : flowElementList) {
                if (!(flowElement instanceof SequenceFlow) || !flowNodeId.equals(((SequenceFlow)flowElement).getSourceRef())) continue;
                sequenceFlows.add((SequenceFlow)flowElement);
            }
            params.put("sequenceFlows", sequenceFlows);
        }
    }

    private void parseFreeFlowElement(ExecutionEntity execution, BpmnModel newBpmnModel, Process dynProcess, BpmnJsonConverter converter, ArrayNode nextNodes, FlowNode flowNode, boolean isFirstNode, Map<String, BpmnModel> mulBpmnModel, boolean addDefaultRejectNode, boolean isFromPlugin) {
        for (JsonNode shapeNode : nextNodes) {
            String elemType = shapeNode.get("type").asText();
            String id = shapeNode.get("id").asText();
            if (newBpmnModel.getFlowElement(id) != null) continue;
            FlowElement flowElement = this.createBaseDynamicElement(elemType, id, execution, newBpmnModel);
            if (flowElement == null) {
                log.error(String.format("convert freeFlowJsonError,exception is {%s}", elemType));
                throw new WFException(WFErrorCode.parseFreeFlowProcessError(), new Object[0]);
            }
            ObjectNode tmp = (ObjectNode)shapeNode;
            JsonNode incomings = shapeNode.get("incomings");
            tmp.remove("incomings");
            converter.parseFreeFlowJsonNode(elemType, shapeNode, flowElement, dynProcess);
            tmp.put("incomings", incomings);
            if (isFirstNode && !isFromPlugin && !"UserTask".equals(elemType)) {
                addDefaultRejectNode = true;
                this.createUserTaskAndSequences(execution, newBpmnModel, dynProcess, flowNode, mulBpmnModel, flowElement);
            }
            if (addDefaultRejectNode) {
                this.addDefaultRejectNode(newBpmnModel, flowElement);
            }
            this.handMulBpnmModel(shapeNode, flowElement, newBpmnModel, dynProcess, mulBpmnModel);
            this.createNeedSequenceAndNode(shapeNode, flowElement, dynProcess, newBpmnModel, flowNode, isFirstNode, mulBpmnModel, isFromPlugin);
            ArrayNode nextNextNodes = (ArrayNode)shapeNode.get(NEXTNODES);
            if (nextNextNodes == null || nextNextNodes.size() <= 0) continue;
            this.parseFreeFlowElement(execution, newBpmnModel, dynProcess, converter, nextNextNodes, flowNode, false, mulBpmnModel, addDefaultRejectNode, false);
        }
    }

    private void addDefaultRejectNode(BpmnModel newBpmnModel, FlowElement flowElement) {
        if (flowElement instanceof UserTask) {
            List<UserTask> elements = newBpmnModel.getMainProcess().findFlowElementsOfType(UserTask.class);
            UserTask firstUserTask = elements.get(0);
            List decisionOptions = flowElement.getDecisionOptions();
            String listElementId = BpmnDiffUtil.getListElementId("decisionOptions");
            if (decisionOptions == null || decisionOptions.isEmpty()) {
                ArrayList<DecisionOption> options = new ArrayList<DecisionOption>();
                DecisionOption rejectOption = new DecisionOption();
                rejectOption.setId(listElementId);
                rejectOption.setNumber("Reject");
                rejectOption.setAuditType("reject");
                SelectNodesModel snm = new SelectNodesModel();
                snm.setName(firstUserTask.getName());
                snm.setDocumentation("");
                snm.setItemId(firstUserTask.getId());
                ArrayList<SelectNodesModel> rejectOptions = new ArrayList<SelectNodesModel>();
                rejectOptions.add(snm);
                rejectOption.setRejectOptions(rejectOptions);
                options.add(rejectOption);
                ((UserTask)flowElement).setDecisionOptions(options);
            } else {
                List<SelectNodesModel> rejectOptions;
                boolean isContainRejectNode = false;
                for (DecisionOption decisionOption : decisionOptions) {
                    if (decisionOption.getAuditType() == null || !decisionOption.getAuditType().equals("reject")) continue;
                    rejectOptions = decisionOption.getRejectOptions();
                    SelectNodesModel selectNodesModel = new SelectNodesModel();
                    selectNodesModel.setItemId(firstUserTask.getId());
                    selectNodesModel.setName(firstUserTask.getName());
                    rejectOptions.add(selectNodesModel);
                    isContainRejectNode = true;
                }
                if (!isContainRejectNode) {
                    DecisionOption rejectOption = new DecisionOption();
                    rejectOption.setId(listElementId);
                    rejectOption.setNumber("Reject");
                    rejectOption.setAuditType("reject");
                    SelectNodesModel snm = new SelectNodesModel();
                    snm.setName(firstUserTask.getName());
                    snm.setDocumentation("");
                    snm.setItemId(firstUserTask.getId());
                    rejectOptions = new ArrayList<SelectNodesModel>();
                    rejectOptions.add(snm);
                    rejectOption.setRejectOptions(rejectOptions);
                    decisionOptions.add(rejectOption);
                }
            }
        }
    }

    private void createUserTaskAndSequences(ExecutionEntity execution, BpmnModel newBpmnModel, Process dynProcess, FlowNode flowNode, Map<String, BpmnModel> mulBpmnModel, FlowElement flowElement) {
        FlowElement userTask = this.getUserTask(newBpmnModel);
        if (userTask == null) {
            ArrayList<Long> userIds = new ArrayList<Long>();
            userIds.add(Long.valueOf(RequestContext.get().getUserId()));
            userTask = DynProcessProcessorUtil.createBaseDynamicUserEvent(execution, newBpmnModel, userIds);
            this.handUserTaskMulBpnmModel(userTask, newBpmnModel, dynProcess, mulBpmnModel);
            SequenceFlow sequenceFlow1 = DynProcessProcessorUtil.createBaseDynamicSequenceFlow(flowNode.getId(), userTask.getId(), newBpmnModel);
            this.handMulBpnmModel(null, sequenceFlow1, newBpmnModel, dynProcess, mulBpmnModel);
        }
        SequenceFlow sequenceFlow2 = DynProcessProcessorUtil.createBaseDynamicSequenceFlow(userTask.getId(), flowElement.getId(), newBpmnModel);
        this.handMulBpnmModel(null, sequenceFlow2, newBpmnModel, dynProcess, mulBpmnModel);
    }

    private void handMulBpnmModel(JsonNode shapeNode, FlowElement flowElement, BpmnModel newBpmnModel, Process dynProcess, Map<String, BpmnModel> mulBpmnModel) {
        for (Lang lang : WfUtils.getSupportLangs()) {
            String key = lang.name();
            FlowElement element = flowElement.clone();
            if (shapeNode == null) {
                mulBpmnModel.get(key).getMainProcess().addFlowElement(element);
                continue;
            }
            JsonNode nodeName = shapeNode.get("name");
            if (nodeName != null) {
                JsonNode value = nodeName.get(key);
                if (this.localeLang.equals(key) && value != null) {
                    flowElement.setName(value.asText());
                }
                if (value != null) {
                    element.setName(value.asText());
                }
            }
            if (flowElement instanceof UserTask) {
                JsonNode autoAudit;
                JsonNode value;
                ArrayNode decisionOptions = (ArrayNode)shapeNode.get("decisionOptions");
                if (decisionOptions != null && decisionOptions.size() > 0) {
                    for (int i = 0; i < decisionOptions.size(); ++i) {
                        JsonNode decisionOptionName = decisionOptions.get(i).get("name");
                        if (decisionOptionName == null) continue;
                        value = decisionOptionName.get(key);
                        if (this.localeLang.equals(key) && value != null) {
                            ((DecisionOption)flowElement.getDecisionOptions().get(i)).setName(value.asText());
                        }
                        if (value == null) continue;
                        ((DecisionOption)element.getDecisionOptions().get(i)).setName(value.asText());
                    }
                }
                if ((autoAudit = shapeNode.get("autoAudit")) != null) {
                    JsonNode processHandler;
                    JsonNode autoOpinionWhenMatch = autoAudit.get("autoOpinionWhenMatch");
                    if (autoOpinionWhenMatch != null) {
                        value = autoOpinionWhenMatch.get(key);
                        if (this.localeLang.equals(key) && value != null) {
                            ((UserTask)flowElement).getAutoAudit().setAutoOpinionWhenMatch(value.asText());
                        }
                        if (value != null) {
                            ((UserTask)element).getAutoAudit().setAutoOpinionWhenMatch(value.asText());
                        }
                    }
                    if ((processHandler = autoAudit.get("processHandler")) != null) {
                        JsonNode value2 = processHandler.get(key);
                        if (this.localeLang.equals(key) && value2 != null) {
                            ((UserTask)flowElement).getAutoAudit().setProcessHandler(value2.asText());
                        }
                        if (value2 != null) {
                            ((UserTask)element).getAutoAudit().setProcessHandler(value2.asText());
                        }
                    }
                }
            }
            mulBpmnModel.get(key).getMainProcess().addFlowElement(element);
        }
        newBpmnModel.getMainProcess().addFlowElement(flowElement);
        dynProcess.addFlowElement(flowElement);
    }

    private void handUserTaskMulBpnmModel(FlowElement userTask, BpmnModel newBpmnModel, Process dynProcess, Map<String, BpmnModel> mulBpmnModel) {
        for (Lang lang : WfUtils.getSupportLangs()) {
            String key = lang.name();
            FlowElement elUserTask = userTask.clone();
            String name = (String)WFMultiLangConstants.getUserTaskName().get((Object)key);
            if (this.localeLang.equals(key) && name != null) {
                userTask.setName(name);
            }
            if (name != null) {
                elUserTask.setName(name);
            }
            mulBpmnModel.get(key).getMainProcess().addFlowElement(elUserTask);
        }
        newBpmnModel.getMainProcess().addFlowElement(userTask);
        dynProcess.addFlowElement(userTask);
    }

    private void createNeedSequenceAndNode(JsonNode shapeNode, FlowElement flowElement, Process dynProcess, BpmnModel newBpmnModel, FlowNode flowNode, boolean isFirstNode, Map<String, BpmnModel> mulBpmnModel, boolean isFromPlugin) {
        ArrayNode nextNodes;
        if (isFirstNode && "UserTask".equals(flowElement.getType()) || isFromPlugin) {
            SequenceFlow sequenceFlow = DynProcessProcessorUtil.createBaseDynamicSequenceFlow(flowNode.getId(), flowElement.getId(), newBpmnModel);
            JsonNode incomings = shapeNode.get("incomings");
            if (incomings != null && incomings.size() > 0) {
                JsonNode sequenceJsonNode = incomings.get(flowElement.getId());
                ObjectNode jsonNode = (ObjectNode)sequenceJsonNode;
                jsonNode.put(SOURCEREF, sequenceFlow.getSourceRef());
                jsonNode.remove("elementid");
                BpmnJsonConverter converter = new BpmnJsonConverter();
                converter.parseFreeFlowJsonNode("SequenceFlow", (JsonNode)jsonNode, sequenceFlow, dynProcess);
            }
            this.handMulBpnmModel(null, sequenceFlow, newBpmnModel, dynProcess, mulBpmnModel);
        }
        if ((nextNodes = (ArrayNode)shapeNode.get(NEXTNODES)) == null || nextNodes.size() == 0) {
            FlowElement endElement = this.getEndElement(newBpmnModel, flowNode);
            if (endElement != null) {
                SequenceFlow sequenceFlow = ((FlowNode)endElement).getIncomingFlows().get(0);
                if (flowNode.getId().equals(sequenceFlow.getSourceRef())) {
                    sequenceFlow.setSourceRef(flowElement.getId());
                    sequenceFlow.setSourceFlowElement(flowElement);
                    this.handMulBpnmModel(null, sequenceFlow, newBpmnModel, dynProcess, mulBpmnModel);
                } else {
                    SequenceFlow newSequenceFlow = DynProcessProcessorUtil.createBaseDynamicSequenceFlow(flowElement.getId(), endElement.getId(), newBpmnModel);
                    this.handMulBpnmModel(null, newSequenceFlow, newBpmnModel, dynProcess, mulBpmnModel);
                }
            }
        } else {
            BpmnJsonConverter converter = new BpmnJsonConverter();
            for (JsonNode nextShapeNode : nextNodes) {
                JsonNode sequenceJsonNode;
                String nextNodeId = nextShapeNode.get("id").asText();
                SequenceFlow sequenceFlow = DynProcessProcessorUtil.createBaseDynamicSequenceFlow(flowElement.getId(), nextShapeNode.get("id").asText(), newBpmnModel);
                JsonNode incomings = nextShapeNode.get("incomings");
                if (incomings != null && incomings.size() > 0 && (sequenceJsonNode = incomings.get(nextNodeId)) != null && sequenceJsonNode.get(SOURCEREF) != null && sequenceJsonNode.get(SOURCEREF).asText().equals(flowElement.getId())) {
                    ObjectNode jsonNode = (ObjectNode)sequenceJsonNode;
                    jsonNode.remove("elementid");
                    converter.parseFreeFlowJsonNode("SequenceFlow", (JsonNode)jsonNode, sequenceFlow, dynProcess);
                }
                this.handMulBpnmModel(null, sequenceFlow, newBpmnModel, dynProcess, mulBpmnModel);
            }
        }
    }

    private FlowElement getEndElement(BpmnModel newBpmnModel, FlowNode flowNode) {
        List<SequenceFlow> outgoingFlows = flowNode.getOutgoingFlows();
        if (CollectionUtil.isNotEmpty(outgoingFlows)) {
            return newBpmnModel.getFlowElement(outgoingFlows.get(0).getTargetRef());
        }
        return null;
    }

    private FlowElement getUserTask(BpmnModel newBpmnModel) {
        List<FlowElement> flowElementList = newBpmnModel.getMainProcess().getFlowElementList();
        for (FlowElement flowElement : flowElementList) {
            if (!"UserTask".equals(flowElement.getType())) continue;
            return flowElement;
        }
        return null;
    }

    private FlowElement createBaseDynamicElement(String elemType, String itemId, ExecutionEntity execution, BpmnModel bpmnModel) {
        FlowElement flowElement = null;
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("is_dynamic_node", Boolean.TRUE);
        config.put("itemId", itemId);
        String modelType = GraphCodecUtils.getModelTypeByProcessType(bpmnModel.getMainProcess().getProcessType());
        if ("SSCApprove".equals(elemType) || "SSCImageUpload".equals(elemType) || "SSCImageUploadNew".equals(elemType)) {
            modelType = "SSCModel";
        }
        DynProcessProcessorUtil.initBillInfo(execution, config);
        flowElement = (FlowElement)GraphCodecUtils.getDefaultElement(modelType, elemType, bpmnModel, config);
        flowElement.setDynamic(false);
        return flowElement;
    }

    private void initProcess(ObjectNode modelNode, BpmnModel dynBpmnModel, Process dynProcess, Map<String, BpmnModel> mulBpmnModel, BpmnJsonConverter converter, boolean isFromPlugin, BpmnModel newBpmnModel) {
        JsonNode entraBillName;
        if (!isFromPlugin) {
            Iterator fields;
            JsonNode extProps = modelNode.get("extProps");
            if (extProps != null && (fields = extProps.fields()).hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                modelNode.put((String)field.getKey(), (JsonNode)field.getValue());
            }
            modelNode.put("properties", (JsonNode)modelNode);
            converter.initProcessInfo(dynBpmnModel, (JsonNode)modelNode, dynProcess);
        }
        if ((entraBillName = modelNode.get("entraBillName")) != null && entraBillName.get(this.localeLang) != null) {
            dynProcess.setEntraBillName(entraBillName.get(this.localeLang).asText());
        }
        for (Map.Entry<String, BpmnModel> entry : mulBpmnModel.entrySet()) {
            String key = entry.getKey();
            Process process = dynProcess.clone();
            if (entraBillName != null && entraBillName.get(key) != null) {
                process.setEntraBillName(entraBillName.get(key).asText());
            }
            entry.getValue().addProcess(process);
        }
    }

    @Override
    public void mergeDynBpmnModel(BpmnModel newBpmnModel, String content) {
        if (content != null) {
            try (TraceSpan ts = Tracer.create((String)"ProcessDefinitionUtil", (String)"mergeBpmnModel");){
                ts.addTag("content", content);
                BpmnModel dynBpmnModel = ProcessDefinitionUtil.getBpmnModel(content);
                if (dynBpmnModel != null) {
                    Process newProcess = newBpmnModel.getMainProcess();
                    Process dynProcess = dynBpmnModel.getMainProcess();
                    boolean isFromAddress = "freeflowtpl".equals(newProcess.getNumber());
                    dynProcess.setId(newProcess.getId());
                    this.mergeProcessInfo(newProcess, dynProcess, isFromAddress);
                    this.mergeFlowElementInfo(newBpmnModel, dynBpmnModel, newProcess, dynProcess);
                    BpmnJsonConverter converter = new BpmnJsonConverter();
                    converter.rebuildFlowNodeSequenceRelation(newProcess, newProcess.getFlowElements());
                    if (isFromAddress) {
                        this.initDynFlowElementsLevels(newBpmnModel, newProcess);
                        this.initDynFlowSequencePosition(newBpmnModel, newBpmnModel);
                    } else {
                        this.adjustFlowElementPosition(dynProcess, newBpmnModel);
                        this.initDynFlowSequencePosition(dynBpmnModel, newBpmnModel);
                    }
                }
            }
        }
    }

    public void mergeDynBpmnModel(BpmnModel newBpmnModel, BpmnModel dynBpmnModel) {
        try (TraceSpan ts = Tracer.create((String)"ProcessDefinitionUtil", (String)"mergeBpmnModel");){
            if (dynBpmnModel != null) {
                Process newProcess = newBpmnModel.getMainProcess();
                Process dynProcess = dynBpmnModel.getMainProcess();
                dynProcess.setId(newProcess.getId());
                this.mergeProcessInfo(newProcess, dynProcess, false);
                this.mergeFlowElementInfo(newBpmnModel, dynBpmnModel, newProcess, dynProcess);
                BpmnJsonConverter converter = new BpmnJsonConverter();
                converter.rebuildFlowNodeSequenceRelation(newProcess, newProcess.getFlowElements());
                HashMap<FlowNode, Integer> convertProcessHierarchyNodeMap = new HashMap<FlowNode, Integer>();
                Map<Integer, Set<FlowNode>> processHierarchyNodeMap = this.getProcessHierarchyNodeMap(newProcess, convertProcessHierarchyNodeMap);
                this.initDynFlowElementsPositionNew(newBpmnModel, newProcess, processHierarchyNodeMap, convertProcessHierarchyNodeMap);
                this.initDynFlowSequencePositionNew(newBpmnModel, newBpmnModel, processHierarchyNodeMap, convertProcessHierarchyNodeMap);
            }
        }
    }

    private Map<Integer, Set<FlowNode>> getProcessHierarchyNodeMap(Process newProcess, Map<FlowNode, Integer> convertProcessHierarchyNodeMap) {
        FlowNode startNode = this.getStartNode(newProcess);
        convertProcessHierarchyNodeMap.putAll(this.getHierarchyNodesMap(startNode));
        Set<Map.Entry<FlowNode, Integer>> convertProcessHierarchyNodeEntrySet = convertProcessHierarchyNodeMap.entrySet();
        HashMap<Integer, Set<FlowNode>> processHierarchyNodeMap = new HashMap<Integer, Set<FlowNode>>(convertProcessHierarchyNodeEntrySet.size());
        for (Map.Entry<FlowNode, Integer> convertProcessHierarchyNode : convertProcessHierarchyNodeEntrySet) {
            Integer key = convertProcessHierarchyNode.getValue();
            FlowNode value = convertProcessHierarchyNode.getKey();
            Set<FlowNode> flowNodeSet = processHierarchyNodeMap.get(key) == null ? new HashSet() : (Set)processHierarchyNodeMap.get(key);
            flowNodeSet.add(value);
            processHierarchyNodeMap.put(key, flowNodeSet);
        }
        return processHierarchyNodeMap;
    }

    private void initDynFlowElementsPositionNew(BpmnModel newBpmnModel, Process newProcess, Map<Integer, Set<FlowNode>> processHierarchyNodeMap, Map<FlowNode, Integer> convertProcessHierarchyNodeMap) {
        int maxSize = 0;
        int maxLevel = 0;
        for (Map.Entry<Integer, Set<FlowNode>> processHierarchyNode : processHierarchyNodeMap.entrySet()) {
            Set<FlowNode> hierarchyNodes = processHierarchyNode.getValue();
            if (hierarchyNodes == null || hierarchyNodes.size() <= maxSize) continue;
            maxSize = hierarchyNodes.size();
            maxLevel = processHierarchyNode.getKey();
        }
        HashMap<String, List<FlowNode>> outGoingMap = new HashMap<String, List<FlowNode>>();
        this.putOutGoingMapValue(convertProcessHierarchyNodeMap, outGoingMap, this.getStartNode(newProcess), maxLevel, 1);
        Set<FlowNode> maxNodeLayerSet = processHierarchyNodeMap.get(maxLevel);
        HashMap<String, List<FlowNode>> targetMap = new HashMap<String, List<FlowNode>>();
        this.putTargetMapValue(maxNodeLayerSet, targetMap);
        this.caculateNodePosition(outGoingMap, targetMap, processHierarchyNodeMap, maxLevel, newBpmnModel, newProcess);
    }

    private void caculateNodePosition(Map<String, List<FlowNode>> outGoingMap, Map<String, List<FlowNode>> targetMap, Map<Integer, Set<FlowNode>> processHierarchyNodeMap, int maxLevel, BpmnModel newBpmnModel, Process newProcess) {
        int i;
        GraphicInfo processLocation = newBpmnModel.getLocation();
        double medianValueX = processLocation.getX() / 2.0;
        double processValueY = processLocation.getY() / 2.0;
        Set<FlowNode> secondHierarchyNodeMap = processHierarchyNodeMap.get(maxLevel - 1);
        int spaceBetween = 60;
        if (processHierarchyNodeMap.get(maxLevel).size() == 1 && "StartSignalEvent".equals(processHierarchyNodeMap.get(maxLevel).iterator().next().getType())) {
            int size = processHierarchyNodeMap.size();
            int index = size % 2 == 0 ? size / 2 : (size + 1) / 2;
            double startX = medianValueX - 75.0 + 17.5;
            double sourceY = size % 2 == 0 ? processValueY + 50.0 + 16.0 : processValueY - 25.0;
            double startY = sourceY - (double)((spaceBetween + 50) * (index - 1));
            FlowNode startNode = this.getStartNode(newProcess);
            if (startNode == null) {
                return;
            }
            GraphicInfo startGraphicInfo = newBpmnModel.getGraphicInfo(startNode.getId());
            startGraphicInfo.setX(startX);
            startGraphicInfo.setY(startY);
            startGraphicInfo.setWidth(115.0);
            startGraphicInfo.setHeight(45.0);
            newBpmnModel.addGraphicInfo(startNode.getId(), startGraphicInfo);
            this.caculateSerialNodePosition(processHierarchyNodeMap, newBpmnModel, spaceBetween);
            this.fixNodePosition(processHierarchyNodeMap, newBpmnModel, newProcess);
            return;
        }
        ArrayList processHierarchyNodeList = new ArrayList();
        for (FlowNode flowNode : secondHierarchyNodeMap) {
            processHierarchyNodeList.addAll(outGoingMap.get(flowNode.getNumber()));
        }
        int maxSize = processHierarchyNodeList.size();
        double leftmostNodeX = 0.0;
        leftmostNodeX = maxSize % 2 == 0 ? medianValueX - (double)(maxSize * 150 / 2) - (double)((maxSize / 2 - 1) * 150) * 1.2 - 90.0 : medianValueX - (double)((maxSize - 1) / 2) * 330.0;
        for (i = 0; i < maxSize; ++i) {
            FlowNode flowNode = (FlowNode)processHierarchyNodeList.get(i);
            GraphicInfo graphicInfo = new GraphicInfo();
            double flowNodeX = leftmostNodeX + (double)i * 330.0;
            graphicInfo.setX(flowNodeX);
            graphicInfo.setY(processValueY);
            graphicInfo.setWidth(150.0);
            graphicInfo.setHeight(50.0);
            newBpmnModel.addGraphicInfo(flowNode.getId(), graphicInfo);
        }
        for (i = maxLevel - 1; i > 0; --i) {
            this.setNextNodePosition(newBpmnModel, processHierarchyNodeMap, i, outGoingMap, true);
        }
        for (i = maxLevel + 1; i < processHierarchyNodeMap.size(); ++i) {
            this.setNextNodePosition(newBpmnModel, processHierarchyNodeMap, i, targetMap, false);
        }
        this.fixNodePosition(processHierarchyNodeMap, newBpmnModel, newProcess);
    }

    private void fixNodePosition(Map<Integer, Set<FlowNode>> processHierarchyNodeMap, BpmnModel newBpmnModel, Process newProcess) {
        int spaceBetween = 60;
        Set<FlowNode> endNodes = processHierarchyNodeMap.get(processHierarchyNodeMap.size());
        FlowNode endNode = endNodes.iterator().next();
        GraphicInfo endGraphicInfo = newBpmnModel.getGraphicInfo(endNode.getId()) == null ? new GraphicInfo() : newBpmnModel.getGraphicInfo(endNode.getId());
        FlowNode startNode = this.getStartNode(newProcess);
        if (startNode != null) {
            endGraphicInfo.setX(newBpmnModel.getGraphicInfo(startNode.getId()).getX());
            double endY = newBpmnModel.getGraphicInfo(startNode.getId()).getY() + (double)((processHierarchyNodeMap.size() - 1) * spaceBetween) + (double)((processHierarchyNodeMap.size() - 2) * 50) + 45.0;
            endGraphicInfo.setY(endY);
            endGraphicInfo.setWidth(115.0);
            endGraphicInfo.setHeight(45.0);
            newBpmnModel.addGraphicInfo(endNode.getId(), endGraphicInfo);
        }
    }

    private void setNextNodePosition(BpmnModel newBpmnModel, Map<Integer, Set<FlowNode>> processHierarchyNodeMap, int i, Map<String, List<FlowNode>> outGoingMap, boolean isUpper) {
        Set<FlowNode> levelNodes = processHierarchyNodeMap.get(i);
        int spaceBetween = 60;
        for (FlowNode flowNode : levelNodes) {
            List<FlowNode> outGoingNodes = outGoingMap.get(flowNode.getNumber());
            double upperY = isUpper ? newBpmnModel.getGraphicInfo(outGoingNodes.get(0).getId()).getY() - (double)spaceBetween - 50.0 : newBpmnModel.getGraphicInfo(outGoingNodes.get(0).getId()).getY() + (double)spaceBetween + 50.0;
            double upperX = 0.0;
            upperX = outGoingNodes.size() % 2 == 0 ? (newBpmnModel.getGraphicInfo(outGoingNodes.get(outGoingNodes.size() - 1).getId()).getX() + 150.0 - newBpmnModel.getGraphicInfo(outGoingNodes.get(0).getId()).getX()) / 2.0 + newBpmnModel.getGraphicInfo(outGoingNodes.get(0).getId()).getX() - 75.0 : newBpmnModel.getGraphicInfo(outGoingNodes.get(0).getId()).getX();
            GraphicInfo upperGraphicInfo = new GraphicInfo();
            upperGraphicInfo.setY(upperY);
            if (flowNode instanceof StartEvent) {
                upperGraphicInfo.setX(upperX + 17.5);
                upperGraphicInfo.setWidth(115.0);
                upperGraphicInfo.setHeight(45.0);
            } else {
                upperGraphicInfo.setX(upperX);
                upperGraphicInfo.setWidth(150.0);
                upperGraphicInfo.setHeight(50.0);
            }
            newBpmnModel.addGraphicInfo(flowNode.getId(), upperGraphicInfo);
        }
    }

    private void caculateSerialNodePosition(Map<Integer, Set<FlowNode>> processHierarchyNodeMap, BpmnModel newBpmnModel, int spaceBetween) {
        for (int i = 2; i < processHierarchyNodeMap.size(); ++i) {
            Set<FlowNode> flowNodes = processHierarchyNodeMap.get(i);
            Set<FlowNode> upperFlowNodes = processHierarchyNodeMap.get(i - 1);
            GraphicInfo upperGraphicInfo = new GraphicInfo();
            double X = i == 2 ? newBpmnModel.getGraphicInfo(upperFlowNodes.iterator().next().getId()).getX() - 17.5 : newBpmnModel.getGraphicInfo(upperFlowNodes.iterator().next().getId()).getX();
            upperGraphicInfo.setX(X);
            upperGraphicInfo.setY(newBpmnModel.getGraphicInfo(upperFlowNodes.iterator().next().getId()).getY() + (double)spaceBetween + 50.0);
            upperGraphicInfo.setWidth(150.0);
            upperGraphicInfo.setHeight(50.0);
            newBpmnModel.addGraphicInfo(flowNodes.iterator().next().getId(), upperGraphicInfo);
        }
    }

    private void putTargetMapValue(Set<FlowNode> maxNodeLayerSet, Map<String, List<FlowNode>> targetMap) {
        if (maxNodeLayerSet == null || maxNodeLayerSet.isEmpty()) {
            return;
        }
        Stack<FlowNode> stack = new Stack<FlowNode>();
        stack.addAll(maxNodeLayerSet);
        while (!stack.isEmpty()) {
            FlowNode flowNode = (FlowNode)stack.pop();
            List<SequenceFlow> outgoingFlows = flowNode.getOutgoingFlows();
            HashSet<FlowNode> nextLevelNodes = new HashSet<FlowNode>(outgoingFlows.size());
            for (int i = 0; i < outgoingFlows.size(); ++i) {
                List<Object> levelSet;
                SequenceFlow sequenceFlow = outgoingFlows.get(i);
                FlowNode nextFlowNode = (FlowNode)sequenceFlow.getTargetFlowElement();
                String number = nextFlowNode.getNumber();
                List<Object> list = levelSet = targetMap.get(number) == null ? new ArrayList() : targetMap.get(number);
                if (!levelSet.contains(flowNode)) {
                    levelSet.add(flowNode);
                }
                targetMap.put(number, levelSet);
                nextLevelNodes.add(nextFlowNode);
            }
            stack.addAll(nextLevelNodes);
        }
    }

    private void putOutGoingMapValue(Map<FlowNode, Integer> convertProcessHierarchyNodeMap, Map<String, List<FlowNode>> outGoingMap, FlowNode flowNode, int maxLevel, int currentLevel) {
        Stack<FlowNode> stack = new Stack<FlowNode>();
        stack.push(flowNode);
        while (!stack.isEmpty()) {
            FlowNode currentFlowNode = (FlowNode)stack.pop();
            if (convertProcessHierarchyNodeMap == null || convertProcessHierarchyNodeMap.get(currentFlowNode) >= maxLevel) continue;
            List<SequenceFlow> outgoingFlows = currentFlowNode.getOutgoingFlows();
            for (int i = 0; i < outgoingFlows.size(); ++i) {
                SequenceFlow sequenceFlow = outgoingFlows.get(i);
                FlowNode nextFlowNode = (FlowNode)sequenceFlow.getTargetFlowElement();
                if (convertProcessHierarchyNodeMap.get(nextFlowNode) > maxLevel) continue;
                String number = currentFlowNode.getNumber();
                List<Object> levelSet = outGoingMap.get(number) == null ? new ArrayList() : outGoingMap.get(number);
                levelSet.add(nextFlowNode);
                outGoingMap.put(number, levelSet);
                stack.push(nextFlowNode);
            }
        }
    }

    private Map<FlowNode, Integer> getHierarchyNodesMap(FlowNode flowNode) {
        HashMap<FlowNode, Integer> convertProcessHierarchyNodeMap = new HashMap<FlowNode, Integer>();
        Integer level = 1;
        convertProcessHierarchyNodeMap.put(flowNode, level);
        this.hierarchicalNode(flowNode, convertProcessHierarchyNodeMap, level);
        return convertProcessHierarchyNodeMap;
    }

    private void hierarchicalNode(FlowNode flowNode, Map<FlowNode, Integer> convertProcessHierarchyNodeMap, Integer level) {
        Stack<FlowNode> stack = new Stack<FlowNode>();
        stack.push(flowNode);
        while (!stack.isEmpty()) {
            FlowNode currentFlowNode = (FlowNode)stack.pop();
            List<SequenceFlow> outgoingFlows = currentFlowNode.getOutgoingFlows();
            for (int i = 0; i < outgoingFlows.size(); ++i) {
                SequenceFlow sequenceFlow = outgoingFlows.get(i);
                FlowNode nextFlowNode = (FlowNode)sequenceFlow.getTargetFlowElement();
                level = convertProcessHierarchyNodeMap.get(currentFlowNode) + 1;
                if (nextFlowNode == null || convertProcessHierarchyNodeMap.get(nextFlowNode) != null && convertProcessHierarchyNodeMap.get(nextFlowNode) >= level) continue;
                convertProcessHierarchyNodeMap.put(nextFlowNode, level);
                stack.push(nextFlowNode);
            }
        }
    }

    private void mergeProcessInfo(Process newProcess, Process dynProcess, boolean isFromAddress) {
        if (isFromAddress) {
            newProcess.cloneBasicProperties(newProcess, dynProcess);
        } else {
            if (CollectionUtil.isNotEmpty(dynProcess.getExecutionListeners())) {
                for (ActivitiListener activitiListener : dynProcess.getExecutionListeners()) {
                    if (newProcess.getExecutionListeners() == null) {
                        newProcess.setExecutionListeners(new ArrayList<ActivitiListener>());
                    }
                    newProcess.getExecutionListeners().add(activitiListener.clone());
                }
            }
            if (CollectionUtil.isNotEmpty(dynProcess.getEventListeners())) {
                for (EventListener eventListener : dynProcess.getEventListeners()) {
                    if (newProcess.getEventListeners() == null) {
                        newProcess.setEventListeners(new ArrayList<EventListener>());
                    }
                    newProcess.getEventListeners().add(eventListener.clone());
                }
            }
            if (CollectionUtil.isNotEmpty(dynProcess.getLanes())) {
                for (Lane lane : dynProcess.getLanes()) {
                    if (newProcess.getLanes() == null) {
                        newProcess.setLanes(new ArrayList<Lane>());
                    }
                    newProcess.getLanes().add(lane.clone());
                }
            }
            if (CollectionUtil.isNotEmpty(dynProcess.getVariables())) {
                for (Variable variable : dynProcess.getVariables()) {
                    if (newProcess.getVariables() == null) {
                        newProcess.setVariables(new ArrayList<Variable>());
                    }
                    newProcess.getVariables().add(variable.clone());
                }
            }
            if (CollectionUtil.isNotEmpty(dynProcess.getMacros())) {
                for (Macro macro : dynProcess.getMacros()) {
                    if (newProcess.getMacros() == null) {
                        newProcess.setMacros(new ArrayList<Macro>());
                    }
                    newProcess.getMacros().add(macro);
                }
            }
            if (CollectionUtil.isNotEmpty(dynProcess.getArtifactList())) {
                for (Artifact artifact : dynProcess.getArtifactList()) {
                    if (newProcess.getArtifactList() == null) {
                        newProcess.setArtifactList(new ArrayList<Artifact>());
                    }
                    newProcess.getArtifactList().add(artifact.clone());
                }
            }
            if (CollectionUtil.isNotEmpty(dynProcess.getDataObjects())) {
                for (ValuedDataObject valuedDataObject : dynProcess.getDataObjects()) {
                    if (newProcess.getDataObjects() == null) {
                        newProcess.setDataObjects(new ArrayList<ValuedDataObject>());
                    }
                    newProcess.getDataObjects().add(valuedDataObject.clone());
                }
            }
            if (CollectionUtil.isNotEmpty(dynProcess.getBillExceptionOp())) {
                for (BillExceptionOp billExceptionOp : dynProcess.getBillExceptionOp()) {
                    if (newProcess.getBillExceptionOp() == null) {
                        newProcess.setBillExceptionOp(new ArrayList<BillExceptionOp>());
                    }
                    newProcess.getBillExceptionOp().add(billExceptionOp.clone());
                }
            }
        }
    }

    private void adjustFlowElementPosition(Process dynProcess, BpmnModel newBpmnModel) {
        List<FlowElement> flowElementList = dynProcess.getFlowElementList();
        HashMap<String, Integer> childFlowElementNum = new HashMap<String, Integer>();
        for (FlowElement flowElement : flowElementList) {
            if (!(flowElement instanceof FlowNode)) continue;
            List<FlowElement> previousNodes = BpmnModelUtil.getPreviousNodes(newBpmnModel, flowElement.getId());
            HashSet<String> adjustedNodeIds = new HashSet<String>(previousNodes.size());
            for (FlowElement previousNode : previousNodes) {
                adjustedNodeIds.add(previousNode.getId());
            }
            this.adjustDynFlowPositions(flowElement, newBpmnModel, childFlowElementNum, adjustedNodeIds);
        }
        newBpmnModel.setOrderedNodesInfo(null);
    }

    private void adjustDynFlowPositions(FlowElement dynFlowElement, BpmnModel newBpmnModel, Map<String, Integer> childFlowElement, Set<String> adjustedNodeIds) {
        FlowNode dynFlowNode = (FlowNode)dynFlowElement;
        List<SequenceFlow> incomingFlows = dynFlowNode.getIncomingFlows();
        SequenceFlow sourceSequence = incomingFlows.get(0);
        FlowNode sourceFlowNode = (FlowNode)sourceSequence.getSourceFlowElement();
        List<SequenceFlow> outgoingFlows = sourceFlowNode.getOutgoingFlows();
        if (outgoingFlows.size() == 1) {
            GraphicInfo graphicInfo = newBpmnModel.getGraphicInfo(sourceFlowNode.getId());
            GraphicInfo graphicInfoClone = graphicInfo.clone();
            graphicInfoClone.setY(graphicInfoClone.getY() + graphicInfoClone.getHeight() * 2.0);
            newBpmnModel.addGraphicInfo(dynFlowNode.getId(), graphicInfoClone);
            this.adjustAfterFlowElementPosition(dynFlowElement, newBpmnModel, adjustedNodeIds);
        } else {
            GraphicInfo graphicInfo = newBpmnModel.getGraphicInfo(sourceFlowNode.getId());
            GraphicInfo graphicInfoClone = graphicInfo.clone();
            Integer size = childFlowElement.get(sourceFlowNode.getId());
            int branchNum = ((FlowNode)dynFlowElement).getOutgoingFlows().size();
            if (size == null) {
                graphicInfoClone.setY(graphicInfoClone.getY() + graphicInfoClone.getHeight() * 2.0);
                newBpmnModel.addGraphicInfo(dynFlowNode.getId(), graphicInfoClone);
                childFlowElement.put(sourceFlowNode.getId(), branchNum);
                this.adjustAfterFlowElementPosition(dynFlowElement, newBpmnModel, adjustedNodeIds);
            } else if (size % 2 == 1) {
                graphicInfoClone.setY(graphicInfoClone.getY() + graphicInfoClone.getHeight() * 2.0);
                graphicInfoClone.setX(graphicInfoClone.getX() - graphicInfoClone.getWidth() * (size == 1 ? 1.5 : (double)size.intValue()));
                newBpmnModel.addGraphicInfo(dynFlowNode.getId(), graphicInfoClone);
                childFlowElement.put(sourceFlowNode.getId(), size + branchNum);
            } else if (size % 2 == 0) {
                graphicInfoClone.setY(graphicInfoClone.getY() + graphicInfoClone.getHeight() * 2.0);
                graphicInfoClone.setX(graphicInfoClone.getX() + graphicInfoClone.getWidth() * (double)size.intValue());
                newBpmnModel.addGraphicInfo(dynFlowNode.getId(), graphicInfoClone);
                childFlowElement.put(sourceFlowNode.getId(), size + branchNum);
            }
        }
    }

    private void adjustAfterFlowElementPosition(FlowElement dynFlowElement, BpmnModel newBpmnModel, Set<String> adjustedNodeIds) {
        FlowNode dynFlowNode = (FlowNode)dynFlowElement;
        List<SequenceFlow> outgoingFlows = dynFlowNode.getOutgoingFlows();
        for (SequenceFlow sequenceFlow : outgoingFlows) {
            if (!this.isAdjust(sequenceFlow) || adjustedNodeIds.contains(dynFlowNode.getId())) continue;
            adjustedNodeIds.add(dynFlowNode.getId());
            FlowElement nextElement = newBpmnModel.getFlowElement(sequenceFlow.getTargetRef());
            GraphicInfo graphicInfo = newBpmnModel.getGraphicInfo(dynFlowElement.getId());
            GraphicInfo graphicInfoClone = null;
            graphicInfoClone = nextElement != null && nextElement.getId() != null && newBpmnModel.getGraphicInfo(nextElement.getId()) != null ? newBpmnModel.getGraphicInfo(nextElement.getId()) : graphicInfo.clone();
            if (graphicInfo != null && graphicInfoClone != null && graphicInfo.getY() + graphicInfo.getHeight() * 2.0 > graphicInfoClone.getY()) {
                graphicInfoClone.setY(graphicInfoClone.getY() + graphicInfoClone.getHeight() * 2.0);
            }
            if (nextElement != null) {
                newBpmnModel.addGraphicInfo(nextElement.getId(), graphicInfoClone);
            }
            this.adjustAfterFlowElementPosition(nextElement, newBpmnModel, adjustedNodeIds);
        }
    }

    private boolean isAdjust(SequenceFlow sequenceFlow) {
        if (sequenceFlow.getConditionalRule() == null || sequenceFlow.getConditionalRule().getExpression() == null) {
            return true;
        }
        Pattern pattern = Pattern.compile("auditNumber");
        Matcher matcher = pattern.matcher(sequenceFlow.getConditionalRule().getExpression());
        if (matcher.find()) {
            return false;
        }
        pattern = Pattern.compile(sequenceFlow.getSourceFlowElement().getId() + "AuditNumber");
        matcher = pattern.matcher(sequenceFlow.getConditionalRule().getExpression());
        return !matcher.find();
    }

    private void initDynFlowSequencePositionNew(BpmnModel dynBpmnModel, BpmnModel newBpmnModel, Map<Integer, Set<FlowNode>> processHierarchyNodeMap, Map<FlowNode, Integer> convertProcessHierarchyNodeMap) {
        HashMap<String, Double> exclusiveBranchXMap = new HashMap<String, Double>();
        for (FlowElement flowElement : dynBpmnModel.getMainProcess().getFlowElementList()) {
            List<SequenceFlow> incomingFlows;
            if (flowElement instanceof SequenceFlow) {
                flowElement = newBpmnModel.getFlowElement(((SequenceFlow)flowElement).getTargetRef());
            }
            if (!(flowElement instanceof FlowNode) || (incomingFlows = ((FlowNode)flowElement).getIncomingFlows()) == null || incomingFlows.size() <= 1) continue;
            for (SequenceFlow incomingFlow : incomingFlows) {
                FlowNode srcElem = (FlowNode)newBpmnModel.getFlowElement(incomingFlow.getSourceRef());
                boolean isParallel = this.isParallelNode(srcElem, newBpmnModel);
                if (isParallel) {
                    this.modifyParallelPosition(newBpmnModel, incomingFlow);
                    continue;
                }
                boolean isDirectLine = this.currentFlowIsDirectLine(srcElem, incomingFlow.getId());
                if (isDirectLine) continue;
                this.modifyExclusivePosition(processHierarchyNodeMap, exclusiveBranchXMap, convertProcessHierarchyNodeMap, newBpmnModel, incomingFlow, srcElem, (FlowNode)flowElement);
            }
        }
    }

    private void modifyExclusivePosition(Map<Integer, Set<FlowNode>> processHierarchyNodeMap, Map<String, Double> exclusiveBranchXMap, Map<FlowNode, Integer> convertProcessHierarchyNodeMap, BpmnModel newBpmnModel, SequenceFlow incomingFlow, FlowNode src, FlowNode target) {
        if (src == null || target == null) {
            return;
        }
        Integer srcLevel = convertProcessHierarchyNodeMap.get(src);
        Integer targetLevel = convertProcessHierarchyNodeMap.get(target);
        int maxSize = 0;
        Set<Object> maxLevelSet = new HashSet();
        for (int i = srcLevel + 1; i < targetLevel; ++i) {
            if (processHierarchyNodeMap.get(i).size() <= maxSize) continue;
            maxSize = processHierarchyNodeMap.get(i).size();
            maxLevelSet = processHierarchyNodeMap.get(i);
        }
        double minX = 0.0;
        double maxX = 0.0;
        for (FlowNode flowNode : maxLevelSet) {
            if (minX == 0.0 || newBpmnModel.getGraphicInfo(flowNode.getId()).getX() < minX) {
                minX = newBpmnModel.getGraphicInfo(flowNode.getId()).getX();
            }
            if (!(newBpmnModel.getGraphicInfo(flowNode.getId()).getX() > maxX)) continue;
            maxX = newBpmnModel.getGraphicInfo(flowNode.getId()).getX();
        }
        GraphicInfo maxLeftGraphicInfo = this.findMaxGraphicInfoBetweenSrcAndTarget(newBpmnModel, src, target, "LEFT");
        GraphicInfo maxRightGraphicInfo = this.findMaxGraphicInfoBetweenSrcAndTarget(newBpmnModel, src, target, "RIGHT");
        Map<String, Object> directorMap = this.calcDirector(maxLeftGraphicInfo, maxRightGraphicInfo, src);
        String direct = (String)directorMap.get("direct");
        GraphicInfo retSouceGraphic = (GraphicInfo)directorMap.get("graphic");
        GraphicInfo targetGraphicInfo = newBpmnModel.getGraphicInfo(incomingFlow.getTargetRef());
        double directX = 0.0;
        if ("LEFT".equals(direct)) {
            Double minDirectX = exclusiveBranchXMap.get(direct);
            directX = minDirectX == null || minDirectX == 0.0 ? maxX - 75.0 : minDirectX - 75.0;
            exclusiveBranchXMap.put(direct, minDirectX);
        } else {
            Double maxDirectX = exclusiveBranchXMap.get(direct);
            directX = maxDirectX == null || maxDirectX == 0.0 ? maxX + 150.0 : maxDirectX + 75.0;
            exclusiveBranchXMap.put(direct, maxDirectX);
        }
        if (retSouceGraphic != null && targetGraphicInfo != null) {
            ArrayList<GraphicInfo> graphicInfoList = new ArrayList<GraphicInfo>(4);
            GraphicInfo graphicInfo1 = new GraphicInfo();
            graphicInfo1.setX(directX + 65.0);
            graphicInfo1.setY(retSouceGraphic.getY() + 25.0 - 2.0);
            graphicInfoList.add(graphicInfo1);
            GraphicInfo graphicInfo4 = new GraphicInfo();
            graphicInfo4.setX(directX + 65.0);
            graphicInfo4.setY(targetGraphicInfo.getY() + 25.0 - 2.0);
            graphicInfoList.add(graphicInfo4);
            GraphicInfo graphicInfo2 = new GraphicInfo();
            graphicInfo2.setTerminalPointType("sourcePoint");
            graphicInfo2.setX(retSouceGraphic.getX() + 150.0);
            graphicInfo2.setY(retSouceGraphic.getY() + 25.0);
            graphicInfoList.add(graphicInfo2);
            GraphicInfo graphicInfo3 = new GraphicInfo();
            graphicInfo3.setTerminalPointType("targetPoint");
            graphicInfo3.setX(targetGraphicInfo.getX() + 100.0);
            graphicInfo3.setY(targetGraphicInfo.getY() + 25.0);
            graphicInfoList.add(graphicInfo3);
            newBpmnModel.addFlowGraphicInfoList(incomingFlow.getId(), graphicInfoList);
            this.replaceSequenceAnchorPoint(incomingFlow, direct, retSouceGraphic);
        }
    }

    private void replaceSequenceAnchorPoint(SequenceFlow incomingFlow, String direct, GraphicInfo retGraphic) {
        if ("RIGHT".equalsIgnoreCase(direct)) {
            String styles = incomingFlow.getStyle();
            ArrayList<String> ret = new ArrayList<String>();
            if (WfUtils.isNotEmpty(styles)) {
                Arrays.stream(styles.split(";")).filter(style -> !style.startsWith("exitX") && !style.startsWith("exitY") && !style.startsWith("entryX") && !style.startsWith("entryY")).forEach(ret::add);
            }
            ret.add("exitX=1");
            ret.add("exitY=0.5");
            ret.add("entryX=1");
            ret.add("entryY=0.5");
            String t = WfUtils.listToString(ret, ";");
            incomingFlow.setStyle(t);
        }
    }

    private Map<String, Object> calcDirector(GraphicInfo maxLeftGraphicInfo, GraphicInfo maxRightGraphicInfo, FlowNode src) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("direct", "RIGHT");
        ret.put("graphic", maxRightGraphicInfo);
        return ret;
    }

    private GraphicInfo findMaxGraphicInfoBetweenSrcAndTarget(BpmnModel newBpmnModel, FlowNode src, FlowNode target, String direct) {
        return newBpmnModel.getGraphicInfo(src.getId());
    }

    private void modifyParallelPosition(BpmnModel newBpmnModel, SequenceFlow incomingFlow) {
        GraphicInfo sourceGraphicInfo = newBpmnModel.getGraphicInfo(incomingFlow.getSourceRef());
        GraphicInfo targetGraphicInfo = newBpmnModel.getGraphicInfo(incomingFlow.getTargetRef());
        if (sourceGraphicInfo != null && targetGraphicInfo != null) {
            ArrayList<GraphicInfo> graphicInfoList = new ArrayList<GraphicInfo>(4);
            GraphicInfo graphicInfo1 = new GraphicInfo();
            graphicInfo1.setTerminalPointType("sourcePoint");
            graphicInfo1.setX(sourceGraphicInfo.getX());
            graphicInfo1.setY(sourceGraphicInfo.getY());
            GraphicInfo graphicInfo2 = new GraphicInfo();
            graphicInfo2.setX(sourceGraphicInfo.getX() + sourceGraphicInfo.getWidth() / 2.0);
            graphicInfo2.setY(targetGraphicInfo.getY() + targetGraphicInfo.getHeight() / 2.0);
            GraphicInfo graphicInfo3 = new GraphicInfo();
            graphicInfo3.setX(sourceGraphicInfo.getX() + sourceGraphicInfo.getWidth() / 2.0);
            graphicInfo3.setY(targetGraphicInfo.getY() + targetGraphicInfo.getHeight() / 2.0);
            GraphicInfo graphicInfo4 = new GraphicInfo();
            graphicInfo4.setTerminalPointType("targetPoint");
            graphicInfo4.setX(targetGraphicInfo.getX());
            graphicInfo4.setY(targetGraphicInfo.getY());
            graphicInfoList.add(graphicInfo1);
            graphicInfoList.add(graphicInfo2);
            graphicInfoList.add(graphicInfo3);
            graphicInfoList.add(graphicInfo4);
            String style = incomingFlow.getStyle();
            if (targetGraphicInfo.getX() > sourceGraphicInfo.getX()) {
                incomingFlow.setStyle(style + "exitX=0.5;exitY=1;exitPerimeter=0;entryX=0;entryY=0.5;entryPerimeter=0;");
            } else if (targetGraphicInfo.getX() < sourceGraphicInfo.getX()) {
                incomingFlow.setStyle(style + "exitX=0.5;exitY=1;exitPerimeter=0;entryX=1;entryY=0.5;entryPerimeter=0;");
            }
            newBpmnModel.addFlowGraphicInfoList(incomingFlow.getId(), graphicInfoList);
        }
    }

    private boolean isParallelNode(FlowNode srcElem, BpmnModel newBpmnModel) {
        Process process = newBpmnModel.getMainProcess();
        Map<String, NodeForkJoinModel> models = process.getForkJoinModels();
        NodeForkJoinModel model = models.get(srcElem.getId());
        return WfUtils.isNotEmpty(model.getLatestForkNode());
    }

    private boolean currentFlowIsDirectLine(FlowNode srcElem, String lineId) {
        boolean ret = true;
        if (srcElem != null && srcElem.getOutgoingFlows() != null && !srcElem.getOutgoingFlows().isEmpty()) {
            for (SequenceFlow flow : srcElem.getOutgoingFlows()) {
                if (flow.getId().equalsIgnoreCase(lineId)) continue;
                ret = false;
                break;
            }
        }
        return ret;
    }

    private void initDynFlowSequencePosition(BpmnModel dynBpmnModel, BpmnModel newBpmnModel) {
        for (FlowElement flowElement : dynBpmnModel.getMainProcess().getFlowElementList()) {
            List<SequenceFlow> incomingFlows;
            if (flowElement instanceof SequenceFlow) {
                flowElement = newBpmnModel.getFlowElement(((SequenceFlow)flowElement).getTargetRef());
            }
            if (!(flowElement instanceof FlowNode) || (incomingFlows = ((FlowNode)flowElement).getIncomingFlows()) == null || incomingFlows.size() <= 1) continue;
            for (SequenceFlow incomingFlow : incomingFlows) {
                this.modifyParallelPosition(newBpmnModel, incomingFlow);
            }
        }
    }

    private void mergeFlowElementInfo(BpmnModel newBpmnModel, BpmnModel dynBpmnModel, Process newProcess, Process dynProcess) {
        for (FlowElement dynFlowElement : dynProcess.getFlowElementList()) {
            SequenceFlow dynSequenceFlow;
            if (newProcess.getFlowElement(dynFlowElement.getId()) != null) {
                if (!(dynFlowElement instanceof SequenceFlow)) continue;
                dynSequenceFlow = (SequenceFlow)dynFlowElement;
                SequenceFlow dyn = (SequenceFlow)newProcess.getFlowElement(dynSequenceFlow.getId());
                dyn.setSourceRef(dynSequenceFlow.getSourceRef());
                dyn.setSourceFlowElement(dynBpmnModel.getFlowElement(dynSequenceFlow.getTargetRef()));
                continue;
            }
            if (dynFlowElement instanceof SequenceFlow) {
                dynSequenceFlow = (SequenceFlow)dynFlowElement;
                this.mergeSequence(newBpmnModel, dynBpmnModel, newProcess, dynFlowElement, dynSequenceFlow);
                continue;
            }
            if (!(dynFlowElement instanceof FlowNode)) continue;
            newProcess.addFlowElement(dynFlowElement);
        }
    }

    private void mergeSequence(BpmnModel newBpmnModel, BpmnModel dynBpmnModel, Process newProcess, FlowElement dynFlowElement, SequenceFlow dynSequenceFlow) {
        FlowElement flowElement;
        if (dynSequenceFlow.getTargetFlowElement() == null) {
            flowElement = dynBpmnModel.getFlowElement(dynSequenceFlow.getTargetRef());
            if (flowElement == null) {
                flowElement = newBpmnModel.getFlowElement(dynSequenceFlow.getTargetRef());
            }
            dynSequenceFlow.setTargetFlowElement(flowElement);
        }
        if (dynSequenceFlow.getSourceFlowElement() == null) {
            flowElement = dynBpmnModel.getFlowElement(dynSequenceFlow.getSourceRef());
            if (flowElement == null) {
                flowElement = newBpmnModel.getFlowElement(dynSequenceFlow.getSourceRef());
            }
            dynSequenceFlow.setSourceFlowElement(flowElement);
        }
        newBpmnModel.addFlowGraphicInfoList(dynFlowElement.getId(), dynBpmnModel.getFlowLocationMap().get(dynFlowElement.getId()));
        newProcess.addFlowElement(dynFlowElement);
    }

    private void initDynFlowElementsLevels(BpmnModel newBpmnModel, Process newProcess) {
        FlowNode startNode = this.getStartNode(newProcess);
        if (startNode != null) {
            GraphicInfo graphicInfo = newBpmnModel.getGraphicInfo(startNode.getId());
            newBpmnModel.getLocationMap().clear();
            newBpmnModel.addGraphicInfo(startNode.getId(), graphicInfo);
            this.caculateNodeLevelPosition(startNode, newBpmnModel, newProcess, graphicInfo.getWidth());
        }
    }

    private FlowNode getStartNode(Process newProcess) {
        for (FlowElement flowElement : newProcess.getFlowElementList()) {
            if (!"StartSignalEvent".equals(flowElement.getType())) continue;
            return (FlowNode)flowElement;
        }
        return null;
    }

    private void caculateNodeLevelPosition(FlowNode flowNode, BpmnModel newBpmnModel, Process newProcess, double startElementWidth) {
        List<SequenceFlow> outgoingFlows = flowNode.getOutgoingFlows();
        if (outgoingFlows != null && !outgoingFlows.isEmpty()) {
            for (int i = 0; i < outgoingFlows.size(); ++i) {
                GraphicInfo oldgraphicInfo;
                SequenceFlow sequenceFlow = outgoingFlows.get(i);
                FlowNode nextFlowNode = (FlowNode)sequenceFlow.getTargetFlowElement();
                if (nextFlowNode == null) continue;
                GraphicInfo graphicInfo = newBpmnModel.getGraphicInfo(flowNode.getId());
                GraphicInfo cloneGraphicInfo = graphicInfo.clone();
                if ("StartSignalEvent".equals(flowNode.getType())) {
                    cloneGraphicInfo.setWidth(150.0);
                    cloneGraphicInfo.setX(graphicInfo.getX() - (150.0 - graphicInfo.getWidth()) / 2.0);
                }
                cloneGraphicInfo.setY(graphicInfo.getY() + graphicInfo.getHeight() * 2.0);
                if (outgoingFlows.size() > 1) {
                    this.calculateFlowElementXPosition(outgoingFlows.size(), i, graphicInfo, cloneGraphicInfo, newBpmnModel);
                }
                if ((oldgraphicInfo = newBpmnModel.getGraphicInfo(nextFlowNode.getId())) != null && oldgraphicInfo.getY() < cloneGraphicInfo.getY()) continue;
                if (oldgraphicInfo != null && nextFlowNode.getIncomingFlows().size() > 1) {
                    cloneGraphicInfo.setX((oldgraphicInfo.getX() + cloneGraphicInfo.getX()) / 2.0);
                }
                if ("EndNoneEvent".equals(nextFlowNode.getType())) {
                    cloneGraphicInfo.setWidth(startElementWidth);
                    cloneGraphicInfo.setX(cloneGraphicInfo.getX() + (150.0 - cloneGraphicInfo.getWidth()) / 2.0);
                }
                if (oldgraphicInfo != null && oldgraphicInfo.getY() > cloneGraphicInfo.getY()) continue;
                newBpmnModel.addGraphicInfo(nextFlowNode.getId(), cloneGraphicInfo);
                this.caculateNodeLevelPosition(nextFlowNode, newBpmnModel, newProcess, startElementWidth);
            }
        }
    }

    private void calculateFlowElementXPosition(int size, int i, GraphicInfo graphicInfo, GraphicInfo cloneGraphicInfo, BpmnModel newBpmnModel) {
        if (size == 2) {
            if (i == 0) {
                cloneGraphicInfo.setX(graphicInfo.getX() - graphicInfo.getWidth() * 1.5);
            } else if (i == 1) {
                cloneGraphicInfo.setX(graphicInfo.getX() + graphicInfo.getWidth() * 1.5);
            }
        } else if (size == 3) {
            if (i == 0) {
                cloneGraphicInfo.setX(graphicInfo.getX() - graphicInfo.getWidth() * 1.5);
            } else if (i == 2) {
                cloneGraphicInfo.setX(graphicInfo.getX() + graphicInfo.getWidth() * 1.5);
            }
        } else if (size == 4) {
            if (i == 0) {
                cloneGraphicInfo.setX(graphicInfo.getX() - graphicInfo.getWidth() * 3.0);
            } else if (i == 1) {
                cloneGraphicInfo.setX(graphicInfo.getX() - graphicInfo.getWidth() * 1.5);
            } else if (i == 2) {
                cloneGraphicInfo.setX(graphicInfo.getX() + graphicInfo.getWidth() * 1.5);
            } else if (i == 3) {
                cloneGraphicInfo.setX(graphicInfo.getX() + graphicInfo.getWidth() * 3.0);
            }
        } else if (size == 5) {
            if (i == 0) {
                cloneGraphicInfo.setX(graphicInfo.getX() - graphicInfo.getWidth() * 3.0);
            } else if (i == 1) {
                cloneGraphicInfo.setX(graphicInfo.getX() - graphicInfo.getWidth() * 1.5);
            } else if (i == 3) {
                cloneGraphicInfo.setX(graphicInfo.getX() + graphicInfo.getWidth() * 1.5);
            } else if (i == 4) {
                cloneGraphicInfo.setX(graphicInfo.getX() + graphicInfo.getWidth() * 3.0);
            }
        }
        Map<String, GraphicInfo> locationMap = newBpmnModel.getLocationMap();
        for (Map.Entry<String, GraphicInfo> entry : locationMap.entrySet()) {
            GraphicInfo localGraphicInfo = entry.getValue();
            if (localGraphicInfo.getY() != cloneGraphicInfo.getY() || !(Math.abs(localGraphicInfo.getX() - cloneGraphicInfo.getX()) < cloneGraphicInfo.getWidth())) continue;
            cloneGraphicInfo.setX(cloneGraphicInfo.getX() + cloneGraphicInfo.getWidth() * 1.5);
        }
    }
}

