/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.dynprocess;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.impl.cmd.task.TaskAddSignValidate;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.IDynamicResourceItem;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;

public class GetDynProcessContentCmd
extends TaskAddSignValidate
implements Command<List<IDynamicResourceItem>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Long taskId;
    private String type;

    public GetDynProcessContentCmd(Long taskId, String type) {
        this.taskId = taskId;
        this.type = type;
    }

    @Override
    public List<IDynamicResourceItem> execute(CommandContext commandContext) {
        ExecutionEntity execution = this.getExecutionEntity(commandContext, this.taskId);
        QFilter qInstanceId = new QFilter("processinstanceid", "=", (Object)execution.getProcessInstanceId());
        QFilter qActInstId = new QFilter("activityinstanceid", "=", (Object)execution.getCurrentActInstId());
        QFilter qType = new QFilter("type", "=", (Object)this.type);
        QFilter[] qFilters = new QFilter[]{qInstanceId, qActInstId, qType};
        List dynamicResourceEntities = commandContext.getDynamicResourceEntityManager().findByQueryFilters(qFilters);
        if (dynamicResourceEntities == null || dynamicResourceEntities.isEmpty()) {
            return new ArrayList<IDynamicResourceItem>();
        }
        ArrayList<IDynamicResourceItem> iDynamicResourceItems = new ArrayList<IDynamicResourceItem>(dynamicResourceEntities.size());
        iDynamicResourceItems.addAll(dynamicResourceEntities);
        return iDynamicResourceItems;
    }
}

