/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.dynprocess;

import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.EndEvent;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.dynprocess.DynProcessAbstractProcessor;
import kd.bos.workflow.engine.impl.dynprocess.DynProcessProcessorUtil;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.DynamicFlowUtil;

public class TerminateProcessor
extends DynProcessAbstractProcessor {
    @Override
    public SequenceFlow createDynProcess(ExecutionEntity execution, String flowNodeId, BpmnModel newBpmnModel, BpmnModel dynBpmnModel, Process dynProcess, Map<String, BpmnModel> mulBpmnModel, Map<String, Object> params) {
        this.initMulBpmnModel(dynProcess, mulBpmnModel);
        EndEvent endEvent = DynProcessProcessorUtil.createEndEvent(newBpmnModel);
        String type = DynamicFlowUtil.getDynamicType(execution);
        this.handleEndEventMulBpmnModel(endEvent, dynProcess, newBpmnModel, mulBpmnModel, type);
        ILocaleString flowName = this.getSequenceFlowName(execution);
        SequenceFlow flow = DynProcessProcessorUtil.createSequenceFlow(flowNodeId, endEvent.getId(), (String)flowName.get((Object)this.localeLang), newBpmnModel, dynProcess);
        this.handleSequenceFlowMulBpmnModel(flow, flowName, mulBpmnModel);
        return flow;
    }

    private void handleSequenceFlowMulBpmnModel(SequenceFlow flow, ILocaleString flowName, Map<String, BpmnModel> mulBpmnModel) {
        for (Map.Entry<String, BpmnModel> entry : mulBpmnModel.entrySet()) {
            SequenceFlow cloneSequence = flow.clone();
            cloneSequence.setName((String)flowName.get((Object)entry.getKey()));
            mulBpmnModel.get(entry.getKey()).getMainProcess().addFlowElement(cloneSequence);
        }
    }

    private ILocaleString getSequenceFlowName(ExecutionEntity execution) {
        LocaleString flowSequenceName = new LocaleString();
        String dynTypeName = DynamicFlowUtil.getDynamicVariableValue(execution, "dynName");
        if (dynTypeName == null) {
            dynTypeName = ResManager.loadKDString((String)"\u7ec8\u6b62", (String)"TerminateProcessor_0", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        if (dynTypeName.toString().startsWith("{") && dynTypeName.toString().endsWith("}")) {
            Map mapType = (Map)SerializationUtils.fromJsonString((String)dynTypeName.toString(), Map.class);
            if (mapType != null && !mapType.isEmpty()) {
                flowSequenceName = LocaleString.fromMap((Map)mapType);
            }
        } else {
            String type;
            switch (type = DynamicFlowUtil.getDynamicType(execution)) {
                case "billAbort": {
                    flowSequenceName = WfUtils.getPromptWordLocaleString("\u6574\u5355\u5f3a\u5236\u64a4\u56de", "TerminateProcessor_1", "bos-wf-engine");
                    break;
                }
                case "forceAbort": 
                case "billExcepAbort": {
                    flowSequenceName = WfUtils.getPromptWordLocaleString("\u7ba1\u7406\u5458\u7ec8\u6b62", "TerminateProcessor_2", "bos-wf-engine");
                    break;
                }
                case "abortByParentProcessJump": {
                    flowSequenceName = WFMultiLangConstants.getParentProcessJumpText();
                    break;
                }
                case "abortByParentProcessAbort": {
                    flowSequenceName = WFMultiLangConstants.getParentProcessAbortText();
                    break;
                }
                case "abortByParentProcessWithdraw": {
                    flowSequenceName = WFMultiLangConstants.getParentProcessWithdrawText();
                    break;
                }
                case "abortByRejectToParentProcess": {
                    flowSequenceName = WFMultiLangConstants.getRejectToParentProcessAbortText();
                    break;
                }
                case "auditAbort": {
                    flowSequenceName = WfUtils.getPromptWordLocaleString("\u5ba1\u6279\u7ec8\u6b62", "TerminateProcessor_3", "bos-wf-engine");
                    break;
                }
                case "meetBillClose": {
                    flowSequenceName = WfUtils.getPromptWordLocaleString("\u4e1a\u52a1\u5b8c\u7ed3", "TerminateProcessor_4", "bos-wf-engine");
                    break;
                }
                case "terminateProcWhenExceptionOccurs": {
                    flowSequenceName = WFMultiLangConstants.getAbendText();
                    break;
                }
            }
        }
        return flowSequenceName;
    }

    private void handleEndEventMulBpmnModel(EndEvent endEvent, Process dynProcess, BpmnModel bpmnModel, Map<String, BpmnModel> mulBpmnModel, String type) {
        ILocaleString endEventName = "meetBillClose".equalsIgnoreCase(type) ? WfUtils.getPromptWordLocaleString("\u7ed3\u675f", "TerminateProcessor_5", "bos-wf-engine") : WfUtils.getPromptWordLocaleString("\u7ec8\u6b62", "TerminateProcessor_0", "bos-wf-engine");
        for (Map.Entry<String, BpmnModel> entry : mulBpmnModel.entrySet()) {
            String lang = entry.getKey();
            EndEvent cloneEndEvent = endEvent.clone();
            cloneEndEvent.setName((String)endEventName.get((Object)lang));
            mulBpmnModel.get(lang).getMainProcess().addFlowElement(cloneEndEvent);
        }
        endEvent.setName((String)endEventName.get((Object)this.localeLang));
        bpmnModel.getMainProcess().addFlowElement(endEvent);
        dynProcess.addFlowElement(endEvent);
    }

    private void initMulBpmnModel(Process dynProcess, Map<String, BpmnModel> mulBpmnModel) {
        for (Map.Entry<String, BpmnModel> entry : mulBpmnModel.entrySet()) {
            mulBpmnModel.get(entry.getKey()).addProcess(dynProcess.clone());
        }
    }
}

